"use strict";var compileSchema=require("./compile"),resolve=require("./compile/resolve"),Cache=require("./cache"),SchemaObject=require("./compile/schema_obj"),stableStringify=require("fast-json-stable-stringify"),formats=require("./compile/formats"),rules=require("./compile/rules"),$dataMetaSchema=require("./data"),util=require("./compile/util");module.exports=Ajv,Ajv.prototype.validate=validate,Ajv.prototype.compile=compile,Ajv.prototype.addSchema=addSchema,Ajv.prototype.addMetaSchema=addMetaSchema,Ajv.prototype.validateSchema=validateSchema,Ajv.prototype.getSchema=getSchema,Ajv.prototype.removeSchema=removeSchema,Ajv.prototype.addFormat=addFormat,Ajv.prototype.errorsText=errorsText,Ajv.prototype._addSchema=_addSchema,Ajv.prototype._compile=_compile,Ajv.prototype.compileAsync=require("./compile/async");var customKeyword=require("./keyword");Ajv.prototype.addKeyword=customKeyword.add,Ajv.prototype.getKeyword=customKeyword.get,Ajv.prototype.removeKeyword=customKeyword.remove,Ajv.prototype.validateKeyword=customKeyword.validate;var errorClasses=require("./compile/error_classes");Ajv.ValidationError=errorClasses.Validation,Ajv.MissingRefError=errorClasses.MissingRef,Ajv.$dataMetaSchema=$dataMetaSchema;var META_SCHEMA_ID="http://json-schema.org/draft-07/schema",META_IGNORE_OPTIONS=["removeAdditional","useDefaults","coerceTypes","strictDefaults"],META_SUPPORT_DATA=["/properties"];function Ajv(e){if(!(this instanceof Ajv))return new Ajv(e);e=this._opts=util.copy(e)||{},setLogger(this),this._schemas={},this._refs={},this._fragments={},this._formats=formats(e.format),this._cache=e.cache||new Cache,this._loadingSchemas={},this._compilations=[],this.RULES=rules(),this._getId=chooseGetId(e),e.loopRequired=e.loopRequired||1/0,"property"==e.errorDataPath&&(e._errorDataPathProperty=!0),void 0===e.serialize&&(e.serialize=stableStringify),this._metaOpts=getMetaSchemaOptions(this),e.formats&&addInitialFormats(this),addDefaultMetaSchema(this),"object"==typeof e.meta&&this.addMetaSchema(e.meta),e.nullable&&this.addKeyword("nullable",{metaSchema:{type:"boolean"}}),addInitialSchemas(this)}function validate(e,t){var r;if("string"==typeof e){if(!(r=this.getSchema(e)))throw new Error('no schema with key or ref "'+e+'"')}else{var a=this._addSchema(e);r=a.validate||this._compile(a)}var o=r(t);return!0!==r.$async&&(this.errors=r.errors),o}function compile(e,t){var r=this._addSchema(e,void 0,t);return r.validate||this._compile(r)}function addSchema(e,t,r,a){if(Array.isArray(e)){for(var o=0;o<e.length;o++)this.addSchema(e[o],void 0,r,a);return this}var i=this._getId(e);if(void 0!==i&&"string"!=typeof i)throw new Error("schema id must be string");return checkUnique(this,t=resolve.normalizeId(t||i)),this._schemas[t]=this._addSchema(e,r,a,!0),this}function addMetaSchema(e,t,r){return this.addSchema(e,t,r,!0),this}function validateSchema(e,t){var r=e.$schema;if(void 0!==r&&"string"!=typeof r)throw new Error("$schema must be a string");if(!(r=r||this._opts.defaultMeta||defaultMeta(this)))return this.logger.warn("meta-schema not available"),this.errors=null,!0;var a=this.validate(r,e);if(!a&&t){var o="schema is invalid: "+this.errorsText();if("log"!=this._opts.validateSchema)throw new Error(o);this.logger.error(o)}return a}function defaultMeta(e){var t=e._opts.meta;return e._opts.defaultMeta="object"==typeof t?e._getId(t)||t:e.getSchema(META_SCHEMA_ID)?META_SCHEMA_ID:void 0,e._opts.defaultMeta}function getSchema(e){var t=_getSchemaObj(this,e);switch(typeof t){case"object":return t.validate||this._compile(t);case"string":return this.getSchema(t);case"undefined":return _getSchemaFragment(this,e)}}function _getSchemaFragment(e,t){var r=resolve.schema.call(e,{schema:{}},t);if(r){var a=r.schema,o=r.root,i=r.baseId,s=compileSchema.call(e,a,o,void 0,i);return e._fragments[t]=new SchemaObject({ref:t,fragment:!0,schema:a,root:o,baseId:i,validate:s}),s}}function _getSchemaObj(e,t){return t=resolve.normalizeId(t),e._schemas[t]||e._refs[t]||e._fragments[t]}function removeSchema(e){if(e instanceof RegExp)return _removeAllSchemas(this,this._schemas,e),_removeAllSchemas(this,this._refs,e),this;switch(typeof e){case"undefined":return _removeAllSchemas(this,this._schemas),_removeAllSchemas(this,this._refs),this._cache.clear(),this;case"string":var t=_getSchemaObj(this,e);return t&&this._cache.del(t.cacheKey),delete this._schemas[e],delete this._refs[e],this;case"object":var r=this._opts.serialize,a=r?r(e):e;this._cache.del(a);var o=this._getId(e);o&&(o=resolve.normalizeId(o),delete this._schemas[o],delete this._refs[o])}return this}function _removeAllSchemas(e,t,r){for(var a in t){var o=t[a];o.meta||r&&!r.test(a)||(e._cache.del(o.cacheKey),delete t[a])}}function _addSchema(e,t,r,a){if("object"!=typeof e&&"boolean"!=typeof e)throw new Error("schema should be object or boolean");var o=this._opts.serialize,i=o?o(e):e,s=this._cache.get(i);if(s)return s;a=a||!1!==this._opts.addUsedSchema;var c=resolve.normalizeId(this._getId(e));c&&a&&checkUnique(this,c);var h,d=!1!==this._opts.validateSchema&&!t;d&&!(h=c&&c==resolve.normalizeId(e.$schema))&&this.validateSchema(e,!0);var n=resolve.ids.call(this,e),m=new SchemaObject({id:c,schema:e,localRefs:n,cacheKey:i,meta:r});return"#"!=c[0]&&a&&(this._refs[c]=m),this._cache.put(i,m),d&&h&&this.validateSchema(e,!0),m}function _compile(e,t){if(e.compiling)return e.validate=o,o.schema=e.schema,o.errors=null,o.root=t||o,!0===e.schema.$async&&(o.$async=!0),o;var r,a;e.compiling=!0,e.meta&&(r=this._opts,this._opts=this._metaOpts);try{a=compileSchema.call(this,e.schema,t,e.localRefs)}catch(t){throw delete e.validate,t}finally{e.compiling=!1,e.meta&&(this._opts=r)}return e.validate=a,e.refs=a.refs,e.refVal=a.refVal,e.root=a.root,a;function o(){var t=e.validate,r=t.apply(this,arguments);return o.errors=t.errors,r}}function chooseGetId(e){switch(e.schemaId){case"auto":return _get$IdOrId;case"id":return _getId;default:return _get$Id}}function _getId(e){return e.$id&&this.logger.warn("schema $id ignored",e.$id),e.id}function _get$Id(e){return e.id&&this.logger.warn("schema id ignored",e.id),e.$id}function _get$IdOrId(e){if(e.$id&&e.id&&e.$id!=e.id)throw new Error("schema $id is different from id");return e.$id||e.id}function errorsText(e,t){if(!(e=e||this.errors))return"No errors";for(var r=void 0===(t=t||{}).separator?", ":t.separator,a=void 0===t.dataVar?"data":t.dataVar,o="",i=0;i<e.length;i++){var s=e[i];s&&(o+=a+s.dataPath+" "+s.message+r)}return o.slice(0,-r.length)}function addFormat(e,t){return"string"==typeof t&&(t=new RegExp(t)),this._formats[e]=t,this}function addDefaultMetaSchema(e){var t;if(e._opts.$data&&(t=require("./refs/data.json"),e.addMetaSchema(t,t.$id,!0)),!1!==e._opts.meta){var r=require("./refs/json-schema-draft-07.json");e._opts.$data&&(r=$dataMetaSchema(r,META_SUPPORT_DATA)),e.addMetaSchema(r,META_SCHEMA_ID,!0),e._refs["http://json-schema.org/schema"]=META_SCHEMA_ID}}function addInitialSchemas(e){var t=e._opts.schemas;if(t)if(Array.isArray(t))e.addSchema(t);else for(var r in t)e.addSchema(t[r],r)}function addInitialFormats(e){for(var t in e._opts.formats){var r=e._opts.formats[t];e.addFormat(t,r)}}function checkUnique(e,t){if(e._schemas[t]||e._refs[t])throw new Error('schema with key or id "'+t+'" already exists')}function getMetaSchemaOptions(e){for(var t=util.copy(e._opts),r=0;r<META_IGNORE_OPTIONS.length;r++)delete t[META_IGNORE_OPTIONS[r]];return t}function setLogger(e){var t=e._opts.logger;if(!1===t)e.logger={log:noop,warn:noop,error:noop};else{if(void 0===t&&(t=console),!("object"==typeof t&&t.log&&t.warn&&t.error))throw new Error("logger must implement log, warn and error methods");e.logger=t}}function noop(){}