var assert=require("assert"),Buffer=require("safer-buffer").Buffer,ASN1=require("./types"),errors=require("./errors"),newInvalidAsn1Error=errors.newInvalidAsn1Error,DEFAULT_OPTS={size:1024,growthFactor:8};function merge(t,e){return assert.ok(t),assert.equal(typeof t,"object"),assert.ok(e),assert.equal(typeof e,"object"),Object.getOwnPropertyNames(t).forEach(function(r){if(!e[r]){var s=Object.getOwnPropertyDescriptor(t,r);Object.defineProperty(e,r,s)}}),e}function Writer(t){t=merge(DEFAULT_OPTS,t||{}),this._buf=Buffer.alloc(t.size||1024),this._size=this._buf.length,this._offset=0,this._options=t,this._seq=[]}Object.defineProperty(Writer.prototype,"buffer",{get:function(){if(this._seq.length)throw newInvalidAsn1Error(this._seq.length+" unended sequence(s)");return this._buf.slice(0,this._offset)}}),Writer.prototype.writeByte=function(t){if("number"!=typeof t)throw new TypeError("argument must be a Number");this._ensure(1),this._buf[this._offset++]=t},Writer.prototype.writeInt=function(t,e){if("number"!=typeof t)throw new TypeError("argument must be a Number");"number"!=typeof e&&(e=ASN1.Integer);for(var r=4;(0==(4286578688&t)||-8388608==(4286578688&t))&&r>1;)r--,t<<=8;if(r>4)throw newInvalidAsn1Error("BER ints cannot be > 0xffffffff");for(this._ensure(2+r),this._buf[this._offset++]=e,this._buf[this._offset++]=r;r-- >0;)this._buf[this._offset++]=(4278190080&t)>>>24,t<<=8},Writer.prototype.writeNull=function(){this.writeByte(ASN1.Null),this.writeByte(0)},Writer.prototype.writeEnumeration=function(t,e){if("number"!=typeof t)throw new TypeError("argument must be a Number");return"number"!=typeof e&&(e=ASN1.Enumeration),this.writeInt(t,e)},Writer.prototype.writeBoolean=function(t,e){if("boolean"!=typeof t)throw new TypeError("argument must be a Boolean");"number"!=typeof e&&(e=ASN1.Boolean),this._ensure(3),this._buf[this._offset++]=e,this._buf[this._offset++]=1,this._buf[this._offset++]=t?255:0},Writer.prototype.writeString=function(t,e){if("string"!=typeof t)throw new TypeError("argument must be a string (was: "+typeof t+")");"number"!=typeof e&&(e=ASN1.OctetString);var r=Buffer.byteLength(t);this.writeByte(e),this.writeLength(r),r&&(this._ensure(r),this._buf.write(t,this._offset),this._offset+=r)},Writer.prototype.writeBuffer=function(t,e){if("number"!=typeof e)throw new TypeError("tag must be a number");if(!Buffer.isBuffer(t))throw new TypeError("argument must be a buffer");this.writeByte(e),this.writeLength(t.length),this._ensure(t.length),t.copy(this._buf,this._offset,0,t.length),this._offset+=t.length},Writer.prototype.writeStringArray=function(t){if(!t instanceof Array)throw new TypeError("argument must be an Array[String]");var e=this;t.forEach(function(t){e.writeString(t)})},Writer.prototype.writeOID=function(t,e){if("string"!=typeof t)throw new TypeError("argument must be a string");if("number"!=typeof e&&(e=ASN1.OID),!/^([0-9]+\.){3,}[0-9]+$/.test(t))throw new Error("argument is not a valid OID string");var r=t.split("."),s=[];s.push(40*parseInt(r[0],10)+parseInt(r[1],10)),r.slice(2).forEach(function(t){!function(t,e){e<128?t.push(e):e<16384?(t.push(e>>>7|128),t.push(127&e)):e<2097152?(t.push(e>>>14|128),t.push(255&(e>>>7|128)),t.push(127&e)):e<268435456?(t.push(e>>>21|128),t.push(255&(e>>>14|128)),t.push(255&(e>>>7|128)),t.push(127&e)):(t.push(255&(e>>>28|128)),t.push(255&(e>>>21|128)),t.push(255&(e>>>14|128)),t.push(255&(e>>>7|128)),t.push(127&e))}(s,parseInt(t,10))});var i=this;this._ensure(2+s.length),this.writeByte(e),this.writeLength(s.length),s.forEach(function(t){i.writeByte(t)})},Writer.prototype.writeLength=function(t){if("number"!=typeof t)throw new TypeError("argument must be a Number");if(this._ensure(4),t<=127)this._buf[this._offset++]=t;else if(t<=255)this._buf[this._offset++]=129,this._buf[this._offset++]=t;else if(t<=65535)this._buf[this._offset++]=130,this._buf[this._offset++]=t>>8,this._buf[this._offset++]=t;else{if(!(t<=16777215))throw newInvalidAsn1Error("Length too long (> 4 bytes)");this._buf[this._offset++]=131,this._buf[this._offset++]=t>>16,this._buf[this._offset++]=t>>8,this._buf[this._offset++]=t}},Writer.prototype.startSequence=function(t){"number"!=typeof t&&(t=ASN1.Sequence|ASN1.Constructor),this.writeByte(t),this._seq.push(this._offset),this._ensure(3),this._offset+=3},Writer.prototype.endSequence=function(){var t=this._seq.pop(),e=t+3,r=this._offset-e;if(r<=127)this._shift(e,r,-2),this._buf[t]=r;else if(r<=255)this._shift(e,r,-1),this._buf[t]=129,this._buf[t+1]=r;else if(r<=65535)this._buf[t]=130,this._buf[t+1]=r>>8,this._buf[t+2]=r;else{if(!(r<=16777215))throw newInvalidAsn1Error("Sequence too long");this._shift(e,r,1),this._buf[t]=131,this._buf[t+1]=r>>16,this._buf[t+2]=r>>8,this._buf[t+3]=r}},Writer.prototype._shift=function(t,e,r){assert.ok(void 0!==t),assert.ok(void 0!==e),assert.ok(r),this._buf.copy(this._buf,t+r,t,t+e),this._offset+=r},Writer.prototype._ensure=function(t){if(assert.ok(t),this._size-this._offset<t){var e=this._size*this._options.growthFactor;e-this._offset<t&&(e+=t);var r=Buffer.alloc(e);this._buf.copy(r,0,0,this._offset),this._buf=r,this._size=e}},module.exports=Writer;