var aws4=exports,url=require("url"),querystring=require("querystring"),crypto=require("crypto"),lru=require("./lru"),credentialsCache=lru(1e3);function hmac(e,t,s){return crypto.createHmac("sha256",e).update(t,"utf8").digest(s)}function hash(e,t){return crypto.createHash("sha256").update(e,"utf8").digest(t)}function encodeRfc3986(e){return e.replace(/[!'()*]/g,function(e){return"%"+e.charCodeAt(0).toString(16).toUpperCase()})}function encodeRfc3986Full(e){return encodeRfc3986(encodeURIComponent(e))}function RequestSigner(e,t){"string"==typeof e&&(e=url.parse(e));var s=e.headers=e.headers||{},r=this.matchHost(e.hostname||e.host||s.Host||s.host);this.request=e,this.credentials=t||this.defaultCredentials(),this.service=e.service||r[0]||"",this.region=e.region||r[1]||"us-east-1","email"===this.service&&(this.service="ses"),!e.method&&e.body&&(e.method="POST"),s.Host||s.host||(s.Host=e.hostname||e.host||this.createHost(),e.port&&(s.Host+=":"+e.port)),e.hostname||e.host||(e.hostname=s.Host||s.host),this.isCodeCommitGit="codecommit"===this.service&&"GIT"===e.method}RequestSigner.prototype.matchHost=function(e){var t=((e||"").match(/([^\.]+)\.(?:([^\.]*)\.)?amazonaws\.com(\.cn)?$/)||[]).slice(1,3);return"es"===t[1]&&(t=t.reverse()),t},RequestSigner.prototype.isSingleRegion=function(){return["s3","sdb"].indexOf(this.service)>=0&&"us-east-1"===this.region||["cloudfront","ls","route53","iam","importexport","sts"].indexOf(this.service)>=0},RequestSigner.prototype.createHost=function(){var e=this.isSingleRegion()?"":("s3"===this.service&&"us-east-1"!==this.region?"-":".")+this.region;return("ses"===this.service?"email":this.service)+e+".amazonaws.com"},RequestSigner.prototype.prepareRequest=function(){this.parsePath();var e,t=this.request,s=t.headers;t.signQuery?(this.parsedPath.query=e=this.parsedPath.query||{},this.credentials.sessionToken&&(e["X-Amz-Security-Token"]=this.credentials.sessionToken),"s3"!==this.service||e["X-Amz-Expires"]||(e["X-Amz-Expires"]=86400),e["X-Amz-Date"]?this.datetime=e["X-Amz-Date"]:e["X-Amz-Date"]=this.getDateTime(),e["X-Amz-Algorithm"]="AWS4-HMAC-SHA256",e["X-Amz-Credential"]=this.credentials.accessKeyId+"/"+this.credentialString(),e["X-Amz-SignedHeaders"]=this.signedHeaders()):(t.doNotModifyHeaders||this.isCodeCommitGit||(!t.body||s["Content-Type"]||s["content-type"]||(s["Content-Type"]="application/x-www-form-urlencoded; charset=utf-8"),!t.body||s["Content-Length"]||s["content-length"]||(s["Content-Length"]=Buffer.byteLength(t.body)),!this.credentials.sessionToken||s["X-Amz-Security-Token"]||s["x-amz-security-token"]||(s["X-Amz-Security-Token"]=this.credentials.sessionToken),"s3"!==this.service||s["X-Amz-Content-Sha256"]||s["x-amz-content-sha256"]||(s["X-Amz-Content-Sha256"]=hash(this.request.body||"","hex")),s["X-Amz-Date"]||s["x-amz-date"]?this.datetime=s["X-Amz-Date"]||s["x-amz-date"]:s["X-Amz-Date"]=this.getDateTime()),delete s.Authorization,delete s.authorization)},RequestSigner.prototype.sign=function(){return this.parsedPath||this.prepareRequest(),this.request.signQuery?this.parsedPath.query["X-Amz-Signature"]=this.signature():this.request.headers.Authorization=this.authHeader(),this.request.path=this.formatPath(),this.request},RequestSigner.prototype.getDateTime=function(){if(!this.datetime){var e=this.request.headers,t=new Date(e.Date||e.date||new Date);this.datetime=t.toISOString().replace(/[:\-]|\.\d{3}/g,""),this.isCodeCommitGit&&(this.datetime=this.datetime.slice(0,-1))}return this.datetime},RequestSigner.prototype.getDate=function(){return this.getDateTime().substr(0,8)},RequestSigner.prototype.authHeader=function(){return["AWS4-HMAC-SHA256 Credential="+this.credentials.accessKeyId+"/"+this.credentialString(),"SignedHeaders="+this.signedHeaders(),"Signature="+this.signature()].join(", ")},RequestSigner.prototype.signature=function(){var e=this.getDate(),t=[this.credentials.secretAccessKey,e,this.region,this.service].join(),s=credentialsCache.get(t);return s||(s=hmac(hmac(hmac(hmac("AWS4"+this.credentials.secretAccessKey,e),this.region),this.service),"aws4_request"),credentialsCache.set(t,s)),hmac(s,this.stringToSign(),"hex")},RequestSigner.prototype.stringToSign=function(){return["AWS4-HMAC-SHA256",this.getDateTime(),this.credentialString(),hash(this.canonicalString(),"hex")].join("\n")},RequestSigner.prototype.canonicalString=function(){this.parsedPath||this.prepareRequest();var e,t=this.parsedPath.path,s=this.parsedPath.query,r=this.request.headers,i="",n="s3"!==this.service,o="s3"===this.service||this.request.doNotEncodePath,a="s3"===this.service,h="s3"===this.service;if(e="s3"===this.service&&this.request.signQuery?"UNSIGNED-PAYLOAD":this.isCodeCommitGit?"":r["X-Amz-Content-Sha256"]||r["x-amz-content-sha256"]||hash(this.request.body||"","hex"),s){var c=Object.keys(s).reduce(function(e,t){return t?(e[encodeRfc3986Full(t)]=Array.isArray(s[t])&&h?s[t][0]:s[t],e):e},{}),u=[];Object.keys(c).sort().forEach(function(e){Array.isArray(c[e])?c[e].map(encodeRfc3986Full).sort().forEach(function(t){u.push(e+"="+t)}):u.push(e+"="+encodeRfc3986Full(c[e]))}),i=u.join("&")}return"/"!==t&&(n&&(t=t.replace(/\/{2,}/g,"/")),"/"!==(t=t.split("/").reduce(function(e,t){return n&&".."===t?e.pop():n&&"."===t||(o&&(t=decodeURIComponent(t).replace(/\+/g," ")),e.push(encodeRfc3986Full(t))),e},[]).join("/"))[0]&&(t="/"+t),a&&(t=t.replace(/%2F/g,"/"))),[this.request.method||"GET",t,i,this.canonicalHeaders()+"\n",this.signedHeaders(),e].join("\n")},RequestSigner.prototype.canonicalHeaders=function(){var e=this.request.headers;return Object.keys(e).sort(function(e,t){return e.toLowerCase()<t.toLowerCase()?-1:1}).map(function(t){return t.toLowerCase()+":"+e[t].toString().trim().replace(/\s+/g," ")}).join("\n")},RequestSigner.prototype.signedHeaders=function(){return Object.keys(this.request.headers).map(function(e){return e.toLowerCase()}).sort().join(";")},RequestSigner.prototype.credentialString=function(){return[this.getDate(),this.region,this.service,"aws4_request"].join("/")},RequestSigner.prototype.defaultCredentials=function(){var e=process.env;return{accessKeyId:e.AWS_ACCESS_KEY_ID||e.AWS_ACCESS_KEY,secretAccessKey:e.AWS_SECRET_ACCESS_KEY||e.AWS_SECRET_KEY,sessionToken:e.AWS_SESSION_TOKEN}},RequestSigner.prototype.parsePath=function(){var e=this.request.path||"/";/[^0-9A-Za-z;,/?:@&=+$\-_.!~*'()#%]/.test(e)&&(e=encodeURI(decodeURI(e)));var t=e.indexOf("?"),s=null;t>=0&&(s=querystring.parse(e.slice(t+1)),e=e.slice(0,t)),this.parsedPath={path:e,query:s}},RequestSigner.prototype.formatPath=function(){var e=this.parsedPath.path,t=this.parsedPath.query;return t?(null!=t[""]&&delete t[""],e+"?"+encodeRfc3986(querystring.stringify(t))):e},aws4.RequestSigner=RequestSigner,aws4.sign=function(e,t){return new RequestSigner(e,t).sign()};