var inherits=require("util").inherits,normalizePath=require("normalize-path"),ArchiveEntry=require("../archive-entry"),GeneralPurposeBit=require("./general-purpose-bit"),UnixStat=require("./unix-stat"),constants=require("./constants"),zipUtil=require("./util"),ZipArchiveEntry=module.exports=function(t){if(!(this instanceof ZipArchiveEntry))return new ZipArchiveEntry(t);ArchiveEntry.call(this),this.platform=constants.PLATFORM_FAT,this.method=-1,this.name=null,this.size=0,this.csize=0,this.gpb=new GeneralPurposeBit,this.crc=0,this.time=-1,this.minver=constants.MIN_VERSION_INITIAL,this.mode=-1,this.extra=null,this.exattr=0,this.inattr=0,this.comment=null,t&&this.setName(t)};inherits(ZipArchiveEntry,ArchiveEntry),ZipArchiveEntry.prototype.getCentralDirectoryExtra=function(){return this.getExtra()},ZipArchiveEntry.prototype.getComment=function(){return null!==this.comment?this.comment:""},ZipArchiveEntry.prototype.getCompressedSize=function(){return this.csize},ZipArchiveEntry.prototype.getCrc=function(){return this.crc},ZipArchiveEntry.prototype.getExternalAttributes=function(){return this.exattr},ZipArchiveEntry.prototype.getExtra=function(){return null!==this.extra?this.extra:constants.EMPTY},ZipArchiveEntry.prototype.getGeneralPurposeBit=function(){return this.gpb},ZipArchiveEntry.prototype.getInternalAttributes=function(){return this.inattr},ZipArchiveEntry.prototype.getLastModifiedDate=function(){return this.getTime()},ZipArchiveEntry.prototype.getLocalFileDataExtra=function(){return this.getExtra()},ZipArchiveEntry.prototype.getMethod=function(){return this.method},ZipArchiveEntry.prototype.getName=function(){return this.name},ZipArchiveEntry.prototype.getPlatform=function(){return this.platform},ZipArchiveEntry.prototype.getSize=function(){return this.size},ZipArchiveEntry.prototype.getTime=function(){return-1!==this.time?zipUtil.dosToDate(this.time):-1},ZipArchiveEntry.prototype.getTimeDos=function(){return-1!==this.time?this.time:0},ZipArchiveEntry.prototype.getUnixMode=function(){return this.platform!==constants.PLATFORM_UNIX?0:this.getExternalAttributes()>>constants.SHORT_SHIFT&constants.SHORT_MASK},ZipArchiveEntry.prototype.getVersionNeededToExtract=function(){return this.minver},ZipArchiveEntry.prototype.setComment=function(t){Buffer.byteLength(t)!==t.length&&this.getGeneralPurposeBit().useUTF8ForNames(!0),this.comment=t},ZipArchiveEntry.prototype.setCompressedSize=function(t){if(t<0)throw new Error("invalid entry compressed size");this.csize=t},ZipArchiveEntry.prototype.setCrc=function(t){if(t<0)throw new Error("invalid entry crc32");this.crc=t},ZipArchiveEntry.prototype.setExternalAttributes=function(t){this.exattr=t>>>0},ZipArchiveEntry.prototype.setExtra=function(t){this.extra=t},ZipArchiveEntry.prototype.setGeneralPurposeBit=function(t){if(!(t instanceof GeneralPurposeBit))throw new Error("invalid entry GeneralPurposeBit");this.gpb=t},ZipArchiveEntry.prototype.setInternalAttributes=function(t){this.inattr=t},ZipArchiveEntry.prototype.setMethod=function(t){if(t<0)throw new Error("invalid entry compression method");this.method=t},ZipArchiveEntry.prototype.setName=function(t){t=normalizePath(t,!1).replace(/^\w+:/,"").replace(/^(\.\.\/|\/)+/,""),Buffer.byteLength(t)!==t.length&&this.getGeneralPurposeBit().useUTF8ForNames(!0),this.name=t},ZipArchiveEntry.prototype.setPlatform=function(t){this.platform=t},ZipArchiveEntry.prototype.setSize=function(t){if(t<0)throw new Error("invalid entry size");this.size=t},ZipArchiveEntry.prototype.setTime=function(t,e){if(!(t instanceof Date))throw new Error("invalid entry time");this.time=zipUtil.dateToDos(t,e)},ZipArchiveEntry.prototype.setUnixMode=function(t){var e=0;e|=(t|=this.isDirectory()?constants.S_IFDIR:constants.S_IFREG)<<constants.SHORT_SHIFT|(this.isDirectory()?constants.S_DOS_D:constants.S_DOS_A),this.setExternalAttributes(e),this.mode=t&constants.MODE_MASK,this.platform=constants.PLATFORM_UNIX},ZipArchiveEntry.prototype.setVersionNeededToExtract=function(t){this.minver=t},ZipArchiveEntry.prototype.isDirectory=function(){return"/"===this.getName().slice(-1)},ZipArchiveEntry.prototype.isUnixSymlink=function(){return(this.getUnixMode()&UnixStat.FILE_TYPE_FLAG)===UnixStat.LINK_FLAG},ZipArchiveEntry.prototype.isZip64=function(){return this.csize>constants.ZIP64_MAGIC||this.size>constants.ZIP64_MAGIC};