var assert=require("assert-plus"),format=require("util").format,fs=require("fs"),path=require("path"),DEBUG=!0;if(DEBUG)var debug=console.warn;else debug=function(){};function renderTemplate(e,r){return e.replace(/{{([a-zA-Z]+)}}/g,function(e,t){return r.hasOwnProperty(t)?r[t]:e})}function shallowCopy(e){if(!e)return e;var r={};return Object.keys(e).forEach(function(t){r[t]=e[t]}),r}function space(e){for(var r="",t=0;t<e;t++)r+=" ";return r}function makeIndent(e,r,t){return null===e||void 0===e?space(r):"number"==typeof e?space(e):"string"==typeof e?e:void assert.fail('invalid "'+t+'": not a string or number: '+e)}function textwrap(e,r){var t=[],o="";return e.trim().split(/\s+/).forEach(function(e){var n=o.length+e.length;o.length>0&&(n+=1),n>r&&(t.push(o),o=""),o.length>0&&(o+=" "),o+=e}),t.push(o),t}function optionKeyFromName(e){return e.replace(/-/g,"_")}function parseBool(e,r,t){return Boolean(t)}function parseString(e,r,t){return assert.string(t,"arg"),t}function parseNumber(e,r,t){assert.string(t,"arg");var o=Number(t);if(isNaN(o))throw new Error(format('arg for "%s" is not a number: "%s"',r,t));return o}function parseInteger(e,r,t){assert.string(t,"arg");var o=Number(t);if(!/^[0-9-]+$/.test(t)||isNaN(o))throw new Error(format('arg for "%s" is not an integer: "%s"',r,t));return o}function parsePositiveInteger(e,r,t){assert.string(t,"arg");var o=Number(t);if(!/^[0-9]+$/.test(t)||isNaN(o)||0===o)throw new Error(format('arg for "%s" is not a positive integer: "%s"',r,t));return o}function parseDate(e,r,t){var o;if(assert.string(t,"arg"),/^\d+$/.test(t))o=new Date(1e3*Number(t));else{if(!/^\d{4}-\d{2}-\d{2}(T\d{2}:\d{2}:\d{2}(\.\d+)?Z?)?$/i.test(t))throw new Error(format('arg for "%s" is not a valid date format: "%s"',r,t));o=new Date(t)}if("Invalid Date"===o.toString())throw new Error(format('arg for "%s" is an invalid date: "%s"',r,t));return o}var optionTypes={bool:{takesArg:!1,parseArg:parseBool},string:{takesArg:!0,helpArg:"ARG",parseArg:parseString},number:{takesArg:!0,helpArg:"NUM",parseArg:parseNumber},integer:{takesArg:!0,helpArg:"INT",parseArg:parseInteger},positiveInteger:{takesArg:!0,helpArg:"INT",parseArg:parsePositiveInteger},date:{takesArg:!0,helpArg:"DATE",parseArg:parseDate},arrayOfBool:{takesArg:!1,array:!0,parseArg:parseBool},arrayOfString:{takesArg:!0,helpArg:"ARG",array:!0,parseArg:parseString},arrayOfNumber:{takesArg:!0,helpArg:"NUM",array:!0,parseArg:parseNumber},arrayOfInteger:{takesArg:!0,helpArg:"INT",array:!0,parseArg:parseInteger},arrayOfPositiveInteger:{takesArg:!0,helpArg:"INT",array:!0,parseArg:parsePositiveInteger},arrayOfDate:{takesArg:!0,helpArg:"INT",array:!0,parseArg:parseDate}};function Parser(e){assert.object(e,"config"),assert.arrayOfObject(e.options,"config.options"),assert.optionalBool(e.interspersed,"config.interspersed");var r=this;this.interspersed=void 0===e.interspersed||e.interspersed,this.allowUnknown=void 0!==e.allowUnknown&&e.allowUnknown,this.options=e.options.map(function(e){return shallowCopy(e)}),this.optionFromName={},this.optionFromEnv={};for(var t=0;t<this.options.length;t++){var o=this.options[t];if(void 0===o.group||null===o.group){assert.ok(optionTypes[o.type],format('invalid config.options.%d.type: "%s" in %j',t,o.type,o)),assert.optionalString(o.name,format("config.options.%d.name",t)),assert.optionalArrayOfString(o.names,format("config.options.%d.names",t)),assert.ok((o.name||o.names)&&!(o.name&&o.names),format('exactly one of "name" or "names" required: %j',o)),assert.optionalString(o.help,format("config.options.%d.help",t));var n=o.env||[];"string"==typeof n&&(n=[n]),assert.optionalArrayOfString(n,format("config.options.%d.env",t)),assert.optionalString(o.helpGroup,format("config.options.%d.helpGroup",t)),assert.optionalBool(o.helpWrap,format("config.options.%d.helpWrap",t)),assert.optionalBool(o.hidden,format("config.options.%d.hidden",t)),o.name?o.names=[o.name]:assert.string(o.names[0],format("config.options.%d.names is empty",t)),o.key=optionKeyFromName(o.names[0]),o.names.forEach(function(e){if(r.optionFromName[e])throw new Error(format('option name collision: "%s" used in %j and %j',e,r.optionFromName[e],o));r.optionFromName[e]=o}),n.forEach(function(e){if(r.optionFromEnv[e])throw new Error(format('option env collision: "%s" used in %j and %j',e,r.optionFromEnv[e],o));r.optionFromEnv[e]=o})}else assert.optionalString(o.group,format("config.options.%d.group",t))}}Parser.prototype.optionTakesArg=function(e){return optionTypes[e.type].takesArg},Parser.prototype.parse=function(e){var r=this;Array.isArray(arguments[0])&&(e={argv:arguments[0],slice:arguments[1]}),assert.optionalObject(e,"inputs"),e||(e={}),assert.optionalArrayOfString(e.argv,"inputs.argv");var t=e.argv||process.argv,o=void 0!==e.slice?e.slice:2,n=t.slice(o),a=e.env||process.env,s={},i=[];function p(e,r,t,o,n){var a=optionTypes[e.type],p=a.parseArg(e,r,o);if(a.array)if(s[t]||(s[t]=[]),a.arrayFlatten&&Array.isArray(p))for(var l=0;l<p.length;l++)s[t].push(p[l]);else s[t].push(p);else s[t]=p;var g={key:t,value:p,from:n};i.push(g)}var l=[],g=0;e:for(;g<n.length;){var f=n[g];if("--"===f){g++;break}if("--"===f.slice(0,2)){var u=null,h=(v=f.slice(2)).indexOf("=");if(-1!==h&&(u=v.slice(h+1),v=v.slice(0,h)),y=this.optionFromName[v]){var c=this.optionTakesArg(y);if(null!==u&&!c)throw new Error(format('argument given to "--%s" option that does not take one: "%s"',v,f));if(c)if(null!==u)p(y,"--"+v,y.key,u,"argv");else{if(g+1>=n.length)throw new Error(format('do not have enough args for "--%s" option',v));p(y,"--"+v,y.key,n[g+1],"argv"),g++}else p(y,"--"+v,y.key,!0,"argv")}else{if(!this.allowUnknown)throw new Error(format('unknown option: "--%s"',v));if(!this.interspersed)break e;l.push(f)}}else if("-"===f[0]&&f.length>1){for(var m=1,d=!0;m<f.length;){var v=f[m];if(!(y=this.optionFromName[v])){if(d=!1,this.allowUnknown){if(this.interspersed){l.push(f);break}break e}throw f.length>2?new Error(format('unknown option: "-%s" in "%s" group',v,f)):new Error(format('unknown option: "-%s"',v))}if(this.optionTakesArg(y))break;m++}for(m=1;d&&m<f.length;){v=f[m],u=f.slice(m+1);var y=this.optionFromName[v];if(c=this.optionTakesArg(y)){if(u){p(y,"-"+v,y.key,u,"argv");break}if(g+1>=n.length)throw new Error(format('do not have enough args for "-%s" option',v));p(y,"-"+v,y.key,n[g+1],"argv"),g++;break}p(y,"-"+v,y.key,!0,"argv"),m++}}else{if(!this.interspersed)break e;l.push(f)}g++}return l=l.concat(n.slice(g)),Object.keys(this.optionFromEnv).forEach(function(e){var t=a[e];if(void 0!==t){var o=r.optionFromEnv[e];if(void 0===s[o.key])r.optionTakesArg(o)?p(o,e,o.key,t,"env"):""!==t&&p(o,e,o.key,"0"!==t,"env")}}),this.options.forEach(function(e){void 0===s[e.key]&&(void 0!==e.default?s[e.key]=e.default:e.type&&void 0!==optionTypes[e.type].default&&(s[e.key]=optionTypes[e.type].default))}),s._order=i,s._args=l,s},Parser.prototype.help=function(e){e=e||{},assert.object(e,"config");var r=makeIndent(e.indent,4,"config.indent"),t=makeIndent(e.headingIndent,Math.round(r.length/2),"config.headingIndent");assert.optionalString(e.nameSort,"config.nameSort");var o=e.nameSort||"length";assert.ok(~["length","none"].indexOf(o),'invalid "config.nameSort"'),assert.optionalNumber(e.maxCol,"config.maxCol"),assert.optionalNumber(e.maxHelpCol,"config.maxHelpCol"),assert.optionalNumber(e.minHelpCol,"config.minHelpCol"),assert.optionalNumber(e.helpCol,"config.helpCol"),assert.optionalBool(e.includeEnv,"config.includeEnv"),assert.optionalBool(e.includeDefault,"config.includeDefault"),assert.optionalBool(e.helpWrap,"config.helpWrap");var n=e.maxCol||80,a=e.minHelpCol||20,s=e.maxHelpCol||40,i=[],p=0;this.options.forEach(function(e){if(!e.hidden)if(void 0===e.group||null===e.group){var r=optionTypes[e.type],t=e.helpArg||r.helpArg||"ARG",n="",a=e.names.slice();"length"===o&&a.sort(function(e,r){return e.length<r.length?-1:r.length<e.length?1:0}),a.forEach(function(e,o){o>0&&(n+=", "),1===e.length?(n+="-"+e,r.takesArg&&(n+=" "+t)):(n+="--"+e,r.takesArg&&(n+="="+t))}),p=Math.max(p,n.length),i.push(n)}else i.push(null)});var l=e.helpCol;l||(l=p+r.length+2,l=Math.min(Math.max(l,a),s));var g=-1;this.options.forEach(function(o){if(!o.hidden)if(g++,void 0===o.group||null===o.group){var a;e.includeDefault&&(void 0!==o.default?a=format("Default: %j",o.default):o.type&&void 0!==optionTypes[o.type].default&&(a=format("Default: %j",optionTypes[o.type].default)));var s=i[g]=r+i[g];if(o.help||e.includeEnv&&o.env||a){var p=l-s.length;s+=p>=0?space(p):"\n"+space(l);var f="";if(o.env&&o.env.length&&e.includeEnv){f+="Environment: ";var u=optionTypes[o.type],h=o.helpArg||u.helpArg||"ARG";f+=(Array.isArray(o.env)?o.env:[o.env]).map(function(e){return u.takesArg?e+"="+h:e+"=1"}).join(", ")}var c=(o.help||"").trim();if(!1!==o.helpWrap&&!1!==e.helpWrap)c.length&&!~".!?\"'".indexOf(c.slice(-1))&&(c+="."),c.length&&(c+=" "),c+=f,a&&(f&&(c+=". "),c+=a),s+=textwrap(c,n-l).join("\n"+space(l));else{var m=c.split("\n").filter(function(e){return e.length});""!==f&&m.push(f),a&&m.push(a),s+=m.join("\n"+space(l))}i[g]=s}}else""===o.group?i[g]="":i[g]=(0===g?"":"\n")+t+o.group+":"});var f="";return i.length>0&&(f=i.join("\n")+"\n"),f},Parser.prototype.bashCompletion=function(e){return assert.object(e,"args"),assert.string(e.name,"args.name"),assert.optionalString(e.specExtra,"args.specExtra"),assert.optionalArrayOfString(e.argtypes,"args.argtypes"),bashCompletionFromOptions({name:e.name,specExtra:e.specExtra,argtypes:e.argtypes,options:this.options})};const BASH_COMPLETION_TEMPLATE_PATH=path.join(__dirname,"../etc/dashdash.bash_completion.in");function bashCompletionSpecFromOptions(e){assert.object(e,"args"),assert.object(e.options,"args.options"),assert.optionalString(e.context,"args.context"),assert.optionalBool(e.includeHidden,"args.includeHidden"),assert.optionalArrayOfString(e.argtypes,"args.argtypes");var r=e.context||"",t=void 0!==e.includeHidden&&e.includeHidden,o=[],n=[],a=[],s=[];return(e.options||[]).forEach(function(e){if(void 0===e.group||null===e.group){var r=e.names||[e.name],o=getOptionType(e.type);if(o.takesArg){var i=e.completionType||o.completionType||e.type;r.forEach(function(r){1===r.length?(!t&&e.hidden||n.push("-"+r),s.push("-"+r+"="+i)):(!t&&e.hidden||a.push("--"+r),s.push("--"+r+"="+i))})}else r.forEach(function(r){!t&&e.hidden||(1===r.length?n.push("-"+r):a.push("--"+r))})}}),o.push(format('local cmd%s_shortopts="%s"',r,n.sort().join(" "))),o.push(format('local cmd%s_longopts="%s"',r,a.sort().join(" "))),o.push(format('local cmd%s_optargs="%s"',r,s.sort().join(" "))),e.argtypes&&o.push(format('local cmd%s_argtypes="%s"',r,e.argtypes.join(" "))),o.join("\n")}function bashCompletionFromOptions(e){assert.object(e,"args"),assert.object(e.options,"args.options"),assert.string(e.name,"args.name"),assert.optionalString(e.specExtra,"args.specExtra"),assert.optionalArrayOfString(e.argtypes,"args.argtypes");var r={name:e.name,date:new Date,spec:bashCompletionSpecFromOptions({options:e.options,argtypes:e.argtypes})};return e.specExtra&&(r.spec+="\n\n"+e.specExtra),renderTemplate(fs.readFileSync(BASH_COMPLETION_TEMPLATE_PATH,"utf8"),r)}function createParser(e){return new Parser(e)}function parse(e){assert.object(e,"config"),assert.optionalArrayOfString(e.argv,"config.argv"),assert.optionalObject(e.env,"config.env");var r=(e=shallowCopy(e)).argv;delete e.argv;var t=e.env;return delete e.env,new Parser(e).parse({argv:r,env:t})}function addOptionType(e){assert.object(e,"optionType"),assert.string(e.name,"optionType.name"),assert.bool(e.takesArg,"optionType.takesArg"),e.takesArg&&assert.string(e.helpArg,"optionType.helpArg"),assert.func(e.parseArg,"optionType.parseArg"),assert.optionalBool(e.array,"optionType.array"),assert.optionalBool(e.arrayFlatten,"optionType.arrayFlatten"),optionTypes[e.name]={takesArg:e.takesArg,helpArg:e.helpArg,parseArg:e.parseArg,array:e.array,arrayFlatten:e.arrayFlatten,default:e.default}}function getOptionType(e){return assert.string(e,"name"),optionTypes[e]}function synopsisFromOpt(e){if(assert.object(e,"o"),e.hasOwnProperty("group"))return null;var r=e.names||[e.name],t=getOptionType(e.type),o=e.helpArg||t&&t.helpArg||"ARG",n=[];return r.forEach(function(e){var r=(1===e.length?"-":"--")+e;t&&t.takesArg&&(r+=1===e.length?" "+o:"="+o),n.push(r)}),"[ "+n.join(" | ")+" ]"}module.exports={createParser:createParser,Parser:Parser,parse:parse,addOptionType:addOptionType,getOptionType:getOptionType,synopsisFromOpt:synopsisFromOpt,BASH_COMPLETION_TEMPLATE_PATH:BASH_COMPLETION_TEMPLATE_PATH,bashCompletionFromOptions:bashCompletionFromOptions,bashCompletionSpecFromOptions:bashCompletionSpecFromOptions,parseBool:parseBool,parseString:parseString,parseNumber:parseNumber,parseInteger:parseInteger,parsePositiveInteger:parsePositiveInteger,parseDate:parseDate};