var BigInteger=require("jsbn").BigInteger,ECCurveFp=require("./ec.js").ECCurveFp;function X9ECParameters(F,e,r,C){this.curve=F,this.g=e,this.n=r,this.h=C}function x9getCurve(){return this.curve}function x9getG(){return this.g}function x9getN(){return this.n}function x9getH(){return this.h}function fromHex(F){return new BigInteger(F,16)}function secp128r1(){var F=fromHex("FFFFFFFDFFFFFFFFFFFFFFFFFFFFFFFF"),e=fromHex("FFFFFFFDFFFFFFFFFFFFFFFFFFFFFFFC"),r=fromHex("E87579C11079F43DD824993C2CEE5ED3"),C=fromHex("FFFFFFFE0000000075A30D1B9038A115"),E=BigInteger.ONE,B=new ECCurveFp(F,e,r);return new X9ECParameters(B,B.decodePointHex("04161FF7528B899B2D0C28607CA52C5B86CF5AC8395BAFEB13C02DA292DDED7A83"),C,E)}function secp160k1(){var F=fromHex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFAC73"),e=BigInteger.ZERO,r=fromHex("7"),C=fromHex("0100000000000000000001B8FA16DFAB9ACA16B6B3"),E=BigInteger.ONE,B=new ECCurveFp(F,e,r);return new X9ECParameters(B,B.decodePointHex("043B4C382CE37AA192A4019E763036F4F5DD4D7EBB938CF935318FDCED6BC28286531733C3F03C4FEE"),C,E)}function secp160r1(){var F=fromHex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFF"),e=fromHex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFC"),r=fromHex("1C97BEFC54BD7A8B65ACF89F81D4D4ADC565FA45"),C=fromHex("0100000000000000000001F4C8F927AED3CA752257"),E=BigInteger.ONE,B=new ECCurveFp(F,e,r);return new X9ECParameters(B,B.decodePointHex("044A96B5688EF573284664698968C38BB913CBFC8223A628553168947D59DCC912042351377AC5FB32"),C,E)}function secp192k1(){var F=fromHex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFEE37"),e=BigInteger.ZERO,r=fromHex("3"),C=fromHex("FFFFFFFFFFFFFFFFFFFFFFFE26F2FC170F69466A74DEFD8D"),E=BigInteger.ONE,B=new ECCurveFp(F,e,r);return new X9ECParameters(B,B.decodePointHex("04DB4FF10EC057E9AE26B07D0280B7F4341DA5D1B1EAE06C7D9B2F2F6D9C5628A7844163D015BE86344082AA88D95E2F9D"),C,E)}function secp192r1(){var F=fromHex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFF"),e=fromHex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFC"),r=fromHex("64210519E59C80E70FA7E9AB72243049FEB8DEECC146B9B1"),C=fromHex("FFFFFFFFFFFFFFFFFFFFFFFF99DEF836146BC9B1B4D22831"),E=BigInteger.ONE,B=new ECCurveFp(F,e,r);return new X9ECParameters(B,B.decodePointHex("04188DA80EB03090F67CBF20EB43A18800F4FF0AFD82FF101207192B95FFC8DA78631011ED6B24CDD573F977A11E794811"),C,E)}function secp224r1(){var F=fromHex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000001"),e=fromHex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFE"),r=fromHex("B4050A850C04B3ABF54132565044B0B7D7BFD8BA270B39432355FFB4"),C=fromHex("FFFFFFFFFFFFFFFFFFFFFFFFFFFF16A2E0B8F03E13DD29455C5C2A3D"),E=BigInteger.ONE,B=new ECCurveFp(F,e,r);return new X9ECParameters(B,B.decodePointHex("04B70E0CBD6BB4BF7F321390B94A03C1D356C21122343280D6115C1D21BD376388B5F723FB4C22DFE6CD4375A05A07476444D5819985007E34"),C,E)}function secp256r1(){var F=fromHex("FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF"),e=fromHex("FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC"),r=fromHex("5AC635D8AA3A93E7B3EBBD55769886BC651D06B0CC53B0F63BCE3C3E27D2604B"),C=fromHex("FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551"),E=BigInteger.ONE,B=new ECCurveFp(F,e,r);return new X9ECParameters(B,B.decodePointHex("046B17D1F2E12C4247F8BCE6E563A440F277037D812DEB33A0F4A13945D898C2964FE342E2FE1A7F9B8EE7EB4A7C0F9E162BCE33576B315ECECBB6406837BF51F5"),C,E)}function getSECCurveByName(F){return"secp128r1"==F?secp128r1():"secp160k1"==F?secp160k1():"secp160r1"==F?secp160r1():"secp192k1"==F?secp192k1():"secp192r1"==F?secp192r1():"secp224r1"==F?secp224r1():"secp256r1"==F?secp256r1():null}X9ECParameters.prototype.getCurve=x9getCurve,X9ECParameters.prototype.getG=x9getG,X9ECParameters.prototype.getN=x9getN,X9ECParameters.prototype.getH=x9getH,module.exports={secp128r1:secp128r1,secp160k1:secp160k1,secp160r1:secp160r1,secp192k1:secp192k1,secp192r1:secp192r1,secp224r1:secp224r1,secp256r1:secp256r1};