var assert=require("assert-plus"),crypto=require("crypto"),http=require("http"),util=require("util"),sshpk=require("sshpk"),jsprim=require("jsprim"),utils=require("./utils"),sprintf=require("util").format,HASH_ALGOS=utils.HASH_ALGOS,PK_ALGOS=utils.PK_ALGOS,InvalidAlgorithmError=utils.InvalidAlgorithmError,HttpSignatureError=utils.HttpSignatureError,validateAlgorithm=utils.validateAlgorithm,AUTHZ_FMT='Signature keyId="%s",algorithm="%s",headers="%s",signature="%s"';function MissingHeaderError(r){HttpSignatureError.call(this,r,MissingHeaderError)}function StrictParsingError(r){HttpSignatureError.call(this,r,StrictParsingError)}function RequestSigner(r){assert.object(r,"options");var e=[];if(void 0!==r.algorithm&&(assert.string(r.algorithm,"options.algorithm"),e=validateAlgorithm(r.algorithm)),this.rs_alg=e,void 0!==r.sign)assert.func(r.sign,"options.sign"),this.rs_signFunc=r.sign;else if("hmac"===e[0]&&void 0!==r.key){if(assert.string(r.keyId,"options.keyId"),this.rs_keyId=r.keyId,"string"!=typeof r.key&&!Buffer.isBuffer(r.key))throw new TypeError("options.key for HMAC must be a string or Buffer");this.rs_signer=crypto.createHmac(e[1].toUpperCase(),r.key),this.rs_signer.sign=function(){var r=this.digest("base64");return{hashAlgorithm:e[1],toString:function(){return r}}}}else{if(void 0===r.key)throw new TypeError("options.sign (func) or options.key is required");var t=r.key;if(("string"==typeof t||Buffer.isBuffer(t))&&(t=sshpk.parsePrivateKey(t)),assert.ok(sshpk.PrivateKey.isPrivateKey(t,[1,2]),"options.key must be a sshpk.PrivateKey"),this.rs_key=t,assert.string(r.keyId,"options.keyId"),this.rs_keyId=r.keyId,!PK_ALGOS[t.type])throw new InvalidAlgorithmError(t.type.toUpperCase()+" type keys are not supported");if(void 0!==e[0]&&t.type!==e[0])throw new InvalidAlgorithmError("options.key must be a "+e[0].toUpperCase()+" key, was given a "+t.type.toUpperCase()+" key instead");this.rs_signer=t.createSign(e[1])}this.rs_headers=[],this.rs_lines=[]}util.inherits(MissingHeaderError,HttpSignatureError),util.inherits(StrictParsingError,HttpSignatureError),RequestSigner.prototype.writeHeader=function(r,e){if(assert.string(r,"header"),r=r.toLowerCase(),assert.string(e,"value"),this.rs_headers.push(r),this.rs_signFunc)this.rs_lines.push(r+": "+e);else{var t=r+": "+e;this.rs_headers.length>0&&(t="\n"+t),this.rs_signer.update(t)}return e},RequestSigner.prototype.writeDateHeader=function(){return this.writeHeader("date",jsprim.rfc1123(new Date))},RequestSigner.prototype.writeTarget=function(r,e){assert.string(r,"method"),assert.string(e,"path"),r=r.toLowerCase(),this.writeHeader("(request-target)",r+" "+e)},RequestSigner.prototype.sign=function(r){if(assert.func(r,"callback"),this.rs_headers.length<1)throw new Error("At least one header must be signed");var e,t;if(this.rs_signFunc){var s=this.rs_lines.join("\n"),i=this;this.rs_signFunc(s,function(s,a){if(s)r(s);else{try{assert.object(a,"signature"),assert.string(a.keyId,"signature.keyId"),assert.string(a.algorithm,"signature.algorithm"),assert.string(a.signature,"signature.signature"),e=validateAlgorithm(a.algorithm),t=sprintf(AUTHZ_FMT,a.keyId,a.algorithm,i.rs_headers.join(" "),a.signature)}catch(e){return void r(e)}r(null,t)}})}else{try{var a=this.rs_signer.sign()}catch(e){return void r(e)}e=(this.rs_alg[0]||this.rs_key.type)+"-"+a.hashAlgorithm;var o=a.toString();t=sprintf(AUTHZ_FMT,this.rs_keyId,e,this.rs_headers.join(" "),o),r(null,t)}},module.exports={isSigner:function(r){return"object"==typeof r&&r instanceof RequestSigner},createSigner:function(r){return new RequestSigner(r)},signRequest:function(r,e){assert.object(r,"request"),assert.object(e,"options"),assert.optionalString(e.algorithm,"options.algorithm"),assert.string(e.keyId,"options.keyId"),assert.optionalArrayOfString(e.headers,"options.headers"),assert.optionalString(e.httpVersion,"options.httpVersion"),r.getHeader("Date")||r.setHeader("Date",jsprim.rfc1123(new Date)),e.headers||(e.headers=["date"]),e.httpVersion||(e.httpVersion="1.1");var t,s=[];e.algorithm&&(e.algorithm=e.algorithm.toLowerCase(),s=validateAlgorithm(e.algorithm));var i,a="";for(t=0;t<e.headers.length;t++){if("string"!=typeof e.headers[t])throw new TypeError("options.headers must be an array of Strings");var o=e.headers[t].toLowerCase();if("request-line"===o){if(e.strict)throw new StrictParsingError("request-line is not a valid header with strict parsing enabled.");a+=r.method+" "+r.path+" HTTP/"+e.httpVersion}else if("(request-target)"===o)a+="(request-target): "+r.method.toLowerCase()+" "+r.path;else{var n=r.getHeader(o);if(void 0===n||""===n)throw new MissingHeaderError(o+" was not in the request");a+=o+": "+n}t+1<e.headers.length&&(a+="\n")}if(r.hasOwnProperty("_stringToSign")&&(r._stringToSign=a),"hmac"===s[0]){if("string"!=typeof e.key&&!Buffer.isBuffer(e.key))throw new TypeError("options.key must be a string or Buffer");var h=crypto.createHmac(s[1].toUpperCase(),e.key);h.update(a),i=h.digest("base64")}else{var g=e.key;if(("string"==typeof g||Buffer.isBuffer(g))&&(g=sshpk.parsePrivateKey(e.key)),assert.ok(sshpk.PrivateKey.isPrivateKey(g,[1,2]),"options.key must be a sshpk.PrivateKey"),!PK_ALGOS[g.type])throw new InvalidAlgorithmError(g.type.toUpperCase()+" type keys are not supported");if(void 0!==s[0]&&g.type!==s[0])throw new InvalidAlgorithmError("options.key must be a "+s[0].toUpperCase()+" key, was given a "+g.type.toUpperCase()+" key instead");var p=g.createSign(s[1]);p.update(a);var u=p.sign();if(!HASH_ALGOS[u.hashAlgorithm])throw new InvalidAlgorithmError(u.hashAlgorithm.toUpperCase()+" is not a supported hash algorithm");e.algorithm=g.type+"-"+u.hashAlgorithm,i=u.toString(),assert.notStrictEqual(i,"","empty signature produced")}var l=e.authorizationHeaderName||"Authorization";return r.setHeader(l,sprintf(AUTHZ_FMT,e.keyId,e.algorithm,e.headers.join(" "),i)),!0}};