"use strict";var traverse=require("../index"),assert=require("assert");describe("json-schema-traverse",function(){var e;function r(){e.push(Array.prototype.slice.call(arguments))}function t(){e.push(["pre"].concat(Array.prototype.slice.call(arguments)))}function s(){e.push(["post"].concat(Array.prototype.slice.call(arguments)))}beforeEach(function(){e=[]}),it("should traverse all keywords containing schemas recursively",function(){var t=require("./fixtures/schema").schema,s=require("./fixtures/schema").expectedCalls;traverse(t,{cb:r}),assert.deepStrictEqual(e,s)}),describe("Legacy v0.3.1 API",function(){it("should traverse all keywords containing schemas recursively",function(){var t=require("./fixtures/schema").schema,s=require("./fixtures/schema").expectedCalls;traverse(t,r),assert.deepStrictEqual(e,s)}),it("should work when an options object is provided",function(){var t=require("./fixtures/schema").schema,s=require("./fixtures/schema").expectedCalls;traverse(t,{},r),assert.deepStrictEqual(e,s)})}),describe("allKeys option",function(){var t={someObject:{minimum:1,maximum:2}};it("should traverse objects with allKeys: true option",function(){var s=[[t,"",t,void 0,void 0,void 0,void 0],[t.someObject,"/someObject",t,"","someObject",t,void 0]];traverse(t,{allKeys:!0,cb:r}),assert.deepStrictEqual(e,s)}),it("should NOT traverse objects with allKeys: false option",function(){var s=[[t,"",t,void 0,void 0,void 0,void 0]];traverse(t,{allKeys:!1,cb:r}),assert.deepStrictEqual(e,s)}),it("should NOT traverse objects without allKeys option",function(){var s=[[t,"",t,void 0,void 0,void 0,void 0]];traverse(t,{cb:r}),assert.deepStrictEqual(e,s)}),it("should NOT travers objects in standard keywords which value is not a schema",function(){var t={const:{foo:"bar"},enum:["a","b"],required:["foo"],another:{},patternProperties:{},dependencies:!0,properties:{smaller:{type:"number"},larger:{type:"number",minimum:{$data:"1/smaller"}}}},s=[[t,"",t,void 0,void 0,void 0,void 0],[t.another,"/another",t,"","another",t,void 0],[t.properties.smaller,"/properties/smaller",t,"","properties",t,"smaller"],[t.properties.larger,"/properties/larger",t,"","properties",t,"larger"]];traverse(t,{allKeys:!0,cb:r}),assert.deepStrictEqual(e,s)})}),describe("pre and post",function(){var r={type:"object",properties:{name:{type:"string"},age:{type:"number"}}};it("should traverse schema in pre-order",function(){traverse(r,{cb:{pre:t}});var s=[["pre",r,"",r,void 0,void 0,void 0,void 0],["pre",r.properties.name,"/properties/name",r,"","properties",r,"name"],["pre",r.properties.age,"/properties/age",r,"","properties",r,"age"]];assert.deepStrictEqual(e,s)}),it("should traverse schema in post-order",function(){traverse(r,{cb:{post:s}});var t=[["post",r.properties.name,"/properties/name",r,"","properties",r,"name"],["post",r.properties.age,"/properties/age",r,"","properties",r,"age"],["post",r,"",r,void 0,void 0,void 0,void 0]];assert.deepStrictEqual(e,t)}),it("should traverse schema in pre- and post-order at the same time",function(){traverse(r,{cb:{pre:t,post:s}});var i=[["pre",r,"",r,void 0,void 0,void 0,void 0],["pre",r.properties.name,"/properties/name",r,"","properties",r,"name"],["post",r.properties.name,"/properties/name",r,"","properties",r,"name"],["pre",r.properties.age,"/properties/age",r,"","properties",r,"age"],["post",r.properties.age,"/properties/age",r,"","properties",r,"age"],["post",r,"",r,void 0,void 0,void 0,void 0]];assert.deepStrictEqual(e,i)})})});