"use strict";var http=require("http"),https=require("https"),url=require("url"),util=require("util"),stream=require("stream"),zlib=require("zlib"),aws2=require("aws-sign2"),aws4=require("aws4"),httpSignature=require("http-signature"),mime=require("mime-types"),caseless=require("caseless"),ForeverAgent=require("forever-agent"),FormData=require("form-data"),extend=require("extend"),isstream=require("isstream"),isTypedArray=require("is-typedarray").strict,helpers=require("./lib/helpers"),cookies=require("./lib/cookies"),getProxyFromURI=require("./lib/getProxyFromURI"),Querystring=require("./lib/querystring").Querystring,Har=require("./lib/har").Har,Auth=require("./lib/auth").Auth,OAuth=require("./lib/oauth").OAuth,hawk=require("./lib/hawk"),Multipart=require("./lib/multipart").Multipart,Redirect=require("./lib/redirect").Redirect,Tunnel=require("./lib/tunnel").Tunnel,now=require("performance-now"),Buffer=require("safe-buffer").Buffer,safeStringify=helpers.safeStringify,isReadStream=helpers.isReadStream,toBase64=helpers.toBase64,defer=helpers.defer,copy=helpers.copy,version=helpers.version,globalCookieJar=cookies.jar(),globalPool={};function filterForNonReserved(e,t){var r={};for(var i in t){-1===e.indexOf(i)&&(r[i]=t[i])}return r}function filterOutReservedFunctions(e,t){var r={};for(var i in t){var s=!(-1===e.indexOf(i)),o="function"==typeof t[i];s&&o||(r[i]=t[i])}return r}function requestToJSON(){return{uri:this.uri,method:this.method,headers:this.headers}}function responseToJSON(){return{statusCode:this.statusCode,body:this.body,headers:this.headers,request:requestToJSON.call(this.request)}}function Request(e){e.har&&(this._har=new Har(this),e=this._har.options(e)),stream.Stream.call(this);var t=Object.keys(Request.prototype),r=filterForNonReserved(t,e);extend(this,r),e=filterOutReservedFunctions(t,e),this.readable=!0,this.writable=!0,e.method&&(this.explicitMethod=!0),this._qs=new Querystring(this),this._auth=new Auth(this),this._oauth=new OAuth(this),this._multipart=new Multipart(this),this._redirect=new Redirect(this),this._tunnel=new Tunnel(this),this.init(e)}function debug(){Request.debug&&console.error("REQUEST %s",util.format.apply(util,arguments))}util.inherits(Request,stream.Stream),Request.debug=process.env.NODE_DEBUG&&/\brequest\b/.test(process.env.NODE_DEBUG),Request.prototype.debug=debug,Request.prototype.init=function(e){var t=this;for(var r in e||(e={}),t.headers=t.headers?copy(t.headers):{},t.headers)void 0===t.headers[r]&&delete t.headers[r];if(caseless.httpify(t,t.headers),t.method||(t.method=e.method||"GET"),t.localAddress||(t.localAddress=e.localAddress),t._qs.init(e),debug(e),t.pool||!1===t.pool||(t.pool=globalPool),t.dests=t.dests||[],t.__isRequestRequest=!0,!t._callback&&t.callback&&(t._callback=t.callback,t.callback=function(){t._callbackCalled||(t._callbackCalled=!0,t._callback.apply(t,arguments))},t.on("error",t.callback.bind()),t.on("complete",t.callback.bind(t,null))),!t.uri&&t.url&&(t.uri=t.url,delete t.url),t.baseUrl){if("string"!=typeof t.baseUrl)return t.emit("error",new Error("options.baseUrl must be a string"));if("string"!=typeof t.uri)return t.emit("error",new Error("options.uri must be a string when using options.baseUrl"));if(0===t.uri.indexOf("//")||-1!==t.uri.indexOf("://"))return t.emit("error",new Error("options.uri must be a path when using options.baseUrl"));var i=t.baseUrl.lastIndexOf("/")===t.baseUrl.length-1,s=0===t.uri.indexOf("/");i&&s?t.uri=t.baseUrl+t.uri.slice(1):i||s?t.uri=t.baseUrl+t.uri:""===t.uri?t.uri=t.baseUrl:t.uri=t.baseUrl+"/"+t.uri,delete t.baseUrl}if(!t.uri)return t.emit("error",new Error("options.uri is a required argument"));if("string"==typeof t.uri&&(t.uri=url.parse(t.uri)),t.uri.href||(t.uri.href=url.format(t.uri)),"unix:"===t.uri.protocol)return t.emit("error",new Error("`unix://` URL scheme is no longer supported. Please use the format `http://unix:SOCKET:PATH`"));if("unix"===t.uri.host&&t.enableUnixSocket(),!1===t.strictSSL&&(t.rejectUnauthorized=!1),t.uri.pathname||(t.uri.pathname="/"),!(t.uri.host||t.uri.hostname&&t.uri.port||t.uri.isUnix)){var o='Invalid URI "'+url.format(t.uri)+'"';return 0===Object.keys(e).length&&(o+=". This can be caused by a crappy redirection."),t.abort(),t.emit("error",new Error(o))}if(t.hasOwnProperty("proxy")||(t.proxy=getProxyFromURI(t.uri)),t.tunnel=t._tunnel.isEnabled(),t.proxy&&t._tunnel.setup(e),t._redirect.onRequest(e),t.setHost=!1,!t.hasHeader("host")){var n=t.originalHostHeaderName||"host";t.setHeader(n,t.uri.host),t.uri.port&&("80"===t.uri.port&&"http:"===t.uri.protocol||"443"===t.uri.port&&"https:"===t.uri.protocol)&&t.setHeader(n,t.uri.hostname),t.setHost=!0}if(t.jar(t._jar||e.jar),t.uri.port||("http:"===t.uri.protocol?t.uri.port=80:"https:"===t.uri.protocol&&(t.uri.port=443)),t.proxy&&!t.tunnel?(t.port=t.proxy.port,t.host=t.proxy.hostname):(t.port=t.uri.port,t.host=t.uri.hostname),e.form&&t.form(e.form),e.formData){var a=e.formData,u=t.form(),h=function(e,t){t&&t.hasOwnProperty("value")&&t.hasOwnProperty("options")?u.append(e,t.value,t.options):u.append(e,t)};for(var p in a)if(a.hasOwnProperty(p)){var d=a[p];if(d instanceof Array)for(var c=0;c<d.length;c++)h(p,d[c]);else h(p,d)}}if(e.qs&&t.qs(e.qs),t.uri.path?t.path=t.uri.path:t.path=t.uri.pathname+(t.uri.search||""),0===t.path.length&&(t.path="/"),e.aws&&t.aws(e.aws),e.hawk&&t.hawk(e.hawk),e.httpSignature&&t.httpSignature(e.httpSignature),e.auth&&(Object.prototype.hasOwnProperty.call(e.auth,"username")&&(e.auth.user=e.auth.username),Object.prototype.hasOwnProperty.call(e.auth,"password")&&(e.auth.pass=e.auth.password),t.auth(e.auth.user,e.auth.pass,e.auth.sendImmediately,e.auth.bearer)),t.gzip&&!t.hasHeader("accept-encoding")&&t.setHeader("accept-encoding","gzip, deflate"),t.uri.auth&&!t.hasHeader("authorization")){var l=t.uri.auth.split(":").map(function(e){return t._qs.unescape(e)});t.auth(l[0],l.slice(1).join(":"),!0)}if(!t.tunnel&&t.proxy&&t.proxy.auth&&!t.hasHeader("proxy-authorization")){var m=t.proxy.auth.split(":").map(function(e){return t._qs.unescape(e)}),f="Basic "+toBase64(m.join(":"));t.setHeader("proxy-authorization",f)}function g(){var e;(isTypedArray(t.body)&&(t.body=Buffer.from(t.body)),t.hasHeader("content-length"))||((e="string"==typeof t.body?Buffer.byteLength(t.body):Array.isArray(t.body)?t.body.reduce(function(e,t){return e+t.length},0):t.body.length)?t.setHeader("content-length",e):t.emit("error",new Error("Argument error, options.body.")))}t.proxy&&!t.tunnel&&(t.path=t.uri.protocol+"//"+t.uri.host+t.path),e.json&&t.json(e.json),e.multipart&&t.multipart(e.multipart),e.time&&(t.timing=!0,t.elapsedTime=t.elapsedTime||0),t.body&&!isstream(t.body)&&g(),e.oauth?t.oauth(e.oauth):t._oauth.params&&t.hasHeader("authorization")&&t.oauth(t._oauth.params);var y=t.proxy&&!t.tunnel?t.proxy.protocol:t.uri.protocol,b={"http:":http,"https:":https},q=t.httpModules||{};if(t.httpModule=q[y]||b[y],!t.httpModule)return t.emit("error",new Error("Invalid protocol: "+y));if(e.ca&&(t.ca=e.ca),!t.agent)if(e.agentOptions&&(t.agentOptions=e.agentOptions),e.agentClass)t.agentClass=e.agentClass;else if(e.forever){var v=version();0===v.major&&v.minor<=10?t.agentClass="http:"===y?ForeverAgent:ForeverAgent.SSL:(t.agentClass=t.httpModule.Agent,t.agentOptions=t.agentOptions||{},t.agentOptions.keepAlive=!0)}else t.agentClass=t.httpModule.Agent;!1===t.pool?t.agent=!1:t.agent=t.agent||t.getNewAgent(),t.on("pipe",function(e){if(t.ntick&&t._started&&t.emit("error",new Error("You cannot pipe to this stream after the outbound request has started.")),t.src=e,isReadStream(e))t.hasHeader("content-type")||t.setHeader("content-type",mime.lookup(e.path));else{if(e.headers)for(var r in e.headers)t.hasHeader(r)||t.setHeader(r,e.headers[r]);t._json&&!t.hasHeader("content-type")&&t.setHeader("content-type","application/json"),e.method&&!t.explicitMethod&&(t.method=e.method)}}),defer(function(){if(!t._aborted){var e=function(){if(t._form&&(t._auth.hasAuth?t._auth.hasAuth&&t._auth.sentAuth&&t._form.pipe(t):t._form.pipe(t)),t._multipart&&t._multipart.chunked&&t._multipart.body.pipe(t),t.body)isstream(t.body)?t.body.pipe(t):(g(),Array.isArray(t.body)?t.body.forEach(function(e){t.write(e)}):t.write(t.body),t.end());else if(t.requestBodyStream)console.warn("options.requestBodyStream is deprecated, please pass the request object to stream.pipe."),t.requestBodyStream.pipe(t);else if(!t.src){if(t._auth.hasAuth&&!t._auth.sentAuth)return void t.end();"GET"!==t.method&&void 0!==t.method&&t.setHeader("content-length",0),t.end()}};t._form&&!t.hasHeader("content-length")?(t.setHeader(t._form.getHeaders(),!0),t._form.getLength(function(r,i){r||isNaN(i)||t.setHeader("content-length",i),e()})):e(),t.ntick=!0}})},Request.prototype.getNewAgent=function(){var e=this.agentClass,t={};if(this.agentOptions)for(var r in this.agentOptions)t[r]=this.agentOptions[r];this.ca&&(t.ca=this.ca),this.ciphers&&(t.ciphers=this.ciphers),this.secureProtocol&&(t.secureProtocol=this.secureProtocol),this.secureOptions&&(t.secureOptions=this.secureOptions),void 0!==this.rejectUnauthorized&&(t.rejectUnauthorized=this.rejectUnauthorized),this.cert&&this.key&&(t.key=this.key,t.cert=this.cert),this.pfx&&(t.pfx=this.pfx),this.passphrase&&(t.passphrase=this.passphrase);var i="";e!==this.httpModule.Agent&&(i+=e.name);var s=this.proxy;return"string"==typeof s&&(s=url.parse(s)),(s&&"https:"===s.protocol||"https:"===this.uri.protocol)&&(t.ca&&(i&&(i+=":"),i+=t.ca),void 0!==t.rejectUnauthorized&&(i&&(i+=":"),i+=t.rejectUnauthorized),t.cert&&(i&&(i+=":"),i+=t.cert.toString("ascii")+t.key.toString("ascii")),t.pfx&&(i&&(i+=":"),i+=t.pfx.toString("ascii")),t.ciphers&&(i&&(i+=":"),i+=t.ciphers),t.secureProtocol&&(i&&(i+=":"),i+=t.secureProtocol),t.secureOptions&&(i&&(i+=":"),i+=t.secureOptions)),this.pool===globalPool&&!i&&0===Object.keys(t).length&&this.httpModule.globalAgent?this.httpModule.globalAgent:(i=this.uri.protocol+i,this.pool[i]||(this.pool[i]=new e(t),this.pool.maxSockets&&(this.pool[i].maxSockets=this.pool.maxSockets)),this.pool[i])},Request.prototype.start=function(){var e=this;if(e.timing)var t=(new Date).getTime(),r=now();if(!e._aborted){e._started=!0,e.method=e.method||"GET",e.href=e.uri.href,e.src&&e.src.stat&&e.src.stat.size&&!e.hasHeader("content-length")&&e.setHeader("content-length",e.src.stat.size),e._aws&&e.aws(e._aws,!0);var i,s=copy(e);delete s.auth,debug("make request",e.uri.href),delete s.timeout;try{e.req=e.httpModule.request(s)}catch(t){return void e.emit("error",t)}e.timing&&(e.startTime=t,e.startTimeNow=r,e.timings={}),e.timeout&&!e.timeoutTimer&&(e.timeout<0?i=0:"number"==typeof e.timeout&&isFinite(e.timeout)&&(i=e.timeout)),e.req.on("response",e.onRequestResponse.bind(e)),e.req.on("error",e.onRequestError.bind(e)),e.req.on("drain",function(){e.emit("drain")}),e.req.on("socket",function(t){var r=t._connecting||t.connecting;if(e.timing&&(e.timings.socket=now()-e.startTimeNow,r)){var s=function(){e.timings.lookup=now()-e.startTimeNow},o=function(){e.timings.connect=now()-e.startTimeNow};t.once("lookup",s),t.once("connect",o),e.req.once("error",function(){t.removeListener("lookup",s),t.removeListener("connect",o)})}var n=function(){e.req.setTimeout(i,function(){if(e.req){e.abort();var t=new Error("ESOCKETTIMEDOUT");t.code="ESOCKETTIMEDOUT",t.connect=!1,e.emit("error",t)}})};if(void 0!==i)if(r){var a=function(){t.removeListener("connect",a),e.clearTimeout(),n()};t.on("connect",a),e.req.on("error",function(e){t.removeListener("connect",a)}),e.timeoutTimer=setTimeout(function(){t.removeListener("connect",a),e.abort();var r=new Error("ETIMEDOUT");r.code="ETIMEDOUT",r.connect=!0,e.emit("error",r)},i)}else n();e.emit("socket",t)}),e.emit("request",e.req)}},Request.prototype.onRequestError=function(e){if(!this._aborted){if(this.req&&this.req._reusedSocket&&"ECONNRESET"===e.code&&this.agent.addRequestNoreuse)return this.agent={addRequest:this.agent.addRequestNoreuse.bind(this.agent)},this.start(),void this.req.end();this.clearTimeout(),this.emit("error",e)}},Request.prototype.onRequestResponse=function(e){var t=this;if(t.timing&&(t.timings.response=now()-t.startTimeNow),debug("onRequestResponse",t.uri.href,e.statusCode,e.headers),e.on("end",function(){t.timing&&(t.timings.end=now()-t.startTimeNow,e.timingStart=t.startTime,t.timings.socket||(t.timings.socket=0),t.timings.lookup||(t.timings.lookup=t.timings.socket),t.timings.connect||(t.timings.connect=t.timings.lookup),t.timings.response||(t.timings.response=t.timings.connect),debug("elapsed time",t.timings.end),t.elapsedTime+=Math.round(t.timings.end),e.elapsedTime=t.elapsedTime,e.timings=t.timings,e.timingPhases={wait:t.timings.socket,dns:t.timings.lookup-t.timings.socket,tcp:t.timings.connect-t.timings.lookup,firstByte:t.timings.response-t.timings.connect,download:t.timings.end-t.timings.response,total:t.timings.end}),debug("response end",t.uri.href,e.statusCode,e.headers)}),t._aborted)return debug("aborted",t.uri.href),void e.resume();if(t.response=e,e.request=t,e.toJSON=responseToJSON,t.httpModule!==https||!t.strictSSL||e.hasOwnProperty("socket")&&e.socket.authorized){t.originalHost=t.getHeader("host"),t.originalHostHeaderName||(t.originalHostHeaderName=t.hasHeader("host")),t.setHost&&t.removeHeader("host"),t.clearTimeout();var r=t._jar&&t._jar.setCookie?t._jar:globalCookieJar,i=function(e){try{r.setCookie(e,t.uri.href,{ignoreError:!0})}catch(e){t.emit("error",e)}};if(e.caseless=caseless(e.headers),e.caseless.has("set-cookie")&&!t._disableCookies){var s=e.caseless.has("set-cookie");Array.isArray(e.headers[s])?e.headers[s].forEach(i):i(e.headers[s])}if(!t._redirect.onResponse(e)){e.on("close",function(){t._ended||t.response.emit("end")}),e.once("end",function(){t._ended=!0});var o,n;if(!t.gzip||(n=e.statusCode,"HEAD"===t.method||n>=100&&n<200||204===n||304===n))o=e;else{var a=e.headers["content-encoding"]||"identity";a=a.trim().toLowerCase();var u={flush:zlib.Z_SYNC_FLUSH,finishFlush:zlib.Z_SYNC_FLUSH};"gzip"===a?(o=zlib.createGunzip(u),e.pipe(o)):"deflate"===a?(o=zlib.createInflate(u),e.pipe(o)):("identity"!==a&&debug("ignoring unrecognized Content-Encoding "+a),o=e)}t.encoding&&(0!==t.dests.length?console.error("Ignoring encoding parameter as this stream is being piped to another stream which makes the encoding option invalid."):o.setEncoding(t.encoding)),t._paused&&o.pause(),t.responseContent=o,t.emit("response",e),t.dests.forEach(function(e){t.pipeDest(e)}),o.on("data",function(r){t.timing&&!t.responseStarted&&(t.responseStartTime=(new Date).getTime(),e.responseStartTime=t.responseStartTime),t._destdata=!0,t.emit("data",r)}),o.once("end",function(e){t.emit("end",e)}),o.on("error",function(e){t.emit("error",e)}),o.on("close",function(){t.emit("close")}),t.callback?t.readResponseBody(e):t.on("end",function(){t._aborted?debug("aborted",t.uri.href):t.emit("complete",e)}),debug("finish init function",t.uri.href)}}else{debug("strict ssl error",t.uri.href);var h=e.hasOwnProperty("socket")?e.socket.authorizationError:t.uri.href+" does not support SSL";t.emit("error",new Error("SSL Error: "+h))}},Request.prototype.readResponseBody=function(e){var t=this;debug("reading response's body");var r=[],i=0,s=[];t.on("data",function(e){Buffer.isBuffer(e)?e.length&&(i+=e.length,r.push(e)):s.push(e)}),t.on("end",function(){if(debug("end event",t.uri.href),t._aborted)return debug("aborted",t.uri.href),r=[],void(i=0);if(i?(debug("has body",t.uri.href,i),e.body=Buffer.concat(r,i),null!==t.encoding&&(e.body=e.body.toString(t.encoding)),r=[],i=0):s.length&&("utf8"===t.encoding&&s[0].length>0&&"\ufeff"===s[0][0]&&(s[0]=s[0].substring(1)),e.body=s.join("")),t._json)try{e.body=JSON.parse(e.body,t._jsonReviver)}catch(e){debug("invalid JSON received",t.uri.href)}debug("emitting complete",t.uri.href),void 0!==e.body||t._json||(e.body=null===t.encoding?Buffer.alloc(0):""),t.emit("complete",e,e.body)})},Request.prototype.abort=function(){this._aborted=!0,this.req?this.req.abort():this.response&&this.response.destroy(),this.clearTimeout(),this.emit("abort")},Request.prototype.pipeDest=function(e){var t=this.response;if(e.headers&&!e.headersSent){if(t.caseless.has("content-type")){var r=t.caseless.has("content-type");e.setHeader?e.setHeader(r,t.headers[r]):e.headers[r]=t.headers[r]}if(t.caseless.has("content-length")){var i=t.caseless.has("content-length");e.setHeader?e.setHeader(i,t.headers[i]):e.headers[i]=t.headers[i]}}if(e.setHeader&&!e.headersSent){for(var s in t.headers)this.gzip&&"content-encoding"===s||e.setHeader(s,t.headers[s]);e.statusCode=t.statusCode}this.pipefilter&&this.pipefilter(t,e)},Request.prototype.qs=function(e,t){var r;for(var i in r=!t&&this.uri.query?this._qs.parse(this.uri.query):{},e)r[i]=e[i];var s=this._qs.stringify(r);return""===s?this:(this.uri=url.parse(this.uri.href.split("?")[0]+"?"+s),this.url=this.uri,this.path=this.uri.path,"unix"===this.uri.host&&this.enableUnixSocket(),this)},Request.prototype.form=function(e){var t=this;return e?(/^application\/x-www-form-urlencoded\b/.test(t.getHeader("content-type"))||t.setHeader("content-type","application/x-www-form-urlencoded"),t.body="string"==typeof e?t._qs.rfc3986(e.toString("utf8")):t._qs.stringify(e).toString("utf8"),t):(t._form=new FormData,t._form.on("error",function(e){e.message="form-data: "+e.message,t.emit("error",e),t.abort()}),t._form)},Request.prototype.multipart=function(e){return this._multipart.onRequest(e),this._multipart.chunked||(this.body=this._multipart.body),this},Request.prototype.json=function(e){return this.hasHeader("accept")||this.setHeader("accept","application/json"),"function"==typeof this.jsonReplacer&&(this._jsonReplacer=this.jsonReplacer),this._json=!0,"boolean"==typeof e?void 0!==this.body&&(/^application\/x-www-form-urlencoded\b/.test(this.getHeader("content-type"))?this.body=this._qs.rfc3986(this.body):this.body=safeStringify(this.body,this._jsonReplacer),this.hasHeader("content-type")||this.setHeader("content-type","application/json")):(this.body=safeStringify(e,this._jsonReplacer),this.hasHeader("content-type")||this.setHeader("content-type","application/json")),"function"==typeof this.jsonReviver&&(this._jsonReviver=this.jsonReviver),this},Request.prototype.getHeader=function(e,t){var r,i;return t||(t=this.headers),Object.keys(t).forEach(function(s){s.length===e.length&&(i=new RegExp(e,"i"),s.match(i)&&(r=t[s]))}),r},Request.prototype.enableUnixSocket=function(){var e=this.uri.path.split(":"),t=e[0],r=e[1];this.socketPath=t,this.uri.pathname=r,this.uri.path=r,this.uri.host=t,this.uri.hostname=t,this.uri.isUnix=!0},Request.prototype.auth=function(e,t,r,i){return this._auth.onRequest(e,t,r,i),this},Request.prototype.aws=function(e,t){if(!t)return this._aws=e,this;if(4===e.sign_version||"4"===e.sign_version){var r={host:this.uri.host,path:this.uri.path,method:this.method,headers:this.headers,body:this.body};e.service&&(r.service=e.service);var i=aws4.sign(r,{accessKeyId:e.key,secretAccessKey:e.secret,sessionToken:e.session});this.setHeader("authorization",i.headers.Authorization),this.setHeader("x-amz-date",i.headers["X-Amz-Date"]),i.headers["X-Amz-Security-Token"]&&this.setHeader("x-amz-security-token",i.headers["X-Amz-Security-Token"])}else{var s=new Date;this.setHeader("date",s.toUTCString());var o={key:e.key,secret:e.secret,verb:this.method.toUpperCase(),date:s,contentType:this.getHeader("content-type")||"",md5:this.getHeader("content-md5")||"",amazonHeaders:aws2.canonicalizeHeaders(this.headers)},n=this.uri.path;e.bucket&&n?o.resource="/"+e.bucket+n:e.bucket&&!n?o.resource="/"+e.bucket:!e.bucket&&n?o.resource=n:e.bucket||n||(o.resource="/"),o.resource=aws2.canonicalizeResource(o.resource),this.setHeader("authorization",aws2.authorization(o))}return this},Request.prototype.httpSignature=function(e){var t=this;return httpSignature.signRequest({getHeader:function(e){return t.getHeader(e,t.headers)},setHeader:function(e,r){t.setHeader(e,r)},method:t.method,path:t.path},e),debug("httpSignature authorization",t.getHeader("authorization")),t},Request.prototype.hawk=function(e){this.setHeader("Authorization",hawk.header(this.uri,this.method,e))},Request.prototype.oauth=function(e){return this._oauth.onRequest(e),this},Request.prototype.jar=function(e){var t;if(0===this._redirect.redirectsFollowed&&(this.originalCookieHeader=this.getHeader("cookie")),e){var r=e.getCookieString?e:globalCookieJar,i=this.uri.href;r&&(t=r.getCookieString(i))}else t=!1,this._disableCookies=!0;return t&&t.length&&(this.originalCookieHeader?this.setHeader("cookie",this.originalCookieHeader+"; "+t):this.setHeader("cookie",t)),this._jar=e,this},Request.prototype.pipe=function(e,t){if(!this.response)return this.dests.push(e),stream.Stream.prototype.pipe.call(this,e,t),e;if(this._destdata)this.emit("error",new Error("You cannot pipe after data has been emitted from the response."));else{if(!this._ended)return stream.Stream.prototype.pipe.call(this,e,t),this.pipeDest(e),e;this.emit("error",new Error("You cannot pipe after the response has been ended."))}},Request.prototype.write=function(){if(!this._aborted)return this._started||this.start(),this.req?this.req.write.apply(this.req,arguments):void 0},Request.prototype.end=function(e){this._aborted||(e&&this.write(e),this._started||this.start(),this.req&&this.req.end())},Request.prototype.pause=function(){this.responseContent?this.responseContent.pause.apply(this.responseContent,arguments):this._paused=!0},Request.prototype.resume=function(){this.responseContent?this.responseContent.resume.apply(this.responseContent,arguments):this._paused=!1},Request.prototype.destroy=function(){this.clearTimeout(),this._ended?this.response&&this.response.destroy():this.end()},Request.prototype.clearTimeout=function(){this.timeoutTimer&&(clearTimeout(this.timeoutTimer),this.timeoutTimer=null)},Request.defaultProxyHeaderWhiteList=Tunnel.defaultProxyHeaderWhiteList.slice(),Request.defaultProxyHeaderExclusiveList=Tunnel.defaultProxyHeaderExclusiveList.slice(),Request.prototype.toJSON=requestToJSON,module.exports=Request;