"use strict";var test=require("tape"),buffer=require("buffer"),index=require("./"),safer=require("./safer"),dangerous=require("./dangerous");test("Default is Safer",function(f){f.equal(index,safer),f.notEqual(safer,dangerous),f.notEqual(index,dangerous),f.end()}),test("Is not a function",function(f){[index,safer,dangerous].forEach(function(e){f.equal(typeof e,"object"),f.equal(typeof e.Buffer,"object")}),[buffer].forEach(function(e){f.equal(typeof e,"object"),f.equal(typeof e.Buffer,"function")}),f.end()}),test("Constructor throws",function(f){[index,safer,dangerous].forEach(function(e){f.throws(function(){e.Buffer()}),f.throws(function(){e.Buffer(0)}),f.throws(function(){e.Buffer("a")}),f.throws(function(){e.Buffer("a","utf-8")}),f.throws(function(){return new e.Buffer}),f.throws(function(){return new e.Buffer(0)}),f.throws(function(){return new e.Buffer("a")}),f.throws(function(){return new e.Buffer("a","utf-8")})}),f.end()}),test("Safe methods exist",function(f){[index,safer,dangerous].forEach(function(e){f.equal(typeof e.Buffer.alloc,"function","alloc"),f.equal(typeof e.Buffer.from,"function","from")}),f.end()}),test("Unsafe methods exist only in Dangerous",function(f){[index,safer].forEach(function(e){f.equal(typeof e.Buffer.allocUnsafe,"undefined"),f.equal(typeof e.Buffer.allocUnsafeSlow,"undefined")}),[dangerous].forEach(function(e){f.equal(typeof e.Buffer.allocUnsafe,"function"),f.equal(typeof e.Buffer.allocUnsafeSlow,"function")}),f.end()}),test("Generic methods/properties are defined and equal",function(f){["poolSize","isBuffer","concat","byteLength"].forEach(function(e){[index,safer,dangerous].forEach(function(r){f.equal(r.Buffer[e],buffer.Buffer[e],e),f.notEqual(typeof r.Buffer[e],"undefined",e)})}),f.end()}),test("Built-in buffer static methods/properties are inherited",function(f){Object.keys(buffer).forEach(function(e){"SlowBuffer"!==e&&"Buffer"!==e&&[index,safer,dangerous].forEach(function(r){f.equal(r[e],buffer[e],e),f.notEqual(typeof r[e],"undefined",e)})}),f.end()}),test("Built-in Buffer static methods/properties are inherited",function(f){Object.keys(buffer.Buffer).forEach(function(e){"allocUnsafe"!==e&&"allocUnsafeSlow"!==e&&[index,safer,dangerous].forEach(function(r){f.equal(r.Buffer[e],buffer.Buffer[e],e),f.notEqual(typeof r.Buffer[e],"undefined",e)})}),f.end()}),test(".prototype property of Buffer is inherited",function(f){[index,safer,dangerous].forEach(function(e){f.equal(e.Buffer.prototype,buffer.Buffer.prototype,"prototype"),f.notEqual(typeof e.Buffer.prototype,"undefined","prototype")}),f.end()}),test("All Safer methods are present in Dangerous",function(f){Object.keys(safer).forEach(function(e){"Buffer"!==e&&[index,safer,dangerous].forEach(function(r){f.equal(r[e],safer[e],e),"kStringMaxLength"!==e&&f.notEqual(typeof r[e],"undefined",e)})}),Object.keys(safer.Buffer).forEach(function(e){[index,safer,dangerous].forEach(function(r){f.equal(r.Buffer[e],safer.Buffer[e],e),f.notEqual(typeof r.Buffer[e],"undefined",e)})}),f.end()}),test("Safe methods from Dangerous methods are present in Safer",function(f){Object.keys(dangerous).forEach(function(e){"Buffer"!==e&&[index,safer,dangerous].forEach(function(r){f.equal(r[e],dangerous[e],e),"kStringMaxLength"!==e&&f.notEqual(typeof r[e],"undefined",e)})}),Object.keys(dangerous.Buffer).forEach(function(e){"allocUnsafe"!==e&&"allocUnsafeSlow"!==e&&[index,safer,dangerous].forEach(function(r){f.equal(r.Buffer[e],dangerous.Buffer[e],e),f.notEqual(typeof r.Buffer[e],"undefined",e)})}),f.end()}),test("Methods return Buffers",function(f){[index,safer,dangerous].forEach(function(e){f.ok(buffer.Buffer.isBuffer(e.Buffer.alloc(0))),f.ok(buffer.Buffer.isBuffer(e.Buffer.alloc(0,10))),f.ok(buffer.Buffer.isBuffer(e.Buffer.alloc(0,"a"))),f.ok(buffer.Buffer.isBuffer(e.Buffer.alloc(10))),f.ok(buffer.Buffer.isBuffer(e.Buffer.alloc(10,"x"))),f.ok(buffer.Buffer.isBuffer(e.Buffer.alloc(9,"ab"))),f.ok(buffer.Buffer.isBuffer(e.Buffer.from(""))),f.ok(buffer.Buffer.isBuffer(e.Buffer.from("string"))),f.ok(buffer.Buffer.isBuffer(e.Buffer.from("string","utf-8"))),f.ok(buffer.Buffer.isBuffer(e.Buffer.from("b25ldHdvdGhyZWU=","base64"))),f.ok(buffer.Buffer.isBuffer(e.Buffer.from([0,42,3]))),f.ok(buffer.Buffer.isBuffer(e.Buffer.from(new Uint8Array([0,42,3])))),f.ok(buffer.Buffer.isBuffer(e.Buffer.from([])))}),["allocUnsafe","allocUnsafeSlow"].forEach(function(e){f.ok(buffer.Buffer.isBuffer(dangerous.Buffer[e](0))),f.ok(buffer.Buffer.isBuffer(dangerous.Buffer[e](10)))}),f.end()}),test("Constructor is buffer.Buffer",function(f){[index,safer,dangerous].forEach(function(e){f.equal(e.Buffer.alloc(0).constructor,buffer.Buffer),f.equal(e.Buffer.alloc(0,10).constructor,buffer.Buffer),f.equal(e.Buffer.alloc(0,"a").constructor,buffer.Buffer),f.equal(e.Buffer.alloc(10).constructor,buffer.Buffer),f.equal(e.Buffer.alloc(10,"x").constructor,buffer.Buffer),f.equal(e.Buffer.alloc(9,"ab").constructor,buffer.Buffer),f.equal(e.Buffer.from("").constructor,buffer.Buffer),f.equal(e.Buffer.from("string").constructor,buffer.Buffer),f.equal(e.Buffer.from("string","utf-8").constructor,buffer.Buffer),f.equal(e.Buffer.from("b25ldHdvdGhyZWU=","base64").constructor,buffer.Buffer),f.equal(e.Buffer.from([0,42,3]).constructor,buffer.Buffer),f.equal(e.Buffer.from(new Uint8Array([0,42,3])).constructor,buffer.Buffer),f.equal(e.Buffer.from([]).constructor,buffer.Buffer)}),[0,10,100].forEach(function(e){f.equal(dangerous.Buffer.allocUnsafe(e).constructor,buffer.Buffer),f.equal(dangerous.Buffer.allocUnsafeSlow(e).constructor,buffer.SlowBuffer(0).constructor)}),f.end()}),test("Invalid calls throw",function(f){[index,safer,dangerous].forEach(function(e){f.throws(function(){e.Buffer.from(0)}),f.throws(function(){e.Buffer.from(10)}),f.throws(function(){e.Buffer.from(10,"utf-8")}),f.throws(function(){e.Buffer.from("string","invalid encoding")}),f.throws(function(){e.Buffer.from(-10)}),f.throws(function(){e.Buffer.from(1e90)}),f.throws(function(){e.Buffer.from(1/0)}),f.throws(function(){e.Buffer.from(-1/0)}),f.throws(function(){e.Buffer.from(NaN)}),f.throws(function(){e.Buffer.from(null)}),f.throws(function(){e.Buffer.from(void 0)}),f.throws(function(){e.Buffer.from()}),f.throws(function(){e.Buffer.from({})}),f.throws(function(){e.Buffer.alloc("")}),f.throws(function(){e.Buffer.alloc("string")}),f.throws(function(){e.Buffer.alloc("string","utf-8")}),f.throws(function(){e.Buffer.alloc("b25ldHdvdGhyZWU=","base64")}),f.throws(function(){e.Buffer.alloc(-10)}),f.throws(function(){e.Buffer.alloc(1e90)}),f.throws(function(){e.Buffer.alloc(2*(1<<30))}),f.throws(function(){e.Buffer.alloc(1/0)}),f.throws(function(){e.Buffer.alloc(-1/0)}),f.throws(function(){e.Buffer.alloc(null)}),f.throws(function(){e.Buffer.alloc(void 0)}),f.throws(function(){e.Buffer.alloc()}),f.throws(function(){e.Buffer.alloc([])}),f.throws(function(){e.Buffer.alloc([0,42,3])}),f.throws(function(){e.Buffer.alloc({})})}),["allocUnsafe","allocUnsafeSlow"].forEach(function(e){f.throws(function(){dangerous.Buffer[e]("")}),f.throws(function(){dangerous.Buffer[e]("string")}),f.throws(function(){dangerous.Buffer[e]("string","utf-8")}),f.throws(function(){dangerous.Buffer[e](2*(1<<30))}),f.throws(function(){dangerous.Buffer[e](1/0)}),dangerous.Buffer[e]===buffer.Buffer.allocUnsafe?f.skip("Skipping, older impl of allocUnsafe coerced negative sizes to 0"):(f.throws(function(){dangerous.Buffer[e](-10)}),f.throws(function(){dangerous.Buffer[e](-1e90)}),f.throws(function(){dangerous.Buffer[e](-1/0)})),f.throws(function(){dangerous.Buffer[e](null)}),f.throws(function(){dangerous.Buffer[e](void 0)}),f.throws(function(){dangerous.Buffer[e]()}),f.throws(function(){dangerous.Buffer[e]([])}),f.throws(function(){dangerous.Buffer[e]([0,42,3])}),f.throws(function(){dangerous.Buffer[e]({})})}),f.end()}),test("Buffers have appropriate lengths",function(f){[index,safer,dangerous].forEach(function(e){f.equal(e.Buffer.alloc(0).length,0),f.equal(e.Buffer.alloc(10).length,10),f.equal(e.Buffer.from("").length,0),f.equal(e.Buffer.from("string").length,6),f.equal(e.Buffer.from("string","utf-8").length,6),f.equal(e.Buffer.from("b25ldHdvdGhyZWU=","base64").length,11),f.equal(e.Buffer.from([0,42,3]).length,3),f.equal(e.Buffer.from(new Uint8Array([0,42,3])).length,3),f.equal(e.Buffer.from([]).length,0)}),["allocUnsafe","allocUnsafeSlow"].forEach(function(e){f.equal(dangerous.Buffer[e](0).length,0),f.equal(dangerous.Buffer[e](10).length,10)}),f.end()}),test("Buffers have appropriate lengths (2)",function(f){f.equal(index.Buffer.alloc,safer.Buffer.alloc),f.equal(index.Buffer.alloc,dangerous.Buffer.alloc);var e=!0;[safer.Buffer.alloc,dangerous.Buffer.allocUnsafe,dangerous.Buffer.allocUnsafeSlow].forEach(function(f){for(var r=0;r<100;r++){var u=Math.round(1e5*Math.random()),o=f(u);buffer.Buffer.isBuffer(o)||(e=!1),o.length!==u&&(e=!1)}}),f.ok(e),f.end()}),test(".alloc(size) is zero-filled and has correct length",function(f){f.equal(index.Buffer.alloc,safer.Buffer.alloc),f.equal(index.Buffer.alloc,dangerous.Buffer.alloc);for(var e=!0,r=0;r<100;r++){var u,o=Math.round(2e6*Math.random()),n=index.Buffer.alloc(o);for(buffer.Buffer.isBuffer(n)||(e=!1),n.length!==o&&(e=!1),u=0;u<o;u++)0!==n[u]&&(e=!1);for(n.fill(1),u=0;u<o;u++)1!==n[u]&&(e=!1)}f.ok(e),f.end()}),test(".allocUnsafe / .allocUnsafeSlow are fillable and have correct lengths",function(f){["allocUnsafe","allocUnsafeSlow"].forEach(function(e){for(var r=!0,u=0;u<100;u++){var o,n=Math.round(2e6*Math.random()),t=dangerous.Buffer[e](n);for(buffer.Buffer.isBuffer(t)||(r=!1),t.length!==n&&(r=!1),t.fill(0,0,n),o=0;o<n;o++)0!==t[o]&&(r=!1);for(t.fill(1,0,n),o=0;o<n;o++)1!==t[o]&&(r=!1)}f.ok(r,e)}),f.end()}),test(".alloc(size, fill) is `fill`-filled",function(f){f.equal(index.Buffer.alloc,safer.Buffer.alloc),f.equal(index.Buffer.alloc,dangerous.Buffer.alloc);for(var e=!0,r=0;r<100;r++){var u=Math.round(2e6*Math.random()),o=Math.round(255*Math.random()),n=index.Buffer.alloc(u,o);buffer.Buffer.isBuffer(n)||(e=!1),n.length!==u&&(e=!1);for(var t=0;t<u;t++)n[t]!==o&&(e=!1)}f.ok(e),f.end()}),test(".alloc(size, fill) is `fill`-filled",function(f){f.equal(index.Buffer.alloc,safer.Buffer.alloc),f.equal(index.Buffer.alloc,dangerous.Buffer.alloc);for(var e=!0,r=0;r<100;r++){var u=Math.round(2e6*Math.random()),o=Math.round(255*Math.random()),n=index.Buffer.alloc(u,o);buffer.Buffer.isBuffer(n)||(e=!1),n.length!==u&&(e=!1);for(var t=0;t<u;t++)n[t]!==o&&(e=!1)}f.ok(e),f.deepEqual(index.Buffer.alloc(9,"a"),index.Buffer.alloc(9,97)),f.notDeepEqual(index.Buffer.alloc(9,"a"),index.Buffer.alloc(9,98));var a=new buffer.Buffer(2);a.fill("ok"),a[1]===a[0]?f.deepEqual(index.Buffer.alloc(5,"ok"),index.Buffer.from("ooooo")):f.deepEqual(index.Buffer.alloc(5,"ok"),index.Buffer.from("okoko")),f.notDeepEqual(index.Buffer.alloc(5,"ok"),index.Buffer.from("kokok")),f.end()}),test("safer.Buffer.from returns results same as Buffer constructor",function(f){[index,safer,dangerous].forEach(function(e){f.deepEqual(e.Buffer.from(""),new buffer.Buffer("")),f.deepEqual(e.Buffer.from("string"),new buffer.Buffer("string")),f.deepEqual(e.Buffer.from("string","utf-8"),new buffer.Buffer("string","utf-8")),f.deepEqual(e.Buffer.from("b25ldHdvdGhyZWU=","base64"),new buffer.Buffer("b25ldHdvdGhyZWU=","base64")),f.deepEqual(e.Buffer.from([0,42,3]),new buffer.Buffer([0,42,3])),f.deepEqual(e.Buffer.from(new Uint8Array([0,42,3])),new buffer.Buffer(new Uint8Array([0,42,3]))),f.deepEqual(e.Buffer.from([]),new buffer.Buffer([]))}),f.end()}),test("safer.Buffer.from returns consistent results",function(f){[index,safer,dangerous].forEach(function(e){f.deepEqual(e.Buffer.from(""),e.Buffer.alloc(0)),f.deepEqual(e.Buffer.from([]),e.Buffer.alloc(0)),f.deepEqual(e.Buffer.from(new Uint8Array([])),e.Buffer.alloc(0)),f.deepEqual(e.Buffer.from("string","utf-8"),e.Buffer.from("string")),f.deepEqual(e.Buffer.from("string"),e.Buffer.from([115,116,114,105,110,103])),f.deepEqual(e.Buffer.from("string"),e.Buffer.from(e.Buffer.from("string"))),f.deepEqual(e.Buffer.from("b25ldHdvdGhyZWU=","base64"),e.Buffer.from("onetwothree")),f.notDeepEqual(e.Buffer.from("b25ldHdvdGhyZWU="),e.Buffer.from("onetwothree"))}),f.end()});