module.exports=Certificate;var assert=require("assert-plus"),Buffer=require("safer-buffer").Buffer,algs=require("./algs"),crypto=require("crypto"),Fingerprint=require("./fingerprint"),Signature=require("./signature"),errs=require("./errors"),util=require("util"),utils=require("./utils"),Key=require("./key"),PrivateKey=require("./private-key"),Identity=require("./identity"),formats={};formats.openssh=require("./formats/openssh-cert"),formats.x509=require("./formats/x509"),formats.pem=require("./formats/x509-pem");var CertificateParseError=errs.CertificateParseError,InvalidAlgorithmError=errs.InvalidAlgorithmError;function Certificate(e){assert.object(e,"options"),assert.arrayOfObject(e.subjects,"options.subjects"),utils.assertCompatible(e.subjects[0],Identity,[1,0],"options.subjects"),utils.assertCompatible(e.subjectKey,Key,[1,0],"options.subjectKey"),utils.assertCompatible(e.issuer,Identity,[1,0],"options.issuer"),void 0!==e.issuerKey&&utils.assertCompatible(e.issuerKey,Key,[1,0],"options.issuerKey"),assert.object(e.signatures,"options.signatures"),assert.buffer(e.serial,"options.serial"),assert.date(e.validFrom,"options.validFrom"),assert.date(e.validUntil,"optons.validUntil"),assert.optionalArrayOfString(e.purposes,"options.purposes"),this._hashCache={},this.subjects=e.subjects,this.issuer=e.issuer,this.subjectKey=e.subjectKey,this.issuerKey=e.issuerKey,this.signatures=e.signatures,this.serial=e.serial,this.validFrom=e.validFrom,this.validUntil=e.validUntil,this.purposes=e.purposes}Certificate.formats=formats,Certificate.prototype.toBuffer=function(e,t){return void 0===e&&(e="x509"),assert.string(e,"format"),assert.object(formats[e],"formats[format]"),assert.optionalObject(t,"options"),formats[e].write(this,t)},Certificate.prototype.toString=function(e,t){return void 0===e&&(e="pem"),this.toBuffer(e,t).toString()},Certificate.prototype.fingerprint=function(e){void 0===e&&(e="sha256"),assert.string(e,"algorithm");var t={type:"certificate",hash:this.hash(e),algorithm:e};return new Fingerprint(t)},Certificate.prototype.hash=function(e){if(assert.string(e,"algorithm"),e=e.toLowerCase(),void 0===algs.hashAlgs[e])throw new InvalidAlgorithmError(e);if(this._hashCache[e])return this._hashCache[e];var t=crypto.createHash(e).update(this.toBuffer("x509")).digest();return this._hashCache[e]=t,t},Certificate.prototype.isExpired=function(e){return void 0===e&&(e=new Date),!(e.getTime()>=this.validFrom.getTime()&&e.getTime()<this.validUntil.getTime())},Certificate.prototype.isSignedBy=function(e){return utils.assertCompatible(e,Certificate,[1,0],"issuer"),!!this.issuer.equals(e.subjects[0])&&(!(this.issuer.purposes&&this.issuer.purposes.length>0&&-1===this.issuer.purposes.indexOf("ca"))&&this.isSignedByKey(e.subjectKey))},Certificate.prototype.getExtension=function(e){return assert.string(e,"keyOrOid"),this.getExtensions().filter(function(t){return"x509"===t.format?t.oid===e:"openssh"===t.format&&t.name===e})[0]},Certificate.prototype.getExtensions=function(){var e=[],t=this.signatures.x509;t&&t.extras&&t.extras.exts&&t.extras.exts.forEach(function(t){t.format="x509",e.push(t)});var i=this.signatures.openssh;return i&&i.exts&&i.exts.forEach(function(t){t.format="openssh",e.push(t)}),e},Certificate.prototype.isSignedByKey=function(e){if(utils.assertCompatible(e,Key,[1,2],"issuerKey"),void 0!==this.issuerKey)return this.issuerKey.fingerprint("sha512").matches(e);var t=Object.keys(this.signatures)[0],i=formats[t].verify(this,e);return i&&(this.issuerKey=e),i},Certificate.prototype.signWith=function(e){utils.assertCompatible(e,PrivateKey,[1,2],"key");for(var t=Object.keys(formats),i=!1,r=0;r<t.length;++r){if("pem"!==t[r])!0===formats[t[r]].sign(this,e)&&(i=!0)}if(!i)throw new Error("Failed to sign the certificate for any available certificate formats")},Certificate.createSelfSigned=function(e,t,i){var r;r=Array.isArray(e)?e:[e],assert.arrayOfObject(r),r.forEach(function(e){utils.assertCompatible(e,Identity,[1,0],"subject")}),utils.assertCompatible(t,PrivateKey,[1,2],"private key"),assert.optionalObject(i,"options"),void 0===i&&(i={}),assert.optionalObject(i.validFrom,"options.validFrom"),assert.optionalObject(i.validUntil,"options.validUntil");var s=i.validFrom,a=i.validUntil;if(void 0===s&&(s=new Date),void 0===a){assert.optionalNumber(i.lifetime,"options.lifetime");var o=i.lifetime;void 0===o&&(o=31536e4),(a=new Date).setTime(a.getTime()+1e3*o)}assert.optionalBuffer(i.serial,"options.serial");var n=i.serial;void 0===n&&(n=Buffer.from("0000000000000001","hex"));var u=i.purposes;if(void 0===u&&(u=[]),-1===u.indexOf("signature")&&u.push("signature"),-1===u.indexOf("ca")&&u.push("ca"),-1===u.indexOf("crl")&&u.push("crl"),u.length<=3){var f=r.filter(function(e){return"host"===e.type}),l=r.filter(function(e){return"user"===e.type});f.length>0&&-1===u.indexOf("serverAuth")&&u.push("serverAuth"),l.length>0&&-1===u.indexOf("clientAuth")&&u.push("clientAuth"),(l.length>0||f.length>0)&&(-1===u.indexOf("keyAgreement")&&u.push("keyAgreement"),"rsa"===t.type&&-1===u.indexOf("encryption")&&u.push("encryption"))}var p=new Certificate({subjects:r,issuer:r[0],subjectKey:t.toPublic(),issuerKey:t.toPublic(),signatures:{},serial:n,validFrom:s,validUntil:a,purposes:u});return p.signWith(t),p},Certificate.create=function(e,t,i,r,s){var a;a=Array.isArray(e)?e:[e],assert.arrayOfObject(a),a.forEach(function(e){utils.assertCompatible(e,Identity,[1,0],"subject")}),utils.assertCompatible(t,Key,[1,0],"key"),PrivateKey.isPrivateKey(t)&&(t=t.toPublic()),utils.assertCompatible(i,Identity,[1,0],"issuer"),utils.assertCompatible(r,PrivateKey,[1,2],"issuer key"),assert.optionalObject(s,"options"),void 0===s&&(s={}),assert.optionalObject(s.validFrom,"options.validFrom"),assert.optionalObject(s.validUntil,"options.validUntil");var o=s.validFrom,n=s.validUntil;if(void 0===o&&(o=new Date),void 0===n){assert.optionalNumber(s.lifetime,"options.lifetime");var u=s.lifetime;void 0===u&&(u=31536e4),(n=new Date).setTime(n.getTime()+1e3*u)}assert.optionalBuffer(s.serial,"options.serial");var f=s.serial;void 0===f&&(f=Buffer.from("0000000000000001","hex"));var l=s.purposes;void 0===l&&(l=[]),-1===l.indexOf("signature")&&l.push("signature"),!0===s.ca&&(-1===l.indexOf("ca")&&l.push("ca"),-1===l.indexOf("crl")&&l.push("crl"));var p=a.filter(function(e){return"host"===e.type}),c=a.filter(function(e){return"user"===e.type});p.length>0&&-1===l.indexOf("serverAuth")&&l.push("serverAuth"),c.length>0&&-1===l.indexOf("clientAuth")&&l.push("clientAuth"),(c.length>0||p.length>0)&&(-1===l.indexOf("keyAgreement")&&l.push("keyAgreement"),"rsa"===t.type&&-1===l.indexOf("encryption")&&l.push("encryption"));var h=new Certificate({subjects:a,issuer:i,subjectKey:t,issuerKey:r.toPublic(),signatures:{},serial:f,validFrom:o,validUntil:n,purposes:l});return h.signWith(r),h},Certificate.parse=function(e,t,i){"string"!=typeof e&&assert.buffer(e,"data"),void 0===t&&(t="auto"),assert.string(t,"format"),"string"==typeof i&&(i={filename:i}),assert.optionalObject(i,"options"),void 0===i&&(i={}),assert.optionalString(i.filename,"options.filename"),void 0===i.filename&&(i.filename="(unnamed)"),assert.object(formats[t],"formats[format]");try{return formats[t].read(e,i)}catch(e){throw new CertificateParseError(i.filename,t,e)}},Certificate.isCertificate=function(e,t){return utils.isCompatible(e,Certificate,t)},Certificate.prototype._sshpkApiVersion=[1,1],Certificate._oldVersionDetect=function(e){return[1,0]};