module.exports={DiffieHellman:DiffieHellman,generateECDSA:generateECDSA,generateED25519:generateED25519};var assert=require("assert-plus"),crypto=require("crypto"),Buffer=require("safer-buffer").Buffer,algs=require("./algs"),utils=require("./utils"),nacl=require("tweetnacl"),Key=require("./key"),PrivateKey=require("./private-key"),CRYPTO_HAVE_ECDH=void 0!==crypto.createECDH,ecdh=require("ecc-jsbn"),ec=require("ecc-jsbn/lib/ec"),jsbn=require("jsbn").BigInteger;function DiffieHellman(e){if(utils.assertCompatible(e,Key,[1,4],"key"),this._isPriv=PrivateKey.isPrivateKey(e,[1,3]),this._algo=e.type,this._curve=e.curve,this._key=e,"dsa"===e.type){if(!CRYPTO_HAVE_ECDH)throw new Error("Due to bugs in the node 0.10 crypto API, node 0.12.x or later is required to use DH");this._dh=crypto.createDiffieHellman(e.part.p.data,void 0,e.part.g.data,void 0),this._p=e.part.p,this._g=e.part.g,this._isPriv&&this._dh.setPrivateKey(e.part.x.data),this._dh.setPublicKey(e.part.y.data)}else if("ecdsa"===e.type){if(!CRYPTO_HAVE_ECDH)return this._ecParams=new X9ECParameters(this._curve),void(this._isPriv&&(this._priv=new ECPrivate(this._ecParams,e.part.d.data)));var t={nistp256:"prime256v1",nistp384:"secp384r1",nistp521:"secp521r1"}[e.curve];if(this._dh=crypto.createECDH(t),"object"!=typeof this._dh||"function"!=typeof this._dh.setPrivateKey)return CRYPTO_HAVE_ECDH=!1,void DiffieHellman.call(this,e);this._isPriv&&this._dh.setPrivateKey(e.part.d.data),this._dh.setPublicKey(e.part.Q.data)}else{if("curve25519"!==e.type)throw new Error("DH not supported for "+e.type+" keys");this._isPriv&&(utils.assertCompatible(e,PrivateKey,[1,5],"key"),this._priv=e.part.k.data)}}function X9ECParameters(e){var t=algs.curves[e];assert.object(t);var r=new jsbn(t.p),i=new jsbn(t.a),a=new jsbn(t.b),s=new jsbn(t.n),n=jsbn.ONE,h=new ec.ECCurveFp(r,i,a),p=h.decodePointHex(t.G.toString("hex"));this.curve=h,this.g=p,this.n=s,this.h=n}function ECPublic(e,t){this._params=e,0===t[0]&&(t=t.slice(1)),this._pub=e.getCurve().decodePointHex(t.toString("hex"))}function ECPrivate(e,t){this._params=e,this._priv=new jsbn(utils.mpNormalize(t))}function generateED25519(){var e=nacl.sign.keyPair(),t=Buffer.from(e.secretKey),r=Buffer.from(e.publicKey);assert.strictEqual(t.length,64),assert.strictEqual(r.length,32);var i=[];return i.push({name:"A",data:r}),i.push({name:"k",data:t.slice(0,32)}),new PrivateKey({type:"ed25519",parts:i})}function generateECDSA(e){var t=[];if(CRYPTO_HAVE_ECDH){var r={nistp256:"prime256v1",nistp384:"secp384r1",nistp521:"secp521r1"}[e],i=crypto.createECDH(r);return i.generateKeys(),t.push({name:"curve",data:Buffer.from(e)}),t.push({name:"Q",data:i.getPublicKey()}),t.push({name:"d",data:i.getPrivateKey()}),new PrivateKey({type:"ecdsa",curve:e,parts:t})}var a=new X9ECParameters(e),s=a.getN(),n=Math.ceil((s.bitLength()+64)/8),h=new jsbn(crypto.randomBytes(n)),p=s.subtract(jsbn.ONE),u=h.mod(p).add(jsbn.ONE),o=a.getG().multiply(u);return u=Buffer.from(u.toByteArray()),o=Buffer.from(a.getCurve().encodePointHex(o),"hex"),t.push({name:"curve",data:Buffer.from(e)}),t.push({name:"Q",data:o}),t.push({name:"d",data:u}),new PrivateKey({type:"ecdsa",curve:e,parts:t})}DiffieHellman.prototype.getPublicKey=function(){return this._isPriv?this._key.toPublic():this._key},DiffieHellman.prototype.getPrivateKey=function(){return this._isPriv?this._key:void 0},DiffieHellman.prototype.getKey=DiffieHellman.prototype.getPrivateKey,DiffieHellman.prototype._keyCheck=function(e,t){if(assert.object(e,"key"),t||utils.assertCompatible(e,PrivateKey,[1,3],"key"),utils.assertCompatible(e,Key,[1,4],"key"),e.type!==this._algo)throw new Error("A "+e.type+" key cannot be used in "+this._algo+" Diffie-Hellman");if(e.curve!==this._curve)throw new Error("A key from the "+e.curve+" curve cannot be used with a "+this._curve+" Diffie-Hellman");"dsa"===e.type&&(assert.deepEqual(e.part.p,this._p,"DSA key prime does not match"),assert.deepEqual(e.part.g,this._g,"DSA key generator does not match"))},DiffieHellman.prototype.setKey=function(e){if(this._keyCheck(e),"dsa"===e.type)this._dh.setPrivateKey(e.part.x.data),this._dh.setPublicKey(e.part.y.data);else if("ecdsa"===e.type)CRYPTO_HAVE_ECDH?(this._dh.setPrivateKey(e.part.d.data),this._dh.setPublicKey(e.part.Q.data)):this._priv=new ECPrivate(this._ecParams,e.part.d.data);else if("curve25519"===e.type){var t=e.part.k;e.part.k||(t=e.part.r),this._priv=t.data,0===this._priv[0]&&(this._priv=this._priv.slice(1)),this._priv=this._priv.slice(0,32)}this._key=e,this._isPriv=!0},DiffieHellman.prototype.setPrivateKey=DiffieHellman.prototype.setKey,DiffieHellman.prototype.computeSecret=function(e){if(this._keyCheck(e,!0),!this._isPriv)throw new Error("DH exchange has not been initialized with a private key yet");var t;if("dsa"===this._algo)return this._dh.computeSecret(e.part.y.data);if("ecdsa"===this._algo)return CRYPTO_HAVE_ECDH?this._dh.computeSecret(e.part.Q.data):(t=new ECPublic(this._ecParams,e.part.Q.data),this._priv.deriveSharedSecret(t));if("curve25519"===this._algo){for(t=e.part.A.data;0===t[0]&&t.length>32;)t=t.slice(1);var r=this._priv;assert.strictEqual(t.length,32),assert.strictEqual(r.length,32);var i=nacl.box.before(new Uint8Array(t),new Uint8Array(r));return Buffer.from(i)}throw new Error("Invalid algorithm: "+this._algo)},DiffieHellman.prototype.generateKey=function(){var e,t,r=[];if("dsa"===this._algo)return this._dh.generateKeys(),r.push({name:"p",data:this._p.data}),r.push({name:"q",data:this._key.part.q.data}),r.push({name:"g",data:this._g.data}),r.push({name:"y",data:this._dh.getPublicKey()}),r.push({name:"x",data:this._dh.getPrivateKey()}),this._key=new PrivateKey({type:"dsa",parts:r}),this._isPriv=!0,this._key;if("ecdsa"===this._algo){if(CRYPTO_HAVE_ECDH)return this._dh.generateKeys(),r.push({name:"curve",data:Buffer.from(this._curve)}),r.push({name:"Q",data:this._dh.getPublicKey()}),r.push({name:"d",data:this._dh.getPrivateKey()}),this._key=new PrivateKey({type:"ecdsa",curve:this._curve,parts:r}),this._isPriv=!0,this._key;var i=this._ecParams.getN(),a=new jsbn(crypto.randomBytes(i.bitLength())),s=i.subtract(jsbn.ONE);return e=a.mod(s).add(jsbn.ONE),t=this._ecParams.getG().multiply(e),e=Buffer.from(e.toByteArray()),t=Buffer.from(this._ecParams.getCurve().encodePointHex(t),"hex"),this._priv=new ECPrivate(this._ecParams,e),r.push({name:"curve",data:Buffer.from(this._curve)}),r.push({name:"Q",data:t}),r.push({name:"d",data:e}),this._key=new PrivateKey({type:"ecdsa",curve:this._curve,parts:r}),this._isPriv=!0,this._key}if("curve25519"===this._algo){var n=nacl.box.keyPair();return e=Buffer.from(n.secretKey),t=Buffer.from(n.publicKey),e=Buffer.concat([e,t]),assert.strictEqual(e.length,64),assert.strictEqual(t.length,32),r.push({name:"A",data:t}),r.push({name:"k",data:e}),this._key=new PrivateKey({type:"curve25519",parts:r}),this._isPriv=!0,this._key}throw new Error("Invalid algorithm: "+this._algo)},DiffieHellman.prototype.generateKeys=DiffieHellman.prototype.generateKey,X9ECParameters.prototype.getCurve=function(){return this.curve},X9ECParameters.prototype.getG=function(){return this.g},X9ECParameters.prototype.getN=function(){return this.n},X9ECParameters.prototype.getH=function(){return this.h},ECPrivate.prototype.deriveSharedSecret=function(e){assert.ok(e instanceof ECPublic);var t=e._pub.multiply(this._priv);return Buffer.from(t.getX().toBigInteger().toByteArray())};