module.exports=Fingerprint;var assert=require("assert-plus"),Buffer=require("safer-buffer").Buffer,algs=require("./algs"),crypto=require("crypto"),errs=require("./errors"),Key=require("./key"),PrivateKey=require("./private-key"),Certificate=require("./certificate"),utils=require("./utils"),FingerprintFormatError=errs.FingerprintFormatError,InvalidAlgorithmError=errs.InvalidAlgorithmError;function Fingerprint(r){if(assert.object(r,"options"),assert.string(r.type,"options.type"),assert.buffer(r.hash,"options.hash"),assert.string(r.algorithm,"options.algorithm"),this.algorithm=r.algorithm.toLowerCase(),!0!==algs.hashAlgs[this.algorithm])throw new InvalidAlgorithmError(this.algorithm);this.hash=r.hash,this.type=r.type,this.hashType=r.hashType}Fingerprint.prototype.toString=function(r){switch(void 0===r&&(r="md5"===this.algorithm||"spki"===this.hashType?"hex":"base64"),assert.string(r),r){case"hex":return"spki"===this.hashType?this.hash.toString("hex"):addColons(this.hash.toString("hex"));case"base64":return"spki"===this.hashType?this.hash.toString("base64"):sshBase64Format(this.algorithm,this.hash.toString("base64"));default:throw new FingerprintFormatError(void 0,r)}},Fingerprint.prototype.matches=function(r){assert.object(r,"key or certificate"),"key"===this.type&&"ssh"!==this.hashType?(utils.assertCompatible(r,Key,[1,7],"key with spki"),PrivateKey.isPrivateKey(r)&&utils.assertCompatible(r,PrivateKey,[1,6],"privatekey with spki support")):"key"===this.type?utils.assertCompatible(r,Key,[1,0],"key"):utils.assertCompatible(r,Certificate,[1,0],"certificate");var t=r.hash(this.algorithm,this.hashType),e=crypto.createHash(this.algorithm).update(t).digest("base64");return void 0===this.hash2&&(this.hash2=crypto.createHash(this.algorithm).update(this.hash).digest("base64")),this.hash2===e};var base64RE=/^[A-Za-z0-9+\/=]+$/,hexRE=/^[a-fA-F0-9]+$/;function addColons(r){return r.replace(/(.{2})(?=.)/g,"$1:")}function base64Strip(r){return r.replace(/=*$/,"")}function sshBase64Format(r,t){return r.toUpperCase()+":"+base64Strip(t)}Fingerprint.parse=function(r,t){var e,i,s;assert.string(r,"fingerprint"),Array.isArray(t)&&(s=t,t={}),assert.optionalObject(t,"options"),void 0===t&&(t={}),void 0!==t.enAlgs&&(s=t.enAlgs),void 0!==t.algorithms&&(s=t.algorithms),assert.optionalArrayOfString(s,"algorithms");var a="ssh";void 0!==t.hashType&&(a=t.hashType),assert.string(a,"options.hashType");var o=r.split(":");if(2==o.length){if(e=o[0].toLowerCase(),!base64RE.test(o[1]))throw new FingerprintFormatError(r);try{i=Buffer.from(o[1],"base64")}catch(t){throw new FingerprintFormatError(r)}}else if(o.length>2){if(e="md5","md5"===o[0].toLowerCase()&&(o=o.slice(1)),o=(o=o.map(function(t){for(;t.length<2;)t="0"+t;if(t.length>2)throw new FingerprintFormatError(r);return t})).join(""),!hexRE.test(o)||o.length%2!=0)throw new FingerprintFormatError(r);try{i=Buffer.from(o,"hex")}catch(t){throw new FingerprintFormatError(r)}}else{if(hexRE.test(r))i=Buffer.from(r,"hex");else{if(!base64RE.test(r))throw new FingerprintFormatError(r);i=Buffer.from(r,"base64")}switch(i.length){case 32:e="sha256";break;case 16:e="md5";break;case 20:e="sha1";break;case 64:e="sha512";break;default:throw new FingerprintFormatError(r)}void 0===t.hashType&&(a="spki")}if(void 0===e)throw new FingerprintFormatError(r);if(void 0===algs.hashAlgs[e])throw new InvalidAlgorithmError(e);if(void 0!==s&&-1===(s=s.map(function(r){return r.toLowerCase()})).indexOf(e))throw new InvalidAlgorithmError(e);return new Fingerprint({algorithm:e,hash:i,type:t.type||"key",hashType:a})},Fingerprint.isFingerprint=function(r,t){return utils.isCompatible(r,Fingerprint,t)},Fingerprint.prototype._sshpkApiVersion=[1,2],Fingerprint._oldVersionDetect=function(r){return assert.func(r.toString),assert.func(r.matches),[1,0]};