module.exports={read:read,write:write};var assert=require("assert-plus"),Buffer=require("safer-buffer").Buffer,Key=require("../key"),PrivateKey=require("../private-key"),utils=require("../utils"),SSHBuffer=require("../ssh-buffer"),Dhe=require("../dhe"),supportedAlgos={"rsa-sha1":5,"rsa-sha256":8,"rsa-sha512":10,"ecdsa-p256-sha256":13,"ecdsa-p384-sha384":14},supportedAlgosById={};function read(e,r){"string"!=typeof e&&(assert.buffer(e,"buf"),e=e.toString("ascii"));var t=e.split("\n");if(t[0].match(/^Private-key-format\: v1/)){var a=t[1].split(" "),s=parseInt(a[1],10),n=a[2];if(!supportedAlgosById[s])throw new Error("Unsupported algorithm: "+n);return readDNSSECPrivateKey(s,t.slice(2))}for(var i=0;t[i].match(/^\;/);)i++;if((t[i].match(/\. IN KEY /)||t[i].match(/\. IN DNSKEY /))&&0===t[i+1].length)return readRFC3110(t[i]);throw new Error("Cannot parse dnssec key")}function readRFC3110(e){var r=e.split(" "),t=parseInt(r[5],10);if(!supportedAlgosById[t])throw new Error("Unsupported algorithm: "+t);var a=r.slice(6,r.length).join(),s=Buffer.from(a,"base64");if(supportedAlgosById[t].match(/^RSA-/)){var n=s.readUInt8(0);if(3!=n&&1!=n)throw new Error("Cannot parse dnssec key: unsupported exponent length");var i=s.slice(1,n+1);i=utils.mpNormalize(i);var o=s.slice(1+n);o=utils.mpNormalize(o);var p={type:"rsa",parts:[]};return p.parts.push({name:"e",data:i}),p.parts.push({name:"n",data:o}),new Key(p)}if("ECDSA-P384-SHA384"===supportedAlgosById[t]||"ECDSA-P256-SHA256"===supportedAlgosById[t]){var u="nistp384",d=384;supportedAlgosById[t].match(/^ECDSA-P256-SHA256/)&&(u="nistp256",d=256);var m={type:"ecdsa",curve:u,size:d,parts:[{name:"curve",data:Buffer.from(u)},{name:"Q",data:utils.ecNormalize(s)}]};return new Key(m)}throw new Error("Unsupported algorithm: "+supportedAlgosById[t])}function elementToBuf(e){return Buffer.from(e.split(" ")[1],"base64")}function readDNSSECRSAPrivateKey(e){var r={};e.forEach(function(e){"Modulus:"===e.split(" ")[0]?r.n=elementToBuf(e):"PublicExponent:"===e.split(" ")[0]?r.e=elementToBuf(e):"PrivateExponent:"===e.split(" ")[0]?r.d=elementToBuf(e):"Prime1:"===e.split(" ")[0]?r.p=elementToBuf(e):"Prime2:"===e.split(" ")[0]?r.q=elementToBuf(e):"Exponent1:"===e.split(" ")[0]?r.dmodp=elementToBuf(e):"Exponent2:"===e.split(" ")[0]?r.dmodq=elementToBuf(e):"Coefficient:"===e.split(" ")[0]&&(r.iqmp=elementToBuf(e))});var t={type:"rsa",parts:[{name:"e",data:utils.mpNormalize(r.e)},{name:"n",data:utils.mpNormalize(r.n)},{name:"d",data:utils.mpNormalize(r.d)},{name:"p",data:utils.mpNormalize(r.p)},{name:"q",data:utils.mpNormalize(r.q)},{name:"dmodp",data:utils.mpNormalize(r.dmodp)},{name:"dmodq",data:utils.mpNormalize(r.dmodq)},{name:"iqmp",data:utils.mpNormalize(r.iqmp)}]};return new PrivateKey(t)}function readDNSSECPrivateKey(e,r){if(supportedAlgosById[e].match(/^RSA-/))return readDNSSECRSAPrivateKey(r);if("ECDSA-P384-SHA384"===supportedAlgosById[e]||"ECDSA-P256-SHA256"===supportedAlgosById[e]){var t=Buffer.from(r[0].split(" ")[1],"base64"),a="nistp384",s=384;"ECDSA-P256-SHA256"===supportedAlgosById[e]&&(a="nistp256",s=256);var n=utils.publicFromPrivateECDSA(a,t).part.Q.data,i={type:"ecdsa",curve:a,size:s,parts:[{name:"curve",data:Buffer.from(a)},{name:"d",data:t},{name:"Q",data:n}]};return new PrivateKey(i)}throw new Error("Unsupported algorithm: "+supportedAlgosById[e])}function dnssecTimestamp(e){var r=e.getFullYear()+""+(e.getMonth()+1)+e.getUTCDate();return r+=""+e.getUTCHours()+e.getUTCMinutes(),r+=e.getUTCSeconds()}function rsaAlgFromOptions(e){if(e&&e.hashAlgo&&"sha1"!==e.hashAlgo){if("sha256"===e.hashAlgo)return"8 (RSASHA256)";if("sha512"===e.hashAlgo)return"10 (RSASHA512)";throw new Error("Unknown or unsupported hash: "+e.hashAlgo)}return"5 (RSASHA1)"}function writeRSA(e,r){e.part.dmodp&&e.part.dmodq||utils.addRSAMissing(e);var t="";t+="Private-key-format: v1.3\n",t+="Algorithm: "+rsaAlgFromOptions(r)+"\n",t+="Modulus: "+utils.mpDenormalize(e.part.n.data).toString("base64")+"\n",t+="PublicExponent: "+utils.mpDenormalize(e.part.e.data).toString("base64")+"\n",t+="PrivateExponent: "+utils.mpDenormalize(e.part.d.data).toString("base64")+"\n",t+="Prime1: "+utils.mpDenormalize(e.part.p.data).toString("base64")+"\n",t+="Prime2: "+utils.mpDenormalize(e.part.q.data).toString("base64")+"\n",t+="Exponent1: "+utils.mpDenormalize(e.part.dmodp.data).toString("base64")+"\n",t+="Exponent2: "+utils.mpDenormalize(e.part.dmodq.data).toString("base64")+"\n",t+="Coefficient: "+utils.mpDenormalize(e.part.iqmp.data).toString("base64")+"\n";var a=new Date;return t+="Created: "+dnssecTimestamp(a)+"\n",t+="Publish: "+dnssecTimestamp(a)+"\n",t+="Activate: "+dnssecTimestamp(a)+"\n",Buffer.from(t,"ascii")}function writeECDSA(e,r){var t="";if(t+="Private-key-format: v1.3\n","nistp256"===e.curve)t+="Algorithm: 13 (ECDSAP256SHA256)\n";else{if("nistp384"!==e.curve)throw new Error("Unsupported curve");t+="Algorithm: 14 (ECDSAP384SHA384)\n"}t+="PrivateKey: "+e.part.d.data.toString("base64")+"\n";var a=new Date;return t+="Created: "+dnssecTimestamp(a)+"\n",t+="Publish: "+dnssecTimestamp(a)+"\n",t+="Activate: "+dnssecTimestamp(a)+"\n",Buffer.from(t,"ascii")}function write(e,r){if(PrivateKey.isPrivateKey(e)){if("rsa"===e.type)return writeRSA(e,r);if("ecdsa"===e.type)return writeECDSA(e,r);throw new Error("Unsupported algorithm: "+e.type)}throw Key.isKey(e)?new Error('Format "dnssec" only supports writing private keys'):new Error("key is not a Key or PrivateKey")}Object.keys(supportedAlgos).forEach(function(e){supportedAlgosById[supportedAlgos[e]]=e.toUpperCase()});