module.exports={read:read,verify:verify,sign:sign,signAsync:signAsync,write:write,fromBuffer:fromBuffer,toBuffer:toBuffer};var assert=require("assert-plus"),SSHBuffer=require("../ssh-buffer"),crypto=require("crypto"),Buffer=require("safer-buffer").Buffer,algs=require("../algs"),Key=require("../key"),PrivateKey=require("../private-key"),Identity=require("../identity"),rfc4253=require("./rfc4253"),Signature=require("../signature"),utils=require("../utils"),Certificate=require("../certificate");function verify(e,r){return!1}var TYPES={user:1,host:2};Object.keys(TYPES).forEach(function(e){TYPES[TYPES[e]]=e});var ECDSA_ALGO=/^ecdsa-sha2-([^@-]+)-cert-v01@openssh.com$/;function read(e,r){Buffer.isBuffer(e)&&(e=e.toString("ascii"));var t=e.trim().split(/[ \t\n]+/g);if(t.length<2||t.length>3)throw new Error("Not a valid SSH certificate line");var s=t[0],n=t[1];return fromBuffer(n=Buffer.from(n,"base64"),s)}function fromBuffer(e,r,t){var s=new SSHBuffer({buffer:e}),n=s.readString();if(void 0!==r&&n!==r)throw new Error("SSH certificate algorithm mismatch");void 0===r&&(r=n);var a={signatures:{}};a.signatures.openssh={},a.signatures.openssh.nonce=s.readBuffer();var i={},f=i.parts=[];i.type=getAlg(r);for(var u=algs.info[i.type].parts.length;f.length<u;)f.push(s.readPart());assert.ok(f.length>=1,"key must have at least one part");var o=algs.info[i.type];if("ecdsa"===i.type){var c=ECDSA_ALGO.exec(r);assert.ok(null!==c),assert.strictEqual(c[1],f[0].data.toString())}for(var d=0;d<o.parts.length;++d)if(f[d].name=o.parts[d],"curve"!==f[d].name&&!1!==o.normalize){var h=f[d];h.data=utils.mpNormalize(h.data)}a.subjectKey=new Key(i),a.serial=s.readInt64();var p=TYPES[s.readInt()];assert.string(p,"valid cert type"),a.signatures.openssh.keyId=s.readString();for(var g=[],v=s.readBuffer(),y=new SSHBuffer({buffer:v});!y.atEnd();)g.push(y.readString());0===g.length&&(g=["*"]),a.subjects=g.map(function(e){if("user"===p)return Identity.forUser(e);if("host"===p)return Identity.forHost(e);throw new Error("Unknown identity type "+p)}),a.validFrom=int64ToDate(s.readInt64()),a.validUntil=int64ToDate(s.readInt64());for(var B,l=[],S=new SSHBuffer({buffer:s.readBuffer()});!S.atEnd();)(B={critical:!0}).name=S.readString(),B.data=S.readBuffer(),l.push(B);for(S=new SSHBuffer({buffer:s.readBuffer()});!S.atEnd();)(B={critical:!1}).name=S.readString(),B.data=S.readBuffer(),l.push(B);a.signatures.openssh.exts=l,s.readBuffer();var w=s.readBuffer();a.issuerKey=rfc4253.read(w),a.issuer=Identity.forHost("**");var m=s.readBuffer();return a.signatures.openssh.signature=Signature.parse(m,a.issuerKey.type,"ssh"),void 0!==t&&(t.remainder=s.remainder(),t.consumed=s._offset),new Certificate(a)}function int64ToDate(e){var r=4294967296*e.readUInt32BE(0);r+=e.readUInt32BE(4);var t=new Date;return t.setTime(1e3*r),t.sourceInt64=e,t}function dateToInt64(e){if(void 0!==e.sourceInt64)return e.sourceInt64;var r=Math.round(e.getTime()/1e3),t=Math.floor(r/4294967296),s=Math.floor(r%4294967296),n=Buffer.alloc(8);return n.writeUInt32BE(t,0),n.writeUInt32BE(s,4),n}function sign(e,r){void 0===e.signatures.openssh&&(e.signatures.openssh={});try{var t=toBuffer(e,!0)}catch(r){return delete e.signatures.openssh,!1}var s=e.signatures.openssh,n=void 0;"rsa"!==r.type&&"dsa"!==r.type||(n="sha1");var a=r.createSign(n);return a.write(t),s.signature=a.sign(),!0}function signAsync(e,r,t){void 0===e.signatures.openssh&&(e.signatures.openssh={});try{var s=toBuffer(e,!0)}catch(r){return delete e.signatures.openssh,void t(r)}var n=e.signatures.openssh;r(s,function(e,r){if(e)t(e);else{try{r.toBuffer("ssh")}catch(e){return void t(e)}n.signature=r,t()}})}function write(e,r){void 0===r&&(r={});var t=toBuffer(e),s=getCertType(e.subjectKey)+" "+t.toString("base64");return r.comment&&(s=s+" "+r.comment),s}function toBuffer(e,r){assert.object(e.signatures.openssh,"signature for openssh format");var t=e.signatures.openssh;void 0===t.nonce&&(t.nonce=crypto.randomBytes(16));var s=new SSHBuffer({});s.writeString(getCertType(e.subjectKey)),s.writeBuffer(t.nonce);var n=e.subjectKey;algs.info[n.type].parts.forEach(function(e){s.writePart(n.part[e])}),s.writeInt64(e.serial);var a=e.subjects[0].type;assert.notStrictEqual(a,"unknown"),e.subjects.forEach(function(e){assert.strictEqual(e.type,a)}),a=TYPES[a],s.writeInt(a),void 0===t.keyId&&(t.keyId=e.subjects[0].type+"_"+(e.subjects[0].uid||e.subjects[0].hostname)),s.writeString(t.keyId);var i=new SSHBuffer({});e.subjects.forEach(function(e){a===TYPES.host?i.writeString(e.hostname):a===TYPES.user&&i.writeString(e.uid)}),s.writeBuffer(i.toBuffer()),s.writeInt64(dateToInt64(e.validFrom)),s.writeInt64(dateToInt64(e.validUntil));var f=t.exts;void 0===f&&(f=[]);var u=new SSHBuffer({});return f.forEach(function(e){!0===e.critical&&(u.writeString(e.name),u.writeBuffer(e.data))}),s.writeBuffer(u.toBuffer()),u=new SSHBuffer({}),f.forEach(function(e){!0!==e.critical&&(u.writeString(e.name),u.writeBuffer(e.data))}),s.writeBuffer(u.toBuffer()),s.writeBuffer(Buffer.alloc(0)),i=rfc4253.write(e.issuerKey),s.writeBuffer(i),r||s.writeBuffer(t.signature.toBuffer("ssh")),s.toBuffer()}function getAlg(e){if("ssh-rsa-cert-v01@openssh.com"===e)return"rsa";if("ssh-dss-cert-v01@openssh.com"===e)return"dsa";if(e.match(ECDSA_ALGO))return"ecdsa";if("ssh-ed25519-cert-v01@openssh.com"===e)return"ed25519";throw new Error("Unsupported cert type "+e)}function getCertType(e){if("rsa"===e.type)return"ssh-rsa-cert-v01@openssh.com";if("dsa"===e.type)return"ssh-dss-cert-v01@openssh.com";if("ecdsa"===e.type)return"ecdsa-sha2-"+e.curve+"-cert-v01@openssh.com";if("ed25519"===e.type)return"ssh-ed25519-cert-v01@openssh.com";throw new Error("Unsupported key type "+e.type)}