module.exports={read:read,write:write};var assert=require("assert-plus"),asn1=require("asn1"),crypto=require("crypto"),Buffer=require("safer-buffer").Buffer,algs=require("../algs"),utils=require("../utils"),Key=require("../key"),PrivateKey=require("../private-key"),pkcs1=require("./pkcs1"),pkcs8=require("./pkcs8"),sshpriv=require("./ssh-private"),rfc4253=require("./rfc4253"),errors=require("../errors"),OID_PBES2="1.2.840.113549.1.5.13",OID_PBKDF2="1.2.840.113549.1.5.12",OID_TO_CIPHER={"1.2.840.113549.3.7":"3des-cbc","2.16.840.1.101.3.4.1.2":"aes128-cbc","2.16.840.1.101.3.4.1.42":"aes256-cbc"},CIPHER_TO_OID={};Object.keys(OID_TO_CIPHER).forEach(function(e){CIPHER_TO_OID[OID_TO_CIPHER[e]]=e});var OID_TO_HASH={"1.2.840.113549.2.7":"sha1","1.2.840.113549.2.9":"sha256","1.2.840.113549.2.11":"sha512"},HASH_TO_OID={};function read(e,r,s){var t=e;"string"!=typeof e&&(assert.buffer(e,"buf"),e=e.toString("ascii"));for(var a,i,o=e.trim().split(/[\r\n]+/g),n=-1;!a&&n<o.length;)a=o[++n].match(/[-]+[ ]*BEGIN ([A-Z0-9][A-Za-z0-9]+ )?(PUBLIC|PRIVATE) KEY[ ]*[-]+/);assert.ok(a,"invalid PEM header");for(var f=o.length;!i&&f>0;)i=o[--f].match(/[-]+[ ]*END ([A-Z0-9][A-Za-z0-9]+ )?(PUBLIC|PRIVATE) KEY[ ]*[-]+/);assert.ok(i,"invalid PEM footer"),assert.equal(a[2],i[2]);var c,p=a[2].toLowerCase();a[1]&&(assert.equal(a[1],i[1],"PEM header and footer mismatch"),c=a[1].trim()),o=o.slice(n,f+1);for(var u,h,d,E={};a=(o=o.slice(1))[0].match(/^([A-Za-z0-9-]+): (.+)$/);)E[a[1].toLowerCase()]=a[2];if(o=o.slice(0,-1).join(""),e=Buffer.from(o,"base64"),E["proc-type"]){var l=E["proc-type"].split(",");if("4"===l[0]&&"ENCRYPTED"===l[1]){if("string"==typeof r.passphrase&&(r.passphrase=Buffer.from(r.passphrase,"utf-8")),!Buffer.isBuffer(r.passphrase))throw new errors.KeyEncryptedError(r.filename,"PEM");l=E["dek-info"].split(","),assert.ok(2===l.length),u=l[0].toLowerCase(),d=Buffer.from(l[1],"hex"),h=utils.opensslKeyDeriv(u,d,r.passphrase,1).key}}if(c&&"encrypted"===c.toLowerCase()){var I,P=new asn1.BerReader(e);P.readSequence(),P.readSequence(),I=P.offset+P.length;var O=P.readOID();if(O!==OID_PBES2)throw new Error("Unsupported PEM/PKCS8 encryption scheme: "+O);P.readSequence(),P.readSequence();var v=P.offset+P.length,w=P.readOID();if(w!==OID_PBKDF2)throw new Error("Unsupported PBES2 KDF: "+w);P.readSequence();var k=P.readString(asn1.Ber.OctetString,!0),y=P.readInt(),S="sha1";if(P.offset<v){P.readSequence();var B=P.readOID();if(void 0===(S=OID_TO_HASH[B]))throw new Error("Unsupported PBKDF2 hash: "+B)}P._offset=v,P.readSequence();var D=P.readOID();if(void 0===(u=OID_TO_CIPHER[D]))throw new Error("Unsupported PBES2 cipher: "+D);if(d=P.readString(asn1.Ber.OctetString,!0),P._offset=I,e=P.readString(asn1.Ber.OctetString,!0),"string"==typeof r.passphrase&&(r.passphrase=Buffer.from(r.passphrase,"utf-8")),!Buffer.isBuffer(r.passphrase))throw new errors.KeyEncryptedError(r.filename,"PEM");var _=utils.opensshCipherInfo(u);u=_.opensslName,h=utils.pbkdf2(S,k,y,_.keySize,r.passphrase),c=void 0}if(u&&h&&d){var g,q=crypto.createDecipheriv(u,h,d),K=[];for(q.once("error",function(e){if(-1!==e.toString().indexOf("bad decrypt"))throw new Error("Incorrect passphrase supplied, could not decrypt key");throw e}),q.write(e),q.end();null!==(g=q.read());)K.push(g);e=Buffer.concat(K)}if(c&&"openssh"===c.toLowerCase())return sshpriv.readSSHPrivate(p,e,r);if(c&&"ssh2"===c.toLowerCase())return rfc4253.readType(p,e,r);var C=new asn1.BerReader(e);return C.originalInput=t,C.readSequence(),c?(s&&assert.strictEqual(s,"pkcs1"),pkcs1.readPkcs1(c,p,C)):(s&&assert.strictEqual(s,"pkcs8"),pkcs8.readPkcs8(c,p,C))}function write(e,r,s){assert.object(e);var t,a={ecdsa:"EC",rsa:"RSA",dsa:"DSA",ed25519:"EdDSA"}[e.type],i=new asn1.BerWriter;if(PrivateKey.isPrivateKey(e))s&&"pkcs8"===s?(t="PRIVATE KEY",pkcs8.writePkcs8(i,e)):(s&&assert.strictEqual(s,"pkcs1"),t=a+" PRIVATE KEY",pkcs1.writePkcs1(i,e));else{if(!Key.isKey(e))throw new Error("key is not a Key or PrivateKey");s&&"pkcs1"===s?(t=a+" PUBLIC KEY",pkcs1.writePkcs1(i,e)):(s&&assert.strictEqual(s,"pkcs8"),t="PUBLIC KEY",pkcs8.writePkcs8(i,e))}var o=i.buffer.toString("base64"),n=o.length+o.length/64+18+16+2*t.length+10,f=Buffer.alloc(n),c=0;c+=f.write("-----BEGIN "+t+"-----\n",c);for(var p=0;p<o.length;){var u=p+64;u>o.length&&(u=o.length),c+=f.write(o.slice(p,u),c),f[c++]=10,p=u}return c+=f.write("-----END "+t+"-----\n",c),f.slice(0,c)}Object.keys(OID_TO_HASH).forEach(function(e){HASH_TO_OID[OID_TO_HASH[e]]=e});