module.exports={read:read,readPkcs1:readPkcs1,write:write,writePkcs1:writePkcs1};var assert=require("assert-plus"),asn1=require("asn1"),Buffer=require("safer-buffer").Buffer,algs=require("../algs"),utils=require("../utils"),Key=require("../key"),PrivateKey=require("../private-key"),pem=require("./pem"),pkcs8=require("./pkcs8"),readECDSACurve=pkcs8.readECDSACurve;function read(e,r){return pem.read(e,r,"pkcs1")}function write(e,r){return pem.write(e,r,"pkcs1")}function readMPInt(e,r){return assert.strictEqual(e.peek(),asn1.Ber.Integer,r+" is not an Integer"),utils.mpNormalize(e.readString(asn1.Ber.Integer,!0))}function readPkcs1(e,r,a){switch(e){case"RSA":if("public"===r)return readPkcs1RSAPublic(a);if("private"===r)return readPkcs1RSAPrivate(a);throw new Error("Unknown key type: "+r);case"DSA":if("public"===r)return readPkcs1DSAPublic(a);if("private"===r)return readPkcs1DSAPrivate(a);throw new Error("Unknown key type: "+r);case"EC":case"ECDSA":if("private"===r)return readPkcs1ECDSAPrivate(a);if("public"===r)return readPkcs1ECDSAPublic(a);throw new Error("Unknown key type: "+r);case"EDDSA":case"EdDSA":if("private"===r)return readPkcs1EdDSAPrivate(a);throw new Error(r+" keys not supported with EdDSA");default:throw new Error("Unknown key algo: "+e)}}function readPkcs1RSAPublic(e){var r=readMPInt(e,"modulus"),a=readMPInt(e,"exponent");return new Key({type:"rsa",parts:[{name:"e",data:a},{name:"n",data:r}]})}function readPkcs1RSAPrivate(e){var r=readMPInt(e,"version");assert.strictEqual(r[0],0);var a=readMPInt(e,"modulus"),t=readMPInt(e,"public exponent"),n=readMPInt(e,"private exponent"),i=readMPInt(e,"prime1"),s=readMPInt(e,"prime2"),d=readMPInt(e,"exponent1"),u=readMPInt(e,"exponent2"),c=readMPInt(e,"iqmp");return new PrivateKey({type:"rsa",parts:[{name:"n",data:a},{name:"e",data:t},{name:"d",data:n},{name:"iqmp",data:c},{name:"p",data:i},{name:"q",data:s},{name:"dmodp",data:d},{name:"dmodq",data:u}]})}function readPkcs1DSAPrivate(e){var r=readMPInt(e,"version");assert.strictEqual(r.readUInt8(0),0);var a=readMPInt(e,"p"),t=readMPInt(e,"q"),n=readMPInt(e,"g"),i=readMPInt(e,"y"),s=readMPInt(e,"x");return new PrivateKey({type:"dsa",parts:[{name:"p",data:a},{name:"q",data:t},{name:"g",data:n},{name:"y",data:i},{name:"x",data:s}]})}function readPkcs1EdDSAPrivate(e){var r=readMPInt(e,"version");assert.strictEqual(r.readUInt8(0),1);var a=e.readString(asn1.Ber.OctetString,!0);e.readSequence(160);var t=e.readOID();assert.strictEqual(t,"1.3.101.112","the ed25519 curve identifier"),e.readSequence(161);var n=utils.readBitString(e),i={type:"ed25519",parts:[{name:"A",data:utils.zeroPadToLength(n,32)},{name:"k",data:a}]};return new PrivateKey(i)}function readPkcs1DSAPublic(e){var r=readMPInt(e,"y"),a=readMPInt(e,"p"),t=readMPInt(e,"q"),n=readMPInt(e,"g");return new Key({type:"dsa",parts:[{name:"y",data:r},{name:"p",data:a},{name:"q",data:t},{name:"g",data:n}]})}function readPkcs1ECDSAPublic(e){e.readSequence();var r=e.readOID();assert.strictEqual(r,"1.2.840.10045.2.1","must be ecPublicKey");for(var a,t=e.readOID(),n=Object.keys(algs.curves),i=0;i<n.length;++i){var s=n[i];if(algs.curves[s].pkcs8oid===t){a=s;break}}assert.string(a,"a known ECDSA named curve");var d=e.readString(asn1.Ber.BitString,!0);d=utils.ecNormalize(d);var u={type:"ecdsa",parts:[{name:"curve",data:Buffer.from(a)},{name:"Q",data:d}]};return new Key(u)}function readPkcs1ECDSAPrivate(e){var r=readMPInt(e,"version");assert.strictEqual(r.readUInt8(0),1);var a=e.readString(asn1.Ber.OctetString,!0);e.readSequence(160);var t=readECDSACurve(e);assert.string(t,"a known elliptic curve"),e.readSequence(161);var n=e.readString(asn1.Ber.BitString,!0);n=utils.ecNormalize(n);var i={type:"ecdsa",parts:[{name:"curve",data:Buffer.from(t)},{name:"Q",data:n},{name:"d",data:a}]};return new PrivateKey(i)}function writePkcs1(e,r){switch(e.startSequence(),r.type){case"rsa":PrivateKey.isPrivateKey(r)?writePkcs1RSAPrivate(e,r):writePkcs1RSAPublic(e,r);break;case"dsa":PrivateKey.isPrivateKey(r)?writePkcs1DSAPrivate(e,r):writePkcs1DSAPublic(e,r);break;case"ecdsa":PrivateKey.isPrivateKey(r)?writePkcs1ECDSAPrivate(e,r):writePkcs1ECDSAPublic(e,r);break;case"ed25519":PrivateKey.isPrivateKey(r)?writePkcs1EdDSAPrivate(e,r):writePkcs1EdDSAPublic(e,r);break;default:throw new Error("Unknown key algo: "+r.type)}e.endSequence()}function writePkcs1RSAPublic(e,r){e.writeBuffer(r.part.n.data,asn1.Ber.Integer),e.writeBuffer(r.part.e.data,asn1.Ber.Integer)}function writePkcs1RSAPrivate(e,r){var a=Buffer.from([0]);e.writeBuffer(a,asn1.Ber.Integer),e.writeBuffer(r.part.n.data,asn1.Ber.Integer),e.writeBuffer(r.part.e.data,asn1.Ber.Integer),e.writeBuffer(r.part.d.data,asn1.Ber.Integer),e.writeBuffer(r.part.p.data,asn1.Ber.Integer),e.writeBuffer(r.part.q.data,asn1.Ber.Integer),r.part.dmodp&&r.part.dmodq||utils.addRSAMissing(r),e.writeBuffer(r.part.dmodp.data,asn1.Ber.Integer),e.writeBuffer(r.part.dmodq.data,asn1.Ber.Integer),e.writeBuffer(r.part.iqmp.data,asn1.Ber.Integer)}function writePkcs1DSAPrivate(e,r){var a=Buffer.from([0]);e.writeBuffer(a,asn1.Ber.Integer),e.writeBuffer(r.part.p.data,asn1.Ber.Integer),e.writeBuffer(r.part.q.data,asn1.Ber.Integer),e.writeBuffer(r.part.g.data,asn1.Ber.Integer),e.writeBuffer(r.part.y.data,asn1.Ber.Integer),e.writeBuffer(r.part.x.data,asn1.Ber.Integer)}function writePkcs1DSAPublic(e,r){e.writeBuffer(r.part.y.data,asn1.Ber.Integer),e.writeBuffer(r.part.p.data,asn1.Ber.Integer),e.writeBuffer(r.part.q.data,asn1.Ber.Integer),e.writeBuffer(r.part.g.data,asn1.Ber.Integer)}function writePkcs1ECDSAPublic(e,r){e.startSequence(),e.writeOID("1.2.840.10045.2.1");var a=r.part.curve.data.toString(),t=algs.curves[a].pkcs8oid;assert.string(t,"a known ECDSA named curve"),e.writeOID(t),e.endSequence();var n=utils.ecNormalize(r.part.Q.data,!0);e.writeBuffer(n,asn1.Ber.BitString)}function writePkcs1ECDSAPrivate(e,r){var a=Buffer.from([1]);e.writeBuffer(a,asn1.Ber.Integer),e.writeBuffer(r.part.d.data,asn1.Ber.OctetString),e.startSequence(160);var t=r.part.curve.data.toString(),n=algs.curves[t].pkcs8oid;assert.string(n,"a known ECDSA named curve"),e.writeOID(n),e.endSequence(),e.startSequence(161);var i=utils.ecNormalize(r.part.Q.data,!0);e.writeBuffer(i,asn1.Ber.BitString),e.endSequence()}function writePkcs1EdDSAPrivate(e,r){var a=Buffer.from([1]);e.writeBuffer(a,asn1.Ber.Integer),e.writeBuffer(r.part.k.data,asn1.Ber.OctetString),e.startSequence(160),e.writeOID("1.3.101.112"),e.endSequence(),e.startSequence(161),utils.writeBitString(e,r.part.A.data),e.endSequence()}function writePkcs1EdDSAPublic(e,r){throw new Error("Public keys are not supported for EdDSA PKCS#1")}