module.exports={read:read,readPkcs8:readPkcs8,write:write,writePkcs8:writePkcs8,pkcs8ToBuffer:pkcs8ToBuffer,readECDSACurve:readECDSACurve,writeECDSACurve:writeECDSACurve};var assert=require("assert-plus"),asn1=require("asn1"),Buffer=require("safer-buffer").Buffer,algs=require("../algs"),utils=require("../utils"),Key=require("../key"),PrivateKey=require("../private-key"),pem=require("./pem");function read(e,r){return pem.read(e,r,"pkcs8")}function write(e,r){return pem.write(e,r,"pkcs8")}function readMPInt(e,r){return assert.strictEqual(e.peek(),asn1.Ber.Integer,r+" is not an Integer"),utils.mpNormalize(e.readString(asn1.Ber.Integer,!0))}function readPkcs8(e,r,t){t.peek()===asn1.Ber.Integer&&(assert.strictEqual(r,"private","unexpected Integer at start of public key"),t.readString(asn1.Ber.Integer,!0)),t.readSequence();var a=t.offset+t.length,n=t.readOID();switch(n){case"1.2.840.113549.1.1.1":return t._offset=a,"public"===r?readPkcs8RSAPublic(t):readPkcs8RSAPrivate(t);case"1.2.840.10040.4.1":return"public"===r?readPkcs8DSAPublic(t):readPkcs8DSAPrivate(t);case"1.2.840.10045.2.1":return"public"===r?readPkcs8ECDSAPublic(t):readPkcs8ECDSAPrivate(t);case"1.3.101.112":return"public"===r?readPkcs8EdDSAPublic(t):readPkcs8EdDSAPrivate(t);case"1.3.101.110":return"public"===r?readPkcs8X25519Public(t):readPkcs8X25519Private(t);default:throw new Error("Unknown key type OID "+n)}}function readPkcs8RSAPublic(e){e.readSequence(asn1.Ber.BitString),e.readByte(),e.readSequence();var r=readMPInt(e,"modulus"),t=readMPInt(e,"exponent"),a={type:"rsa",source:e.originalInput,parts:[{name:"e",data:t},{name:"n",data:r}]};return new Key(a)}function readPkcs8RSAPrivate(e){e.readSequence(asn1.Ber.OctetString),e.readSequence();var r=readMPInt(e,"version");assert.equal(r[0],0,"unknown RSA private key version");var t=readMPInt(e,"modulus"),a=readMPInt(e,"public exponent"),n=readMPInt(e,"private exponent"),i=readMPInt(e,"prime1"),s=readMPInt(e,"prime2"),u=readMPInt(e,"exponent1"),c=readMPInt(e,"exponent2"),d=readMPInt(e,"iqmp");return new PrivateKey({type:"rsa",parts:[{name:"n",data:t},{name:"e",data:a},{name:"d",data:n},{name:"iqmp",data:d},{name:"p",data:i},{name:"q",data:s},{name:"dmodp",data:u},{name:"dmodq",data:c}]})}function readPkcs8DSAPublic(e){e.readSequence();var r=readMPInt(e,"p"),t=readMPInt(e,"q"),a=readMPInt(e,"g");e.readSequence(asn1.Ber.BitString),e.readByte();var n=readMPInt(e,"y");return new Key({type:"dsa",parts:[{name:"p",data:r},{name:"q",data:t},{name:"g",data:a},{name:"y",data:n}]})}function readPkcs8DSAPrivate(e){e.readSequence();var r=readMPInt(e,"p"),t=readMPInt(e,"q"),a=readMPInt(e,"g");e.readSequence(asn1.Ber.OctetString);var n=readMPInt(e,"x"),i=utils.calculateDSAPublic(a,r,n);return new PrivateKey({type:"dsa",parts:[{name:"p",data:r},{name:"q",data:t},{name:"g",data:a},{name:"y",data:i},{name:"x",data:n}]})}function readECDSACurve(e){var r,t,a,n,i;if(e.peek()===asn1.Ber.OID){var s=e.readOID();for(t=Object.keys(algs.curves),a=0;a<t.length;++a)if(n=t[a],(i=algs.curves[n]).pkcs8oid===s){r=n;break}}else{e.readSequence();var u=e.readString(asn1.Ber.Integer,!0);assert.strictEqual(u[0],1,"ECDSA key not version 1");var c={};e.readSequence();var d=e.readOID();assert.strictEqual(d,"1.2.840.10045.1.1","ECDSA key is not from a prime-field");var f=c.p=utils.mpNormalize(e.readString(asn1.Ber.Integer,!0));c.size=8*f.length-utils.countZeros(f),e.readSequence(),c.a=utils.mpNormalize(e.readString(asn1.Ber.OctetString,!0)),c.b=utils.mpNormalize(e.readString(asn1.Ber.OctetString,!0)),e.peek()===asn1.Ber.BitString&&(c.s=e.readString(asn1.Ber.BitString,!0)),c.G=e.readString(asn1.Ber.OctetString,!0),assert.strictEqual(c.G[0],4,"uncompressed G is required"),c.n=utils.mpNormalize(e.readString(asn1.Ber.Integer,!0)),c.h=utils.mpNormalize(e.readString(asn1.Ber.Integer,!0)),assert.strictEqual(c.h[0],1,"a cofactor=1 curve is required"),t=Object.keys(algs.curves);var S=Object.keys(c);for(a=0;a<t.length;++a){n=t[a],i=algs.curves[n];for(var B=!0,o=0;o<S.length;++o){var p=S[o];if(void 0!==i[p])if("object"==typeof i[p]&&void 0!==i[p].equals){if(!i[p].equals(c[p])){B=!1;break}}else if(Buffer.isBuffer(i[p])){if(i[p].toString("binary")!==c[p].toString("binary")){B=!1;break}}else if(i[p]!==c[p]){B=!1;break}}if(B){r=n;break}}}return r}function readPkcs8ECDSAPrivate(e){var r=readECDSACurve(e);assert.string(r,"a known elliptic curve"),e.readSequence(asn1.Ber.OctetString),e.readSequence();var t=readMPInt(e,"version");assert.equal(t[0],1,"unknown version of ECDSA key");var a,n=e.readString(asn1.Ber.OctetString,!0);(160==e.peek()&&(e.readSequence(160),e._offset+=e.length),161==e.peek()&&(e.readSequence(161),a=e.readString(asn1.Ber.BitString,!0),a=utils.ecNormalize(a)),void 0===a)&&(a=utils.publicFromPrivateECDSA(r,n).part.Q.data);var i={type:"ecdsa",parts:[{name:"curve",data:Buffer.from(r)},{name:"Q",data:a},{name:"d",data:n}]};return new PrivateKey(i)}function readPkcs8ECDSAPublic(e){var r=readECDSACurve(e);assert.string(r,"a known elliptic curve");var t=e.readString(asn1.Ber.BitString,!0);t=utils.ecNormalize(t);var a={type:"ecdsa",parts:[{name:"curve",data:Buffer.from(r)},{name:"Q",data:t}]};return new Key(a)}function readPkcs8EdDSAPublic(e){0===e.peek()&&e.readByte();var r=utils.readBitString(e),t={type:"ed25519",parts:[{name:"A",data:utils.zeroPadToLength(r,32)}]};return new Key(t)}function readPkcs8X25519Public(e){var r=utils.readBitString(e),t={type:"curve25519",parts:[{name:"A",data:utils.zeroPadToLength(r,32)}]};return new Key(t)}function readPkcs8EdDSAPrivate(e){0===e.peek()&&e.readByte(),e.readSequence(asn1.Ber.OctetString);var r,t=e.readString(asn1.Ber.OctetString,!0);t=utils.zeroPadToLength(t,32),e.peek()===asn1.Ber.BitString?(r=utils.readBitString(e),r=utils.zeroPadToLength(r,32)):r=utils.calculateED25519Public(t);var a={type:"ed25519",parts:[{name:"A",data:utils.zeroPadToLength(r,32)},{name:"k",data:utils.zeroPadToLength(t,32)}]};return new PrivateKey(a)}function readPkcs8X25519Private(e){0===e.peek()&&e.readByte(),e.readSequence(asn1.Ber.OctetString);var r=e.readString(asn1.Ber.OctetString,!0);r=utils.zeroPadToLength(r,32);var t=utils.calculateX25519Public(r),a={type:"curve25519",parts:[{name:"A",data:utils.zeroPadToLength(t,32)},{name:"k",data:utils.zeroPadToLength(r,32)}]};return new PrivateKey(a)}function pkcs8ToBuffer(e){var r=new asn1.BerWriter;return writePkcs8(r,e),r.buffer}function writePkcs8(e,r){if(e.startSequence(),PrivateKey.isPrivateKey(r)){var t=Buffer.from([0]);e.writeBuffer(t,asn1.Ber.Integer)}switch(e.startSequence(),r.type){case"rsa":e.writeOID("1.2.840.113549.1.1.1"),PrivateKey.isPrivateKey(r)?writePkcs8RSAPrivate(r,e):writePkcs8RSAPublic(r,e);break;case"dsa":e.writeOID("1.2.840.10040.4.1"),PrivateKey.isPrivateKey(r)?writePkcs8DSAPrivate(r,e):writePkcs8DSAPublic(r,e);break;case"ecdsa":e.writeOID("1.2.840.10045.2.1"),PrivateKey.isPrivateKey(r)?writePkcs8ECDSAPrivate(r,e):writePkcs8ECDSAPublic(r,e);break;case"ed25519":if(e.writeOID("1.3.101.112"),PrivateKey.isPrivateKey(r))throw new Error("Ed25519 private keys in pkcs8 format are not supported");writePkcs8EdDSAPublic(r,e);break;default:throw new Error("Unsupported key type: "+r.type)}e.endSequence()}function writePkcs8RSAPrivate(e,r){r.writeNull(),r.endSequence(),r.startSequence(asn1.Ber.OctetString),r.startSequence();var t=Buffer.from([0]);r.writeBuffer(t,asn1.Ber.Integer),r.writeBuffer(e.part.n.data,asn1.Ber.Integer),r.writeBuffer(e.part.e.data,asn1.Ber.Integer),r.writeBuffer(e.part.d.data,asn1.Ber.Integer),r.writeBuffer(e.part.p.data,asn1.Ber.Integer),r.writeBuffer(e.part.q.data,asn1.Ber.Integer),e.part.dmodp&&e.part.dmodq||utils.addRSAMissing(e),r.writeBuffer(e.part.dmodp.data,asn1.Ber.Integer),r.writeBuffer(e.part.dmodq.data,asn1.Ber.Integer),r.writeBuffer(e.part.iqmp.data,asn1.Ber.Integer),r.endSequence(),r.endSequence()}function writePkcs8RSAPublic(e,r){r.writeNull(),r.endSequence(),r.startSequence(asn1.Ber.BitString),r.writeByte(0),r.startSequence(),r.writeBuffer(e.part.n.data,asn1.Ber.Integer),r.writeBuffer(e.part.e.data,asn1.Ber.Integer),r.endSequence(),r.endSequence()}function writePkcs8DSAPrivate(e,r){r.startSequence(),r.writeBuffer(e.part.p.data,asn1.Ber.Integer),r.writeBuffer(e.part.q.data,asn1.Ber.Integer),r.writeBuffer(e.part.g.data,asn1.Ber.Integer),r.endSequence(),r.endSequence(),r.startSequence(asn1.Ber.OctetString),r.writeBuffer(e.part.x.data,asn1.Ber.Integer),r.endSequence()}function writePkcs8DSAPublic(e,r){r.startSequence(),r.writeBuffer(e.part.p.data,asn1.Ber.Integer),r.writeBuffer(e.part.q.data,asn1.Ber.Integer),r.writeBuffer(e.part.g.data,asn1.Ber.Integer),r.endSequence(),r.endSequence(),r.startSequence(asn1.Ber.BitString),r.writeByte(0),r.writeBuffer(e.part.y.data,asn1.Ber.Integer),r.endSequence()}function writeECDSACurve(e,r){var t=algs.curves[e.curve];if(t.pkcs8oid)r.writeOID(t.pkcs8oid);else{r.startSequence();var a=Buffer.from([1]);r.writeBuffer(a,asn1.Ber.Integer),r.startSequence(),r.writeOID("1.2.840.10045.1.1"),r.writeBuffer(t.p,asn1.Ber.Integer),r.endSequence(),r.startSequence();var n=t.p;0===n[0]&&(n=n.slice(1)),r.writeBuffer(n,asn1.Ber.OctetString),r.writeBuffer(t.b,asn1.Ber.OctetString),r.writeBuffer(t.s,asn1.Ber.BitString),r.endSequence(),r.writeBuffer(t.G,asn1.Ber.OctetString),r.writeBuffer(t.n,asn1.Ber.Integer);var i=t.h;i||(i=Buffer.from([1])),r.writeBuffer(i,asn1.Ber.Integer),r.endSequence()}}function writePkcs8ECDSAPublic(e,r){writeECDSACurve(e,r),r.endSequence();var t=utils.ecNormalize(e.part.Q.data,!0);r.writeBuffer(t,asn1.Ber.BitString)}function writePkcs8ECDSAPrivate(e,r){writeECDSACurve(e,r),r.endSequence(),r.startSequence(asn1.Ber.OctetString),r.startSequence();var t=Buffer.from([1]);r.writeBuffer(t,asn1.Ber.Integer),r.writeBuffer(e.part.d.data,asn1.Ber.OctetString),r.startSequence(161);var a=utils.ecNormalize(e.part.Q.data,!0);r.writeBuffer(a,asn1.Ber.BitString),r.endSequence(),r.endSequence(),r.endSequence()}function writePkcs8EdDSAPublic(e,r){r.endSequence(),utils.writeBitString(r,e.part.A.data)}function writePkcs8EdDSAPrivate(e,r){r.endSequence();var t=utils.mpNormalize(e.part.k.data,!0);r.startSequence(asn1.Ber.OctetString),r.writeBuffer(t,asn1.Ber.OctetString),r.endSequence()}