module.exports={read:read.bind(void 0,!1,void 0),readType:read.bind(void 0,!1),write:write,readPartial:read.bind(void 0,!0),readInternal:read,keyTypeToAlg:keyTypeToAlg,algToKeyType:algToKeyType};var assert=require("assert-plus"),Buffer=require("safer-buffer").Buffer,algs=require("../algs"),utils=require("../utils"),Key=require("../key"),PrivateKey=require("../private-key"),SSHBuffer=require("../ssh-buffer");function algToKeyType(e){if(assert.string(e),"ssh-dss"===e)return"dsa";if("ssh-rsa"===e)return"rsa";if("ssh-ed25519"===e)return"ed25519";if("ssh-curve25519"===e)return"curve25519";if(e.match(/^ecdsa-sha2-/))return"ecdsa";throw new Error("Unknown algorithm "+e)}function keyTypeToAlg(e){if(assert.object(e),"dsa"===e.type)return"ssh-dss";if("rsa"===e.type)return"ssh-rsa";if("ed25519"===e.type)return"ssh-ed25519";if("curve25519"===e.type)return"ssh-curve25519";if("ecdsa"===e.type)return"ecdsa-sha2-"+e.part.curve.data.toString();throw new Error("Unknown key type "+e.type)}function read(e,r,t,a){"string"==typeof t&&(t=Buffer.from(t)),assert.buffer(t,"buf");var s={},n=s.parts=[],i=new SSHBuffer({buffer:t}),o=i.readString();assert.ok(!i.atEnd(),"key must have at least one part"),s.type=algToKeyType(o);var f=algs.info[s.type].parts.length;for(r&&"private"===r&&(f=algs.privInfo[s.type].parts.length);!i.atEnd()&&n.length<f;)n.push(i.readPart());for(;!e&&!i.atEnd();)n.push(i.readPart());assert.ok(n.length>=1,"key must have at least one part"),assert.ok(e||i.atEnd(),"leftover bytes at end of key");var u=Key,d=algs.info[s.type];if("private"!==r&&d.parts.length===n.length||(d=algs.privInfo[s.type],u=PrivateKey),assert.strictEqual(d.parts.length,n.length),"ecdsa"===s.type){var p=/^ecdsa-sha2-(.+)$/.exec(o);assert.ok(null!==p),assert.strictEqual(p[1],n[0].data.toString())}for(var y=!0,l=0;l<d.parts.length;++l){var g,h=n[l];if(h.name=d.parts[l],"ed25519"===s.type&&"k"===h.name&&(h.data=h.data.slice(0,32)),"curve"!==h.name&&!1!==d.normalize)(g="ed25519"===s.type?utils.zeroPadToLength(h.data,32):utils.mpNormalize(h.data)).toString("binary")!==h.data.toString("binary")&&(h.data=g,y=!1)}return y&&(s._rfc4253Cache=i.toBuffer()),e&&"object"==typeof e&&(e.remainder=i.remainder(),e.consumed=i._offset),new u(s)}function write(e,r){assert.object(e);var t,a=keyTypeToAlg(e),s=algs.info[e.type];PrivateKey.isPrivateKey(e)&&(s=algs.privInfo[e.type]);var n=s.parts,i=new SSHBuffer({});for(i.writeString(a),t=0;t<n.length;++t){var o=e.part[n[t]].data;!1!==s.normalize&&(o="ed25519"===e.type?utils.zeroPadToLength(o,32):utils.mpNormalize(o)),"ed25519"===e.type&&"k"===n[t]&&(o=Buffer.concat([o,e.part.A.data])),i.writeBuffer(o)}return i.toBuffer()}