module.exports={read:read,readSSHPrivate:readSSHPrivate,write:write};var bcrypt,assert=require("assert-plus"),asn1=require("asn1"),Buffer=require("safer-buffer").Buffer,algs=require("../algs"),utils=require("../utils"),crypto=require("crypto"),Key=require("../key"),PrivateKey=require("../private-key"),pem=require("./pem"),rfc4253=require("./rfc4253"),SSHBuffer=require("../ssh-buffer"),errors=require("../errors");function read(e,r){return pem.read(e,r)}var MAGIC="openssh-key-v1";function readSSHPrivate(e,r,t){var i=(r=new SSHBuffer({buffer:r})).readCString();assert.strictEqual(i,MAGIC,"bad magic string");var n=r.readString(),a=r.readString(),f=r.readBuffer();if(1!==r.readInt())throw new Error("OpenSSH-format key file contains multiple keys: this is unsupported.");var s=r.readBuffer();if("public"===e)return assert.ok(r.atEnd(),"excess bytes left after key"),rfc4253.read(s);var o=r.readBuffer();assert.ok(r.atEnd(),"excess bytes left after key");var u=new SSHBuffer({buffer:f});switch(a){case"none":if("none"!==n)throw new Error('OpenSSH-format key uses KDF "none" but specifies a cipher other than "none"');break;case"bcrypt":var p=u.readBuffer(),c=u.readInt(),d=utils.opensshCipherInfo(n);if(void 0===bcrypt&&(bcrypt=require("bcrypt-pbkdf")),"string"==typeof t.passphrase&&(t.passphrase=Buffer.from(t.passphrase,"utf-8")),!Buffer.isBuffer(t.passphrase))throw new errors.KeyEncryptedError(t.filename,"OpenSSH");var y=new Uint8Array(t.passphrase),l=new Uint8Array(p),w=new Uint8Array(d.keySize+d.blockSize);if(0!==bcrypt.pbkdf(y,y.length,l,l.length,w,w.length,c))throw new Error("bcrypt_pbkdf function returned failure, parameters invalid");var S=(w=Buffer.from(w)).slice(0,d.keySize),h=w.slice(d.keySize,d.keySize+d.blockSize),v=crypto.createDecipheriv(d.opensslName,S,h);v.setAutoPadding(!1);var b,k=[];for(v.once("error",function(e){if(-1!==e.toString().indexOf("bad decrypt"))throw new Error("Incorrect passphrase supplied, could not decrypt key");throw e}),v.write(o),v.end();null!==(b=v.read());)k.push(b);o=Buffer.concat(k);break;default:throw new Error('OpenSSH-format key uses unknown KDF "'+a+'"')}if((r=new SSHBuffer({buffer:o})).readInt()!==r.readInt())throw new Error("Incorrect passphrase supplied, could not decrypt key");var B={},g=rfc4253.readInternal(B,"private",r.remainder());r.skip(B.consumed);var m=r.readString();return g.comment=m,g}function write(e,r){var t;t=PrivateKey.isPrivateKey(e)?e.toPublic():e;var i,n,a="none",f="none",s=Buffer.alloc(0),o={blockSize:8};if(void 0!==r&&("string"==typeof(i=r.passphrase)&&(i=Buffer.from(i,"utf-8")),void 0!==i&&(assert.buffer(i,"options.passphrase"),assert.optionalString(r.cipher,"options.cipher"),void 0===(a=r.cipher)&&(a="aes128-ctr"),o=utils.opensshCipherInfo(a),f="bcrypt")),PrivateKey.isPrivateKey(e)){n=new SSHBuffer({});var u=crypto.randomBytes(4).readUInt32BE(0);n.writeInt(u),n.writeInt(u),n.write(e.toBuffer("rfc4253")),n.writeString(e.comment||"");for(var p=1;n._offset%o.blockSize!=0;)n.writeChar(p++);n=n.toBuffer()}switch(f){case"none":break;case"bcrypt":var c=crypto.randomBytes(16),d=new SSHBuffer({});d.writeBuffer(c),d.writeInt(16),s=d.toBuffer(),void 0===bcrypt&&(bcrypt=require("bcrypt-pbkdf"));var y=new Uint8Array(i),l=new Uint8Array(c),w=new Uint8Array(o.keySize+o.blockSize);if(0!==bcrypt.pbkdf(y,y.length,l,l.length,w,w.length,16))throw new Error("bcrypt_pbkdf function returned failure, parameters invalid");var S=(w=Buffer.from(w)).slice(0,o.keySize),h=w.slice(o.keySize,o.keySize+o.blockSize),v=crypto.createCipheriv(o.opensslName,S,h);v.setAutoPadding(!1);var b,k=[];for(v.once("error",function(e){throw e}),v.write(n),v.end();null!==(b=v.read());)k.push(b);n=Buffer.concat(k);break;default:throw new Error("Unsupported kdf "+f)}var B,g=new SSHBuffer({});g.writeCString(MAGIC),g.writeString(a),g.writeString(f),g.writeBuffer(s),g.writeInt(1),g.writeBuffer(t.toBuffer("rfc4253")),n&&g.writeBuffer(n),g=g.toBuffer(),B=PrivateKey.isPrivateKey(e)?"OPENSSH PRIVATE KEY":"OPENSSH PUBLIC KEY";var m=g.toString("base64"),E=m.length+m.length/70+18+16+2*B.length+10,I=0;I+=(g=Buffer.alloc(E)).write("-----BEGIN "+B+"-----\n",I);for(var P=0;P<m.length;){var H=P+70;H>m.length&&(H=m.length),I+=g.write(m.slice(P,H),I),g[I++]=10,P=H}return I+=g.write("-----END "+B+"-----\n",I),g.slice(0,I)}