module.exports={read:read,verify:verify,sign:sign,signAsync:signAsync,write:write};var assert=require("assert-plus"),asn1=require("asn1"),Buffer=require("safer-buffer").Buffer,algs=require("../algs"),utils=require("../utils"),Key=require("../key"),PrivateKey=require("../private-key"),pem=require("./pem"),Identity=require("../identity"),Signature=require("../signature"),Certificate=require("../certificate"),pkcs8=require("./pkcs8");function readMPInt(e,r){return assert.strictEqual(e.peek(),asn1.Ber.Integer,r+" is not an Integer"),utils.mpNormalize(e.readString(asn1.Ber.Integer,!0))}function verify(e,r){var t=e.signatures.x509;assert.object(t,"x509 signature");var a=t.algo.split("-");if(a[0]!==r.type)return!1;var s=t.cache;if(void 0===s){var n=new asn1.BerWriter;writeTBSCert(e,n),s=n.buffer}var i=r.createVerify(a[1]);return i.write(s),i.verify(t.signature)}function Local(e){return asn1.Ber.Context|asn1.Ber.Constructor|e}function Context(e){return asn1.Ber.Context|e}var SIGN_ALGS={"rsa-md5":"1.2.840.113549.1.1.4","rsa-sha1":"1.2.840.113549.1.1.5","rsa-sha256":"1.2.840.113549.1.1.11","rsa-sha384":"1.2.840.113549.1.1.12","rsa-sha512":"1.2.840.113549.1.1.13","dsa-sha1":"1.2.840.10040.4.3","dsa-sha256":"2.16.840.1.101.3.4.3.2","ecdsa-sha1":"1.2.840.10045.4.1","ecdsa-sha256":"1.2.840.10045.4.3.2","ecdsa-sha384":"1.2.840.10045.4.3.3","ecdsa-sha512":"1.2.840.10045.4.3.4","ed25519-sha512":"1.3.101.112"};Object.keys(SIGN_ALGS).forEach(function(e){SIGN_ALGS[SIGN_ALGS[e]]=e}),SIGN_ALGS["1.3.14.3.2.3"]="rsa-md5",SIGN_ALGS["1.3.14.3.2.29"]="rsa-sha1";var EXTS={issuerKeyId:"2.5.29.35",altName:"2.5.29.17",basicConstraints:"2.5.29.19",keyUsage:"2.5.29.15",extKeyUsage:"2.5.29.37"};function read(e,r){"string"==typeof e&&(e=Buffer.from(e,"binary")),assert.buffer(e,"buf");var t=new asn1.BerReader(e);if(t.readSequence(),Math.abs(t.length-t.remain)>1)throw new Error("DER sequence does not contain whole byte stream");var a=t.offset;t.readSequence();var s=t.offset+t.length,n=s;if(t.peek()===Local(0)){t.readSequence(Local(0));var i=t.readInt();assert.ok(i<=3,"only x.509 versions up to v3 supported")}var o={signatures:{}},u=o.signatures.x509={};u.extras={},o.serial=readMPInt(t,"serial"),t.readSequence();var c=t.offset+t.length,f=t.readOID();if(void 0===SIGN_ALGS[f])throw new Error("unknown signature algorithm "+f);if(t._offset=c,o.issuer=Identity.parseAsn1(t),t.readSequence(),o.validFrom=readDate(t),o.validUntil=readDate(t),o.subjects=[Identity.parseAsn1(t)],t.readSequence(),c=t.offset+t.length,o.subjectKey=pkcs8.readPkcs8(void 0,"public",t),t._offset=c,t.peek()===Local(1)&&(t.readSequence(Local(1)),u.extras.issuerUniqueID=e.slice(t.offset,t.offset+t.length),t._offset+=t.length),t.peek()===Local(2)&&(t.readSequence(Local(2)),u.extras.subjectUniqueID=e.slice(t.offset,t.offset+t.length),t._offset+=t.length),t.peek()===Local(3)){t.readSequence(Local(3));var d=t.offset+t.length;for(t.readSequence();t.offset<d;)readExtension(o,e,t);assert.strictEqual(t.offset,d)}assert.strictEqual(t.offset,s),t.readSequence(),c=t.offset+t.length;var l=t.readOID(),S=SIGN_ALGS[l];if(void 0===S)throw new Error("unknown signature algorithm "+l);t._offset=c;var g=t.readString(asn1.Ber.BitString,!0);0===g[0]&&(g=g.slice(1));var p=S.split("-");return u.signature=Signature.parse(g,p[0],"asn1"),u.signature.hashAlgorithm=p[1],u.algo=S,u.cache=e.slice(a,n),new Certificate(o)}function readDate(e){if(e.peek()===asn1.Ber.UTCTime)return utcTimeToDate(e.readString(asn1.Ber.UTCTime));if(e.peek()===asn1.Ber.GeneralizedTime)return gTimeToDate(e.readString(asn1.Ber.GeneralizedTime));throw new Error("Unsupported date format")}function writeDate(e,r){r.getUTCFullYear()>=2050||r.getUTCFullYear()<1950?e.writeString(dateToGTime(r),asn1.Ber.GeneralizedTime):e.writeString(dateToUTCTime(r),asn1.Ber.UTCTime)}var ALTNAME={OtherName:Local(0),RFC822Name:Context(1),DNSName:Context(2),X400Address:Local(3),DirectoryName:Local(4),EDIPartyName:Local(5),URI:Context(6),IPAddress:Context(7),OID:Context(8)},EXTPURPOSE={serverAuth:"1.3.6.1.5.5.7.3.1",clientAuth:"1.3.6.1.5.5.7.3.2",codeSigning:"1.3.6.1.5.5.7.3.3",joyentDocker:"1.3.6.1.4.1.38678.1.4.1",joyentCmon:"1.3.6.1.4.1.38678.1.4.2"},EXTPURPOSE_REV={};Object.keys(EXTPURPOSE).forEach(function(e){EXTPURPOSE_REV[EXTPURPOSE[e]]=e});var KEYUSEBITS=["signature","identity","keyEncryption","encryption","keyAgreement","ca","crl"];function readExtension(e,r,t){t.readSequence();var a,s,n=t.offset+t.length,i=t.readOID(),o=e.signatures.x509;switch(o.extras.exts||(o.extras.exts=[]),t.peek()===asn1.Ber.Boolean&&(s=t.readBoolean()),i){case EXTS.basicConstraints:t.readSequence(asn1.Ber.OctetString),t.readSequence();var u=t.offset+t.length,c=!1;t.peek()===asn1.Ber.Boolean&&(c=t.readBoolean()),void 0===e.purposes&&(e.purposes=[]),!0===c&&e.purposes.push("ca");var f={oid:i,critical:s};t.offset<u&&t.peek()===asn1.Ber.Integer&&(f.pathLen=t.readInt()),o.extras.exts.push(f);break;case EXTS.extKeyUsage:t.readSequence(asn1.Ber.OctetString),t.readSequence(),void 0===e.purposes&&(e.purposes=[]);for(var d=t.offset+t.length;t.offset<d;){var l=t.readOID();e.purposes.push(EXTPURPOSE_REV[l]||l)}-1!==e.purposes.indexOf("serverAuth")&&-1===e.purposes.indexOf("clientAuth")?e.subjects.forEach(function(e){"host"!==e.type&&(e.type="host",e.hostname=e.uid||e.email||e.components[0].value)}):-1!==e.purposes.indexOf("clientAuth")&&-1===e.purposes.indexOf("serverAuth")&&e.subjects.forEach(function(e){"user"!==e.type&&(e.type="user",e.uid=e.hostname||e.email||e.components[0].value)}),o.extras.exts.push({oid:i,critical:s});break;case EXTS.keyUsage:t.readSequence(asn1.Ber.OctetString);var S=t.readString(asn1.Ber.BitString,!0);readBitField(S,KEYUSEBITS).forEach(function(r){void 0===e.purposes&&(e.purposes=[]),-1===e.purposes.indexOf(r)&&e.purposes.push(r)}),o.extras.exts.push({oid:i,critical:s,bits:S});break;case EXTS.altName:t.readSequence(asn1.Ber.OctetString),t.readSequence();for(var g=t.offset+t.length;t.offset<g;)switch(t.peek()){case ALTNAME.OtherName:case ALTNAME.EDIPartyName:t.readSequence(),t._offset+=t.length;break;case ALTNAME.OID:t.readOID(ALTNAME.OID);break;case ALTNAME.RFC822Name:var p=t.readString(ALTNAME.RFC822Name);a=Identity.forEmail(p),e.subjects[0].equals(a)||e.subjects.push(a);break;case ALTNAME.DirectoryName:t.readSequence(ALTNAME.DirectoryName),a=Identity.parseAsn1(t),e.subjects[0].equals(a)||e.subjects.push(a);break;case ALTNAME.DNSName:var h=t.readString(ALTNAME.DNSName);a=Identity.forHost(h),e.subjects[0].equals(a)||e.subjects.push(a);break;default:t.readString(t.peek())}o.extras.exts.push({oid:i,critical:s});break;default:o.extras.exts.push({oid:i,critical:s,data:t.readString(asn1.Ber.OctetString,!0)})}t._offset=n}var UTCTIME_RE=/^([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})?Z$/;function utcTimeToDate(e){var r=e.match(UTCTIME_RE);assert.ok(r,"timestamps must be in UTC");var t=new Date,a=t.getUTCFullYear(),s=100*Math.floor(a/100),n=parseInt(r[1],10);return n+=a%100<50&&n>=60?s-1:s,t.setUTCFullYear(n,parseInt(r[2],10)-1,parseInt(r[3],10)),t.setUTCHours(parseInt(r[4],10),parseInt(r[5],10)),r[6]&&r[6].length>0&&t.setUTCSeconds(parseInt(r[6],10)),t}var GTIME_RE=/^([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})?Z$/;function gTimeToDate(e){var r=e.match(GTIME_RE);assert.ok(r);var t=new Date;return t.setUTCFullYear(parseInt(r[1],10),parseInt(r[2],10)-1,parseInt(r[3],10)),t.setUTCHours(parseInt(r[4],10),parseInt(r[5],10)),r[6]&&r[6].length>0&&t.setUTCSeconds(parseInt(r[6],10)),t}function zeroPad(e,r){void 0===r&&(r=2);for(var t=""+e;t.length<r;)t="0"+t;return t}function dateToUTCTime(e){var r="";return r+=zeroPad(e.getUTCFullYear()%100),r+=zeroPad(e.getUTCMonth()+1),r+=zeroPad(e.getUTCDate()),r+=zeroPad(e.getUTCHours()),r+=zeroPad(e.getUTCMinutes()),r+=zeroPad(e.getUTCSeconds()),r+="Z"}function dateToGTime(e){var r="";return r+=zeroPad(e.getUTCFullYear(),4),r+=zeroPad(e.getUTCMonth()+1),r+=zeroPad(e.getUTCDate()),r+=zeroPad(e.getUTCHours()),r+=zeroPad(e.getUTCMinutes()),r+=zeroPad(e.getUTCSeconds()),r+="Z"}function sign(e,r){void 0===e.signatures.x509&&(e.signatures.x509={});var t=e.signatures.x509;if(t.algo=r.type+"-"+r.defaultHashAlgorithm(),void 0===SIGN_ALGS[t.algo])return!1;var a=new asn1.BerWriter;writeTBSCert(e,a);var s=a.buffer;t.cache=s;var n=r.createSign();return n.write(s),e.signatures.x509.signature=n.sign(),!0}function signAsync(e,r,t){void 0===e.signatures.x509&&(e.signatures.x509={});var a=e.signatures.x509,s=new asn1.BerWriter;writeTBSCert(e,s);var n=s.buffer;a.cache=n,r(n,function(e,r){e?t(e):(a.algo=r.type+"-"+r.hashAlgorithm,void 0!==SIGN_ALGS[a.algo]?(a.signature=r,t()):t(new Error('Invalid signing algorithm "'+a.algo+'"')))})}function write(e,r){var t=e.signatures.x509;assert.object(t,"x509 signature");var a=new asn1.BerWriter;a.startSequence(),t.cache?(a._ensure(t.cache.length),t.cache.copy(a._buf,a._offset),a._offset+=t.cache.length):writeTBSCert(e,a),a.startSequence(),a.writeOID(SIGN_ALGS[t.algo]),t.algo.match(/^rsa-/)&&a.writeNull(),a.endSequence();var s=t.signature.toBuffer("asn1"),n=Buffer.alloc(s.length+1);return n[0]=0,s.copy(n,1),a.writeBuffer(n,asn1.Ber.BitString),a.endSequence(),a.buffer}function writeTBSCert(e,r){var t=e.signatures.x509;assert.object(t,"x509 signature"),r.startSequence(),r.startSequence(Local(0)),r.writeInt(2),r.endSequence(),r.writeBuffer(utils.mpNormalize(e.serial),asn1.Ber.Integer),r.startSequence(),r.writeOID(SIGN_ALGS[t.algo]),t.algo.match(/^rsa-/)&&r.writeNull(),r.endSequence(),e.issuer.toAsn1(r),r.startSequence(),writeDate(r,e.validFrom),writeDate(r,e.validUntil),r.endSequence();var a=e.subjects[0],s=e.subjects.slice(1);if(a.toAsn1(r),pkcs8.writePkcs8(r,e.subjectKey),t.extras&&t.extras.issuerUniqueID&&r.writeBuffer(t.extras.issuerUniqueID,Local(1)),t.extras&&t.extras.subjectUniqueID&&r.writeBuffer(t.extras.subjectUniqueID,Local(2)),s.length>0||"host"===a.type||void 0!==e.purposes&&e.purposes.length>0||t.extras&&t.extras.exts){r.startSequence(Local(3)),r.startSequence();var n=[];void 0!==e.purposes&&e.purposes.length>0&&(n.push({oid:EXTS.basicConstraints,critical:!0}),n.push({oid:EXTS.keyUsage,critical:!0}),n.push({oid:EXTS.extKeyUsage,critical:!0})),n.push({oid:EXTS.altName}),t.extras&&t.extras.exts&&(n=t.extras.exts);for(var i=0;i<n.length;++i){if(r.startSequence(),r.writeOID(n[i].oid),void 0!==n[i].critical&&r.writeBoolean(n[i].critical),n[i].oid===EXTS.altName){r.startSequence(asn1.Ber.OctetString),r.startSequence(),"host"===a.type&&r.writeString(a.hostname,Context(2));for(var o=0;o<s.length;++o)"host"===s[o].type?r.writeString(s[o].hostname,ALTNAME.DNSName):"email"===s[o].type?r.writeString(s[o].email,ALTNAME.RFC822Name):(r.startSequence(ALTNAME.DirectoryName),s[o].toAsn1(r),r.endSequence());r.endSequence(),r.endSequence()}else if(n[i].oid===EXTS.basicConstraints){r.startSequence(asn1.Ber.OctetString),r.startSequence();var u=-1!==e.purposes.indexOf("ca"),c=n[i].pathLen;r.writeBoolean(u),void 0!==c&&r.writeInt(c),r.endSequence(),r.endSequence()}else if(n[i].oid===EXTS.extKeyUsage)r.startSequence(asn1.Ber.OctetString),r.startSequence(),e.purposes.forEach(function(e){if("ca"!==e&&-1===KEYUSEBITS.indexOf(e)){var t=e;void 0!==EXTPURPOSE[e]&&(t=EXTPURPOSE[e]),r.writeOID(t)}}),r.endSequence(),r.endSequence();else if(n[i].oid===EXTS.keyUsage){if(r.startSequence(asn1.Ber.OctetString),void 0!==n[i].bits)r.writeBuffer(n[i].bits,asn1.Ber.BitString);else{var f=writeBitField(e.purposes,KEYUSEBITS);r.writeBuffer(f,asn1.Ber.BitString)}r.endSequence()}else r.writeBuffer(n[i].data,asn1.Ber.OctetString);r.endSequence()}r.endSequence(),r.endSequence()}r.endSequence()}function readBitField(e,r){for(var t=8*(e.length-1)-e[0],a={},s=0;s<t;++s){var n=1<<7-s%8,i=0!=(e[1+Math.floor(s/8)]&n),o=r[s];i&&"string"==typeof o&&(a[o]=!0)}return Object.keys(a)}function writeBitField(e,r){var t=r.length,a=Math.ceil(t/8),s=8*a-t,n=Buffer.alloc(1+a);n[0]=s;for(var i=0;i<t;++i){var o=1+Math.floor(i/8),u=1<<7-i%8,c=r[i];if(void 0!==c)-1!==e.indexOf(c)&&(n[o]|=u)}return n}