module.exports=Identity;var assert=require("assert-plus"),algs=require("./algs"),crypto=require("crypto"),Fingerprint=require("./fingerprint"),Signature=require("./signature"),errs=require("./errors"),util=require("util"),utils=require("./utils"),asn1=require("asn1"),Buffer=require("safer-buffer").Buffer,DNS_NAME_RE=/^([*]|[a-z0-9][a-z0-9\-]{0,62})(?:\.([*]|[a-z0-9][a-z0-9\-]{0,62}))*$/i,oids={cn:"2.5.4.3",o:"2.5.4.10",ou:"2.5.4.11",l:"2.5.4.7",s:"2.5.4.8",c:"2.5.4.6",sn:"2.5.4.4",postalCode:"2.5.4.17",serialNumber:"2.5.4.5",street:"2.5.4.9",x500UniqueIdentifier:"2.5.4.45",role:"2.5.4.72",telephoneNumber:"2.5.4.20",description:"2.5.4.13",dc:"0.9.2342.19200300.100.1.25",uid:"0.9.2342.19200300.100.1.1",mail:"0.9.2342.19200300.100.1.3",title:"2.5.4.12",gn:"2.5.4.42",initials:"2.5.4.43",pseudonym:"2.5.4.65",emailAddress:"1.2.840.113549.1.9.1"},unoids={};function Identity(e){var t=this;if(assert.object(e,"options"),assert.arrayOfObject(e.components,"options.components"),this.components=e.components,this.componentLookup={},this.components.forEach(function(e){e.name&&!e.oid&&(e.oid=oids[e.name]),e.oid&&!e.name&&(e.name=unoids[e.oid]),void 0===t.componentLookup[e.name]&&(t.componentLookup[e.name]=[]),t.componentLookup[e.name].push(e)}),this.componentLookup.cn&&this.componentLookup.cn.length>0&&(this.cn=this.componentLookup.cn[0].value),assert.optionalString(e.type,"options.type"),void 0===e.type)1===this.components.length&&this.componentLookup.cn&&1===this.componentLookup.cn.length&&this.componentLookup.cn[0].value.match(DNS_NAME_RE)?(this.type="host",this.hostname=this.componentLookup.cn[0].value):this.componentLookup.dc&&this.components.length===this.componentLookup.dc.length?(this.type="host",this.hostname=this.componentLookup.dc.map(function(e){return e.value}).join(".")):this.componentLookup.uid&&this.components.length===this.componentLookup.uid.length?(this.type="user",this.uid=this.componentLookup.uid[0].value):this.componentLookup.cn&&1===this.componentLookup.cn.length&&this.componentLookup.cn[0].value.match(DNS_NAME_RE)?(this.type="host",this.hostname=this.componentLookup.cn[0].value):this.componentLookup.uid&&1===this.componentLookup.uid.length?(this.type="user",this.uid=this.componentLookup.uid[0].value):this.componentLookup.mail&&1===this.componentLookup.mail.length?(this.type="email",this.email=this.componentLookup.mail[0].value):this.componentLookup.cn&&1===this.componentLookup.cn.length?(this.type="user",this.uid=this.componentLookup.cn[0].value):this.type="unknown";else if(this.type=e.type,"host"===this.type)this.hostname=e.hostname;else if("user"===this.type)this.uid=e.uid;else{if("email"!==this.type)throw new Error("Unknown type "+this.type);this.email=e.email}}Object.keys(oids).forEach(function(e){unoids[oids[e]]=e}),Identity.prototype.toString=function(){return this.components.map(function(e){var t=e.name.toUpperCase();t=t.replace(/=/g,"\\=");var n=e.value;return t+"="+(n=n.replace(/,/g,"\\,"))}).join(", ")},Identity.prototype.get=function(e,t){assert.string(e,"name");var n=this.componentLookup[e];if(void 0!==n&&0!==n.length){if(!t&&n.length>1)throw new Error("Multiple values for attribute "+e);return t?n.map(function(e){return e.value}):n[0].value}},Identity.prototype.toArray=function(e){return this.components.map(function(e){return{name:e.name,value:e.value}})};var NOT_PRINTABLE=/[^a-zA-Z0-9 '(),+.\/:=?-]/,NOT_IA5=/[^\x00-\x7f]/;function globMatch(e,t){if("**"===e||"**"===t)return!0;var n=e.split("."),o=t.split(".");if(n.length!==o.length)return!1;for(var i=0;i<n.length;++i)if("*"!==n[i]&&"*"!==o[i]&&n[i]!==o[i])return!1;return!0}Identity.prototype.toAsn1=function(e,t){e.startSequence(t),this.components.forEach(function(t){if(e.startSequence(asn1.Ber.Constructor|asn1.Ber.Set),e.startSequence(),e.writeOID(t.oid),t.asn1type===asn1.Ber.Utf8String||t.value.match(NOT_IA5)){var n=Buffer.from(t.value,"utf8");e.writeBuffer(n,asn1.Ber.Utf8String)}else if(t.asn1type===asn1.Ber.IA5String||t.value.match(NOT_PRINTABLE))e.writeString(t.value,asn1.Ber.IA5String);else{var o=asn1.Ber.PrintableString;void 0!==t.asn1type&&(o=t.asn1type),e.writeString(t.value,o)}e.endSequence(),e.endSequence()}),e.endSequence()},Identity.prototype.equals=function(e){if(!Identity.isIdentity(e,[1,0]))return!1;if(e.components.length!==this.components.length)return!1;for(var t=0;t<this.components.length;++t){if(this.components[t].oid!==e.components[t].oid)return!1;if(!globMatch(this.components[t].value,e.components[t].value))return!1}return!0},Identity.forHost=function(e){return assert.string(e,"hostname"),new Identity({type:"host",hostname:e,components:[{name:"cn",value:e}]})},Identity.forUser=function(e){return assert.string(e,"uid"),new Identity({type:"user",uid:e,components:[{name:"uid",value:e}]})},Identity.forEmail=function(e){return assert.string(e,"email"),new Identity({type:"email",email:e,components:[{name:"mail",value:e}]})},Identity.parseDN=function(e){assert.string(e,"dn");for(var t=[""],n=0,o=e;o.length>0;){var i;if(null!==(i=/^,/.exec(o)))t[++n]="",o=o.slice(i[0].length);else if(null!==(i=/^\\,/.exec(o)))t[n]+=",",o=o.slice(i[0].length);else if(null!==(i=/^\\./.exec(o)))t[n]+=i[0],o=o.slice(i[0].length);else{if(null===(i=/^[^\\,]+/.exec(o)))throw new Error("Failed to parse DN");t[n]+=i[0],o=o.slice(i[0].length)}}return new Identity({components:t.map(function(e){for(var t=(e=e.trim()).indexOf("=");t>0&&"\\"===e.charAt(t-1);)t=e.indexOf("=",t+1);if(-1===t)throw new Error("Failed to parse DN");return{name:e.slice(0,t).toLowerCase().replace(/\\=/g,"="),value:e.slice(t+1)}})})},Identity.fromArray=function(e){return assert.arrayOfObject(e,"components"),e.forEach(function(e){if(assert.object(e,"component"),assert.string(e.name,"component.name"),!Buffer.isBuffer(e.value)&&"string"!=typeof e.value)throw new Error("Invalid component value")}),new Identity({components:e})},Identity.parseAsn1=function(e,t){var n=[];e.readSequence(t);for(var o=e.offset+e.length;e.offset<o;){e.readSequence(asn1.Ber.Constructor|asn1.Ber.Set);var i=e.offset+e.length;e.readSequence();var r,s=e.readOID(),a=e.peek();switch(a){case asn1.Ber.PrintableString:case asn1.Ber.IA5String:case asn1.Ber.OctetString:case asn1.Ber.T61String:r=e.readString(a);break;case asn1.Ber.Utf8String:r=(r=e.readString(a,!0)).toString("utf8");break;case asn1.Ber.CharacterString:case asn1.Ber.BMPString:r=(r=e.readString(a,!0)).toString("utf16le");break;default:throw new Error("Unknown asn1 type "+a)}n.push({oid:s,asn1type:a,value:r}),e._offset=i}return e._offset=o,new Identity({components:n})},Identity.isIdentity=function(e,t){return utils.isCompatible(e,Identity,t)},Identity.prototype._sshpkApiVersion=[1,0],Identity._oldVersionDetect=function(e){return[1,0]};