module.exports=Key;var edCompat,assert=require("assert-plus"),algs=require("./algs"),crypto=require("crypto"),Fingerprint=require("./fingerprint"),Signature=require("./signature"),DiffieHellman=require("./dhe").DiffieHellman,errs=require("./errors"),utils=require("./utils"),PrivateKey=require("./private-key");try{edCompat=require("./ed-compat")}catch(r){}var InvalidAlgorithmError=errs.InvalidAlgorithmError,KeyParseError=errs.KeyParseError,formats={};function Key(r){assert.object(r,"options"),assert.arrayOfObject(r.parts,"options.parts"),assert.string(r.type,"options.type"),assert.optionalString(r.comment,"options.comment");var t=algs.info[r.type];if("object"!=typeof t)throw new InvalidAlgorithmError(r.type);for(var e,s={},i=0;i<r.parts.length;++i){var a=r.parts[i];s[a.name]=a}if(this.type=r.type,this.parts=r.parts,this.part=s,this.comment=void 0,this.source=r.source,this._rfc4253Cache=r._rfc4253Cache,this._hashCache={},this.curve=void 0,"ecdsa"===this.type){var o=this.part.curve.data.toString();this.curve=o,e=algs.curves[o].size}else if("ed25519"===this.type||"curve25519"===this.type)e=256,this.curve="curve25519";else{var n=this.part[t.sizePart];e=8*(e=n.data.length)-utils.countZeros(n.data)}this.size=e}formats.auto=require("./formats/auto"),formats.pem=require("./formats/pem"),formats.pkcs1=require("./formats/pkcs1"),formats.pkcs8=require("./formats/pkcs8"),formats.rfc4253=require("./formats/rfc4253"),formats.ssh=require("./formats/ssh"),formats["ssh-private"]=require("./formats/ssh-private"),formats.openssh=formats["ssh-private"],formats.dnssec=require("./formats/dnssec"),formats.putty=require("./formats/putty"),formats.ppk=formats.putty,Key.formats=formats,Key.prototype.toBuffer=function(r,t){return void 0===r&&(r="ssh"),assert.string(r,"format"),assert.object(formats[r],"formats[format]"),assert.optionalObject(t,"options"),"rfc4253"===r?(void 0===this._rfc4253Cache&&(this._rfc4253Cache=formats.rfc4253.write(this)),this._rfc4253Cache):formats[r].write(this,t)},Key.prototype.toString=function(r,t){return this.toBuffer(r,t).toString()},Key.prototype.hash=function(r,t){if(assert.string(r,"algorithm"),assert.optionalString(t,"type"),void 0===t&&(t="ssh"),r=r.toLowerCase(),void 0===algs.hashAlgs[r])throw new InvalidAlgorithmError(r);var e,s=r+"||"+t;if(this._hashCache[s])return this._hashCache[s];if("ssh"===t)e=this.toBuffer("rfc4253");else{if("spki"!==t)throw new Error("Hash type "+t+" not supported");e=formats.pkcs8.pkcs8ToBuffer(this)}var i=crypto.createHash(r).update(e).digest();return this._hashCache[s]=i,i},Key.prototype.fingerprint=function(r,t){void 0===r&&(r="sha256"),void 0===t&&(t="ssh"),assert.string(r,"algorithm"),assert.string(t,"type");var e={type:"key",hash:this.hash(r,t),algorithm:r,hashType:t};return new Fingerprint(e)},Key.prototype.defaultHashAlgorithm=function(){var r="sha1";return"rsa"===this.type&&(r="sha256"),"dsa"===this.type&&this.size>1024&&(r="sha256"),"ed25519"===this.type&&(r="sha512"),"ecdsa"===this.type&&(r=this.size<=256?"sha256":this.size<=384?"sha384":"sha512"),r},Key.prototype.createVerify=function(r){if(void 0===r&&(r=this.defaultHashAlgorithm()),assert.string(r,"hash algorithm"),"ed25519"===this.type&&void 0!==edCompat)return new edCompat.Verifier(this,r);if("curve25519"===this.type)throw new Error("Curve25519 keys are not suitable for signing or verification");var t,e,s;try{e=r.toUpperCase(),t=crypto.createVerify(e)}catch(r){s=r}(void 0===t||s instanceof Error&&s.message.match(/Unknown message digest/))&&(e="RSA-",e+=r.toUpperCase(),t=crypto.createVerify(e)),assert.ok(t,"failed to create verifier");var i=t.verify.bind(t),a=this.toBuffer("pkcs8"),o=this.curve,n=this;return t.verify=function(t,e){if(Signature.isSignature(t,[2,0]))return t.type===n.type&&((!t.hashAlgorithm||t.hashAlgorithm===r)&&((!t.curve||"ecdsa"!==n.type||t.curve===o)&&i(a,t.toBuffer("asn1"))));if("string"==typeof t||Buffer.isBuffer(t))return i(a,t,e);throw Signature.isSignature(t,[1,0])?new Error("signature was created by too old a version of sshpk and cannot be verified"):new TypeError("signature must be a string, Buffer, or Signature object")},t},Key.prototype.createDiffieHellman=function(){if("rsa"===this.type)throw new Error("RSA keys do not support Diffie-Hellman");return new DiffieHellman(this)},Key.prototype.createDH=Key.prototype.createDiffieHellman,Key.parse=function(r,t,e){"string"!=typeof r&&assert.buffer(r,"data"),void 0===t&&(t="auto"),assert.string(t,"format"),"string"==typeof e&&(e={filename:e}),assert.optionalObject(e,"options"),void 0===e&&(e={}),assert.optionalString(e.filename,"options.filename"),void 0===e.filename&&(e.filename="(unnamed)"),assert.object(formats[t],"formats[format]");try{var s=formats[t].read(r,e);return s instanceof PrivateKey&&(s=s.toPublic()),s.comment||(s.comment=e.filename),s}catch(r){if("KeyEncryptedError"===r.name)throw r;throw new KeyParseError(e.filename,t,r)}},Key.isKey=function(r,t){return utils.isCompatible(r,Key,t)},Key.prototype._sshpkApiVersion=[1,7],Key._oldVersionDetect=function(r){return assert.func(r.toBuffer),assert.func(r.fingerprint),r.createDH?[1,4]:r.defaultHashAlgorithm?[1,3]:r.formats.auto?[1,2]:r.formats.pkcs1?[1,1]:[1,0]};