module.exports=PrivateKey;var assert=require("assert-plus"),Buffer=require("safer-buffer").Buffer,algs=require("./algs"),crypto=require("crypto"),Fingerprint=require("./fingerprint"),Signature=require("./signature"),errs=require("./errors"),util=require("util"),utils=require("./utils"),dhe=require("./dhe"),generateECDSA=dhe.generateECDSA,generateED25519=dhe.generateED25519,edCompat=require("./ed-compat"),nacl=require("tweetnacl"),Key=require("./key"),InvalidAlgorithmError=errs.InvalidAlgorithmError,KeyParseError=errs.KeyParseError,KeyEncryptedError=errs.KeyEncryptedError,formats={};function PrivateKey(e){assert.object(e,"options"),Key.call(this,e),this._pubCache=void 0}formats.auto=require("./formats/auto"),formats.pem=require("./formats/pem"),formats.pkcs1=require("./formats/pkcs1"),formats.pkcs8=require("./formats/pkcs8"),formats.rfc4253=require("./formats/rfc4253"),formats["ssh-private"]=require("./formats/ssh-private"),formats.openssh=formats["ssh-private"],formats.ssh=formats["ssh-private"],formats.dnssec=require("./formats/dnssec"),util.inherits(PrivateKey,Key),PrivateKey.formats=formats,PrivateKey.prototype.toBuffer=function(e,r){return void 0===e&&(e="pkcs1"),assert.string(e,"format"),assert.object(formats[e],"formats[format]"),assert.optionalObject(r,"options"),formats[e].write(this,r)},PrivateKey.prototype.hash=function(e,r){return this.toPublic().hash(e,r)},PrivateKey.prototype.fingerprint=function(e,r){return this.toPublic().fingerprint(e,r)},PrivateKey.prototype.toPublic=function(){if(this._pubCache)return this._pubCache;for(var e=algs.info[this.type],r=[],t=0;t<e.parts.length;++t){var i=e.parts[t];r.push(this.part[i])}return this._pubCache=new Key({type:this.type,source:this,parts:r}),this.comment&&(this._pubCache.comment=this.comment),this._pubCache},PrivateKey.prototype.derive=function(e){var r,t,i;if(assert.string(e,"type"),"ed25519"===this.type&&"curve25519"===e)return 0===(r=this.part.k.data)[0]&&(r=r.slice(1)),i=nacl.box.keyPair.fromSecretKey(new Uint8Array(r)),t=Buffer.from(i.publicKey),new PrivateKey({type:"curve25519",parts:[{name:"A",data:utils.mpNormalize(t)},{name:"k",data:utils.mpNormalize(r)}]});if("curve25519"===this.type&&"ed25519"===e)return 0===(r=this.part.k.data)[0]&&(r=r.slice(1)),i=nacl.sign.keyPair.fromSeed(new Uint8Array(r)),t=Buffer.from(i.publicKey),new PrivateKey({type:"ed25519",parts:[{name:"A",data:utils.mpNormalize(t)},{name:"k",data:utils.mpNormalize(r)}]});throw new Error("Key derivation not supported from "+this.type+" to "+e)},PrivateKey.prototype.createVerify=function(e){return this.toPublic().createVerify(e)},PrivateKey.prototype.createSign=function(e){if(void 0===e&&(e=this.defaultHashAlgorithm()),assert.string(e,"hash algorithm"),"ed25519"===this.type&&void 0!==edCompat)return new edCompat.Signer(this,e);if("curve25519"===this.type)throw new Error("Curve25519 keys are not suitable for signing or verification");var r,t,i;try{t=e.toUpperCase(),r=crypto.createSign(t)}catch(e){i=e}(void 0===r||i instanceof Error&&i.message.match(/Unknown message digest/))&&(t="RSA-",t+=e.toUpperCase(),r=crypto.createSign(t)),assert.ok(r,"failed to create verifier");var a=r.sign.bind(r),s=this.toBuffer("pkcs1"),o=this.type,n=this.curve;return r.sign=function(){var r=a(s);return"string"==typeof r&&(r=Buffer.from(r,"binary")),(r=Signature.parse(r,o,"asn1")).hashAlgorithm=e,r.curve=n,r},r},PrivateKey.parse=function(e,r,t){"string"!=typeof e&&assert.buffer(e,"data"),void 0===r&&(r="auto"),assert.string(r,"format"),"string"==typeof t&&(t={filename:t}),assert.optionalObject(t,"options"),void 0===t&&(t={}),assert.optionalString(t.filename,"options.filename"),void 0===t.filename&&(t.filename="(unnamed)"),assert.object(formats[r],"formats[format]");try{var i=formats[r].read(e,t);return assert.ok(i instanceof PrivateKey,"key is not a private key"),i.comment||(i.comment=t.filename),i}catch(e){if("KeyEncryptedError"===e.name)throw e;throw new KeyParseError(t.filename,r,e)}},PrivateKey.isPrivateKey=function(e,r){return utils.isCompatible(e,PrivateKey,r)},PrivateKey.generate=function(e,r){switch(void 0===r&&(r={}),assert.object(r,"options"),e){case"ecdsa":return void 0===r.curve&&(r.curve="nistp256"),assert.string(r.curve,"options.curve"),generateECDSA(r.curve);case"ed25519":return generateED25519();default:throw new Error('Key generation not supported with key type "'+e+'"')}},PrivateKey.prototype._sshpkApiVersion=[1,6],PrivateKey._oldVersionDetect=function(e){return assert.func(e.toPublic),assert.func(e.createSign),e.derive?[1,3]:e.defaultHashAlgorithm?[1,2]:e.formats.auto?[1,1]:[1,0]};