module.exports=Signature;var assert=require("assert-plus"),Buffer=require("safer-buffer").Buffer,algs=require("./algs"),crypto=require("crypto"),errs=require("./errors"),utils=require("./utils"),asn1=require("asn1"),SSHBuffer=require("./ssh-buffer"),InvalidAlgorithmError=errs.InvalidAlgorithmError,SignatureParseError=errs.SignatureParseError;function Signature(r){assert.object(r,"options"),assert.arrayOfObject(r.parts,"options.parts"),assert.string(r.type,"options.type");for(var e={},t=0;t<r.parts.length;++t){var a=r.parts[t];e[a.name]=a}this.type=r.type,this.hashAlgorithm=r.hashAlgo,this.curve=r.curve,this.parts=r.parts,this.part=e}function parseOneNum(r,e,t,a){if("ssh"===t){try{var s=new SSHBuffer({buffer:r}),i=s.readString()}catch(r){}if(void 0!==s){var n="SSH signature does not match expected type (expected "+e+", got "+i+")";switch(i){case"ssh-rsa":assert.strictEqual(e,"rsa",n),a.hashAlgo="sha1";break;case"rsa-sha2-256":assert.strictEqual(e,"rsa",n),a.hashAlgo="sha256";break;case"rsa-sha2-512":assert.strictEqual(e,"rsa",n),a.hashAlgo="sha512";break;case"ssh-ed25519":assert.strictEqual(e,"ed25519",n),a.hashAlgo="sha512";break;default:throw new Error("Unknown SSH signature type: "+i)}var u=s.readPart();return assert.ok(s.atEnd(),"extra trailing bytes"),u.name="sig",a.parts.push(u),new Signature(a)}}return a.parts.push({name:"sig",data:r}),new Signature(a)}function parseDSAasn1(r,e,t,a){var s=new asn1.BerReader(r);s.readSequence();var i=s.readString(asn1.Ber.Integer,!0),n=s.readString(asn1.Ber.Integer,!0);return a.parts.push({name:"r",data:utils.mpNormalize(i)}),a.parts.push({name:"s",data:utils.mpNormalize(n)}),new Signature(a)}function parseDSA(r,e,t,a){if(40!=r.length){var s=new SSHBuffer({buffer:r}),i=s.readBuffer();"ssh-dss"===i.toString("ascii")&&(i=s.readBuffer()),assert.ok(s.atEnd(),"extra trailing bytes"),assert.strictEqual(i.length,40,"invalid inner length"),r=i}return a.parts.push({name:"r",data:r.slice(0,20)}),a.parts.push({name:"s",data:r.slice(20,40)}),new Signature(a)}function parseECDSA(r,e,t,a){var s,i,n=new SSHBuffer({buffer:r}),u=n.readBuffer(),h=u.toString("ascii");if("ecdsa-"===h.slice(0,6)){var o=h.split("-");switch(assert.strictEqual(o[0],"ecdsa"),assert.strictEqual(o[1],"sha2"),a.curve=o[2],a.curve){case"nistp256":a.hashAlgo="sha256";break;case"nistp384":a.hashAlgo="sha384";break;case"nistp521":a.hashAlgo="sha512";break;default:throw new Error("Unsupported ECDSA curve: "+a.curve)}u=n.readBuffer(),assert.ok(n.atEnd(),"extra trailing bytes on outer"),s=(n=new SSHBuffer({buffer:u})).readPart()}else s={data:u};return i=n.readPart(),assert.ok(n.atEnd(),"extra trailing bytes"),s.name="r",i.name="s",a.parts.push(s),a.parts.push(i),new Signature(a)}Signature.prototype.toBuffer=function(r){var e;void 0===r&&(r="asn1"),assert.string(r,"format");var t="ssh-"+this.type;switch(this.type){case"rsa":switch(this.hashAlgorithm){case"sha256":t="rsa-sha2-256";break;case"sha512":t="rsa-sha2-512";break;case"sha1":case void 0:break;default:throw new Error("SSH signature format does not support hash algorithm "+this.hashAlgorithm)}return"ssh"===r?((e=new SSHBuffer({})).writeString(t),e.writePart(this.part.sig),e.toBuffer()):this.part.sig.data;case"ed25519":return"ssh"===r?((e=new SSHBuffer({})).writeString(t),e.writePart(this.part.sig),e.toBuffer()):this.part.sig.data;case"dsa":case"ecdsa":var a,s;if("asn1"===r){var i=new asn1.BerWriter;return i.startSequence(),a=utils.mpNormalize(this.part.r.data),s=utils.mpNormalize(this.part.s.data),i.writeBuffer(a,asn1.Ber.Integer),i.writeBuffer(s,asn1.Ber.Integer),i.endSequence(),i.buffer}if("ssh"===r&&"dsa"===this.type){if((e=new SSHBuffer({})).writeString("ssh-dss"),(a=this.part.r.data).length>20&&0===a[0]&&(a=a.slice(1)),(s=this.part.s.data).length>20&&0===s[0]&&(s=s.slice(1)),this.hashAlgorithm&&"sha1"!==this.hashAlgorithm||a.length+s.length!==40)throw new Error("OpenSSH only supports DSA signatures with SHA1 hash");return e.writeBuffer(Buffer.concat([a,s])),e.toBuffer()}if("ssh"===r&&"ecdsa"===this.type){var n,u=new SSHBuffer({});a=this.part.r.data,u.writeBuffer(a),u.writePart(this.part.s),e=new SSHBuffer({}),0===a[0]&&(a=a.slice(1));var h=8*a.length;return 256===h?n="nistp256":384===h?n="nistp384":528===h&&(n="nistp521"),e.writeString("ecdsa-sha2-"+n),e.writeBuffer(u.toBuffer()),e.toBuffer()}throw new Error("Invalid signature format");default:throw new Error("Invalid signature data")}},Signature.prototype.toString=function(r){return assert.optionalString(r,"format"),this.toBuffer(r).toString("base64")},Signature.parse=function(r,e,t){"string"==typeof r&&(r=Buffer.from(r,"base64")),assert.buffer(r,"data"),assert.string(t,"format"),assert.string(e,"type");var a={};a.type=e.toLowerCase(),a.parts=[];try{switch(assert.ok(r.length>0,"signature must not be empty"),a.type){case"rsa":case"ed25519":return parseOneNum(r,e,t,a);case"dsa":case"ecdsa":return"asn1"===t?parseDSAasn1(r,e,t,a):"dsa"===a.type?parseDSA(r,e,t,a):parseECDSA(r,e,t,a);default:throw new InvalidAlgorithmError(e)}}catch(r){if(r instanceof InvalidAlgorithmError)throw r;throw new SignatureParseError(e,t,r)}},Signature.isSignature=function(r,e){return utils.isCompatible(r,Signature,e)},Signature.prototype._sshpkApiVersion=[2,1],Signature._oldVersionDetect=function(r){return assert.func(r.toBuffer),r.hasOwnProperty("hashAlgorithm")?[2,0]:[1,0]};