module.exports=SSHBuffer;var assert=require("assert-plus"),Buffer=require("safer-buffer").Buffer;function SSHBuffer(t){assert.object(t,"options"),void 0!==t.buffer&&assert.buffer(t.buffer,"options.buffer"),this._size=t.buffer?t.buffer.length:1024,this._buffer=t.buffer||Buffer.alloc(this._size),this._offset=0}SSHBuffer.prototype.toBuffer=function(){return this._buffer.slice(0,this._offset)},SSHBuffer.prototype.atEnd=function(){return this._offset>=this._buffer.length},SSHBuffer.prototype.remainder=function(){return this._buffer.slice(this._offset)},SSHBuffer.prototype.skip=function(t){this._offset+=t},SSHBuffer.prototype.expand=function(){this._size*=2;var t=Buffer.alloc(this._size);this._buffer.copy(t,0),this._buffer=t},SSHBuffer.prototype.readPart=function(){return{data:this.readBuffer()}},SSHBuffer.prototype.readBuffer=function(){var t=this._buffer.readUInt32BE(this._offset);this._offset+=4,assert.ok(this._offset+t<=this._buffer.length,"length out of bounds at +0x"+this._offset.toString(16)+" (data truncated?)");var f=this._buffer.slice(this._offset,this._offset+t);return this._offset+=t,f},SSHBuffer.prototype.readString=function(){return this.readBuffer().toString()},SSHBuffer.prototype.readCString=function(){for(var t=this._offset;t<this._buffer.length&&0!==this._buffer[t];)t++;assert.ok(t<this._buffer.length,"c string does not terminate");var f=this._buffer.slice(this._offset,t).toString();return this._offset=t+1,f},SSHBuffer.prototype.readInt=function(){var t=this._buffer.readUInt32BE(this._offset);return this._offset+=4,t},SSHBuffer.prototype.readInt64=function(){assert.ok(this._offset+8<this._buffer.length,"buffer not long enough to read Int64");var t=this._buffer.slice(this._offset,this._offset+8);return this._offset+=8,t},SSHBuffer.prototype.readChar=function(){return this._buffer[this._offset++]},SSHBuffer.prototype.writeBuffer=function(t){for(;this._offset+4+t.length>this._size;)this.expand();this._buffer.writeUInt32BE(t.length,this._offset),this._offset+=4,t.copy(this._buffer,this._offset),this._offset+=t.length},SSHBuffer.prototype.writeString=function(t){this.writeBuffer(Buffer.from(t,"utf8"))},SSHBuffer.prototype.writeCString=function(t){for(;this._offset+1+t.length>this._size;)this.expand();this._buffer.write(t,this._offset),this._offset+=t.length,this._buffer[this._offset++]=0},SSHBuffer.prototype.writeInt=function(t){for(;this._offset+4>this._size;)this.expand();this._buffer.writeUInt32BE(t,this._offset),this._offset+=4},SSHBuffer.prototype.writeInt64=function(t){if(assert.buffer(t,"value"),t.length>8){for(var f=t.slice(0,t.length-8),e=0;e<f.length;++e)assert.strictEqual(f[e],0,"must fit in 64 bits of precision");t=t.slice(t.length-8,t.length)}for(;this._offset+8>this._size;)this.expand();t.copy(this._buffer,this._offset),this._offset+=8},SSHBuffer.prototype.writeChar=function(t){for(;this._offset+1>this._size;)this.expand();this._buffer[this._offset++]=t},SSHBuffer.prototype.writePart=function(t){this.writeBuffer(t.data)},SSHBuffer.prototype.write=function(t){for(;this._offset+t.length>this._size;)this.expand();t.copy(this._buffer,this._offset),this._offset+=t.length};