module.exports={bufferSplit:bufferSplit,addRSAMissing:addRSAMissing,calculateDSAPublic:calculateDSAPublic,calculateED25519Public:calculateED25519Public,calculateX25519Public:calculateX25519Public,mpNormalize:mpNormalize,mpDenormalize:mpDenormalize,ecNormalize:ecNormalize,countZeros:countZeros,assertCompatible:assertCompatible,isCompatible:isCompatible,opensslKeyDeriv:opensslKeyDeriv,opensshCipherInfo:opensshCipherInfo,publicFromPrivateECDSA:publicFromPrivateECDSA,zeroPadToLength:zeroPadToLength,writeBitString:writeBitString,readBitString:readBitString,pbkdf2:pbkdf2};var assert=require("assert-plus"),Buffer=require("safer-buffer").Buffer,PrivateKey=require("./private-key"),Key=require("./key"),crypto=require("crypto"),algs=require("./algs"),asn1=require("asn1"),ec=require("ecc-jsbn/lib/ec"),jsbn=require("jsbn").BigInteger,nacl=require("tweetnacl"),MAX_CLASS_DEPTH=3;function isCompatible(e,r,t){if(null===e||"object"!=typeof e)return!1;if(void 0===t&&(t=r.prototype._sshpkApiVersion),e instanceof r&&r.prototype._sshpkApiVersion[0]==t[0])return!0;for(var a=Object.getPrototypeOf(e),s=0;a.constructor.name!==r.name;)if(!(a=Object.getPrototypeOf(a))||++s>MAX_CLASS_DEPTH)return!1;if(a.constructor.name!==r.name)return!1;var n=a._sshpkApiVersion;return void 0===n&&(n=r._oldVersionDetect(e)),!(n[0]!=t[0]||n[1]<t[1])}function assertCompatible(e,r,t,a){if(void 0===a&&(a="object"),assert.ok(e,a+" must not be null"),assert.object(e,a+" must be an object"),void 0===t&&(t=r.prototype._sshpkApiVersion),!(e instanceof r&&r.prototype._sshpkApiVersion[0]==t[0])){for(var s=Object.getPrototypeOf(e),n=0;s.constructor.name!==r.name;)s=Object.getPrototypeOf(s),assert.ok(s&&++n<=MAX_CLASS_DEPTH,a+" must be a "+r.name+" instance");assert.strictEqual(s.constructor.name,r.name,a+" must be a "+r.name+" instance");var i=s._sshpkApiVersion;void 0===i&&(i=r._oldVersionDetect(e)),assert.ok(i[0]==t[0]&&i[1]>=t[1],a+" must be compatible with "+r.name+" klass version "+t[0]+"."+t[1])}}var CIPHER_LEN={"des-ede3-cbc":{key:24,iv:8},"aes-128-cbc":{key:16,iv:16},"aes-256-cbc":{key:32,iv:16}},PKCS5_SALT_LEN=8;function opensslKeyDeriv(e,r,t,a){assert.buffer(r,"salt"),assert.buffer(t,"passphrase"),assert.number(a,"iteration count");var s,n,i,o=CIPHER_LEN[e];assert.object(o,"supported cipher"),r=r.slice(0,PKCS5_SALT_LEN);for(var c=Buffer.alloc(0);c.length<o.key+o.iv;){i=[],n&&i.push(n),i.push(t),i.push(r),s=Buffer.concat(i);for(var u=0;u<a;++u)s=crypto.createHash("md5").update(s).digest();c=Buffer.concat([c,s]),n=s}return{key:c.slice(0,o.key),iv:c.slice(o.key,o.key+o.iv)}}function pbkdf2(e,r,t,a,s){var n=Buffer.alloc(r.length+4);r.copy(n);for(var i=0,o=[],c=1;i<a;){var u=f(c++);i+=u.length,o.push(u)}return Buffer.concat(o).slice(0,a);function f(r){n.writeUInt32BE(r,n.length-4);var a=crypto.createHmac(e,s);a.update(n);for(var i=a.digest(),o=i,c=1;c++<t;){(a=crypto.createHmac(e,s)).update(o),o=a.digest();for(var u=0;u<i.length;++u)i[u]^=o[u]}return i}}function countZeros(e){for(var r=0,t=8;r<e.length;){var a=1<<t;if((e[r]&a)===a)break;--t<0&&(r++,t=8)}return 8*r+(8-t)-1}function bufferSplit(e,r){assert.buffer(e),assert.string(r);for(var t=[],a=0,s=0,n=0;n<e.length;++n)if(e[n]===r.charCodeAt(s)?++s:s=e[n]===r.charCodeAt(0)?1:0,s>=r.length){var i=n+1;t.push(e.slice(a,i-s)),a=i,s=0}return a<=e.length&&t.push(e.slice(a,e.length)),t}function ecNormalize(e,r){if(assert.buffer(e),0===e[0]&&4===e[1])return r?e:e.slice(1);if(4===e[0]){if(!r)return e}else{for(;0===e[0];)e=e.slice(1);if(2===e[0]||3===e[0])throw new Error("Compressed elliptic curve points are not supported");if(4!==e[0])throw new Error("Not a valid elliptic curve point");if(!r)return e}var t=Buffer.alloc(e.length+1);return t[0]=0,e.copy(t,1),t}function readBitString(e,r){void 0===r&&(r=asn1.Ber.BitString);var t=e.readString(r,!0);return assert.strictEqual(t[0],0,"bit strings with unused bits are not supported (0x"+t[0].toString(16)+")"),t.slice(1)}function writeBitString(e,r,t){void 0===t&&(t=asn1.Ber.BitString);var a=Buffer.alloc(r.length+1);a[0]=0,r.copy(a,1),e.writeBuffer(a,t)}function mpNormalize(e){for(assert.buffer(e);e.length>1&&0===e[0]&&0==(128&e[1]);)e=e.slice(1);if(128==(128&e[0])){var r=Buffer.alloc(e.length+1);r[0]=0,e.copy(r,1),e=r}return e}function mpDenormalize(e){for(assert.buffer(e);e.length>1&&0===e[0];)e=e.slice(1);return e}function zeroPadToLength(e,r){for(assert.buffer(e),assert.number(r);e.length>r;)assert.equal(e[0],0),e=e.slice(1);for(;e.length<r;){var t=Buffer.alloc(e.length+1);t[0]=0,e.copy(t,1),e=t}return e}function bigintToMpBuf(e){var r=Buffer.from(e.toByteArray());return r=mpNormalize(r)}function calculateDSAPublic(e,r,t){return assert.buffer(e),assert.buffer(r),assert.buffer(t),e=new jsbn(e),r=new jsbn(r),t=new jsbn(t),bigintToMpBuf(e.modPow(t,r))}function calculateED25519Public(e){assert.buffer(e);var r=nacl.sign.keyPair.fromSeed(new Uint8Array(e));return Buffer.from(r.publicKey)}function calculateX25519Public(e){assert.buffer(e);var r=nacl.box.keyPair.fromSeed(new Uint8Array(e));return Buffer.from(r.publicKey)}function addRSAMissing(e){assert.object(e),assertCompatible(e,PrivateKey,[1,1]);var r,t=new jsbn(e.part.d.data);if(!e.part.dmodp){var a=new jsbn(e.part.p.data);r=bigintToMpBuf(t.mod(a.subtract(1))),e.part.dmodp={name:"dmodp",data:r},e.parts.push(e.part.dmodp)}if(!e.part.dmodq){var s=new jsbn(e.part.q.data);r=bigintToMpBuf(t.mod(s.subtract(1))),e.part.dmodq={name:"dmodq",data:r},e.parts.push(e.part.dmodq)}}function publicFromPrivateECDSA(e,r){assert.string(e,"curveName"),assert.buffer(r);var t=algs.curves[e],a=new jsbn(t.p),s=new jsbn(t.a),n=new jsbn(t.b),i=new ec.ECCurveFp(a,s,n),o=i.decodePointHex(t.G.toString("hex")),c=new jsbn(mpNormalize(r)),u=o.multiply(c);u=Buffer.from(i.encodePointHex(u),"hex");var f=[];return f.push({name:"curve",data:Buffer.from(e)}),f.push({name:"Q",data:u}),new Key({type:"ecdsa",curve:i,parts:f})}function opensshCipherInfo(e){var r={};switch(e){case"3des-cbc":r.keySize=24,r.blockSize=8,r.opensslName="des-ede3-cbc";break;case"blowfish-cbc":r.keySize=16,r.blockSize=8,r.opensslName="bf-cbc";break;case"aes128-cbc":case"aes128-ctr":case"aes128-gcm@openssh.com":r.keySize=16,r.blockSize=16,r.opensslName="aes-128-"+e.slice(7,10);break;case"aes192-cbc":case"aes192-ctr":case"aes192-gcm@openssh.com":r.keySize=24,r.blockSize=16,r.opensslName="aes-192-"+e.slice(7,10);break;case"aes256-cbc":case"aes256-ctr":case"aes256-gcm@openssh.com":r.keySize=32,r.blockSize=16,r.opensslName="aes-256-"+e.slice(7,10);break;default:throw new Error('Unsupported openssl cipher "'+e+'"')}return r}