"use strict";var punycode,net=require("net"),urlParse=require("url").parse,util=require("util"),pubsuffix=require("./pubsuffix-psl"),Store=require("./store").Store,MemoryCookieStore=require("./memstore").MemoryCookieStore,pathMatch=require("./pathMatch").pathMatch,VERSION=require("./version");try{punycode=require("punycode")}catch(e){console.warn("tough-cookie: can't load punycode; won't use punycode for domain normalization")}var COOKIE_OCTETS=/^[\x21\x23-\x2B\x2D-\x3A\x3C-\x5B\x5D-\x7E]+$/,CONTROL_CHARS=/[\x00-\x1F]/,TERMINATORS=["\n","\r","\0"],PATH_VALUE=/[\x20-\x3A\x3C-\x7E]+/,DATE_DELIM=/[\x09\x20-\x2F\x3B-\x40\x5B-\x60\x7B-\x7E]/,MONTH_TO_NUM={jan:0,feb:1,mar:2,apr:3,may:4,jun:5,jul:6,aug:7,sep:8,oct:9,nov:10,dec:11},NUM_TO_MONTH=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],NUM_TO_DAY=["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],MAX_TIME=2147483647e3,MIN_TIME=0;function parseDigits(e,t,o,r){for(var i=0;i<e.length;){var n=e.charCodeAt(i);if(n<=47||n>=58)break;i++}return i<t||i>o?null:r||i==e.length?parseInt(e.substr(0,i),10):null}function parseTime(e){var t=e.split(":"),o=[0,0,0];if(3!==t.length)return null;for(var r=0;r<3;r++){var i=2==r,n=parseDigits(t[r],1,2,i);if(null===n)return null;o[r]=n}return o}function parseMonth(e){e=String(e).substr(0,3).toLowerCase();var t=MONTH_TO_NUM[e];return t>=0?t:null}function parseDate(e){if(e){var t=e.split(DATE_DELIM);if(t){for(var o=null,r=null,i=null,n=null,s=null,a=null,u=0;u<t.length;u++){var l,p=t[u].trim();if(p.length)null===i&&(l=parseTime(p))?(o=l[0],r=l[1],i=l[2]):null!==n||null===(l=parseDigits(p,1,2,!0))?null!==s||null===(l=parseMonth(p))?null===a&&null!==(l=parseDigits(p,2,4,!0))&&((a=l)>=70&&a<=99?a+=1900:a>=0&&a<=69&&(a+=2e3)):s=l:n=l}if(!(null===n||null===s||null===a||null===i||n<1||n>31||a<1601||o>23||r>59||i>59))return new Date(Date.UTC(a,s,n,o,r,i))}}}function formatDate(e){var t=e.getUTCDate();t=t>=10?t:"0"+t;var o=e.getUTCHours();o=o>=10?o:"0"+o;var r=e.getUTCMinutes();r=r>=10?r:"0"+r;var i=e.getUTCSeconds();return i=i>=10?i:"0"+i,NUM_TO_DAY[e.getUTCDay()]+", "+t+" "+NUM_TO_MONTH[e.getUTCMonth()]+" "+e.getUTCFullYear()+" "+o+":"+r+":"+i+" GMT"}function canonicalDomain(e){return null==e?null:(e=e.trim().replace(/^\./,""),punycode&&/[^\u0001-\u007f]/.test(e)&&(e=punycode.toASCII(e)),e.toLowerCase())}function domainMatch(e,t,o){if(null==e||null==t)return null;if(!1!==o&&(e=canonicalDomain(e),t=canonicalDomain(t)),e==t)return!0;if(net.isIP(e))return!1;var r=e.indexOf(t);return!(r<=0)&&(e.length===t.length+r&&"."===e.substr(r-1,1))}function defaultPath(e){if(!e||"/"!==e.substr(0,1))return"/";if("/"===e)return e;var t=e.lastIndexOf("/");return 0===t?"/":e.slice(0,t)}function trimTerminator(e){for(var t=0;t<TERMINATORS.length;t++){var o=e.indexOf(TERMINATORS[t]);-1!==o&&(e=e.substr(0,o))}return e}function parseCookiePair(e,t){var o,r,i=(e=trimTerminator(e)).indexOf("=");if(t)0===i&&(i=(e=e.substr(1)).indexOf("="));else if(i<=0)return;if(i<=0?(o="",r=e.trim()):(o=e.substr(0,i).trim(),r=e.substr(i+1).trim()),!CONTROL_CHARS.test(o)&&!CONTROL_CHARS.test(r)){var n=new Cookie;return n.key=o,n.value=r,n}}function parse(e,t){t&&"object"==typeof t||(t={});var o=(e=e.trim()).indexOf(";"),r=parseCookiePair(-1===o?e:e.substr(0,o),!!t.loose);if(r){if(-1===o)return r;var i=e.slice(o+1).trim();if(0===i.length)return r;for(var n=i.split(";");n.length;){var s=n.shift().trim();if(0!==s.length){var a,u,l=s.indexOf("=");switch(-1===l?(a=s,u=null):(a=s.substr(0,l),u=s.substr(l+1)),a=a.trim().toLowerCase(),u&&(u=u.trim()),a){case"expires":if(u){var p=parseDate(u);p&&(r.expires=p)}break;case"max-age":if(u&&/^-?[0-9]+$/.test(u)){var c=parseInt(u,10);r.setMaxAge(c)}break;case"domain":if(u){var f=u.trim().replace(/^\./,"");f&&(r.domain=f.toLowerCase())}break;case"path":r.path=u&&"/"===u[0]?u:null;break;case"secure":r.secure=!0;break;case"httponly":r.httpOnly=!0;break;default:r.extensions=r.extensions||[],r.extensions.push(s)}}}return r}}function jsonParse(e){var t;try{t=JSON.parse(e)}catch(e){return e}return t}function fromJSON(e){if(!e)return null;var t;if("string"==typeof e){if((t=jsonParse(e))instanceof Error)return null}else t=e;for(var o=new Cookie,r=0;r<Cookie.serializableProperties.length;r++){var i=Cookie.serializableProperties[r];void 0!==t[i]&&t[i]!==Cookie.prototype[i]&&("expires"===i||"creation"===i||"lastAccessed"===i?null===t[i]?o[i]=null:o[i]="Infinity"==t[i]?"Infinity":new Date(t[i]):o[i]=t[i])}return o}function cookieCompare(e,t){var o=0,r=e.path?e.path.length:0;return 0!==(o=(t.path?t.path.length:0)-r)?o:0!==(o=(e.creation?e.creation.getTime():MAX_TIME)-(t.creation?t.creation.getTime():MAX_TIME))?o:o=e.creationIndex-t.creationIndex}function permutePath(e){if("/"===e)return["/"];e.lastIndexOf("/")===e.length-1&&(e=e.substr(0,e.length-1));for(var t=[e];e.length>1;){var o=e.lastIndexOf("/");if(0===o)break;e=e.substr(0,o),t.push(e)}return t.push("/"),t}function getCookieContext(e){if(e instanceof Object)return e;try{e=decodeURI(e)}catch(e){}return urlParse(e)}function Cookie(e){e=e||{},Object.keys(e).forEach(function(t){Cookie.prototype.hasOwnProperty(t)&&Cookie.prototype[t]!==e[t]&&"_"!==t.substr(0,1)&&(this[t]=e[t])},this),this.creation=this.creation||new Date,Object.defineProperty(this,"creationIndex",{configurable:!1,enumerable:!1,writable:!0,value:++Cookie.cookiesCreated})}function CookieJar(e,t){"boolean"==typeof t?t={rejectPublicSuffixes:t}:null==t&&(t={}),null!=t.rejectPublicSuffixes&&(this.rejectPublicSuffixes=t.rejectPublicSuffixes),null!=t.looseMode&&(this.enableLooseMode=t.looseMode),e||(e=new MemoryCookieStore),this.store=e}Cookie.cookiesCreated=0,Cookie.parse=parse,Cookie.fromJSON=fromJSON,Cookie.prototype.key="",Cookie.prototype.value="",Cookie.prototype.expires="Infinity",Cookie.prototype.maxAge=null,Cookie.prototype.domain=null,Cookie.prototype.path=null,Cookie.prototype.secure=!1,Cookie.prototype.httpOnly=!1,Cookie.prototype.extensions=null,Cookie.prototype.hostOnly=null,Cookie.prototype.pathIsDefault=null,Cookie.prototype.creation=null,Cookie.prototype.lastAccessed=null,Object.defineProperty(Cookie.prototype,"creationIndex",{configurable:!0,enumerable:!1,writable:!0,value:0}),Cookie.serializableProperties=Object.keys(Cookie.prototype).filter(function(e){return!(Cookie.prototype[e]instanceof Function||"creationIndex"===e||"_"===e.substr(0,1))}),Cookie.prototype.inspect=function(){var e=Date.now();return'Cookie="'+this.toString()+"; hostOnly="+(null!=this.hostOnly?this.hostOnly:"?")+"; aAge="+(this.lastAccessed?e-this.lastAccessed.getTime()+"ms":"?")+"; cAge="+(this.creation?e-this.creation.getTime()+"ms":"?")+'"'},util.inspect.custom&&(Cookie.prototype[util.inspect.custom]=Cookie.prototype.inspect),Cookie.prototype.toJSON=function(){for(var e={},t=Cookie.serializableProperties,o=0;o<t.length;o++){var r=t[o];this[r]!==Cookie.prototype[r]&&("expires"===r||"creation"===r||"lastAccessed"===r?null===this[r]?e[r]=null:e[r]="Infinity"==this[r]?"Infinity":this[r].toISOString():"maxAge"===r?null!==this[r]&&(e[r]=this[r]==1/0||this[r]==-1/0?this[r].toString():this[r]):this[r]!==Cookie.prototype[r]&&(e[r]=this[r]))}return e},Cookie.prototype.clone=function(){return fromJSON(this.toJSON())},Cookie.prototype.validate=function(){if(!COOKIE_OCTETS.test(this.value))return!1;if(!(this.expires==1/0||this.expires instanceof Date||parseDate(this.expires)))return!1;if(null!=this.maxAge&&this.maxAge<=0)return!1;if(null!=this.path&&!PATH_VALUE.test(this.path))return!1;var e=this.cdomain();if(e){if(e.match(/\.$/))return!1;if(null==pubsuffix.getPublicSuffix(e))return!1}return!0},Cookie.prototype.setExpires=function(e){e instanceof Date?this.expires=e:this.expires=parseDate(e)||"Infinity"},Cookie.prototype.setMaxAge=function(e){this.maxAge=e===1/0||e===-1/0?e.toString():e},Cookie.prototype.cookieString=function(){var e=this.value;return null==e&&(e=""),""===this.key?e:this.key+"="+e},Cookie.prototype.toString=function(){var e=this.cookieString();return this.expires!=1/0&&(this.expires instanceof Date?e+="; Expires="+formatDate(this.expires):e+="; Expires="+this.expires),null!=this.maxAge&&this.maxAge!=1/0&&(e+="; Max-Age="+this.maxAge),this.domain&&!this.hostOnly&&(e+="; Domain="+this.domain),this.path&&(e+="; Path="+this.path),this.secure&&(e+="; Secure"),this.httpOnly&&(e+="; HttpOnly"),this.extensions&&this.extensions.forEach(function(t){e+="; "+t}),e},Cookie.prototype.TTL=function(e){if(null!=this.maxAge)return this.maxAge<=0?0:1e3*this.maxAge;var t=this.expires;return t!=1/0?(t instanceof Date||(t=parseDate(t)||1/0),t==1/0?1/0:t.getTime()-(e||Date.now())):1/0},Cookie.prototype.expiryTime=function(e){if(null!=this.maxAge){var t=e||this.creation||new Date,o=this.maxAge<=0?-1/0:1e3*this.maxAge;return t.getTime()+o}return this.expires==1/0?1/0:this.expires.getTime()},Cookie.prototype.expiryDate=function(e){var t=this.expiryTime(e);return t==1/0?new Date(MAX_TIME):t==-1/0?new Date(MIN_TIME):new Date(t)},Cookie.prototype.isPersistent=function(){return null!=this.maxAge||this.expires!=1/0},Cookie.prototype.cdomain=Cookie.prototype.canonicalizedDomain=function(){return null==this.domain?null:canonicalDomain(this.domain)},CookieJar.prototype.store=null,CookieJar.prototype.rejectPublicSuffixes=!0,CookieJar.prototype.enableLooseMode=!1;var CAN_BE_SYNC=[];function syncWrap(e){return function(){if(!this.store.synchronous)throw new Error("CookieJar store is not synchronous; use async API instead.");var t,o,r=Array.prototype.slice.call(arguments);if(r.push(function(e,r){t=e,o=r}),this[e].apply(this,r),t)throw t;return o}}CAN_BE_SYNC.push("setCookie"),CookieJar.prototype.setCookie=function(e,t,o,r){var i,n=getCookieContext(t);o instanceof Function&&(r=o,o={});var s=canonicalDomain(n.hostname),a=this.enableLooseMode;if(null!=o.loose&&(a=o.loose),e instanceof Cookie||(e=Cookie.parse(e,{loose:a})),!e)return i=new Error("Cookie failed to parse"),r(o.ignoreError?null:i);var u=o.now||new Date;if(this.rejectPublicSuffixes&&e.domain&&null==pubsuffix.getPublicSuffix(e.cdomain()))return i=new Error("Cookie has domain set to a public suffix"),r(o.ignoreError?null:i);if(e.domain){if(!domainMatch(s,e.cdomain(),!1))return i=new Error("Cookie not in this host's domain. Cookie:"+e.cdomain()+" Request:"+s),r(o.ignoreError?null:i);null==e.hostOnly&&(e.hostOnly=!1)}else e.hostOnly=!0,e.domain=s;if(e.path&&"/"===e.path[0]||(e.path=defaultPath(n.pathname),e.pathIsDefault=!0),!1===o.http&&e.httpOnly)return i=new Error("Cookie is HttpOnly and this isn't an HTTP API"),r(o.ignoreError?null:i);var l=this.store;l.updateCookie||(l.updateCookie=function(e,t,o){this.putCookie(t,o)}),l.findCookie(e.domain,e.path,e.key,function(t,i){if(t)return r(t);var n=function(t){if(t)return r(t);r(null,e)};if(i){if(!1===o.http&&i.httpOnly)return t=new Error("old Cookie is HttpOnly and this isn't an HTTP API"),r(o.ignoreError?null:t);e.creation=i.creation,e.creationIndex=i.creationIndex,e.lastAccessed=u,l.updateCookie(i,e,n)}else e.creation=e.lastAccessed=u,l.putCookie(e,n)})},CAN_BE_SYNC.push("getCookies"),CookieJar.prototype.getCookies=function(e,t,o){var r=getCookieContext(e);t instanceof Function&&(o=t,t={});var i=canonicalDomain(r.hostname),n=r.pathname||"/",s=t.secure;null!=s||!r.protocol||"https:"!=r.protocol&&"wss:"!=r.protocol||(s=!0);var a=t.http;null==a&&(a=!0);var u=t.now||Date.now(),l=!1!==t.expire,p=!!t.allPaths,c=this.store;function f(e){if(e.hostOnly){if(e.domain!=i)return!1}else if(!domainMatch(i,e.domain,!1))return!1;return!(!p&&!pathMatch(n,e.path))&&(!(e.secure&&!s)&&(!(e.httpOnly&&!a)&&(!(l&&e.expiryTime()<=u)||(c.removeCookie(e.domain,e.path,e.key,function(){}),!1))))}c.findCookies(i,p?null:n,function(e,r){if(e)return o(e);r=r.filter(f),!1!==t.sort&&(r=r.sort(cookieCompare));var i=new Date;r.forEach(function(e){e.lastAccessed=i}),o(null,r)})},CAN_BE_SYNC.push("getCookieString"),CookieJar.prototype.getCookieString=function(){var e=Array.prototype.slice.call(arguments,0),t=e.pop();e.push(function(e,o){e?t(e):t(null,o.sort(cookieCompare).map(function(e){return e.cookieString()}).join("; "))}),this.getCookies.apply(this,e)},CAN_BE_SYNC.push("getSetCookieStrings"),CookieJar.prototype.getSetCookieStrings=function(){var e=Array.prototype.slice.call(arguments,0),t=e.pop();e.push(function(e,o){e?t(e):t(null,o.map(function(e){return e.toString()}))}),this.getCookies.apply(this,e)},CAN_BE_SYNC.push("serialize"),CookieJar.prototype.serialize=function(e){var t=this.store.constructor.name;"Object"===t&&(t=null);var o={version:"tough-cookie@"+VERSION,storeType:t,rejectPublicSuffixes:!!this.rejectPublicSuffixes,cookies:[]};if(!this.store.getAllCookies||"function"!=typeof this.store.getAllCookies)return e(new Error("store does not support getAllCookies and cannot be serialized"));this.store.getAllCookies(function(t,r){return t?e(t):(o.cookies=r.map(function(e){return delete(e=e instanceof Cookie?e.toJSON():e).creationIndex,e}),e(null,o))})},CookieJar.prototype.toJSON=function(){return this.serializeSync()},CAN_BE_SYNC.push("_importCookies"),CookieJar.prototype._importCookies=function(e,t){var o=this,r=e.cookies;if(!r||!Array.isArray(r))return t(new Error("serialized jar has no cookies array"));r=r.slice(),function e(i){if(i)return t(i);if(!r.length)return t(i,o);var n;try{n=fromJSON(r.shift())}catch(e){return t(e)}if(null===n)return e(null);o.store.putCookie(n,e)}()},CookieJar.deserialize=function(e,t,o){var r;if(3!==arguments.length&&(o=t,t=null),"string"==typeof e){if((r=jsonParse(e))instanceof Error)return o(r)}else r=e;var i=new CookieJar(t,r.rejectPublicSuffixes);i._importCookies(r,function(e){if(e)return o(e);o(null,i)})},CookieJar.deserializeSync=function(e,t){var o="string"==typeof e?JSON.parse(e):e,r=new CookieJar(t,o.rejectPublicSuffixes);if(!r.store.synchronous)throw new Error("CookieJar store is not synchronous; use async API instead.");return r._importCookiesSync(o),r},CookieJar.fromJSON=CookieJar.deserializeSync,CookieJar.prototype.clone=function(e,t){1===arguments.length&&(t=e,e=null),this.serialize(function(o,r){if(o)return t(o);CookieJar.deserialize(r,e,t)})},CAN_BE_SYNC.push("removeAllCookies"),CookieJar.prototype.removeAllCookies=function(e){var t=this.store;if(t.removeAllCookies instanceof Function&&t.removeAllCookies!==Store.prototype.removeAllCookies)return t.removeAllCookies(e);t.getAllCookies(function(o,r){if(o)return e(o);if(0===r.length)return e(null);var i=0,n=[];function s(t){if(t&&n.push(t),++i===r.length)return e(n.length?n[0]:null)}r.forEach(function(e){t.removeCookie(e.domain,e.path,e.key,s)})})},CookieJar.prototype._cloneSync=syncWrap("clone"),CookieJar.prototype.cloneSync=function(e){if(!e.synchronous)throw new Error("CookieJar clone destination store is not synchronous; use async API instead.");return this._cloneSync(e)},CAN_BE_SYNC.forEach(function(e){CookieJar.prototype[e+"Sync"]=syncWrap(e)}),exports.version=VERSION,exports.CookieJar=CookieJar,exports.Cookie=Cookie,exports.Store=Store,exports.MemoryCookieStore=MemoryCookieStore,exports.parseDate=parseDate,exports.formatDate=formatDate,exports.parse=parse,exports.fromJSON=fromJSON,exports.domainMatch=domainMatch,exports.defaultPath=defaultPath,exports.pathMatch=pathMatch,exports.getPublicSuffix=pubsuffix.getPublicSuffix,exports.cookieCompare=cookieCompare,exports.permuteDomain=require("./permuteDomain").permuteDomain,exports.permutePath=permutePath,exports.canonicalDomain=canonicalDomain;