import sys, os, random, math
from midi.MidiOutStream import MidiOutStream
from midi.MidiInFile import MidiInFile

NOTE_CHARS = {  0 :"C",
                1 :"C#",
                2 :"D",
                3 :"D#",
                4 :"E",
                5 :"F",
                6 :"F#",
                7 :"G",
                8 :"G#",
                9 :"A",
                10:"A#",
                11:"B"}

NOTE_VALUES = { "C" :0,
                "C#":1,
                "D" :2,
                "D#":3,
                "E" :4,
                "F" :5,
                "F#":6,
                "G" :7,
                "G#":8,
                "A" :9,
                "A#":10,
                "B" :11}

class midiNote:
    def __init__(self, note, time):
        self.note = note
        self.time = time
    def getChar(self):
        return str(self.note%12)


class dataBuilder(MidiOutStream):
    def __init__(self):
        self.channels = [[],[],[],[],[],[],[],[],[],[]]
        self.sequences = []

    def note_on(self, channel=0, note=0x40, velocity=0x40):
        if channel < 10:
            self.channels[channel].append(midiNote(note, self.abs_time()))

    def readAllMidiFiles(self, dataDir, seqLength):
        filenames = os.listdir(dataDir)
        for filename in filenames:
            print "reading " + filename + "..."
            l = len(self.sequences)
            self.channels = [[],[],[],[],[],[],[],[],[],[]]
            f = MidiInFile(self, dataDir + "/" + filename)
            f.read()
            self.buildData(seqLength)
            print "Sequences found: " + str(len(self.sequences) - l) + "\n"
        print "Total sequences found: " + str(len(self.sequences)) + "\n"

        print "shuffling data..."
        random.shuffle(self.sequences)


    def buildData(self, seqLength):
        self.channels = [x for x in self.channels if len(x) >= seqLength]
        lastTimes = [0]*len(self.channels)
        seqs = [x[:seqLength-1] for x in self.channels]
        self.channels = [x[seqLength-1:] for x in self.channels]

        while self.channels:
            minTime = 100000000
            minChannelIndex = 0
            for i in xrange(len(self.channels)):
                if self.channels[i][0].time < minTime:
                    minTime = self.channels[i][0].time
                    minChannelIndex = i

            minChannel = self.channels[minChannelIndex]
            lastTimes[minChannelIndex] = minChannel[0].time
            seqs[minChannelIndex].append(minChannel[0])
            if len(seqs[minChannelIndex])>seqLength:
                del seqs[minChannelIndex][0]

            for i in xrange(len(seqs)):
                if i != minChannelIndex and len(seqs[i]) == seqLength:
                    matching = True
                    for j in xrange(seqLength):
                        if seqs[minChannelIndex][j].time != seqs[i][j].time:
                            matching = False
                            break
                    if matching:
                        #print "channel " + str(minChannelIndex) + " matches channel " + str(i)
                        self.sequences.append(([x.getChar() for x in seqs[i]], [y.getChar() for y in seqs[minChannelIndex]]))

            del minChannel[0]
            if not minChannel:
                del self.channels[minChannelIndex]
                del lastTimes[minChannelIndex]
                del seqs[minChannelIndex]


    def writeToFile(self, filename):
        print "writing data to " + filename + "..."
        file = open(filename, 'w')
        for sequence in self.sequences:
            for entry in sequence[0][:-1]:
                file.write((2-len(entry))*" "+str(entry) + ", ")
            file.write((2-len(sequence[0][-1]))*" "+str(sequence[0][-1])+ " : ")
            for entry in sequence[1][:-1]:
                file.write((2-len(entry))*" "+ entry + ", ")
            file.write((2-len(sequence[0][-1]))*" "+sequence[1][-1]+ "\n")
        print "Done!"

def readFile(filename, userSeqlength, compSeqlength, percentage):
    f = open(filename, "r")
    dataPoints = []
    lines = f.readlines()
    for line in lines[:int(math.floor(len(lines)*percentage))]:
        seqs = line.split(":")
        seq1 = [int(x.strip(" \n")) for x in seqs[0].split(",")]
        seq2 = [int(x.strip(" \n")) for x in seqs[1].split(",")]
        lastNote = seq2.pop(-1)

        while len(seq1) > userSeqlength:
            del seq1[0]
        while len(seq2) > compSeqlength:
            del seq2[0]

        dataPoints.append((seq1, seq2, lastNote))
    return dataPoints

def main():
    if len(sys.argv) != 4:
        print "Usage: python databuilder.py dataDirectory outputFile sequenceLength"
        sys.exit()

    dataDir = sys.argv[1]
    filename = sys.argv[2]
    seqlength = int(sys.argv[3])
    dbuilder = dataBuilder()
    dbuilder.readAllMidiFiles(dataDir, seqlength)
    dbuilder.writeToFile(filename)


if __name__ == "__main__":
    main()
