import pygame, sys, databuilder, cPickle
from kmeans import Kmeans, Centroid


keyMap = {pygame.K_z:"C",
            pygame.K_s:"C#",
            pygame.K_x:"D",
            pygame.K_d:"D#",
            pygame.K_c:"E",
            pygame.K_v:"F",
            pygame.K_g:"F#",
            pygame.K_b:"G",
            pygame.K_h:"G#",
            pygame.K_n:"A",
            pygame.K_j:"A#",
            pygame.K_m:"B",
            pygame.K_COMMA:"C",
            pygame.K_l:"C#",
            pygame.K_PERIOD:"D",
            pygame.K_SEMICOLON:"D#",
            pygame.K_SLASH:"E"}

whiteNotes = {  "C":0,
                "D":45,
                "E":90,
                "F":135,
                "G":180,
                "A":225,
                "B":270}

blackNotes = {  "C#":34,
                "D#":79,
                "F#":169,
                "G#":214,
                "A#":259}

class keyComp:
    def __init__(self, filename, autoTranspose):
        file = open(filename, 'r')
        self.comp = cPickle.load(file)
        self.userSeqlength = self.comp.userSeqlength
        self.compSeqlength = self.comp.compSeqlength
        self.autoTranspose = autoTranspose

        print "\n Starting KeyComp!"
        pygame.mixer.pre_init(frequency=22050, size=-16, channels=8, buffer=512)
        self.keyStack = []
        self.userNoteSequence = []
        self.compNoteSequence = []
        pygame.init()
        pygame.display.set_caption("KeyComp!")
        self.surface = pygame.display.set_mode((630,320))
        pygame.mixer.quit()
        pygame.mixer.init(22050, -8, 2)
        pygame.mixer.set_num_channels(2)
        self.userChannel = pygame.mixer.Channel(0)
        self.compChannel = pygame.mixer.Channel(1)
        self.background = pygame.image.load_basic("keyboard.bmp")
        self.blackKey = pygame.image.load_basic("blackkey.bmp")
        self.whiteKeyPressed = pygame.image.load_basic("whitekeypressed.bmp")
        self.blackKeyPressed = pygame.image.load_basic("blackkeypressed.bmp")
        self.draw(None,None, [], [], 0)

    def playUserNote(self, note):
        print "user: "+note +", ",
        self.playNote(note, "_a", self.userChannel)
        self.userNoteSequence.append(note)
        while len(self.userNoteSequence) > self.userSeqlength:
            del self.userNoteSequence[0]
        (compNote, centroidSequence, compSequence, centroidKey) = self.comp.makeDecision(self.userNoteSequence, self.compNoteSequence, self.autoTranspose)
        if compNote:
            self.playNote(compNote, "_b", self.compChannel)
            self.compNoteSequence.append(compNote)
        self.draw(note, compNote, centroidSequence, compSequence, centroidKey)
        while len(self.compNoteSequence) > self.compSeqlength:
            del self.compNoteSequence[0]

        if compNote:
            print compNote
        else:
            print ""

    def playNote(self, note, suffix, channel):
        sound = pygame.mixer.Sound(note + suffix + ".wav")
        channel.play(sound, -1, 1000000)

    def stopNotes(self):
        pygame.mixer.stop()
        self.wipeNotes()

    def draw(self, userNote, compNote, centroidSequence, compSequence, centroidKey,):
        self.surface.fill((0,0,0))
        self.surface.blit(self.background, (0,0))
        if userNote:
            if userNote in whiteNotes.keys():
                self.surface.blit(self.whiteKeyPressed, (whiteNotes[userNote],0))
        if compNote:
            if compNote in whiteNotes.keys():
                self.surface.blit(self.whiteKeyPressed, (whiteNotes[compNote]+315,0))
        for x in blackNotes.values():
            self.surface.blit(self.blackKey, (x,0))
            self.surface.blit(self.blackKey, (x+315,0))
        if userNote:
            if userNote in blackNotes.keys():
                self.surface.blit(self.blackKeyPressed, (blackNotes[userNote],0))
        if compNote:
            if compNote in blackNotes.keys():
                self.surface.blit(self.blackKeyPressed, (blackNotes[compNote]+315,0))


        for i in xrange(len(centroidSequence)):
            for j in xrange(len(centroidSequence[i])):
                value = (j-centroidKey)%12
                pygame.draw.rect(self.surface, (0, 0, 255*centroidSequence[i][j]), (i*40, 320 - (value+1)*10, 40, 10))

        for i in xrange(len(self.userNoteSequence)):
            value = databuilder.NOTE_VALUES[self.userNoteSequence[i]]
            pygame.draw.rect(self.surface, (0,200,255), (i*40, 320 - (value+1)*10, 40, 10), 1)

        for i in xrange(len(compSequence)):
            for j in xrange(len(compSequence[i])):
                value = (j-centroidKey)%12
                pygame.draw.rect(self.surface, (0, 255*compSequence[i][j], 0), (i*40+len(self.userNoteSequence)*40+40, 320 - (value+1)*10, 40, 10))

        for i in xrange(len(self.compNoteSequence)):
            value = databuilder.NOTE_VALUES[self.compNoteSequence[i]]
            pygame.draw.rect(self.surface, (200,255,0), (i*40+len(self.userNoteSequence)*40+40, 320 - (value+1)*10, 40, 10), 1)

        pygame.display.update()

    def wipeNotes(self):
        self.surface.blit(self.background, (0,0))
        for x in blackNotes.values():
            self.surface.blit(self.blackKey, (x,0))
            self.surface.blit(self.blackKey, (x+315,0))
        pygame.display.update()

    def eventLoop(self):
        pygame.event.set_blocked((pygame.MOUSEBUTTONDOWN, pygame.MOUSEBUTTONUP, pygame.MOUSEMOTION, pygame.ACTIVEEVENT))
        while True:
            event = pygame.event.wait()
            if event.type == pygame.KEYDOWN:
                key = event.key
                if key in keyMap.keys():
                    self.keyStack.append(key)
                    self.playUserNote(keyMap[key])
            elif event.type == pygame.KEYUP:
                key = event.key
                if key in keyMap.keys():
                    if self.keyStack and key == self.keyStack[-1]:
                        self.keyStack.remove(event.key)
                        if not self.keyStack:
                            self.stopNotes()
                        else:
                            self.playUserNote(keyMap[self.keyStack[-1]])
                    elif key in self.keyStack:
                        self.keyStack.remove(key)
            elif event.type == pygame.QUIT:
                sys.exit()
            else:
                print event


def main():
    if len(sys.argv) != 3:
        print "Usage: python clusterFile autoTranspose(0 or 1)"
        sys.exit()

    filename = sys.argv[1]
    autoTranspose = int(sys.argv[2])
    kc = keyComp(filename, autoTranspose)
    kc.eventLoop()


if __name__ == "__main__":
    main()

