import random, databuilder, cPickle, sys, math, pygame

def transpose(seq, key):
    return [(x+key)%12 for x in seq]

class Centroid:
    def __init__(self, userSeqLength, compSeqLength):
        self.userNotes = []
        self.compNotes = []
        self.userSeqLength = userSeqLength
        self.compSeqLength = compSeqLength
        self.dataPoints = []
        self.numNotes = [0]*12
        self.majorityNote = 0
        self.lastUserNotes = None
        self.lastCompNotes = None
        for i in xrange(userSeqLength):
            l = [0]*12
            l[random.randint(0,11)] = 1
            self.userNotes.append(l)
        for i in xrange(compSeqLength):
            l = [0]*12
            l[random.randint(0,11)] = 1
            self.compNotes.append(l)

    def hasChanged(self):
        if not (self.lastUserNotes and self.lastCompNotes):
            return True

        for i in xrange(len(self.userNotes)):
            if self.userNotes[i] != self.lastUserNotes[i]:
                return True
        for i in xrange(len(self.compNotes)):
            if self.compNotes[i] != self.lastCompNotes[i]:
                return True
        return False

    def computeMean(self):
        #clear mean from last time
        self.lastUserNotes = self.userNotes
        self.lastCompNotes = self.compNotes
        self.userNotes = []
        self.compNotes = []
        self.numNotes = [0]*12
        for i in xrange(self.userSeqLength):
            l = [0]*12
            self.userNotes.append(l)
        for i in xrange(self.compSeqLength):
            l = [0]*12
            self.compNotes.append(l)

        #recompute mean
        for point in self.dataPoints:
            userSequence = point[0]
            compSequence = point[1]
            lastNote = point[2]
            for i in xrange(len(self.userNotes)):
                self.userNotes[i][userSequence[i]] += 1
            for i in xrange(len(self.compNotes)):
                self.compNotes[i][compSequence[i]] += 1
            self.numNotes[lastNote] += 1

        if self.dataPoints:
            for note in self.userNotes:
                for i in xrange(len(note)):
                    note[i] *= 1.0/len(self.dataPoints)
            for note in self.compNotes:
                for i in xrange(len(note)):
                    note[i] *= 1.0/len(self.dataPoints)
        maxNumNotes = 0
        for i in xrange(len(self.numNotes)):
            if self.numNotes[i] > maxNumNotes:
                maxNumNotes = self.numNotes[i]
                self.majorityNote = i
        self.dataPoints = []

    def add(self, point):
        self.dataPoints.append(point)

    def similarity(self, userSequence, compSequence):
        score = 0
        for i in xrange(self.userSeqLength):
            score += self.userNotes[i][userSequence[i]]
        for i in xrange(self.compSeqLength):
            score += self.compNotes[i][compSequence[i]]
        return score

class Kmeans:
    def __init__(self, filename,  k, userSeqlength, compSeqlength, percentage):
        pygame.init()
        pygame.display.set_caption("Kmeans sequence clusterer")
        surface = pygame.display.set_mode((800,800))

        self.userSeqlength = userSeqlength
        self.compSeqlength = compSeqlength
        self.centroids = []
        for i in xrange(k):
            self.centroids.append(Centroid(userSeqlength, compSeqlength))

        print "reading " + filename + "..."
        dataPoints = databuilder.readFile(filename, userSeqlength, compSeqlength, percentage)

        gridSize = math.ceil(math.sqrt(k))
        cellSize = math.floor(800/gridSize)
        subCellSize = (math.floor((cellSize-1)/(userSeqlength+compSeqlength)), math.floor((cellSize-1)/12))

        print "starting clustering..."
        #do the clustering
        times = 0
        while self.haveCentroidsChanged() and times < 100:
            #do the drawing here
            surface.fill((0,0,0))
            for i in xrange(k):
                hpos = int((i%gridSize)*cellSize)
                ypos = int(math.floor(i/gridSize)*cellSize)
                pygame.draw.rect(surface, (0, 0, 255), (hpos, ypos, cellSize+1,cellSize+1), 1)
                for j in xrange(self.userSeqlength):
                    for value in xrange(12):
                        pygame.draw.rect(surface,
                                            (0, 0, 255*self.centroids[i].userNotes[j][value]),
                                            (j*subCellSize[0]+hpos+1, ypos+1+cellSize - (value+1)*subCellSize[1], subCellSize[0], subCellSize[1]))
                for j in xrange(self.compSeqlength):
                    for value in xrange(12):
                        pygame.draw.rect(surface,
                                            (0, 255*self.centroids[i].compNotes[j][value],0),
                                            (j*subCellSize[0]+hpos+1+subCellSize[0]*self.userSeqlength, ypos+1+cellSize - (value+1)*subCellSize[1], subCellSize[0], subCellSize[1]))

            pygame.display.update()
            if pygame.event.get(pygame.QUIT):
                sys.exit()

            print "computing membership..."
            #assign all points to nearest centroid
            for point in dataPoints:
                maxSimilarity = -1
                bestCentroid = None
                for centroid in self.centroids:
                    similarity = centroid.similarity(point[0], point[1])
                    if similarity > maxSimilarity:
                        maxSimilarity = similarity
                        bestCentroid = centroid
                bestCentroid.add((point[0],point[1], point[2]))

            print "computing cluster means..."
            count = 1
            for centroid in self.centroids:
                members = len(centroid.dataPoints)
                centroid.computeMean()
                if centroid.hasChanged():
                    print "K" + str(count) + ": " + databuilder.NOTE_CHARS[centroid.majorityNote] +  ", " + str(members) + " members"
                count = count + 1

            times += 1
        print "Finished clustering!"


    def haveCentroidsChanged(self):
        for centroid in self.centroids:
            if centroid.hasChanged():
                return True
        return False

    def categoryUtility(self):
        cu = 0
        for centroid in self.centroids:
            sm = sum(centroid.numNotes)
            if sm > 0:
                cu += math.pow(centroid.numNotes[centroid.majorityNote]*1.0/sm,2)-math.pow(1/12.0,2)
        cu /= len(self.centroids)
        return cu

    def makeDecision(self, userSequence, compSequence, autoTranspose):
        if len(userSequence) == self.userSeqlength and len(compSequence) == self.compSeqlength:
            maxSimilarity = -1
            bestCentroid = None
            bestIndex = 0
            bestKey = 0
            userNumbers = [databuilder.NOTE_VALUES[x] for x in userSequence]
            compNumbers = [databuilder.NOTE_VALUES[x] for x in compSequence]
            count = 1
            for centroid in self.centroids:
                for key in xrange(12):
                    if key == 0 or autoTranspose == 1:
                        similarity = centroid.similarity(transpose(userNumbers,key), transpose(compNumbers,key))
                        if similarity > maxSimilarity:
                            maxSimilarity = similarity
                            bestCentroid = centroid
                            bestKey = key
                            bestIndex = count
                count += 1
            print "K"+str(bestIndex)+": ",
            return (databuilder.NOTE_CHARS[(bestCentroid.majorityNote-bestKey)%12], bestCentroid.userNotes, bestCentroid.compNotes, bestKey)
        return (random.choice(userSequence), [], [], 0)

def main():
    if len(sys.argv) != 7:
        print "Usage: python kmeans.py datafile numberOfMeans userSequenceLength compSequenceLength percentageOfData outputfile"
        sys.exit()

    filename = sys.argv[1]
    k = int(sys.argv[2])
    userSeqlength = int(sys.argv[3])
    compSeqlength = int(sys.argv[4])
    percentage = int(sys.argv[5])*0.01
    outputfile = sys.argv[6]
    kmeans = Kmeans(filename, k, userSeqlength, compSeqlength, percentage)
    print "Category utility is " + str(kmeans.categoryUtility())
    print "pickling to " + outputfile + "..."
    file = open(outputfile, 'w')
    cPickle.dump(kmeans, file)
    print "Done!"
    while True:
            event = pygame.event.wait()
            if event.type == pygame.QUIT:
                sys.exit()



if __name__ == "__main__":
    main()



