import wave, sys, math, array
FREQ = 22050
MAXFRAMES = FREQ/2
scale = 32767
notes = {"C" :261.64,
         "C#":277.18,
         "D" :293.66,
         "D#":311.13,
         "E" :329.63,
         "F" :349.23,
         "F#":369.99,
         "G" :392.00,
         "G#":415.30,
         "A" :440.00,
         "A#":466.16,
         "B" :493.88}

if len(sys.argv) != 5:
    print "Usage: python wavgenerator.py multiplier fileSuffix lvolume rvolume"
    sys.exit()

multiplier = float(sys.argv[1])
fileSuffix = sys.argv[2]
lvolume = float(sys.argv[3])
rvolume = float(sys.argv[4])


for note in notes.keys():
    f = wave.open(note + fileSuffix + ".wav", 'w')
    print "Writing " + note + fileSuffix + ".wav..."
    f.setnchannels(2)
    f.setframerate(FREQ)
    f.setsampwidth(2)
    snd = array.array('h')
    cyclesPerSample = notes[note]*multiplier/FREQ
    amp = 0
    lastamp = 0
    closestToZero = 100000
    bestIndex = MAXFRAMES
    for x in xrange(MAXFRAMES):
        amp = math.sin(cyclesPerSample*x*2*math.pi)*scale
        if amp >= 0 and lastamp < 0:
            if amp < closestToZero:
                closestToZero = amp
                bestIndex = x
        lastamp = amp

    for x in xrange(bestIndex):
        amp = math.sin(cyclesPerSample*x*2*math.pi)*scale
        snd.append(int(round(amp*lvolume)))
        snd.append(int(round(amp*rvolume)))

    for x in xrange(len(snd)):
        snd.append(0)

    f.writeframes(snd)
    f.close()