/*! grafana - v4.5.0 - 2017-09-14
 * Copyright (c) 2017 Torkel Ödegaard; Licensed Apache-2.0 */

define("app/core/partials",["app/core/core_module"],function(a){a.default.run(["$templateCache",function(a){"use strict";a.put("public/app/core/components/help/help.html",'<div class="modal-body"><div class="modal-header"><h2 class="modal-header-title"><i class="fa fa-keyboard-o"></i> <span class="p-l-1">Shortcuts</span></h2><a class="modal-header-close" ng-click="ctrl.dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content help-modal"><p class="small" style="position: absolute; top: 13px; right: 44px"><span class="shortcut-table-key">mod</span> = <span class="muted">CTRL on windows or linux and CMD key on Mac</span></p><div ng-repeat="(category, shortcuts) in ctrl.shortcuts" class="shortcut-category"><table class="shortcut-table"><tbody><tr><th class="shortcut-table-category-header" colspan="2">{{category}}</th></tr><tr ng-repeat="shortcut in shortcuts"><td class="shortcut-table-keys"><span class="shortcut-table-key" ng-repeat="key in shortcut.keys track by $index" ng-bind-html="key"></span></td><td class="shortcut-table-description">{{shortcut.description}}</td></tr><tbody></tbody></tbody></table></div><div class="clearfix"></div></div></div>'),a.put("public/app/core/components/navbar/navbar.html",'<div class="navbar-inner"><a class="navbar-brand-btn pointer" ng-click="ctrl.contextSrv.toggleSideMenu()"><span class="navbar-brand-btn-background"><img src="public/img/grafana_icon.svg"></span><i class="icon-gf icon-gf-grafana_wordmark"></i> <i class="fa fa-caret-down"></i> <i class="fa fa-chevron-left"></i></a><div ng-if="::!ctrl.hasMenu"><a href="{{::ctrl.section.url}}" class="navbar-page-btn"><i class="{{::ctrl.section.icon}}" ng-show="::ctrl.section.icon"></i> <img ng-src="{{::ctrl.section.iconUrl}}" ng-show="::ctrl.section.iconUrl">{{::ctrl.section.title}}</a></div><div class="dropdown navbar-section-wrapper" ng-if="::ctrl.hasMenu"><a href="{{::ctrl.section.url}}" class="navbar-page-btn" data-toggle="dropdown"><i class="{{::ctrl.section.icon}}" ng-show="::ctrl.section.icon"></i> <img ng-src="{{::ctrl.section.iconUrl}}" ng-show="::ctrl.section.iconUrl">{{::ctrl.section.title}} <i class="fa fa-caret-down"></i></a><ul class="dropdown-menu dropdown-menu--navbar"><li ng-repeat="navItem in ::ctrl.model.menu" ng-class="{active: navItem.active}"><a class="pointer" ng-href="{{::navItem.url}}" ng-click="ctrl.navItemClicked(navItem, $event)"><i class="{{::navItem.icon}}" ng-show="::navItem.icon"></i> {{::navItem.title}}</a></li></ul></div><div ng-transclude></div></div><dashboard-search></dashboard-search>'),a.put("public/app/core/components/search/search.html",'<div class="search-backdrop" ng-if="ctrl.isOpen"></div><div class="search-container" ng-if="ctrl.isOpen"><div class="search-field-wrapper"><div class="search-field-icon pointer" ng-click="ctrl.closeSearch()"><i class="fa fa-search"></i></div><input type="text" placeholder="Find dashboards by name" give-focus="ctrl.giveSearchFocus" tabindex="1" ng-keydown="ctrl.keyDown($event)" ng-model="ctrl.query.query" ng-model-options="{ debounce: 500 }" spellcheck="false" ng-change="ctrl.search()" ng-blur="ctrl.searchInputBlur()"><div class="search-switches"><i class="fa fa-filter"></i> <a class="pointer" href="javascript:void 0;" ng-click="ctrl.showStarred()" tabindex="2"><i class="fa fa-remove" ng-show="ctrl.query.starred"></i> starred </a>| <a class="pointer" href="javascript:void 0;" ng-click="ctrl.getTags()" tabindex="3"><i class="fa fa-remove" ng-show="ctrl.tagsMode"></i> tags </a><span ng-if="ctrl.query.tag.length">| <span ng-repeat="tagName in ctrl.query.tag"><a ng-click="ctrl.removeTag(tagName, $event)" tag-color-from-name="tagName" class="label label-tag"><i class="fa fa-remove"></i> {{tagName}}</a></span></span></div><div class="search-field-spacer"></div></div><div class="search-dropdown" ng-class="{\'search-dropdown--fade-in\': ctrl.openCompleted}"><div class="search-results-container" ng-if="ctrl.tagsMode"><div ng-repeat="tag in ctrl.results" class="pointer" style="width: 180px; float: left" ng-class="{\'selected\': $index === ctrl.selectedIndex }" ng-click="ctrl.filterByTag(tag.term, $event)"><a class="search-result-tag label label-tag" tag-color-from-name="tag.term"><i class="fa fa-tag"></i> <span>{{tag.term}} &nbsp;({{tag.count}})</span></a></div></div><div class="search-results-container" ng-if="!ctrl.tagsMode"><h6 ng-hide="ctrl.results.length">No dashboards matching your query were found.</h6><a class="search-item pointer search-item-{{row.type}}" bindonce ng-repeat="row in ctrl.results" ng-class="{\'selected\': $index == ctrl.selectedIndex}" ng-href="{{row.url}}"><span class="search-result-tags"><span ng-click="ctrl.filterByTag(tag, $event)" ng-repeat="tag in row.tags" tag-color-from-name="tag" class="label label-tag">{{tag}} </span><i class="fa" ng-class="{\'fa-star\': row.isStarred, \'fa-star-o\': !row.isStarred}"></i> </span><span class="search-result-link"><i class="fa search-result-icon"></i> <span bo-text="row.title"></span></span></a></div><div class="search-button-row"><a class="btn btn-secondary" href="dashboard/new" ng-show="ctrl.contextSrv.isEditor" ng-click="ctrl.isOpen = false;"><i class="fa fa-plus"></i>&nbsp; New Dashboard </a><a class="btn btn-inverse" href="dashboard/new/?editview=import" ng-show="ctrl.contextSrv.isEditor" ng-click="ctrl.isOpen = false;"><i class="fa fa-upload"></i>&nbsp; Import Dashboard </a><a class="search-button-row-explore-link" target="_blank" href="https://grafana.com/dashboards?utm_source=grafana_search">Find <img src="public/img/icn-dashboard-tiny.svg" width="14"> dashboards on Grafana.com</a></div></div></div>'),a.put("public/app/core/components/sidemenu/sidemenu.html",'<ul class="sidemenu"><li class="sidemenu-org-section" ng-if="::ctrl.isSignedIn" class="dropdown"><a class="sidemenu-org" href="profile"><div class="sidemenu-org-avatar"><img ng-src="{{::ctrl.user.gravatarUrl}}"> <span class="sidemenu-org-avatar--missing"><i class="fa fa-fw fa-user"></i></span></div><div class="sidemenu-org-details"><span class="sidemenu-org-user sidemenu-item-text">{{::ctrl.user.name}}</span> <span class="sidemenu-org-name sidemenu-item-text">{{::ctrl.user.orgName}}</span></div></a><i class="fa fa-caret-right"></i><ul class="dropdown-menu" role="menu"><li ng-repeat="menuItem in ctrl.orgMenu" ng-class="::menuItem.cssClass"><span ng-show="::menuItem.section">{{::menuItem.section}}</span> <a href="{{::menuItem.url}}" ng-show="::menuItem.url" target="{{::menuItem.target}}"><i class="{{::menuItem.icon}}" ng-show="::menuItem.icon"></i> {{::menuItem.text}}</a></li><li ng-show="ctrl.orgs.length > ctrl.maxShownOrgs" style="margin-left: 10px;width: 90%"><span class="sidemenu-item-text">Max shown : {{::ctrl.maxShownOrgs}}</span> <input ng-model="::ctrl.orgFilter" style="padding-left: 5px" type="text" ng-change="::ctrl.loadOrgsItems();" class="gf-input-small width-12" placeholder="Filter"></li><li ng-repeat="orgItem in ctrl.orgItems" ng-class="::orgItem.cssClass"><a href="{{::orgItem.url}}" ng-show="::orgItem.url" target="{{::orgItem.target}}"><i class="{{::orgItem.icon}}" ng-show="::orgItem.icon"></i> {{::orgItem.text}}</a></li></ul></li><li ng-repeat="item in ::ctrl.mainLinks" class="dropdown"><a href="{{::item.url}}" class="sidemenu-item sidemenu-main-link" target="{{::item.target}}"><span class="icon-circle sidemenu-icon"><i class="{{::item.icon}}" ng-show="::item.icon"></i> <img ng-src="{{::item.img}}" ng-show="::item.img"> </span><span class="sidemenu-item-text">{{::item.text}}</span> <span class="fa fa-caret-right" ng-if="::item.children"></span></a><ul class="dropdown-menu" role="menu" ng-if="::item.children"><li ng-repeat="child in ::item.children" ng-class="{divider: child.divider}"><a href="{{::child.url}}"><i class="{{::child.icon}}" ng-show="::child.icon"></i> {{::child.text}}</a></li></ul></li><li ng-show="::!ctrl.isSignedIn"><a href="{{ctrl.loginUrl}}" class="sidemenu-item" target="_self"><span class="icon-circle sidemenu-icon"><i class="fa fa-fw fa-sign-in"></i></span> <span class="sidemenu-item-text">Sign in</span></a></li><li><a class="sidemenu-item" target="_self" ng-hide="ctrl.contextSrv.pinned" ng-click="ctrl.contextSrv.setPinnedState(true)"><span class="icon-circle sidemenu-icon"><i class="fa fa-fw fa-thumb-tack"></i></span> <span class="sidemenu-item-text">Pin</span></a></li></ul>'),a.put("public/app/core/components/wizard/wizard.html",'<div class="modal-body"><div class="modal-header"><h2 class="modal-header-title"><i class="fa fa-cog fa-spin"></i> <span class="p-l-1">{{model.name}}</span></h2><a class="modal-header-close" ng-click="dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content"><div ng-if="activeStep"></div></div></div>'),a.put("public/app/features/admin/partials/admin_home.html",'<navbar model="ctrl.navModel"></navbar><div class="page-container"><div class="page-header"><h1>Server Administration</h1></div><a class="btn btn-inverse" href="admin/users">Manage Users </a><a class="btn btn-inverse" href="admin/orgs">Manage Organizations </a><a class="btn btn-inverse" href="admin/settings">View Server Settings </a><a class="btn btn-inverse" href="admin/stats">View Server Stats </a><a class="btn btn-inverse" href="styleguide">Style guide</a></div>'),a.put("public/app/features/admin/partials/edit_org.html",'<navbar model="navModel"></navbar><div class="page-container"><div class="page-header"><h1>Edit Organization</h1></div><form name="orgDetailsForm" class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-10">Name</span> <input type="text" required ng-model="org.name" class="gf-form-input max-width-14"></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="update()" ng-show="!createMode">Update</button></div></form><h3 class="page-heading">Organization Users</h3><table class="grafana-options-table"><tr><th>Username</th><th>Email</th><th>Role</th><th></th></tr><tr ng-repeat="orgUser in orgUsers"><td>{{orgUser.login}}</td><td>{{orgUser.email}}</td><td><select type="text" ng-model="orgUser.role" class="gf-form-input max-width-8" ng-options="f for f in [\'Viewer\', \'Editor\', \'Read Only Editor\', \'Admin\']" ng-change="updateOrgUser(orgUser)"></select></td><td style="width: 1%"><a ng-click="removeOrgUser(orgUser)" class="btn btn-danger btn-mini"><i class="fa fa-remove"></i></a></td></tr></table></div>'),a.put("public/app/features/admin/partials/edit_user.html",'<navbar model="navModel"></navbar><div class="page-container"><div class="page-header"><h1>Edit User</h1></div><form name="userForm" class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-10">Name</span> <input type="text" required ng-model="user.name" class="gf-form-input max-width-25"></div><div class="gf-form"><span class="gf-form-label width-10">Email</span> <input type="email" ng-model="user.email" class="gf-form-input max-width-25"></div><div class="gf-form"><span class="gf-form-label width-10">Username</span> <input type="text" ng-model="user.login" class="gf-form-input max-width-25"></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="update()" ng-show="!createMode">Update</button></div></form><h3 class="page-heading">Change password</h3><form name="passwordForm" class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-10">New password</span> <input type="password" required ng-minlength="4" ng-model="password" class="gf-form-input max-width-25"></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="setPassword()">Update</button></div></form><h3 class="page-heading">Permissions</h3><form name="passwordForm" class="gf-form-group"><div class="gf-form"><editor-checkbox text="Grafana Admin" model="permissions.isGrafanaAdmin" style="line-height: 1.5rem"></editor-checkbox></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="updatePermissions()">Update</button></div></form><h3 class="page-heading">Organizations</h3><form name="addOrgForm" class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-12">Add organization</span> <input type="text" ng-model="newOrg.name" bs-typeahead="searchOrgs" required class="gf-form-input max-width-20" placeholder="organization name"></div><div class="gf-form"><span class="gf-form-label">Role</span><select type="text" ng-model="newOrg.role" class="gf-form-input width-10" ng-options="f for f in [\'Viewer\', \'Editor\', \'Read Only Editor\', \'Admin\']"></select></div><div class="gf-form"><button class="btn btn-success gf-form-btn" ng-click="addOrgUser()">Add</button></div></div></form><table class="grafana-options-table"><tr><th>Name</th><th>Role</th><th></th></tr><tr ng-repeat="org in orgs"><td>{{org.name}} <span class="label label-info" ng-show="org.orgId === user.orgId">Current</span></td><td><select type="text" ng-model="org.role" class="gf-form-input max-width-12" ng-options="f for f in [\'Viewer\', \'Editor\', \'Read Only Editor\', \'Admin\']" ng-change="updateOrgUser(org)"></select></td><td style="width: 1%"><a ng-click="removeOrgUser(org)" class="btn btn-danger btn-mini"><i class="fa fa-remove"></i></a></td></tr></table></div>'),a.put("public/app/features/admin/partials/new_user.html",'<navbar model="navModel"></navbar><div class="page-container"><div class="page-header"><h1>Add new user</h1></div><form name="userForm" class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-10">Name</span> <input type="text" required ng-model="user.name" class="gf-form-input max-width-20"></div><div class="gf-form"><span class="gf-form-label width-10">Email</span> <input type="email" ng-model="user.email" class="gf-form-input max-width-20"></div><div class="gf-form"><span class="gf-form-label width-10">Username</span> <input type="text" ng-model="user.login" class="gf-form-input max-width-20"></div><div class="gf-form"><span class="gf-form-label width-10">Password</span> <input type="password" required ng-model="user.password" class="gf-form-input max-width-20"></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="create()">Create</button></div></form></div>'),a.put("public/app/features/admin/partials/orgs.html",'<navbar model="navModel"></navbar><div class="page-container"><div class="page-header"><h1>Organizations</h1></div><table class="filter-table form-inline"><thead><tr><th>Id</th><th>Name</th><th></th></tr></thead><tbody><tr ng-repeat="org in orgs"><td>{{org.id}}</td><td>{{org.name}}</td><td class="text-right"><a href="admin/orgs/edit/{{org.id}}" class="btn btn-inverse btn-small"><i class="fa fa-edit"></i> Edit </a>&nbsp;&nbsp; <a ng-click="deleteOrg(org)" class="btn btn-danger btn-small"><i class="fa fa-remove"></i></a></td></tr></tbody></table></div>'),a.put("public/app/features/admin/partials/settings.html",'<navbar model="ctrl.navModel"></navbar><div class="page-container"><div class="page-header"><h1>Server settings</h1></div><div class="grafana-info-box span8" style="margin: 20px 0 25px 0">These system settings are defined in grafana.ini or custom.ini (or overridden in ENV variables). To change these you currently need to restart grafana.</div><table class="grafana-options-table"><tr ng-repeat-start="(secName, secValue) in settings"><td class="admin-settings-section">{{secName}}</td><td></td></tr><tr ng-repeat="(keyName, keyValue) in secValue" ng-repeat-end><td style="padding-left: 25px">{{keyName}}</td><td>{{keyValue}}</td></tr></table></div>'),a.put("public/app/features/admin/partials/stats.html",'<navbar model="ctrl.navModel"></navbar><div class="page-container"><div class="page-header"><h1>Stats</h1></div><table class="filter-table form-inline"><thead><tr><th>Name</th><th>Value</th></tr></thead><tbody><tr><td>Total dashboards</td><td>{{ctrl.stats.dashboards}}</td></tr><tr><td>Total users</td><td>{{ctrl.stats.users}}</td></tr><tr><td>Active users (seen last 14 days)</td><td>{{ctrl.stats.activeUsers}}</td></tr><tr><td>Total organizations</td><td>{{ctrl.stats.orgs}}</td></tr><tr><td>Total datasources</td><td>{{ctrl.stats.datasources}}</td></tr><tr><td>Total playlists</td><td>{{ctrl.stats.playlists}}</td></tr><tr><td>Total snapshots</td><td>{{ctrl.stats.snapshots}}</td></tr><tr><td>Total dashboard tags</td><td>{{ctrl.stats.tags}}</td></tr><tr><td>Total starred dashboards</td><td>{{ctrl.stats.stars}}</td></tr><tr><td>Total alerts</td><td>{{ctrl.stats.alerts}}</td></tr></tbody></table></div>'),a.put("public/app/features/admin/partials/users.html",'<navbar model="ctrl.navModel"></navbar><div class="page-container"><div class="page-header"><h1>Users</h1><a class="btn btn-success" href="admin/users/create"><i class="fa fa-plus"></i> Add new user</a></div><div class="gf-form pull-right gf-form-group"><label class="gf-form-label">Search</label><span style="position: relative"><input class="gf-form-input width-15" type="text" placeholder="Find user by name/login/email" tabindex="1" give-focus="true" ng-model="ctrl.query" ng-model-options="{ debounce: 500 }" spellcheck="false" ng-change="ctrl.getUsers()"></span></div><div class="admin-list-table"><table class="filter-table form-inline"><thead><tr><th>Id</th><th>Name</th><th>Login</th><th>Email</th><th>Seen<tip>Time since user was seen using Grafana</tip></th><th></th><th></th></tr></thead><tbody><tr ng-repeat="user in ctrl.users"><td>{{user.id}}</td><td>{{user.name}}</td><td>{{user.login}}</td><td>{{user.email}}</td><td>{{user.lastSeenAtAge}}</td><td><i class="fa fa-shield" ng-show="user.isAdmin" bs-tooltip="\'Grafana Admin\'"></i></td><td class="text-right"><a href="admin/users/edit/{{user.id}}" class="btn btn-inverse btn-small"><i class="fa fa-edit"></i> Edit </a>&nbsp;&nbsp; <a ng-click="ctrl.deleteUser(user)" class="btn btn-danger btn-small"><i class="fa fa-remove"></i></a></td></tr></tbody></table></div><div class="admin-list-paging" ng-if="ctrl.showPaging"><ol><li ng-repeat="page in ctrl.pages"><button class="btn btn-small" ng-class="{\'btn-secondary\': page.current, \'btn-inverse\': !page.current}" ng-click="ctrl.navigateToPage(page)">{{page.page}}</button></li></ol></div></div>'),a.put("public/app/features/alerting/partials/alert_howto.html",'<div class="modal-body"><div class="modal-header"><h2 class="modal-header-title"><i class="fa fa-info-circle"></i> <span class="p-l-1">Adding an Alert</span></h2><a class="modal-header-close" ng-click="dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content"><div class="text-center"><img src="public/img/alert_howto_new.png"></div><p class="p-a-2 text-center offset-lg-1 col-lg-10">Alerts are added and configured in the <strong>Alert Tab</strong> of any dashboard graph panel, letting you build and visualize an alert using existing queries.<br><br>To persist your alert rule changes remember to save the dashboard.<br><br><a href="{{appSubUrl}}" class="external-link" ng-click="dismiss()">Go to Home Dashboard</a></p></div></div>'),a.put("public/app/features/alerting/partials/alert_list.html",'<navbar model="ctrl.navModel"></navbar><div class="page-container"><div class="page-header"><h1>Alert List</h1><a class="btn btn-inverse" ng-click="ctrl.openHowTo()"><i class="fa fa-info-circle"></i> How to add an alert </a><a class="btn btn-inverse" href="alerting/notifications"><i class="fa fa-cog"></i> Configure notifications</a></div><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label">Filter by state</label><div class="gf-form-select-wrapper width-13"><select class="gf-form-input" ng-model="ctrl.filters.state" ng-options="f.value as f.text for f in ctrl.stateFilters" ng-change="ctrl.filtersChanged()"></select></div></div></div></div><section class="card-section card-list-layout-list"><ol class="card-list"><li class="card-item-wrapper" ng-repeat="alert in ctrl.alerts"><div class="card-item card-item--alert"><div class="card-item-header"><div class="card-item-type"><a class="card-item-cog" bs-tooltip="\'Pausing an alert rule prevents it from executing\'" ng-click="ctrl.pauseAlertRule(alert.id)"><i class="fa fa-pause"></i> </a><a class="card-item-cog" href="dashboard/{{alert.dashboardUri}}?panelId={{alert.panelId}}&fullscreen&edit&tab=alert" bs-tooltip="\'Edit alert rule\'"><i class="icon-gf icon-gf-settings"></i></a></div></div><div class="card-item-body"><div class="card-item-details"><div class="card-item-name"><a href="dashboard/{{alert.dashboardUri}}?panelId={{alert.panelId}}&fullscreen&edit&tab=alert">{{alert.name}}</a></div><div class="card-item-sub-name"><span class="alert-list-item-state {{alert.stateModel.stateClass}}"><i class="{{alert.stateModel.iconClass}}"></i> {{alert.stateModel.text}} <span class="small muted" ng-show="alert.no_data">(due to no data)</span> </span>for {{alert.newStateDateAgo}}</div><div class="small muted" ng-show="alert.executionError !== \'\'">Error: "{{alert.executionError}}"</div></div></div></div></li></ol></section></div>'),a.put("public/app/features/alerting/partials/alert_tab.html",'<div class="edit-tab-with-sidemenu" ng-if="ctrl.alert"><aside class="edit-sidemenu-aside"><ul class="edit-sidemenu"><li ng-class="{active: ctrl.subTabIndex === 0}"><a ng-click="ctrl.changeTabIndex(0)">Alert Config</a></li><li ng-class="{active: ctrl.subTabIndex === 1}"><a ng-click="ctrl.changeTabIndex(1)">Notifications <span class="muted">({{ctrl.alertNotifications.length}})</span></a></li><li ng-class="{active: ctrl.subTabIndex === 2}"><a ng-click="ctrl.changeTabIndex(2)">State history</a></li><li><a ng-click="ctrl.delete()">Delete</a></li></ul></aside><div class="edit-tab-content"><div ng-if="ctrl.subTabIndex === 0"><div class="alert alert-error m-b-2" ng-show="ctrl.error"><i class="fa fa-warning"></i> {{ctrl.error}}</div><div class="gf-form-group"><h5 class="section-heading">Alert Config</h5><div class="gf-form"><span class="gf-form-label width-6">Name</span> <input type="text" class="gf-form-input width-20" ng-model="ctrl.alert.name"> <span class="gf-form-label">Evaluate every</span> <input class="gf-form-input max-width-5" type="text" ng-model="ctrl.alert.frequency"></div></div><div class="gf-form-group"><h5 class="section-heading">Conditions</h5><div class="gf-form-inline" ng-repeat="conditionModel in ctrl.conditionModels"><div class="gf-form"><metric-segment-model css-class="query-keyword width-5" ng-if="$index" property="conditionModel.operator.type" options="ctrl.evalOperators" custom="false"></metric-segment-model><span class="gf-form-label query-keyword width-5" ng-if="$index===0">WHEN</span></div><div class="gf-form"><query-part-editor class="gf-form-label query-part width-6" part="conditionModel.reducerPart" handle-event="ctrl.handleReducerPartEvent(conditionModel, $event)"></query-part-editor><span class="gf-form-label query-keyword">OF</span></div><div class="gf-form"><query-part-editor class="gf-form-label query-part" part="conditionModel.queryPart" handle-event="ctrl.handleQueryPartEvent(conditionModel, $event)"></query-part-editor></div><div class="gf-form"><metric-segment-model property="conditionModel.evaluator.type" options="ctrl.evalFunctions" custom="false" css-class="query-keyword" on-change="ctrl.evaluatorTypeChanged(conditionModel.evaluator)"></metric-segment-model><input class="gf-form-input max-width-9" type="number" step="any" ng-hide="conditionModel.evaluator.params.length === 0" ng-model="conditionModel.evaluator.params[0]" ng-change="ctrl.evaluatorParamsChanged()"><label class="gf-form-label query-keyword" ng-show="conditionModel.evaluator.params.length === 2">TO</label><input class="gf-form-input max-width-9" type="number" step="any" ng-if="conditionModel.evaluator.params.length === 2" ng-model="conditionModel.evaluator.params[1]" ng-change="ctrl.evaluatorParamsChanged()"></div><div class="gf-form"><label class="gf-form-label"><a class="pointer" tabindex="1" ng-click="ctrl.removeCondition($index)"><i class="fa fa-trash"></i></a></label></div></div><div class="gf-form"><label class="gf-form-label dropdown"><a class="pointer dropdown-toggle" data-toggle="dropdown"><i class="fa fa-plus"></i></a><ul class="dropdown-menu" role="menu"><li ng-repeat="ct in ctrl.conditionTypes" role="menuitem"><a ng-click="ctrl.addCondition(ct.value);">{{ct.text}}</a></li></ul></label></div></div><div class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-18">If no data or all values are null</span> <span class="gf-form-label query-keyword">SET STATE TO</span><div class="gf-form-select-wrapper"><select class="gf-form-input" ng-model="ctrl.alert.noDataState" ng-options="f.value as f.text for f in ctrl.noDataModes"></select></div></div><div class="gf-form"><span class="gf-form-label width-18">If execution error or timeout</span> <span class="gf-form-label query-keyword">SET STATE TO</span><div class="gf-form-select-wrapper"><select class="gf-form-input" ng-model="ctrl.alert.executionErrorState" ng-options="f.value as f.text for f in ctrl.executionErrorModes"></select></div></div><div class="gf-form-button-row"><button class="btn btn-inverse" ng-click="ctrl.test()">Test Rule</button></div></div><div class="gf-form-group" ng-if="ctrl.testing">Evaluating rule <i class="fa fa-spinner fa-spin"></i></div><div class="gf-form-group" ng-if="ctrl.testResult"><json-tree root-name="result" object="ctrl.testResult" start-expanded="true"></json-tree></div></div><div class="gf-form-group" ng-if="ctrl.subTabIndex === 1"><h5 class="section-heading">Notifications</h5><div class="gf-form-inline"><div class="gf-form max-width-30"><span class="gf-form-label width-8">Send to</span> <span class="gf-form-label" ng-repeat="nc in ctrl.alertNotifications" ng-style="{\'background-color\': nc.bgColor }"><i class="{{nc.iconClass}}"></i>&nbsp;{{nc.name}}&nbsp; <i class="fa fa-remove pointer muted" ng-click="ctrl.removeNotification($index)" ng-if="nc.isDefault === false"></i></span><metric-segment segment="ctrl.addNotificationSegment" get-options="ctrl.getNotifications()" on-change="ctrl.notificationAdded()"></metric-segment></div></div><div class="gf-form gf-form--v-stretch"><span class="gf-form-label width-8">Message</span><textarea class="gf-form-input" rows="10" ng-model="ctrl.alert.message" placeholder="Notification message details..."></textarea></div></div><div class="gf-form-group" style="max-width: 720px" ng-if="ctrl.subTabIndex === 2"><button class="btn btn-mini btn-danger pull-right" ng-click="ctrl.clearHistory()"><i class="fa fa-trash"></i>&nbsp;Clear history</button><h5 class="section-heading" style="whitespace: nowrap">State history <span class="muted small">(last 50 state changes)</span></h5><div ng-show="ctrl.alertHistory.length === 0"><br><i>No state changes recorded</i></div><section class="card-section card-list-layout-list"><ol class="card-list"><li class="card-item-wrapper" ng-repeat="ah in ctrl.alertHistory"><div class="card-item card-item--alert"><div class="card-item-header"><div class="card-item-type"></div></div><div class="card-item-body"><div class="card-item-details"><div class="card-item-sub-name"><span class="alert-list-item-state {{ah.stateModel.stateClass}}"><i class="{{ah.stateModel.iconClass}}"></i> {{ah.stateModel.text}} </span>{{ah.time}}</div><div class="card-item-sub-name">{{ah.info}}</div></div></div></div></li></ol></section></div></div></div><div class="gf-form-group" ng-if="!ctrl.alert"><div class="gf-form-button-row"><button class="btn btn-inverse" ng-click="ctrl.enable()"><i class="icon-gf icon-gf-alert"></i> Create Alert</button></div></div>'),a.put("public/app/features/alerting/partials/notification_edit.html",'<navbar model="ctrl.navModel"></navbar><div class="page-container"><div class="page-header"><h1 ng-show="ctrl.model.id">Edit Channel</h1><h1 ng-show="!ctrl.model.id">New Channel</h1></div><form name="ctrl.theForm" ng-if="ctrl.notifiers"><div class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-12">Name</span> <input type="text" required class="gf-form-input max-width-15" ng-model="ctrl.model.name" required></div><div class="gf-form"><span class="gf-form-label width-12">Type</span><div class="gf-form-select-wrapper width-15"><select class="gf-form-input" ng-model="ctrl.model.type" ng-options="t.type as t.name for t in ctrl.notifiers" ng-change="ctrl.typeChanged(notification, $index)"></select></div></div><gf-form-switch class="gf-form" label="Send on all alerts" label-class="width-12" checked="ctrl.model.isDefault" tooltip="Use this notification for all alerts"></gf-form-switch><gf-form-switch class="gf-form" label="Include image" label-class="width-12" checked="ctrl.model.settings.uploadImage" tooltip="Captures an image and include it in the notification"></gf-form-switch></div><div class="gf-form-group" ng-include src="ctrl.notifierTemplateId"></div><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form width-6"><button type="submit" ng-click="ctrl.save()" class="btn btn-success">Save</button></div><div class="gf-form width-20"><div class="gf-form"><button type="submit" ng-click="ctrl.testNotification()" class="btn btn-secondary">Send Test</button></div></div></div></div></form></div>'),a.put("public/app/features/alerting/partials/notifications_list.html",'<navbar model="ctrl.navModel"></navbar><div class="page-container"><div class="page-header"><h1>Notification channels</h1><a href="alerting/notification/new" class="btn btn-success pull-right"><i class="fa fa-plus"></i> New Channel</a></div><table class="grafana-options-table"><thead><th style="min-width: 200px"><strong>Name</strong></th><th style="min-width: 100px">Type</th><th style="width: 1%"></th></thead><tr ng-repeat="notification in ctrl.notifications"><td><a href="alerting/notification/{{notification.id}}/edit">{{notification.name}}</a></td><td>{{notification.type}}</td><td class="text-right"><span class="btn btn-secondary btn-small" ng-show="notification.isDefault == true">default </span><a href="alerting/notification/{{notification.id}}/edit" class="btn btn-inverse btn-small"><i class="fa fa-edit"></i> edit </a><a ng-click="ctrl.deleteNotification(notification.id)" class="btn btn-danger btn-small"><i class="fa fa-remove"></i></a></td></tr></table></div>'),a.put("public/app/features/annotations/partials/editor.html",'<div ng-controller="AnnotationsEditorCtrl"><div class="tabbed-view-header"><h2 class="tabbed-view-title">Annotations</h2><ul class="gf-tabs"><li class="gf-tabs-item"><a class="gf-tabs-link" ng-click="ctrl.mode = \'list\';" ng-class="{active: ctrl.mode === \'list\'}">Queries</a></li><li class="gf-tabs-item" ng-show="ctrl.mode === \'edit\'"><a class="gf-tabs-link" ng-class="{active: ctrl.mode === \'edit\'}">Edit Query</a></li><li class="gf-tabs-item" ng-show="ctrl.mode === \'new\'"><span class="active gf-tabs-link">New Query</span></li><li class="gf-tabs-item"><a class="gf-tabs-link" ng-click="ctrl.mode = \'help\';" ng-class="{active: ctrl.mode === \'help\'}">Help</a></li></ul><button class="tabbed-view-close-btn" ng-click="dismiss();"><i class="fa fa-remove"></i></button></div><div class="tabbed-view-body"><div ng-show="ctrl.mode === \'help\'"><div class="grafana-info-box col-lg-8"><h5>What are Annotations?</h5><p>Annotations provide a way to integrate event data into your graphs. They are visualized as vertical lines and icons on all graph panels. When you hover over an annotation icon you can get title, tags, and text information for the event. In the <i>Queries</i> tab you can add queries that return annotation events.<br><br>Checkout the <a class="external-link" target="_blank" href="http://docs.grafana.org/reference/annotations/">Annotations documentation</a> for more information.</p></div></div><div class="editor-row row" ng-if="ctrl.mode === \'list\'"><div ng-if="ctrl.annotations.length === 0"><em>No annotation queries defined</em></div><table class="grafana-options-table"><tr ng-repeat="annotation in ctrl.annotations"><td style="width:90%"><i class="fa fa-bolt" style="color:{{annotation.iconColor}}"></i> &nbsp; {{annotation.name}}</td><td style="width: 1%"><i ng-click="_.move(ctrl.annotations,$index,$index-1)" ng-hide="$first" class="pointer fa fa-arrow-up"></i></td><td style="width: 1%"><i ng-click="_.move(ctrl.annotations,$index,$index+1)" ng-hide="$last" class="pointer fa fa-arrow-down"></i></td><td style="width: 1%"><a ng-click="ctrl.edit(annotation)" class="btn btn-inverse btn-mini"><i class="fa fa-edit"></i> Edit</a></td><td style="width: 1%"><a ng-click="ctrl.removeAnnotation(annotation)" class="btn btn-danger btn-mini"><i class="fa fa-remove"></i></a></td></tr></table></div><div class="gf-form" ng-show="ctrl.mode === \'list\'"><div class="gf-form-button-row"><a type="button" class="btn gf-form-button btn-success" ng-click="ctrl.mode = \'new\';"><i class="fa fa-plus"></i>&nbsp;&nbsp;New</a></div></div><div class="annotations-basic-settings" ng-if="ctrl.mode === \'edit\' || ctrl.mode === \'new\'"><div class="gf-form-group"><h5 class="section-heading">Options</h5><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-9">Name</span> <input type="text" class="gf-form-input width-12" ng-model="ctrl.currentAnnotation.name" placeholder="name"></div><div class="gf-form"><span class="gf-form-label width-9">Data source</span><div class="gf-form-select-wrapper width-12"><select class="gf-form-input" ng-model="ctrl.currentAnnotation.datasource" ng-options="f.name as f.name for f in ctrl.datasources" ng-change="ctrl.datasourceChanged()"></select></div></div></div><div class="gf-form-group"><div class="gf-form-inline"><gf-form-switch class="gf-form" label="Hide toggle" tooltip="Hides the annotation query toggle from showing at the top of the dashboard" checked="ctrl.currentAnnotation.hide" label-class="width-9"></gf-form-switch></div><div class="gf-form"><label class="gf-form-label width-9">Color</label><spectrum-picker class="gf-form-input width-3" ng-model="ctrl.currentAnnotation.iconColor"></spectrum-picker></div></div></div><h5 class="section-heading">Query</h5><rebuild-on-change property="ctrl.currentDatasource"><plugin-component type="annotations-query-ctrl"></plugin-component></rebuild-on-change><div class="gf-form"><div class="gf-form-button-row p-y-0"><button ng-show="ctrl.mode === \'new\'" type="button" class="btn gf-form-button btn-success" ng-click="ctrl.add()">Add</button> <button ng-show="ctrl.mode === \'edit\'" type="button" class="btn btn-success pull-left" ng-click="ctrl.update()">Update</button></div></div></div></div></div>'),
a.put("public/app/features/annotations/partials/event_editor.html",'<h5 class="section-heading text-center">Add annotation</h5><form name="ctrl.form" class="text-center"><div style="display: inline-block"><div class="gf-form"><span class="gf-form-label width-7">Title</span> <input type="text" ng-model="ctrl.event.title" class="gf-form-input max-width-20" required></div><div ng-if="!ctrl.event.isRegion"><div class="gf-form"><span class="gf-form-label width-7">Time</span> <input type="text" ng-model="ctrl.event.time" class="gf-form-input max-width-20" input-datetime required ng-change="ctrl.timeChanged()"></div></div><div ng-if="ctrl.event.isRegion"><div class="gf-form"><span class="gf-form-label width-7">Start</span> <input type="text" ng-model="ctrl.event.time" class="gf-form-input max-width-20" input-datetime required ng-change="ctrl.timeChanged()"></div><div class="gf-form"><span class="gf-form-label width-7">End</span> <input type="text" ng-model="ctrl.event.timeEnd" class="gf-form-input max-width-20" input-datetime required ng-change="ctrl.timeChanged()"></div></div><div class="gf-form gf-form--v-stretch"><span class="gf-form-label width-7">Description</span><textarea class="gf-form-input width-20" rows="3" ng-model="ctrl.event.text" placeholder="Event description"></textarea></div><div class="gf-form-button-row"><button type="submit" class="btn gf-form-btn btn-success" ng-click="ctrl.save()">Save</button> <a class="btn-text" ng-click="ctrl.close();">Cancel</a></div></div></form>'),a.put("public/app/features/dashboard/dashnav/dashnav.html",'<div class="navbar"><div class="navbar-inner"><a class="navbar-brand-btn pointer" ng-click="ctrl.toggleSideMenu()"><span class="navbar-brand-btn-background"><img src="public/img/grafana_icon.svg"></span><i class="icon-gf icon-gf-grafana_wordmark"></i> <i class="fa fa-caret-down"></i> <i class="fa fa-chevron-left"></i></a><div class="navbar-section-wrapper"><a class="navbar-page-btn" ng-click="ctrl.showSearch()"><i class="icon-gf icon-gf-dashboard"></i> {{ctrl.dashboard.title}} <i class="fa fa-caret-down"></i></a></div><ul class="nav dash-playlist-actions" ng-if="ctrl.playlistSrv.isPlaying"><li><a ng-click="ctrl.playlistSrv.prev()"><i class="fa fa-step-backward"></i></a></li><li><a ng-click="ctrl.playlistSrv.stop()"><i class="fa fa-stop"></i></a></li><li><a ng-click="ctrl.playlistSrv.next()"><i class="fa fa-step-forward"></i></a></li></ul><ul class="nav pull-left dashnav-action-icons"><li ng-show="::ctrl.dashboard.meta.canStar"><a class="pointer" ng-click="ctrl.starDashboard()"><i class="fa" ng-class="{\'fa-star-o\': !ctrl.dashboard.meta.isStarred, \'fa-star\': ctrl.dashboard.meta.isStarred}" style="color: orange"></i></a></li><li ng-show="::ctrl.dashboard.meta.canShare" class="dropdown"><a class="pointer" ng-click="ctrl.hideTooltip($event)" bs-tooltip="\'Share dashboard\'" data-placement="bottom" data-toggle="dropdown"><i class="fa fa-share-square-o"></i></a><ul class="dropdown-menu"><li><a class="pointer" ng-click="ctrl.shareDashboard(0)"><i class="fa fa-link"></i> Link to Dashboard<div class="dropdown-desc">Share an internal link to the current dashboard. Some configuration options available.</div></a></li><li><a class="pointer" ng-click="ctrl.shareDashboard(1)"><i class="icon-gf icon-gf-snapshot"></i>Snapshot<div class="dropdown-desc">Interactive, publically accessible dashboard. Sensitive data is stripped out.</div></a></li><li><a class="pointer" ng-click="ctrl.shareDashboard(2)"><i class="fa fa-cloud-upload"></i>Export<div class="dropdown-desc">Export the dashboard to a JSON file for others and to share on Grafana.com</div></a></li></ul></li><li ng-show="::ctrl.dashboard.meta.canSave"><a ng-click="ctrl.saveDashboard()" bs-tooltip="\'Save dashboard <br> CTRL+S\'" data-placement="bottom"><i class="fa fa-save"></i></a></li><li ng-if="::ctrl.dashboard.snapshot.originalUrl"><a ng-href="{{ctrl.dashboard.snapshot.originalUrl}}" bs-tooltip="\'Open original dashboard\'" data-placement="bottom"><i class="fa fa-link"></i></a></li><li class="dropdown"><a class="pointer" data-toggle="dropdown"><i class="fa fa-cog"></i></a><ul class="dropdown-menu dropdown-menu--navbar"><li ng-repeat="navItem in ::ctrl.navModel.menu" ng-class="{active: navItem.active}"><a class="pointer" ng-href="{{::navItem.url}}" ng-click="ctrl.navItemClicked(navItem, $event)"><i class="{{::navItem.icon}}" ng-show="::navItem.icon"></i> {{::navItem.title}}</a></li></ul></li></ul><ul class="nav pull-right"><li ng-show="ctrl.dashboard.meta.fullscreen" class="dashnav-back-to-dashboard"><a ng-click="ctrl.exitFullscreen()">Back to dashboard</a></li><li><gf-time-picker dashboard="ctrl.dashboard"></gf-time-picker></li></ul></div></div><dashboard-search></dashboard-search>'),a.put("public/app/features/dashboard/export/export_modal.html",'<div class="share-modal-header"><div class="share-modal-big-icon"><i class="fa fa-cloud-upload"></i></div><div><p class="share-modal-info-text">Export the dashboard to a JSON file. The exporter will templatize the dashboard\'s data sources to make it easy for other\'s to to import and reuse. You can share dashboards on <a class="external-link" href="https://grafana.com">Grafana.com</a></p><div class="gf-form-button-row"><button type="button" class="btn gf-form-btn width-10 btn-success" ng-click="ctrl.save()"><i class="fa fa-save"></i> Save to file</button> <button type="button" class="btn gf-form-btn width-10 btn-secondary" ng-click="ctrl.saveJson()"><i class="fa fa-file-text-o"></i> View JSON</button> <a class="btn btn-link" ng-click="dismiss()">Cancel</a></div></div></div>'),a.put("public/app/features/dashboard/export_data/export_data_modal.html",'<div class="modal-body"><div class="modal-header"><h2 class="modal-header-title">Export CSV</h2><a class="modal-header-close" ng-click="ctrl.dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content"><div class="p-t-2"><div class="gf-form" ng-hide="ctrl.panel === \'table\'"><label class="gf-form-label width-10">Mode</label><div class="gf-form-select-wrapper"><select class="gf-form-input" ng-model="ctrl.asRows" ng-options="f.value as f.text for f in [{text: \'Series as rows\', value: true}, {text: \'Series as columns\', value: false}]"></select></div></div><div class="gf-form" ng-hide="ctrl.panel === \'table\'"><label class="gf-form-label width-10">Date Time Format</label><input type="text" class="gf-form-input" ng-model="ctrl.dateTimeFormat"></div><gf-form-switch class="gf-form" label="Export To Excel" label-class="width-12" switch-class="max-width-6" checked="ctrl.excel"></gf-form-switch></div><div class="gf-form-button-row text-center"><a class="btn btn-success" ng-click="ctrl.export();">Export</a> <a class="btn-text" ng-click="ctrl.dismiss();">Cancel</a></div></div></div>'),a.put("public/app/features/dashboard/history/history.html",'<div class="tabbed-view-header"><h2 class="tabbed-view-title">Version history</h2><ul class="gf-tabs"><li class="gf-tabs-item"><a class="gf-tabs-link" ng-click="ctrl.switchMode(\'list\');" ng-class="{active: ctrl.mode === \'list\'}">List</a></li><li class="gf-tabs-item" ng-show="ctrl.mode === \'compare\'"><span class="active gf-tabs-link">Version Comparison</span></li></ul><button class="tabbed-view-close-btn" ng-click="ctrl.dismiss();"><i class="fa fa-remove"></i></button></div><div class="tabbed-view-body"><div ng-if="ctrl.mode === \'list\'"><div ng-if="ctrl.loading"><i class="fa fa-spinner fa-spin"></i> <em>Fetching history list&hellip;</em></div><div ng-if="!ctrl.loading"><div class="gf-form-group"><table class="filter-table"><thead><tr><th class="width-4"></th><th class="width-4">Version</th><th class="width-14">Date</th><th class="width-10">Updated By</th><th>Notes</th><th></th></tr></thead><tbody><tr ng-repeat="revision in ctrl.revisions"><td class="filter-table__switch-cell" bs-tooltip="!revision.checked && ctrl.canCompare ? \'You can only compare 2 versions at a time\' : \'\'" data-placement="right"><gf-form-switch switch-class="gf-form-switch--table-cell" checked="revision.checked" on-change="ctrl.revisionSelectionChanged()" ng-disabled="!revision.checked && ctrl.canCompare"></gf-form-switch></td><td class="text-center">{{revision.version}}</td><td>{{revision.createdDateString}}</td><td>{{revision.createdBy}}</td><td>{{revision.message}}</td><td class="text-right"><a class="btn btn-inverse btn-small" ng-show="revision.version !== ctrl.dashboard.version" ng-click="ctrl.restore(revision.version)"><i class="fa fa-history"></i>&nbsp;&nbsp;Restore </a><a class="btn btn-outline-disabled btn-small" ng-show="revision.version === ctrl.dashboard.version"><i class="fa fa-check"></i>&nbsp;&nbsp;Latest</a></td></tr></tbody></table><div ng-if="ctrl.appending"><i class="fa fa-spinner fa-spin"></i> <em>Fetching more entries&hellip;</em></div><div class="gf-form-group" ng-show="ctrl.mode === \'list\'"><div class="gf-form-button-row"><button type="button" class="btn gf-form-button btn-secondary" ng-if="ctrl.revisions.length > 1" ng-disabled="!ctrl.canCompare" ng-click="ctrl.getDiff(ctrl.diff)" bs-tooltip="ctrl.canCompare ? \'\' : \'Select 2 versions to start comparing\'" data-placement="bottom"><i class="fa fa-code-fork"></i>&nbsp;&nbsp;Compare versions</button> <button type="button" class="btn gf-form-button btn-inverse" ng-if="ctrl.revisions.length >= ctrl.limit" ng-click="ctrl.addToLog()" ng-disabled="ctrl.isLastPage()">Show more versions</button></div></div></div></div></div><div class="edit-tab-with-sidemenu" ng-if="ctrl.mode === \'compare\'"><aside class="edit-sidemenu-aside"><ul class="edit-sidemenu"><li ng-class="{active: ctrl.diff === \'basic\'}"><a ng-click="ctrl.getDiff(\'basic\')" href="">Change Summary</a></li><li ng-class="{active: ctrl.diff === \'html\'}"><a ng-click="ctrl.getDiff(\'json\')" href="">JSON Diff</a></li></ul></aside><div class="edit-tab-content"><div ng-if="ctrl.loading"><i class="fa fa-spinner fa-spin"></i> <em>Fetching changes&hellip;</em></div><div ng-if="!ctrl.loading"><a type="button" class="btn gf-form-button btn-secondary pull-right" ng-click="ctrl.restore(ctrl.baseInfo.version)" ng-if="ctrl.isNewLatest"><i class="fa fa-history"></i>&nbsp;&nbsp;Restore to version {{ctrl.baseInfo.version}}</a><h4>Comparing Version {{ctrl.baseInfo.version}} <i class="fa fa-arrows-h"></i> Version {{ctrl.newInfo.version}} <cite class="muted" ng-if="ctrl.isNewLatest">(Latest)</cite></h4><section><p class="small muted"><strong>Version {{ctrl.newInfo.version}}</strong> updated by <span>{{ctrl.newInfo.createdBy}} </span><span>{{ctrl.newInfo.ageString}}</span> <span>- {{ctrl.newInfo.message}}</span></p><p class="small muted"><strong>Version {{ctrl.baseInfo.version}}</strong> updated by <span>{{ctrl.baseInfo.createdBy}} </span><span>{{ctrl.baseInfo.ageString}}</span> <span>- {{ctrl.baseInfo.message}}</span></p></section><div id="delta" diff-delta><div class="delta-basic" ng-show="ctrl.diff === \'basic\'" compile="ctrl.delta.basic"></div><div class="delta-html" ng-show="ctrl.diff === \'json\'" compile="ctrl.delta.json"></div></div></div></div></div></div>'),a.put("public/app/features/dashboard/import/dash_import.html",'<div class="modal-body"><div class="modal-header"><h2 class="modal-header-title"><i class="fa fa-upload"></i> <span class="p-l-1">Import Dashboard</span></h2><a class="modal-header-close" ng-click="dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content" ng-cloak><div ng-if="ctrl.step === 1"><form class="gf-form-group"><dash-upload on-upload="ctrl.onUpload(dash)"></dash-upload></form><h5 class="section-heading">Grafana.com Dashboard</h5><div class="gf-form-group"><div class="gf-form"><input type="text" class="gf-form-input" ng-model="ctrl.gnetUrl" placeholder="Paste Grafana.com dashboard url or id" ng-blur="ctrl.checkGnetDashboard()"></div><div class="gf-form" ng-if="ctrl.gnetError"><label class="gf-form-label text-warning"><i class="fa fa-warning"></i> {{ctrl.gnetError}}</label></div></div><h5 class="section-heading">Or paste JSON</h5><div class="gf-form-group"><div class="gf-form"><textarea rows="7" data-share-panel-url="" class="gf-form-input" ng-model="ctrl.jsonText"></textarea></div><button type="button" class="btn btn-secondary" ng-click="ctrl.loadJsonText()"><i class="fa fa-paste"></i> Load</button> <span ng-if="ctrl.parseError" class="text-error p-l-1"><i class="fa fa-warning"></i> {{ctrl.parseError}}</span></div></div><div ng-if="ctrl.step === 2"><div class="gf-form-group" ng-if="ctrl.dash.gnetId"><h3 class="section-heading">Importing Dashboard from <a href="https://grafana.com/dashboards/{{ctrl.dash.gnetId}}" class="external-link" target="_blank">Grafana.com</a></h3><div class="gf-form"><label class="gf-form-label width-15">Published by</label><label class="gf-form-label width-15">{{ctrl.gnetInfo.orgName}}</label></div><div class="gf-form"><label class="gf-form-label width-15">Updated on</label><label class="gf-form-label width-15">{{ctrl.gnetInfo.updatedAt | date : \'yyyy-MM-dd HH:mm:ss\'}}</label></div></div><h3 class="section-heading">Options</h3><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form gf-form--grow"><label class="gf-form-label width-15">Name</label><input type="text" class="gf-form-input" ng-model="ctrl.dash.title" give-focus="true" ng-change="ctrl.titleChanged()" ng-class="{\'validation-error\': ctrl.nameExists || !ctrl.dash.title}"><label class="gf-form-label text-success" ng-if="!ctrl.nameExists && ctrl.dash.title"><i class="fa fa-check"></i></label></div></div><div class="gf-form-inline" ng-if="ctrl.nameExists"><div class="gf-form offset-width-15 gf-form--grow"><label class="gf-form-label text-warning gf-form-label--grow"><i class="fa fa-warning"></i> A Dashboard with the same name already exists</label></div></div><div class="gf-form-inline" ng-if="!ctrl.dash.title"><div class="gf-form offset-width-15 gf-form--grow"><label class="gf-form-label text-warning gf-form-label--grow"><i class="fa fa-warning"></i> A Dashboard should have a name</label></div></div><div ng-repeat="input in ctrl.inputs"><div class="gf-form"><label class="gf-form-label width-15">{{input.label}}<info-popover mode="right-normal">{{input.info}}</info-popover></label><div class="gf-form-select-wrapper" style="width: 100%" ng-if="input.type === \'datasource\'"><select class="gf-form-input" ng-model="input.value" ng-options="v.value as v.text for v in input.options" ng-change="ctrl.inputValueChanged()"><option value="" ng-hide="input.value">{{input.info}}</option></select></div><input ng-if="input.type === \'constant\'" type="text" class="gf-form-input" ng-model="input.value" placeholder="{{input.default}}" ng-change="ctrl.inputValueChanged()"><label class="gf-form-label text-success" ng-show="input.value"><i class="fa fa-check"></i></label></div></div></div><div class="gf-form-button-row"><button type="button" class="btn gf-form-btn btn-success width-12" ng-click="ctrl.saveDashboard()" ng-hide="ctrl.nameExists" ng-disabled="!ctrl.inputsValid"><i class="fa fa-save"></i> Import</button> <button type="button" class="btn gf-form-btn btn-danger width-12" ng-click="ctrl.saveDashboard()" ng-show="ctrl.nameExists" ng-disabled="!ctrl.inputsValid"><i class="fa fa-save"></i> Import (Overwrite)</button> <a class="btn btn-link" ng-click="dismiss()">Cancel</a> <a class="btn btn-link" ng-click="ctrl.back()">Back</a></div></div></div></div>'),a.put("public/app/features/dashboard/partials/addAnnotationModal.html",'<div class="modal-body" ng-controller="AddAnnotationModalCtrl"><div class="modal-header"><h2 class="modal-header-title">Add Annotation</h2><a class="modal-header-close" ng-click="ctrl.close()"><i class="fa fa-remove"></i></a></div><div class="modal-content"><div class="share-modal-body"><div class="share-modal-header"><div class="share-modal-big-icon"><i class="fa fa-tag"></i></div><div class="share-modal-content"><div class="gf-form-group share-modal-options"><p class="share-modal-info-text">Add annotation details.</p><div class="gf-form"><span class="gf-form-label width-8">Title</span> <input type="text" ng-model="ctrl.annotation.title" class="gf-form-input max-width-20"></div><div class="gf-form"><span class="gf-form-label width-8" ng-if="!ctrl.annotation.timeTo">Time</span> <span class="gf-form-label width-8" ng-if="ctrl.annotation.timeTo">Time Start</span> <input type="text" ng-model="ctrl.annotation.time" class="gf-form-input max-width-20"></div><div class="gf-form" ng-if="ctrl.annotation.timeTo"><span class="gf-form-label width-8">Time Stop</span> <input type="text" ng-model="ctrl.annotation.timeTo" class="gf-form-input max-width-20"></div></div><div><h6>Description</h6></div><div class="gf-form-group share-modal-options"><div class="gf-form"><textarea rows="3" class="gf-form-input width-27" ng-model="ctrl.annotation.text"></textarea></div></div><div class="gf-form-button-row"><button class="btn gf-form-btn width-10 btn-success" ng-click="ctrl.addAnnotation()"><i class="fa fa-pencil"></i> Add Annotation</button></div></div></div></div></div></div>'),a.put("public/app/features/dashboard/partials/inspector.html",'<div class="modal-body" ng-controller="InspectCtrl" ng-init="init()"><div class="modal-header"><h2 class="modal-header-title"><i class="fa fa-info-circle"></i> <span class="p-l-1">Inspector</span></h2><ul class="gf-tabs"><li class="gf-tabs-item" ng-repeat="tab in [\'Panel Description\', \'Request\', \'Response\', \'JS Error\']"><a class="gf-tabs-link" ng-click="editor.index = $index" ng-class="{active: editor.index === $index}">{{::tab}}</a></li></ul><a class="modal-header-close" ng-click="dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content"><div ng-if="editor.index == 0" ng-bind-html="panelInfoHtml"></div><div ng-if="editor.index == 1"><h5 class="section-heading">Request details</h5><table class="filter-table gf-form-group"><tr><td>Url</td><td>{{inspector.error.config.url}}</td></tr><tr><td>Method</td><td>{{inspector.error.config.method}}</td></tr><tr ng-repeat="(key, value) in inspector.error.config.headers"><td>{{key}}</td><td>{{value}}</td></tr></table><h5 class="section-heading">Request parameters</h5><table class="filter-table"><tr ng-repeat="param in request_parameters"><td>{{param.key}}</td><td>{{param.value}}</td></tr></table></div><div ng-if="editor.index == 2"><h5 ng-show="message">{{message}}</h5><pre class="small">\n{{response}}\n\t\t\t</pre></div><div ng-if="editor.index == 3"><label>Message:</label><pre>\n{{message}}\n</pre><label>Stack trace:</label><pre>\n{{stack_trace}}\n</pre></div></div></div>'),a.put("public/app/features/dashboard/partials/settings.html",'<div class="tabbed-view-header"><h2 class="tabbed-view-title">Settings</h2><ul class="gf-tabs"><li class="gf-tabs-item" ng-repeat="tab in ::[\'General\', \'Rows\', \'Links\', \'Time picker\', \'Metadata\']"><a class="gf-tabs-link" ng-click="editor.index = $index" ng-class="{active: editor.index === $index}">{{::tab}}</a></li></ul><button class="tabbed-view-close-btn" ng-click="dismiss();"><i class="fa fa-remove"></i></button></div><div class="tabbed-view-body"><div ng-if="editor.index == 0"><div class="gf-form-group section"><h5 class="section-heading">Details</h5><div class="gf-form"><label class="gf-form-label width-7">Name</label><input type="text" class="gf-form-input width-30" ng-model="dashboard.title"></div><div class="gf-form"><label class="gf-form-label width-7">Description</label><input type="text" class="gf-form-input width-30" ng-model="dashboard.description"></div><div class="gf-form"><label class="gf-form-label width-7">Tags<info-popover mode="right-normal">Press enter to add a tag</info-popover></label><bootstrap-tagsinput ng-model="dashboard.tags" tagclass="label label-tag" placeholder="add tags"></bootstrap-tagsinput></div><div class="gf-form"><label class="gf-form-label width-7">Timezone</label><div class="gf-form-select-wrapper"><select ng-model="dashboard.timezone" class="gf-form-input" ng-options="f.value as f.text for f in [{value: \'\', text: \'Default\'}, {value: \'browser\', text: \'Local browser time\'},{value: \'utc\', text: \'UTC\'}]" ng-change="timezoneChanged()"></select></div></div></div><div class="section"><h5 class="section-heading">Toggles</h5><div class="gf-form-group"><gf-form-switch class="gf-form" label="Editable" tooltip="Uncheck, then save and reload to disable all dashboard editing" checked="dashboard.editable" label-class="width-11"></gf-form-switch><gf-form-switch class="gf-form" label="Hide Controls" tooltip="Hide row controls. Shortcut: CTRL+H or CMD+H" checked="dashboard.hideControls" label-class="width-11"></gf-form-switch></div></div><div class="section"><h5 class="section-heading">Panel Options</h5><div class="gf-form"><label class="gf-form-label width-11">Graph Tooltip<info-popover mode="right-normal">Cycle between options using Shortcut: CTRL+O or CMD+O</info-popover></label><div class="gf-form-select-wrapper"><select ng-model="dashboard.graphTooltip" class="gf-form-input" ng-options="f.value as f.text for f in [{value: 0, text: \'Default\'}, {value: 1, text: \'Shared crosshair\'},{value: 2, text: \'Shared Tooltip\'}]"></select></div></div></div></div><div ng-if="editor.index == 1"><h5 class="section-heading">Rows settings</h5><div class="gf-form-group"><div class="gf-form-inline" ng-repeat="row in dashboard.rows"><div class="gf-form"><span class="gf-form-label">Title</span> <input type="text" class="gf-form-input max-width-14" ng-model="row.title"></div><gf-form-switch class="gf-form" label="Show title" checked="row.showTitle" switch-class="max-width-6"></gf-form-switch><div class="gf-form"><button class="btn btn-inverse gf-form-btn" ng-click="_.move(dashboard.rows,$index,$index-1)"><i ng-class="{\'invisible\': $first}" class="fa fa-arrow-up"></i></button> <button class="btn btn-inverse gf-from-btn" ng-click="_.move(dashboard.rows,$index,$index+1)"><i ng-class="{\'invisible\': $last}" class="fa fa-arrow-down"></i></button> <button class="btn btn-inverse gf-form-btn" ng-click="dashboard.rows = _.without(dashboard.rows,row)"><i class="fa fa-trash"></i></button></div></div></div></div><div ng-if="editor.index == 2"><dash-links-editor></dash-links-editor></div><div ng-if="editor.index == 3"><gf-time-picker-settings dashboard="dashboard"></gf-time-picker-settings></div><div ng-if="editor.index == 4"><h5 class="section-heading">Dashboard info</h5><div class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-10">Last updated at:</span> <span class="gf-form-label width-18">{{dashboard.formatDate(dashboardMeta.updated)}}</span></div><div class="gf-form"><span class="gf-form-label width-10">Last updated by:</span> <span class="gf-form-label width-18">{{dashboardMeta.updatedBy}}&nbsp;</span></div><div class="gf-form"><span class="gf-form-label width-10">Created at:</span> <span class="gf-form-label width-18">{{dashboard.formatDate(dashboardMeta.created)}}&nbsp;</span></div><div class="gf-form"><span class="gf-form-label width-10">Created by:</span> <span class="gf-form-label width-18">{{dashboardMeta.createdBy}}&nbsp;</span></div><div class="gf-form"><span class="gf-form-label width-10">Current version:</span> <span class="gf-form-label width-18">{{dashboardMeta.version}}&nbsp;</span></div></div></div></div>'),a.put("public/app/features/dashboard/partials/shareModal.html",'<div class="modal-body" ng-controller="ShareModalCtrl" ng-init="init()"><div class="modal-header"><h2 class="modal-header-title">{{modalTitle}}</h2><ul class="gf-tabs"><li class="gf-tabs-item" ng-repeat="tab in tabs"><a class="gf-tabs-link" ng-click="editor.index = $index" ng-class="{active: editor.index === $index}">{{::tab.title}}</a></li></ul><a class="modal-header-close" ng-click="dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content" ng-repeat="tab in tabs" ng-if="editor.index == $index"><div ng-include src="tab.src" class="share-modal-body"></div></div></div><script type="text/ng-template" id="shareEmbed.html"><div class="share-modal-header">\n\t\t<div class="share-modal-big-icon">\n\t\t\t<i class="fa fa-code"></i>\n\t\t</div>\n\t\t<div class="share-modal-content">\n\t\t\t<p class="share-modal-info-text">\n\t\t\t\tThe html code below can be pasted and included in another web page. Unless anonymous access\n\t\t\t\tis enabled the user viewing that page need to be signed into grafana for the graph to load.\n\t\t\t</p>\n\n\t\t\t<div ng-include src="\'shareLinkOptions.html\'"></div>\n\n\t\t\t<div class="gf-form-group gf-form--grow">\n\t\t\t\t<div class="gf-form">\n\t\t\t\t\t<textarea rows="5" data-share-panel-url class="gf-form-input" ng-model=\'iframeHtml\'></textarea>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</div>\n\t</div></script><script type="text/ng-template" id="shareExport.html"><dash-export-modal dismiss="dismiss()"></dash-export-modal></script><script type="text/ng-template" id="shareLinkOptions.html"><div class="gf-form-group">\n\t\t<gf-form-switch class="gf-form"\n\t\t\tlabel="Current time range" label-class="width-12" switch-class="max-width-6"\n\t\t\tchecked="options.forCurrent" on-change="buildUrl()">\n\t\t</gf-form-switch>\n\t\t<gf-form-switch class="gf-form"\n\t\t\tlabel="Template variables" label-class="width-12" switch-class="max-width-6"\n\t\t\tchecked="options.includeTemplateVars" on-change="buildUrl()">\n\t\t</gf-form-switch>\n\t\t<div class="gf-form">\n\t\t\t<span class="gf-form-label width-12">Theme</span>\n\t\t\t<div class="gf-form-select-wrapper width-6">\n\t\t\t\t<select class="gf-form-input" ng-model="options.theme" ng-options="f as f for f in [\'current\', \'dark\', \'light\']" ng-change="buildUrl()"></select>\n\t\t\t</div>\n\t\t</div>\n\t</div></script><script type="text/ng-template" id="shareLink.html"><div class="share-modal-header">\n\t\t<div class="share-modal-big-icon">\n\t\t\t<i class="fa fa-link"></i>\n\t\t</div>\n\t\t<div class="share-modal-content">\n\t\t\t<p class="share-modal-info-text">\n\t\t\t\tCreate a direct link to this dashboard or panel, customized with the options below.\n\t\t\t</p>\n\t\t\t<div ng-include src="\'shareLinkOptions.html\'"></div>\n\t\t\t<div>\n\t\t\t\t<div class="gf-form-group">\n\t\t\t\t\t<div class="gf-form-inline">\n\t\t\t\t\t\t<div class="gf-form gf-form--grow">\n\t\t\t\t\t\t\t<input type="text" data-share-panel-url class="gf-form-input" ng-model="shareUrl"></input>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div class="gf-form">\n\t\t\t\t\t\t\t<button class="btn btn-inverse" clipboard-button="getShareUrl()"><i class="fa fa-clipboard"></i> Copy</button>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class="gf-form" ng-show="modeSharePanel">\n\t\t\t\t<a href="{{imageUrl}}" target="_blank"><i class="fa fa-camera"></i> Direct link rendered image</a>\n\t\t\t</div>\n\t\t</div></script><script type="text/ng-template" id="shareSnapshot.html"><div class="ng-cloak" ng-cloak ng-controller="ShareSnapshotCtrl" ng-init="init()">\n\t\t<div class="share-modal-header">\n\t\t\t<div class="share-modal-big-icon">\n\t\t\t\t<i ng-if="loading" class="fa fa-spinner fa-spin"></i>\n\t\t\t\t<i ng-if="!loading" class="icon-gf icon-gf-snapshot"></i>\n\t\t\t</div>\n      <div class="share-modal-content">\n        <div ng-if="step === 1">\n          <p class="share-modal-info-text">\n            A snapshot is an instant way to share an interactive dashboard publicly.\n            When created, we <strong>strip sensitive data</strong> like queries (metric, template and annotation) and panel links,\n            leaving only the visible metric data and series names embedded into your dashboard.\n          </p>\n          <p class="share-modal-info-text">\n            Keep in mind, your <strong>snapshot can be viewed by anyone</strong> that has the link and can reach the URL.\n            Share wisely.\n          </p>\n        </div>\n\n\t\t\t\t<div class="share-modal-header" ng-if="step === 3">\n\t\t\t\t\t<p class="share-modal-info-text">\n\t\t\t\t\t\tThe snapshot has now been deleted. If it you have already accessed it once, It might take up to an hour before it is removed from\n\t\t\t\t\t\tbrowser caches or CDN caches.\n\t\t\t\t\t</p>\n\t\t\t\t</div>\n\n\t\t\t\t<div class="gf-form-group share-modal-options">\n\t\t\t\t\t<div class="gf-form" ng-if="step === 1">\n\t\t\t\t\t\t<span class="gf-form-label width-12">Snapshot name</span>\n\t\t\t\t\t\t<input type="text" ng-model="snapshot.name" class="gf-form-input max-width-15" >\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class="gf-form" ng-if="step === 1">\n\t\t\t\t\t\t<span class="gf-form-label width-12">Expire</span>\n\t\t\t\t\t\t<div class="gf-form-select-wrapper max-width-15">\n\t\t\t\t\t\t\t<select class="gf-form-input" ng-model="snapshot.expires" ng-options="f.value as f.text for f in expireOptions"></select>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\n\t\t\t\t\t<div class="gf-form" ng-if="step === 2" style="margin-top: 40px">\n\t\t\t\t\t\t<div class="gf-form-row">\n\t\t\t\t\t\t\t<a href="{{snapshotUrl}}" class="large share-modal-link" target="_blank">\n\t\t\t\t\t\t\t\t<i class="fa fa-external-link-square"></i>\n\t\t\t\t\t\t\t\t{{snapshotUrl}}\n\t\t\t\t\t\t\t</a>\n\t\t\t\t\t\t\t<br>\n\t\t\t\t\t\t\t<button class="btn btn-inverse" clipboard-button="getSnapshotUrl()"><i class="fa fa-clipboard"></i> Copy Link</button>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\n\t\t\t\t<div ng-if="step === 1">\n\t\t\t\t\t<p class="share-modal-info-text">\n\t\t\t\t\t\tYou may need to configure the timeout value if it takes a long time to collect your dashboard\'s metrics.\n\t\t\t\t\t</p>\n\t\t\t\t</div>\n\n\t\t\t\t<div class="gf-form-group share-modal-options">\n\t\t\t\t\t<div class="gf-form" ng-if="step === 1">\n\t\t\t\t\t\t<span class="gf-form-label width-12">Timeout (seconds)</span>\n\t\t\t\t\t\t<input type="number" ng-model="snapshot.timeoutSeconds" class="gf-form-input max-width-15" >\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\n\t\t\t\t<div ng-if="step === 1" class="gf-form-button-row">\n\t\t\t\t\t<button class="btn gf-form-btn width-10 btn-success" ng-click="createSnapshot()" ng-disabled="loading">\n\t\t\t\t\t\t<i class="fa fa-save"></i>\n\t\t\t\t\t\tLocal Snapshot\n\t\t\t\t\t</button>\n\t\t\t\t\t<button class="btn gf-form-btn width-16 btn-secondary" ng-if="externalEnabled" ng-click="createSnapshot(true)" ng-disabled="loading">\n\t\t\t\t\t\t<i class="fa fa-cloud-upload"></i>\n\t\t\t\t\t\t{{sharingButtonText}}\n\t\t\t\t\t</button>\n\t\t\t\t\t<a class="btn btn-link" ng-click="dismiss()">Cancel</a>\n\t\t\t\t</div>\n\n\t\t\t\t<div class="pull-right" ng-if="step === 2" style="padding: 5px">\n\t\t\t\t\tDid you make a mistake? <a class="pointer" ng-click="deleteSnapshot()" target="_blank">delete snapshot.</a>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</div>\n\t</div>\n\n</div></script>'),a.put("public/app/features/dashboard/row/add_panel.html",'<div class="dash-row-dropview"><a class="dash-row-dropview-close pointer" ng-click="ctrl.rowCtrl.closeDropView();"><i class="fa fa-remove"></i></a><div class="gf-form-inline dash-row-add-panel-form"><div class="gf-form"><input type="text" class="gf-form-input max-width-14" ng-model="ctrl.panelSearch" give-focus="true" ng-keydown="ctrl.keyDown($event)" ng-change="ctrl.panelSearchChanged()" placeholder="panel search filter"></div></div><div class="add-panel-panels-scroll"><div class="add-panel-panels"><div class="add-panel-item" ng-repeat="panel in ctrl.panelHits" ng-class="{active: $index === ctrl.activeIndex}" ng-click="ctrl.addPanel(panel)" ui-draggable="true" drag="panel.id" title="{{panel.name}}"><img class="add-panel-item-img" ng-src="{{panel.info.logos.small}}"><div class="add-panel-item-name">{{panel.name}}</div></div></div></div></div>'),a.put("public/app/features/dashboard/row/options.html",'<div class="dash-row-dropview"><a class="dash-row-dropview-close pointer" ng-click="ctrl.rowCtrl.closeDropView();"><i class="fa fa-remove"></i></a><div><div class="section"><div class="gf-form"><span class="gf-form-label width-6">Title</span> <input type="text" class="gf-form-input max-width-14" ng-model="ctrl.row.title"></div><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label width-6">Size</label><div class="gf-form-select-wrapper"><select class="input-small gf-form-input" ng-model="ctrl.row.titleSize" ng-options="f for f in ctrl.fontSizes"></select></div></div><gf-form-switch class="gf-form" label="Show" checked="ctrl.row.showTitle"></gf-form-switch></div></div><div class="section"><div class="gf-form"><span class="gf-form-label width-7">Height</span> <input type="text" class="gf-form-input max-width-14" ng-model="ctrl.row.height"></div><div class="gf-form"><span class="gf-form-label width-7">Repeat for</span><dash-repeat-option model="ctrl.row"></dash-repeat-option></div></div></div></div>'),
a.put("public/app/features/dashboard/row/row.html",'<div class="dash-row-header" ng-if="ctrl.row.showTitle || ctrl.row.collapse"><a class="dash-row-header-title" ng-click="ctrl.toggleCollapse()"><span class="dash-row-collapse-toggle pointer"><i class="fa fa-chevron-down" ng-show="!ctrl.row.collapse"></i> <i class="fa fa-chevron-right" ng-show="ctrl.row.collapse"></i> </span><span ng-class="ctrl.row.titleSize">{{ctrl.row.title | interpolateTemplateVars:this}}</span></a></div><div ng-if="ctrl.dropView === 1"><dash-row-add-panel row-ctrl="ctrl"></dash-row-add-panel></div><div ng-if="ctrl.dropView === 2"><dash-row-options row-ctrl="ctrl"></dash-row-options></div><div class="panels-wrapper" ng-if="!ctrl.row.collapse"><div class="dash-row-menu-container" data-click-hide ng-hide="ctrl.dashboard.meta.fullscreen"><ul class="dash-row-menu" role="menu"><li><a ng-click="ctrl.toggleCollapse()"><i class="fa fa-minus"></i> Collapse</a></li><li ng-show="ctrl.dashboard.meta.canEdit"><a ng-click="ctrl.onMenuAddPanel()"><i class="fa fa-plus"></i> Add Panel</a></li><li ng-show="ctrl.dashboard.meta.canEdit"><a ng-click="ctrl.onMenuRowOptions()"><i class="fa fa-cog"></i> Row Options</a></li><li ng-show="ctrl.dashboard.meta.canEdit"><a ng-click="ctrl.moveRow(-1)"><i class="fa fa-arrow-up"></i> Move Up</a></li><li ng-show="ctrl.dashboard.meta.canEdit"><a ng-click="ctrl.moveRow(1)"><i class="fa fa-arrow-down"></i> Move Down</a></li><li ng-show="ctrl.dashboard.meta.canEdit"><a ng-click="ctrl.onMenuDeleteRow()"><i class="fa fa-trash"></i> Remove</a></li></ul><div class="dash-row-menu-grip"><i class="fa fa-ellipsis-v"></i></div></div><div ng-repeat="panel in ctrl.row.panels track by panel.id" class="panel" ui-draggable="!ctrl.dashboard.meta.fullscreen" drag="panel.id" ui-on-drop="ctrl.onDrop($data, panel)" drag-handle-class="drag-handle" panel-width><plugin-component type="panel" class="panel-margin"></plugin-component></div><div panel-drop-zone class="panel panel-drop-zone" ui-on-drop="ctrl.onDrop($data)" data-drop="true"><div class="panel-margin"><div class="panel-container"><div class="panel-drop-zone-text"></div></div></div></div><div class="clearfix"></div></div>'),a.put("public/app/features/dashboard/submenu/submenu.html",'<div class="submenu-controls"><div ng-repeat="variable in ctrl.variables" ng-hide="variable.hide === 2" class="submenu-item gf-form-inline"><div class="gf-form"><label class="gf-form-label template-variable" ng-hide="variable.hide === 1">{{variable.label || variable.name}}</label><value-select-dropdown ng-if="variable.type !== \'adhoc\'" variable="variable" on-updated="ctrl.variableUpdated(variable)"></value-select-dropdown></div><ad-hoc-filters ng-if="variable.type === \'adhoc\'" variable="variable"></ad-hoc-filters></div><div ng-if="ctrl.dashboard.annotations.list.length > 0"><div ng-repeat="annotation in ctrl.dashboard.annotations.list" ng-hide="annotation.hide" class="submenu-item" ng-class="{\'annotation-disabled\': !annotation.enable}"><gf-form-switch class="gf-form" label="{{annotation.name}}" checked="annotation.enable" on-change="ctrl.annotationStateChanged()"></gf-form-switch></div></div><div class="gf-form gf-form--grow"></div><div ng-if="ctrl.dashboard.links.length > 0"><dash-links-container links="ctrl.dashboard.links" class="gf-form-inline"></dash-links-container></div><div class="clearfix"></div></div>'),a.put("public/app/features/dashboard/timepicker/dropdown.html",'<div class="row pull-right"><form name="timeForm" class="gf-timepicker-absolute-section"><h3>Time range</h3><label class="small">From:</label><div class="gf-form-inline"><div class="gf-form max-width-28"><input type="text" class="gf-form-input input-large" ng-model="ctrl.editTimeRaw.from" input-datetime></div><div class="gf-form"><button class="btn gf-form-btn btn-primary" type="button" ng-click="openFromPicker=!openFromPicker"><i class="fa fa-calendar"></i></button></div></div><div ng-if="openFromPicker"><datepicker ng-model="ctrl.absolute.fromJs" class="gf-timepicker-component" show-weeks="false" starting-day="ctrl.firstDayOfWeek" ng-change="ctrl.absoluteFromChanged()"></datepicker></div><label class="small">To:</label><div class="gf-form-inline"><div class="gf-form max-width-28"><input type="text" class="gf-form-input input-large" ng-model="ctrl.editTimeRaw.to" input-datetime></div><div class="gf-form"><button class="btn gf-form-btn btn-primary" type="button" ng-click="openToPicker=!openToPicker"><i class="fa fa-calendar"></i></button></div></div><div ng-if="openToPicker"><datepicker ng-model="ctrl.absolute.toJs" class="gf-timepicker-component" show-weeks="false" starting-day="ctrl.firstDayOfWeek" ng-change="ctrl.absoluteToChanged()"></datepicker></div><label class="small">Refreshing every:</label><div class="gf-form-inline"><div class="gf-form max-width-28"><select ng-model="ctrl.refresh.value" class="gf-form-input input-medium" ng-options="f.value as f.text for f in ctrl.refresh.options"></select></div><div class="gf-form"><button type="submit" class="btn gf-form-btn btn-secondary" ng-click="ctrl.applyCustom();" ng-disabled="!timeForm.$valid">Apply</button></div></div></form><div class="gf-timepicker-relative-section"><h3>Quick ranges</h3><ul ng-repeat="group in ctrl.timeOptions"><li bindonce ng-repeat="option in group" ng-class="{active: option.active}"><a ng-click="ctrl.setRelativeFilter(option)" bo-text="option.display"></a></li></ul></div></div><div class="clearfix"></div>'),a.put("public/app/features/dashboard/timepicker/settings.html",'<div class="editor-row"><div class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-10">Auto-refresh</span> <input type="text" class="gf-form-input max-width-25" ng-model="ctrl.panel.refresh_intervals" array-join></div><div class="gf-form"><span class="gf-form-label width-10">Now delay now-</span> <input type="text" class="gf-form-input max-width-25" ng-model="ctrl.panel.nowDelay" placeholder="0m" valid-time-span bs-tooltip="\'Enter 1m to ignore the last minute (because it can contain incomplete metrics)\'" data-placement="right"></div></div></div>'),a.put("public/app/features/dashboard/timepicker/timepicker.html",'<ul class="nav gf-timepicker-nav"><li class="dashnav-move-timeframe gf-timepicker-time-control" bs-tooltip="\'Shift time backward <br> (left arrow key)\'" data-placement="bottom"><a ng-click="ctrl.move(-1)"><i class="fa fa-chevron-left"></i></a></li><li class="dashnav-zoom-out gf-timepicker-time-control" bs-tooltip="\'Time range zoom out <br> CTRL+Z\'" data-placement="bottom"><a ng-click="ctrl.zoom(2)">Zoom Out</a></li><li class="dashnav-move-timeframe gf-timepicker-time-control" bs-tooltip="\'Shift time forward <br> (right arrow key)\'" data-placement="bottom"><a ng-click="ctrl.move(1)"><i class="fa fa-chevron-right"></i></a></li><li><a bs-tooltip="ctrl.tooltip" data-placement="bottom" ng-click="ctrl.openDropdown()" class="gf-timepicker-nav-btn"><i class="fa fa-clock-o"></i> <span ng-bind="ctrl.rangeString"></span> <span ng-show="ctrl.isUtc" class="gf-timepicker-utc">UTC </span><span ng-show="ctrl.dashboard.refresh" class="text-warning">&nbsp; Refresh every {{ctrl.dashboard.refresh}}</span></a></li><li class="dashnav-refresh-action"><a ng-click="ctrl.timeSrv.refreshDashboard()"><i class="fa fa-refresh"></i></a></li></ul>'),a.put("public/app/features/dashlinks/editor.html",'<div class="editor-row"><h5 class="section-heading">Links and Dash Navigation</h5><div ng-repeat="link in dashboard.links"><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-6">Type</span><div class="gf-form-select-wrapper width-10"><select class="gf-form-input" ng-model="link.type" ng-options="f for f in [\'dashboards\',\'link\']" ng-change="updated()"></select></div></div><div class="gf-form" ng-show="link.type === \'dashboards\'"><span class="gf-form-label">With tags</span><bootstrap-tagsinput ng-model="link.tags" tagclass="label label-tag" placeholder="add tags"></bootstrap-tagsinput></div><div class="gf-form" ng-show="link.type === \'dashboards\'"><editor-checkbox text="As dropdown" model="link.asDropdown" change="updated()"></editor-checkbox></div><div class="gf-form max-width-30" ng-show="link.type === \'link\'"><li class="gf-form-label width-6">Url</li><input type="text" ng-model="link.url" class="gf-form-input" ng-model-onblur ng-change="updated()"></div><div class="gf-form"><button class="btn btn-inverse btn-mini" ng-click="moveLink($index, -1)" ng-hide="$first"><i class="fa fa-arrow-up"></i></button></div><div class="gf-form"><button class="btn btn-inverse btn-mini" ng-click="moveLink($index, 1)" ng-hide="$last"><i class="fa fa-arrow-down"></i></button></div><div class="gf-form"><button class="btn btn-inverse btn-mini" ng-click="deleteLink($index)"><i class="fa fa-trash"></i></button></div></div><div class="gf-form" ng-show="link.type === \'dashboards\' && link.asDropdown"><span class="gf-form-label width-6">Title</span> <input type="text" ng-model="link.title" class="gf-form-input max-width-25" ng-model-onblur ng-change="updated()"></div><div class="gf-form-inline" ng-show="link.type === \'link\'"><div class="gf-form"><span class="gf-form-label width-6">Title</span> <input type="text" ng-model="link.title" class="gf-form-input max-width-10" ng-model-onblur ng-change="updated()"></div><div class="gf-form"><span class="gf-form-label width-6">Tooltip</span> <input type="text" ng-model="link.tooltip" class="gf-form-input max-width-10" placeholder="Open dashboard" ng-model-onblur ng-change="updated()"></div><div class="gf-form"><span class="gf-form-label width-6">Icon</span><div class="gf-form-select-wrapper max-width-10"><select class="gf-form-input" ng-model="link.icon" ng-options="k as k for (k, v) in iconMap" ng-change="updated()"></select></div></div></div><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-6">Include</span><editor-checkbox text="Time range" model="link.keepTime" change="updated()"></editor-checkbox><editor-checkbox text="Variable values" model="link.includeVars" change="updated()"></editor-checkbox><editor-checkbox text="Open in new tab " model="link.targetBlank" change="updated()"></editor-checkbox></div></div></div></div></div><button class="btn btn-inverse" ng-click="addLink()"><i class="fa fa-plus"></i> Add link</button>'),a.put("public/app/features/org/partials/add_user.html",'<div class="modal-body" ng-controller="UserInviteCtrl" ng-init="init()"><div class="modal-header"><h2 class="modal-header-title">Add Users</h2><a class="modal-header-close" ng-click="dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content"><div class="modal-tagline p-b-2">Add existing Grafana users to the organization <span class="highlight-word">{{contextSrv.user.orgName}}</span></div><form name="inviteForm"><div class="gf-form-group"><div class="gf-form-inline" ng-repeat="invite in invites"><div class="gf-form max-width-21"><span class="gf-form-label">Email or Username</span> <input type="text" ng-model="invite.loginOrEmail" required class="gf-form-input" placeholder="email@test.com"></div><div class="gf-form max-width-10"><span class="gf-form-label">Role</span><select ng-model="invite.role" class="gf-form-input" ng-options="f for f in [\'Viewer\', \'Editor\', \'Read Only Editor\', \'Admin\']"></select></div><div class="gf-form gf-size-auto"><a class="gf-form-label pointer" tabindex="1" ng-click="removeInvite(invite)"><i class="fa fa-remove"></i></a></div></div></div><div class="gf-form-inline gf-form-group"><div class="gf-form"><a class="btn btn-inverse btn-small" ng-click="addInvite()"><i class="fa fa-plus"></i> Add another</a></div></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="sendInvites();">Add Users</button> <a class="btn-text" ng-click="dismiss()">Cancel</a></div><div class="clearfix"></div></form></div></div>'),a.put("public/app/features/org/partials/apikeyModal.html",'<div class="modal-body"><div class="modal-header"><h2 class="modal-header-title"><i class="fa fa-key"></i> <span class="p-l-1">API Key Created</span></h2><a class="modal-header-close" ng-click="dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content"><div class="gf-form-group"><div class="gf-form"><span class="gf-form-label">Key</span> <span class="gf-form-label">{{key}}</span></div></div><div class="grafana-info-box" style="border: 0">You will only be able to view this key here once! It is not stored in this form. So be sure to copy it now.<br><br>You can authenticate request using the Authorization HTTP header, example:<br><br><pre class="small">\ncurl -H "Authorization: Bearer {{key}}" {{rootPath}}/api/dashboards/home\n\t\t\t</pre></div></div></div>'),a.put("public/app/features/org/partials/change_password.html",'<navbar model="navModel"></navbar><div class="page-container"><div class="page-header"><h1>Change password</h1></div><div ng-if="ldapEnabled || authProxyEnabled">You cannot change password when ldap or auth proxy authentication is enabled.<br><br><a class="btn-text" href="profile">Back to profile</a></div><form name="userForm" class="gf-form-group" ng-hide="ldapEnabled || authProxyEnabled"><div class="gf-form"><span class="gf-form-label width-10">Old Password</span> <input class="gf-form-input max-width-21" type="password" required ng-model="command.oldPassword"></div><div class="gf-form"><span class="gf-form-label width-10">New Password</span> <input class="gf-form-input max-width-21" type="password" required ng-minlength="4" ng-model="command.newPassword"></div><div class="gf-form"><span class="gf-form-label width-10">Confirm Password</span> <input class="gf-form-input max-width-21" type="password" required ng-minlength="4" ng-model="command.confirmNew"></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="changePassword()">Change Password</button> <a class="btn-text" href="profile">Cancel</a></div></form></div>'),a.put("public/app/features/org/partials/invite.html",'<div class="modal-body" ng-controller="UserInviteCtrl" ng-init="init()"><div class="modal-header"><h2 class="modal-header-title">Invite Users</h2><a class="modal-header-close" ng-click="dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content"><div class="modal-tagline p-b-2">Send invite or add existing Grafana users to the organization <span class="highlight-word">{{contextSrv.user.orgName}}</span></div><form name="inviteForm"><div class="gf-form-group"><div class="gf-form-inline" ng-repeat="invite in invites"><div class="gf-form max-width-21"><span class="gf-form-label">Email or Username</span> <input type="text" ng-model="invite.loginOrEmail" required class="gf-form-input" placeholder="email@test.com"></div><div class="gf-form max-width-14"><span class="gf-form-label">Name</span> <input type="text" ng-model="invite.name" class="gf-form-input" placeholder="name (optional)"></div><div class="gf-form max-width-10"><span class="gf-form-label">Role</span><select ng-model="invite.role" class="gf-form-input" ng-options="f for f in [\'Viewer\', \'Editor\', \'Read Only Editor\', \'Admin\']"></select></div><div class="gf-form gf-size-auto"><a class="gf-form-label pointer" tabindex="1" ng-click="removeInvite(invite)"><i class="fa fa-remove"></i></a></div></div></div><div class="gf-form-inline gf-form-group"><div class="gf-form"><a class="btn btn-inverse btn-small" ng-click="addInvite()"><i class="fa fa-plus"></i> Invite another</a></div><div class="gf-form"><editor-checkbox text="Skip sending invite email" model="options.skipEmails" change="targetBlur()"></editor-checkbox></div></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="sendInvites();">Invite Users</button> <a class="btn-text" ng-click="dismiss()">Cancel</a></div><div class="clearfix"></div></form></div></div>'),a.put("public/app/features/org/partials/newOrg.html",'<navbar model="navModel"></navbar><div class="page-container" ng-form="playlistEditForm"><div class="page-header"><h1>New Organization</h1></div><p class="playlist-description">Each organization contains their own dashboards, data sources and configuration, and cannot be shared between orgs. While users may belong to more than one, mutiple organization are most frequently used in multi-tenant deployments.</p><form><div class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-10">Org. name</span> <input type="text" ng-model="newOrg.name" required class="gf-form-input max-width-21" placeholder="organization name"></div><br><div class="gf-form-buttons-row"><button type="submit" class="btn btn-success" ng-click="createOrg()">Create</button></div></div></form></div>'),a.put("public/app/features/org/partials/orgApiKeys.html",'<navbar model="navModel"></navbar><div class="page-container"><div class="page-header"><h1>API Keys</h1></div><h3 class="page-heading">Add new</h3><form name="addTokenForm" class="gf-form-group"><div class="gf-form-inline"><div class="gf-form max-width-21"><span class="gf-form-label">Add a key</span> <input type="text" class="gf-form-input" ng-model="token.name" placeholder="Name"></div><div class="gf-form"><span class="gf-form-label">Role</span><select class="gf-form-input gf-size-auto" ng-model="token.role" ng-options="r for r in roleTypes"></select></div><div class="gf-form"><button class="btn gf-form-btn btn-success" ng-click="addToken()">Add</button></div></div></form><h3 class="page-heading">Existing Keys</h3><table class="filter-table"><thead><tr><th>Name</th><th>Role</th><th style="width: 34px"></th></tr></thead><tbody><tr ng-repeat="t in tokens"><td>{{t.name}}</td><td>{{t.role}}</td><td><a ng-click="removeToken(t.id)" class="btn btn-danger btn-mini"><i class="fa fa-remove"></i></a></td></tr></tbody></table></div>'),a.put("public/app/features/org/partials/orgDetails.html",'<navbar model="navModel"></navbar><div class="page-container"><div class="page-header"><h1>Org Preferences</h1></div><h3 class="page-heading">General</h3><form name="orgForm" class="gf-form-group"><div class="gf-form-inline"><div class="gf-form max-width-28"><span class="gf-form-label width-6">Name</span> <input class="gf-form-input" type="text" required ng-model="org.name"></div><div class="gf-form"><button type="submit" class="btn gf-form-btn btn-success" ng-click="update()">Update</button></div></div></form><prefs-control mode="org"></prefs-control><h3 class="page-heading">Address</h3><form name="addressForm" class="gf-form-group"><div class="gf-form-inline"><div class="gf-form max-width-28"><span class="gf-form-label width-7">Address1</span> <input class="gf-form-input" type="text" ng-model="address.address1"></div><div class="gf-form max-width-28"><span class="gf-form-label width-7">Address2</span> <input class="gf-form-input" type="text" ng-model="address.address2"></div></div><div class="gf-form-inline"><div class="gf-form max-width-28"><span class="gf-form-label width-7">City</span> <input class="gf-form-input" type="text" ng-model="address.city"></div><div class="gf-form max-width-28"><span class="gf-form-label width-7">Postal code</span> <input class="gf-form-input" type="text" ng-model="address.zipCode"></div></div><div class="gf-form-inline"><div class="gf-form max-width-28"><span class="gf-form-label width-7">State</span> <input class="gf-form-input" type="text" ng-model="address.state"></div><div class="gf-form max-width-28"><span class="gf-form-label width-7">Country</span> <input class="gf-form-input" type="text" ng-model="address.country"></div></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="updateAddress()">Update</button></div></form><h3 class="page-heading">Admin Pages</h3><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><a href="org/users" class="btn gf-form-btn btn-inverse">Users &amp; Roles</a></div><div class="gf-form"><a href="org/apikeys" class="btn gf-form-btn btn-inverse">API Keys</a></div></div></div></div>'),a.put("public/app/features/org/partials/orgUsers.html",'<navbar model="ctrl.navModel"></navbar><div class="page-container"><div class="page-header"><h1>Organization users</h1><div class="page-header-tabs"><button class="btn btn-success" ng-click="ctrl.openAddUsersView()" ng-hide="ctrl.externalUserMngLinkUrl"><i class="fa fa-plus"></i> <span>{{ctrl.addUsersBtnName}}</span></button> <a class="btn btn-inverse" ng-href="{{ctrl.externalUserMngLinkUrl}}" target="_blank" ng-if="ctrl.externalUserMngLinkUrl"><i class="fa fa-external-link-square"></i> {{ctrl.addUsersBtnName}}</a><ul class="gf-tabs"><li class="gf-tabs-item"><a class="gf-tabs-link" ng-click="ctrl.editor.index = 0" ng-class="{active: ctrl.editor.index === 0}">Users ({{ctrl.users.length}})</a></li><li class="gf-tabs-item" ng-show="ctrl.pendingInvites.length"><a class="gf-tabs-link" ng-click="ctrl.editor.index = 1" ng-class="{active: ctrl.editor.index === 1}">Pending Invitations ({{ctrl.pendingInvites.length}})</a></li></ul></div></div><div class="grafana-info-box" ng-if="ctrl.externalUserMngInfo"><span ng-bind-html="ctrl.externalUserMngInfo"></span></div><div ng-if="ctrl.editor.index === 0" class="tab-content"><table class="filter-table form-inline"><thead><tr><th>Login</th><th>Email</th><th>Seen<tip>Time since user was seen using Grafana</tip></th><th>Role</th><th style="width: 34px"></th></tr></thead><tr ng-repeat="user in ctrl.users"><td>{{user.login}}</td><td><span class="ellipsis">{{user.email}}</span></td><td>{{user.lastSeenAtAge}}</td><td><select type="text" ng-model="user.role" class="input-medium" ng-options="f for f in [\'Viewer\', \'Editor\', \'Read Only Editor\', \'Admin\']" ng-change="ctrl.updateOrgUser(user)"></select></td><td><a ng-click="ctrl.removeUser(user)" class="btn btn-danger btn-mini"><i class="fa fa-remove"></i></a></td></tr></table></div><div ng-if="ctrl.editor.index === 1"><table class="filter-table form-inline"><thead><tr><th>Email</th><th>Name</th><th></th></tr></thead><tbody ng-repeat="invite in ctrl.pendingInvites"><tr ng-click="invite.expanded = !invite.expanded" ng-class="{\'expanded\': invite.expanded}"><td>{{invite.email}}</td><td>{{invite.name}}</td><td class="text-right"><button class="btn btn-inverse btn-mini" clipboard-button="ctrl.getInviteUrl(invite)" ng-click="ctrl.copyInviteToClipboard($event)"><i class="fa fa-clipboard"></i> Copy Invite</button> &nbsp; <button class="btn btn-inverse btn-mini">Details <i ng-show="!invite.expanded" class="fa fa-caret-right"></i> <i ng-show="invite.expanded" class="fa fa-caret-down"></i></button></td></tr><tr ng-show="invite.expanded"><td colspan="3"><a href="{{invite.url}}">{{invite.url}}</a><br><br>&nbsp; <button class="btn btn-inverse btn-mini" ng-click="ctrl.revokeInvite(invite, $event)"><i class="fa fa-remove" style="color: red"></i> Revoke invite</button> <span style="padding-left: 15px">Invited: <em>{{invite.createdOn | date: \'shortDate\'}} by {{invite.invitedBy}}</em></span></td></tr></tbody></table></div></div>'),a.put("public/app/features/org/partials/profile.html",'<navbar model="ctrl.navModel"></navbar><div class="page-container"><div class="page-header"><h1>User Profile</h1></div><form name="ctrl.userForm" class="gf-form-group"><h3 class="page-heading">Information</h3><div class="gf-form max-width-30"><span class="gf-form-label width-8">Name</span> <input class="gf-form-input max-width-22" type="text" required ng-model="ctrl.user.name"></div><div class="gf-form max-width-30"><span class="gf-form-label width-8">Email</span> <input class="gf-form-input max-width-22" type="email" ng-readonly="ctrl.readonlyLoginFields" required ng-model="ctrl.user.email"> <i ng-if="ctrl.readonlyLoginFields" class="fa fa-lock gf-form-icon--right-absolute" bs-tooltip="\'Login Details Locked - managed in another system.\'"></i></div><div class="gf-form max-width-30"><span class="gf-form-label width-8">Username</span> <input class="gf-form-input max-width-22" type="text" ng-readonly="ctrl.readonlyLoginFields" required ng-model="ctrl.user.login"> <i ng-if="ctrl.readonlyLoginFields" class="fa fa-lock gf-form-icon--right-absolute" bs-tooltip="\'Login Details Locked - managed in another system.\'"></i></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="ctrl.update()">Update</button></div></form><prefs-control mode="user"></prefs-control><h3 class="page-heading">Password</h3><div class="gf-form-group"><a href="profile/password" class="btn btn-inverse">Change Password</a></div><h3 class="page-heading" ng-show="ctrl.showOrgsList">Organizations</h3><div class="gf-form-group" ng-show="ctrl.showOrgsList"><table class="filter-table form-inline"><thead><tr><th>Name</th><th>Role</th><th></th></tr></thead><tbody><tr ng-repeat="org in ctrl.orgs"><td>{{org.name}}</td><td>{{org.role}}</td><td class="text-right"><span class="btn btn-primary btn-mini" ng-show="org.orgId === contextSrv.user.orgId">Current </span><a ng-click="ctrl.setUsingOrg(org)" class="btn btn-inverse btn-mini" ng-show="org.orgId !== contextSrv.user.orgId">Select</a></td></tr></tbody></table></div></div>'),a.put("public/app/features/org/partials/select_org.html",'<div class="container"><div class="signup-page-background"></div><div class="login-box"><div class="login-box-logo"><img src="img/logo_transparent_200x75.png"></div><div class="invite-box"><h3><i class="fa fa-users"></i>&nbsp; Change active organization</h3><div class="modal-tagline">You have been added to another Organization<br>due to an open invitation!<br><br>Please select which organization you want to<br>use right now (you can change this later at any time).</div><div style="display: inline-block; width: 400px; margin: 30px 0"><table class="grafana-options-table"><tr ng-repeat="org in orgs"><td class="nobg max-width-btns"><a ng-click="setUsingOrg(org)" class="btn btn-inverse">{{org.name}} ({{org.role}})</a></td></tr></table></div></div><div class="row" style="margin-top: 50px"><div class="version-footer text-center small">Grafana version: {{buildInfo.version}}, commit: {{buildInfo.commit}}, build date: {{buildInfo.buildstamp | date: \'yyyy-MM-dd HH:mm:ss\' }}</div></div></div></div>'),a.put("public/app/features/panel/partials/metrics_tab.html",'<div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label gf-query-ds-label"><i class="icon-gf icon-gf-datasources"></i></label><label class="gf-form-label">Data Source</label><gf-form-dropdown model="ctrl.panelDsValue" css-class="gf-size-auto" lookup-text="true" get-options="ctrl.getOptions(true)" on-change="ctrl.datasourceChanged($option)"></gf-form-dropdown></div><div class="gf-form gf-form--grow"><label class="gf-form-label gf-form-label--grow"></label></div><div class="gf-form" ng-if="ctrl.queryOptions"><a class="gf-form-label" ng-click="ctrl.toggleOptions()"><i class="fa fa-fw fa-caret-right" ng-hide="ctrl.optionsOpen"></i><i class="fa fa-fw fa-caret-down" ng-show="ctrl.optionsOpen"></i>Options</a></div><div class="gf-form" ng-if="ctrl.hasQueryHelp"><button class="gf-form-label" ng-click="ctrl.toggleHelp()"><i class="fa fa-fw fa-caret-right" ng-hide="ctrl.helpOpen"></i><i class="fa fa-fw fa-caret-down" ng-show="ctrl.helpOpen"></i>Help</button></div><div class="gf-form"><button class="gf-form-label" ng-click="ctrl.toggleQueryTroubleshooter()" bs-tooltip="\'Display query request & response\'"><i class="fa fa-fw fa-caret-right" ng-hide="ctrl.queryTroubleshooterOpen"></i><i class="fa fa-fw fa-caret-down" ng-show="ctrl.queryTroubleshooterOpen"></i>Query Inspector</button></div></div><div><div ng-if="ctrl.optionsOpen"><div class="gf-form gf-form--flex-end" ng-if="ctrl.queryOptions.minInterval"><label class="gf-form-label">Min time interval</label><input type="text" class="gf-form-input width-6" placeholder="{{ctrl.panelCtrl.interval}}" ng-model="ctrl.panel.interval" spellcheck="false" ng-model-onblur ng-change="ctrl.panelCtrl.refresh()"><info-popover mode="right-absolute">A lower limit for the auto group by time interval. Recommended to be set to write frequency, for example <code>1m</code> if your data is written every minute. Access auto interval via variable <code>$__interval</code> for time range string and <code>$__interval_ms</code> for numeric variable that can be used in math expressions.</info-popover></div><div class="gf-form gf-form--flex-end" ng-if="ctrl.queryOptions.cacheTimeout"><label class="gf-form-label width-9">Cache timeout</label><input type="text" class="gf-form-input width-6" placeholder="60" ng-model="ctrl.panel.cacheTimeout" ng-model-onblur ng-change="ctrl.panelCtrl.refresh()" spellcheck="false"><info-popover mode="right-absolute">If your time series store has a query cache this option can override the default cache timeout. Specify a numeric value in seconds.</info-popover></div><div class="gf-form gf-form--flex-end" ng-if="ctrl.queryOptions.maxDataPoints"><label class="gf-form-label width-9">Max data points</label><input type="text" class="gf-form-input width-6" placeholder="auto" ng-model-onblur ng-change="ctrl.panelCtrl.refresh()" ng-model="ctrl.panel.maxDataPoints" spellcheck="false"><info-popover mode="right-absolute">The maximum data points the query should return. For graphs this is automatically set to one data point per pixel.</info-popover></div></div><div class="grafana-info-box" ng-if="ctrl.helpOpen"><div class="markdown-html" ng-bind-html="ctrl.helpHtml"></div><a class="grafana-info-box__close" ng-click="ctrl.toggleHelp()"><i class="fa fa-chevron-up"></i></a></div><query-troubleshooter panel-ctrl="ctrl.panelCtrl" is-open="ctrl.queryTroubleshooterOpen"></query-troubleshooter></div></div><div class="query-editor-rows gf-form-group" ng-if="ctrl.datasourceInstance"><div ng-repeat="target in ctrl.panel.targets" ng-class="{\'gf-form-disabled\': target.hide}"><rebuild-on-change property="ctrl.panel.datasource || target.datasource" show-null="true"><plugin-component type="query-ctrl"></plugin-component></rebuild-on-change></div><div class="gf-form-query"><div class="gf-form gf-form-query-letter-cell"><label class="gf-form-label"><span class="gf-form-query-letter-cell-carret"><i class="fa fa-caret-down"></i> </span><span class="gf-form-query-letter-cell-letter">{{ctrl.panelCtrl.nextRefId}}</span></label><button class="btn btn-secondary gf-form-btn" ng-click="ctrl.addQuery()" ng-hide="ctrl.datasourceInstance.meta.mixed">Add Query</button><div class="dropdown" ng-if="ctrl.datasourceInstance.meta.mixed"><gf-form-dropdown model="ctrl.addQueryDropdown" get-options="ctrl.getOptions(false)" on-change="ctrl.addMixedQuery($option)"></gf-form-dropdown></div></div></div></div>'),a.put("public/app/features/panel/partials/panelTime.html",'<div class="gf-form-group"><div class="gf-form"><span class="gf-form-label"><i class="fa fa-clock-o"></i> </span><span class="gf-form-label width-12">Override relative time</span> <span class="gf-form-label width-6">Last</span> <input type="text" class="gf-form-input max-width-8" placeholder="1h" empty-to-null ng-model="ctrl.panel.timeFrom" valid-time-span ng-change="ctrl.refresh()" ng-model-onblur></div><div class="gf-form"><span class="gf-form-label"><i class="fa fa-clock-o"></i> </span><span class="gf-form-label width-12">Add time shift</span> <span class="gf-form-label width-6">Amount</span> <input type="text" class="gf-form-input max-width-8" placeholder="1h" empty-to-null ng-model="ctrl.panel.timeShift" valid-time-span ng-change="ctrl.refresh()" ng-model-onblur></div><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label"><i class="fa fa-clock-o"></i></span></div><gf-form-switch class="gf-form max-width-30" label="Hide time override info" label-class="width-12" checked="ctrl.panel.hideTimeOverride" switch-class="max-width-6" on-change="ctrl.refresh()"></gf-form-switch></div></div>'),a.put("public/app/features/panel/partials/query_editor_row.html",'<div class="gf-form-query"><div class="gf-form gf-form-query-letter-cell"><label class="gf-form-label"><a class="pointer" tabindex="1" ng-click="ctrl.toggleCollapse()"><span ng-class="{muted: !ctrl.canCollapse}" class="gf-form-query-letter-cell-carret"><i class="fa fa-caret-down" ng-hide="ctrl.collapsed"></i> <i class="fa fa-caret-right" ng-show="ctrl.collapsed"></i> </span><span class="gf-form-query-letter-cell-letter">{{ctrl.target.refId}}</span> <em class="gf-form-query-letter-cell-ds" ng-show="ctrl.target.datasource">({{ctrl.target.datasource}})</em></a></label></div><div class="gf-form-query-content gf-form-query-content--collapsed" ng-if="ctrl.collapsed"><div class="gf-form"><label class="gf-form-label pointer gf-form-label--grow" ng-click="ctrl.toggleCollapse()">{{ctrl.collapsedText}}</label></div></div><div ng-transclude class="gf-form-query-content" ng-if="!ctrl.collapsed"></div><div class="gf-form"><label class="gf-form-label dropdown"><a class="pointer dropdown-toggle" data-toggle="dropdown" tabindex="1"><i class="fa fa-bars"></i></a><ul class="dropdown-menu pull-right" role="menu"><li role="menuitem" ng-if="ctrl.hasTextEditMode"><a tabindex="1" ng-click="ctrl.toggleEditorMode()">Toggle Edit Mode</a></li><li role="menuitem"><a tabindex="1" ng-click="ctrl.duplicateQuery()">Duplicate</a></li><li role="menuitem"><a tabindex="1" ng-click="ctrl.moveQuery(-1)">Move up</a></li><li role="menuitem"><a tabindex="1" ng-click="ctrl.moveQuery(1)">Move down</a></li></ul></label><label class="gf-form-label"><a ng-click="ctrl.toggleHideQuery()" role="menuitem"><i class="fa fa-eye"></i></a></label><label class="gf-form-label"><a class="pointer" tabindex="1" ng-click="ctrl.removeQuery(ctrl.target)"><i class="fa fa-trash"></i></a></label></div></div>'),
a.put("public/app/features/panel/partials/soloPanel.html",'<div class="panel panel--solo" ng-if="panel" style="width: 100%"><plugin-component type="panel"></plugin-component></div><div class="clearfix"></div>'),a.put("public/app/features/panellinks/module.html",'<div class="editor-row"><h5 class="section-heading">Drilldown / detail link<tip>These links appear in the dropdown menu in the panel menu.</tip></h5><div class="gf-form-group" ng-repeat="link in panel.links"><div class="section"><div class="gf-form max-width-25"><span class="gf-form-label width-7">Type</span><div class="gf-form-select-wrapper gf-form--grow"><select class="gf-form-input" ng-model="link.type" ng-options="f for f in [\'dashboard\',\'absolute\']"></select></div></div><div class="gf-form max-width-25"><span class="gf-form-label width-7" ng-show="link.type === \'dashboard\'">Dashboard</span> <input ng-show="link.type === \'dashboard\'" type="text" ng-model="link.dashboard" bs-typeahead="searchDashboards" class="gf-form-input" ng-blur="dashboardChanged(link)"> <span class="gf-form-label width-7" ng-show="link.type === \'absolute\'">Url</span> <input ng-show="link.type === \'absolute\'" type="text" ng-model="link.url" class="gf-form-input max-width-14"></div><div class="gf-form max-width-25"><div class="gf-form-label width-7">Title</div><input type="text" ng-model="link.title" class="gf-form-input"></div></div><div class="section"><div class="gf-form"><span class="gf-form-label width-10">Url params</span> <input type="text" ng-model="link.params" class="gf-form-input width-10"></div><gf-form-switch class="gf-form" label-class="width-10" label="Include time range" checked="link.keepTime"></gf-form-switch><gf-form-switch class="gf-form" label-class="width-10" label="Include variables" checked="link.includeVars"></gf-form-switch><gf-form-switch class="gf-form" label-class="width-10" label="Open in new tab " checked="link.targetBlank"></gf-form-switch></div><div class="section"><div class="gf-form"><button class="btn btn-inverse gf-form-btn" ng-click="deleteLink(link)"><i class="fa fa-trash"></i> Remove Link</button></div></div></div></div><div class="editor-row"><button class="btn btn-inverse" ng-click="addLink()"><i class="fa fa-plus"></i> Add link</button></div>'),a.put("public/app/features/playlist/partials/playlist.html",'<navbar model="ctrl.navModel"></navbar><div class="page-container" ng-form="playlistEditForm"><div class="page-header"><h1 ng-show="ctrl.isNew()">New Playlist</h1><h1 ng-show="!ctrl.isNew()">Edit Playlist</h1></div><p class="playlist-description">A playlist rotates through a pre-selected list of Dashboards. A Playlist can be a great way to build situational awareness, or just show off your metrics to your team or visitors.</p><div class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-7">Name</span> <input type="text" required ng-model="ctrl.playlist.name" class="gf-form-input max-width-21"></div><div class="gf-form"><span class="gf-form-label width-7">Interval</span> <input type="text" required ng-model="ctrl.playlist.interval" placeholder="5m" class="gf-form-input max-width-21"></div></div><div class="gf-form-group"><h3 class="page-headering">Dashboards</h3></div><div class="row"><div class="col-lg-6"><div class="playlist-search-containerwrapper"><div class="max-width-32"><h5 class="page-headering playlist-column-header">Available</h5><div style=""><playlist-search class="playlist-search-container" search-started="ctrl.searchStarted(promise)"></playlist-search></div></div></div><div ng-if="ctrl.filteredDashboards.length > 0"><table class="grafana-options-table playlist-available-list"><tr ng-repeat="playlistItem in ctrl.filteredDashboards"><td><i class="icon-gf icon-gf-dashboard"></i> &nbsp;&nbsp;{{playlistItem.title}} <i class="fa fa-star" ng-show="playlistItem.isStarred"></i></td><td class="add-dashboard"><button class="btn btn-inverse btn-mini pull-right" ng-click="ctrl.addPlaylistItem(playlistItem)"><i class="fa fa-plus"></i> Add to playlist</button></td></tr></table></div><div class="playlist-search-results-container" ng-if="ctrl.filteredTags.length > 0;"><table class="grafana-options-table playlist-available-list"><tr ng-repeat="tag in ctrl.filteredTags"><td><a class="search-result-tag label label-tag" tag-color-from-name="tag.term"><i class="fa fa-tag"></i> <span>{{tag.term}} &nbsp;({{tag.count}})</span></a></td><td class="add-dashboard"><button class="btn btn-inverse btn-mini pull-right" ng-click="ctrl.addTagPlaylistItem(tag)"><i class="fa fa-plus"></i> Add to playlist</button></td></tr></table></div></div><div class="col-lg-6"><h5 class="page headering playlist-column-header">Selected</h5><table class="grafana-options-table playlist-available-list"><tr ng-repeat="playlistItem in ctrl.playlistItems"><td ng-if="playlistItem.type === \'dashboard_by_id\'"><i class="icon-gf icon-gf-dashboard"></i>&nbsp;&nbsp;{{playlistItem.title}}</td><td ng-if="playlistItem.type === \'dashboard_by_tag\'"><a class="search-result-tag label label-tag" tag-color-from-name="playlistItem.title"><i class="fa fa-tag"></i> <span>{{playlistItem.title}}</span></a></td><td class="selected-playlistitem-settings"><button class="btn btn-inverse btn-mini" ng-hide="$first" ng-click="ctrl.movePlaylistItemUp(playlistItem)"><i class="fa fa-arrow-up"></i></button> <button class="btn btn-inverse btn-mini" ng-hide="$last" ng-click="ctrl.movePlaylistItemDown(playlistItem)"><i class="fa fa-arrow-down"></i></button> <button class="btn btn-inverse btn-mini" ng-click="ctrl.removePlaylistItem(playlistItem)"><i class="fa fa-remove"></i></button></td></tr></table></div></div><div class="clearfix"></div><div class="gf-form-button-row"><a class="btn btn-success" ng-show="ctrl.isNew()" ng-disabled="ctrl.playlistEditForm.$invalid || ctrl.isPlaylistEmpty()" ng-click="ctrl.savePlaylist(ctrl.playlist, ctrl.playlistItems)">Create new playlist</a> <a class="btn btn-success" ng-show="!ctrl.isNew()" ng-disabled="ctrl.playlistEditForm.$invalid || ctrl.isPlaylistEmpty()" ng-click="ctrl.savePlaylist(ctrl.playlist, ctrl.playlistItems)">Save</a> <a class="btn-text" ng-click="ctrl.backToList()">Cancel</a></div></div>'),a.put("public/app/features/playlist/partials/playlist_search.html",'<div class="playlist-search-field-wrapper"><span style="position: relative"><input type="text" placeholder="Find dashboards by name" tabindex="1" ng-keydown="ctrl.keyDown($event)" ng-model="ctrl.query.query" ng-model-options="{ debounce: 500 }" spellcheck="false" ng-change="ctrl.searchDashboards()"><div class="playlist-search-switches"><i class="fa fa-filter"></i> <a class="pointer" href="javascript:void 0;" ng-click="ctrl.showStarred()" tabindex="2"><i class="fa fa-remove" ng-show="ctrl.query.starred"></i> starred </a>| <a class="pointer" href="javascript:void 0;" ng-click="ctrl.getTags()" tabindex="3"><i class="fa fa-remove" ng-show="ctrl.tagsMode"></i> tags </a><span ng-if="ctrl.query.tag.length">| <span ng-repeat="tagName in ctrl.query.tag"><a ng-click="ctrl.removeTag(tagName, $event)" tag-color-from-name="ctrl.tagName" class="label label-tag"><i class="fa fa-remove"></i> {{tagName}}</a></span></span></div></span></div>'),a.put("public/app/features/playlist/partials/playlists.html",'<navbar model="ctrl.navModel"></navbar><div class="page-container"><div class="page-header"><h1>Saved playlists</h1><a class="btn btn-success pull-right" href="playlists/create"><i class="fa fa-plus"></i> New Playlist</a></div><table class="filter-table" style="margin-top: 20px"><thead><th><strong>Name</strong></th><th><strong>Start url</strong></th><th style="width: 68px"></th><th style="width: 78px"></th><th style="width: 25px"></th></thead><tr ng-repeat="playlist in ctrl.playlists"><td><a href="playlists/edit/{{playlist.id}}">{{playlist.name}}</a></td><td><a href="playlists/play/{{playlist.id}}">playlists/play/{{playlist.id}}</a></td><td class="text-center"><a href="playlists/play/{{playlist.id}}" class="btn btn-inverse btn-small"><i class="fa fa-play"></i> Play</a></td><td class="text-right"><a href="playlists/edit/{{playlist.id}}" class="btn btn-inverse btn-small"><i class="fa fa-edit"></i> Edit</a></td><td class="text-right"><a ng-click="ctrl.removePlaylist(playlist)" class="btn btn-danger btn-small"><i class="fa fa-remove"></i></a></td></tr></table></div>'),a.put("public/app/features/plugins/import_list/import_list.html",'<div class="gf-form-group" ng-if="ctrl.dashboards.length"><table class="filter-table"><tbody><tr ng-repeat="dash in ctrl.dashboards"><td class="width-1"><i class="icon-gf icon-gf-dashboard"></i></td><td><a href="dashboard/{{dash.importedUri}}" ng-show="dash.imported">{{dash.title}} </a><span ng-show="!dash.imported">{{dash.title}}</span></td><td><span>Revision: {{dash.revision}} <span ng-if="dash.imported" class="small">(Imported: {{dash.importedRevision}})</span> <span></span></span></td><td style="text-align: right"><button class="btn btn-secondary btn-small" ng-click="ctrl.import(dash, false)" ng-show="!dash.imported">Import</button> <button class="btn btn-secondary btn-small" ng-click="ctrl.import(dash, true)" ng-show="dash.imported"><span ng-if="dash.revision !== dash.importedRevision">Update</span> <span ng-if="dash.revision === dash.importedRevision">Re-import</span></button> <button class="btn btn-danger btn-small" ng-click="ctrl.remove(dash)" ng-show="dash.imported"><i class="fa fa-trash"></i></button></td></tr></tbody></table></div>'),a.put("public/app/features/plugins/partials/ds_edit.html",'<navbar model="ctrl.navModel"></navbar><div class="page-container"><div class="page-header"><h1 ng-show="ctrl.isNew">Add data source</h1><h1 ng-hide="ctrl.isNew">Edit data source</h1><div class="page-header-tabs" ng-show="ctrl.hasDashboards"><ul class="gf-tabs"><li class="gf-tabs-item"><a class="gf-tabs-link" ng-click="ctrl.tabIndex = 0" ng-class="{active: ctrl.tabIndex === 0}">Config</a></li><li class="gf-tabs-item"><a class="gf-tabs-link" ng-click="ctrl.tabIndex = 1" ng-class="{active: ctrl.tabIndex === 1}">Dashboards</a></li></ul></div></div><div ng-if="ctrl.tabIndex === 0" class="tab-content"><form name="ctrl.editForm" ng-if="ctrl.current"><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form max-width-30"><span class="gf-form-label width-7">Name</span> <input class="gf-form-input max-width-23" type="text" ng-model="ctrl.current.name" placeholder="name" required><info-popover offset="0px -135px" mode="right-absolute">The name is used when you select the data source in panels. The <em>Default</em> data source is preselected in new panels.</info-popover></div><gf-form-switch class="gf-form" label="Default" checked="ctrl.current.isDefault" switch-class="max-width-6"></gf-form-switch></div><div class="gf-form"><span class="gf-form-label width-7">Type</span><div class="gf-form-select-wrapper max-width-23"><select class="gf-form-input" ng-model="ctrl.current.type" ng-options="v.id as v.name for v in ctrl.types" ng-change="ctrl.userChangedType()"></select></div></div></div><div class="alert alert-info gf-form-group" ng-if="ctrl.datasourceMeta.state === \'alpha\'">This plugin is marked as being in alpha state, which means it is in early development phase and updates will include breaking changes.</div><rebuild-on-change property="ctrl.datasourceMeta.id"><plugin-component type="datasource-config-ctrl"></plugin-component></rebuild-on-change><div ng-if="ctrl.testing" class="gf-form-group"><h5 ng-show="!ctrl.testing.done">Testing.... <i class="fa fa-spiner fa-spin"></i></h5><div class="alert-{{ctrl.testing.status}} alert" ng-show="ctrl.testing.done"><div class="alert-icon"><i class="fa fa-exclamation-triangle" ng-show="ctrl.testing.status === \'error\'"></i> <i class="fa fa-check" ng-show="ctrl.testing.status !== \'error\'"></i></div><div class="alert-body"><div class="alert-title">{{ctrl.testing.message}}</div></div></div></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-show="ctrl.isNew" ng-click="ctrl.saveChanges()">Add</button> <button type="submit" class="btn btn-success" ng-show="!ctrl.isNew" ng-click="ctrl.saveChanges()">Save &amp; Test</button> <button type="submit" class="btn btn-danger" ng-show="!ctrl.isNew" ng-click="ctrl.delete()">Delete</button> <a class="btn btn-link" href="datasources">Cancel</a></div></form></div><div ng-if="ctrl.tabIndex === 1" class="tab-content"><dashboard-import-list plugin="ctrl.datasourceMeta" datasource="ctrl.current"></dashboard-import-list></div></div>'),a.put("public/app/features/plugins/partials/ds_http_settings.html",'<div class="gf-form-group"><h3 class="page-heading">Http settings</h3><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form max-width-30"><span class="gf-form-label width-7">Url</span> <input class="gf-form-input" type="text" ng-model="current.url" placeholder="{{suggestUrl}}" bs-typeahead="getSuggestUrls" min-length="0" ng-pattern="/^(ftp|http|https):\\/\\/(\\w+:{0,1}\\w*@)?(\\S+)(:[0-9]+)?(\\/|\\/([\\w#!:.?+=&%@!\\-\\/]))?$/" required><info-popover mode="right-absolute"><p>Specify a complete HTTP url (for example http://your_server:8080)</p><span ng-show="current.access === \'direct\'">Your access method is <em>Direct</em>, this means the url needs to be accessible from the browser. </span><span ng-show="current.access === \'proxy\'">Your access method is currently <em>Proxy</em>, this means the url needs to be accessible from the grafana backend.</span></info-popover></div></div><div class="gf-form-inline"><div class="gf-form max-width-30"><span class="gf-form-label width-7">Access</span><div class="gf-form-select-wrapper gf-form-select-wrapper--has-help-icon max-width-24"><select class="gf-form-input" ng-model="current.access" ng-options="f for f in [\'direct\', \'proxy\']"></select><info-popover mode="right-absolute">Direct = url is used directly from browser<br>Proxy = Grafana backend will proxy the request</info-popover></div></div></div></div><h3 class="page-heading">Http Auth</h3><div class="gf-form-inline"><gf-form-switch class="gf-form" label="Basic Auth" checked="current.basicAuth" label-class="width-8" switch-class="max-width-6"></gf-form-switch><gf-form-switch class="gf-form" label="With Credentials" tooltip="Whether credentials such as cookies or auth headers should be sent with cross-site requests." checked="current.withCredentials" label-class="width-11" switch-class="max-width-6"></gf-form-switch></div><div class="gf-form-inline"><gf-form-switch class="gf-form" ng-if="current.access==\'proxy\'" label="TLS Client Auth" label-class="width-8" checked="current.jsonData.tlsAuth" switch-class="max-width-6"></gf-form-switch><gf-form-switch class="gf-form" ng-if="current.access==\'proxy\'" label="With CA Cert" tooltip="Optional. Needed for self-signed TLS Certs." checked="current.jsonData.tlsAuthWithCACert" label-class="width-11" switch-class="max-width-6"></gf-form-switch></div></div><div class="gf-form-group" ng-if="current.basicAuth"><h6>Basic Auth Details</h6><div class="gf-form" ng-if="current.basicAuth"><span class="gf-form-label width-7">User </span><input class="gf-form-input max-width-21" type="text" ng-model="current.basicAuthUser" placeholder="user" required></div><div class="gf-form"><span class="gf-form-label width-7">Password </span><input class="gf-form-input max-width-21" type="password" ng-model="current.basicAuthPassword" placeholder="password" required></div></div><div class="gf-form-group" ng-if="current.jsonData.tlsAuth && current.access==\'proxy\'"><div class="gf-form"><h6>TLS Auth Details</h6><info-popover mode="header">TLS Certs are encrypted and stored in the Grafana database.</info-popover></div><div ng-if="current.jsonData.tlsAuthWithCACert"><div class="gf-form-inline"><div class="gf-form gf-form--v-stretch"><label class="gf-form-label width-7">CA Cert</label></div><div class="gf-form gf-form--grow" ng-if="!current.secureJsonFields.tlsCACert"><textarea rows="7" class="gf-form-input gf-form-textarea" ng-model="current.secureJsonData.tlsCACert" placeholder="Begins with -----BEGIN CERTIFICATE-----. The CA Certificate is necessary if you are using self-signed certificates."></textarea></div><div class="gf-form" ng-if="current.secureJsonFields.tlsCACert"><input type="text" class="gf-form-input max-width-12" disabled="disabled" value="configured"> <a class="btn btn-secondary gf-form-btn" href="#" ng-click="current.secureJsonFields.tlsCACert = false">reset</a></div></div></div><div class="gf-form-inline"><div class="gf-form gf-form--v-stretch"><label class="gf-form-label width-7">Client Cert</label></div><div class="gf-form gf-form--grow" ng-if="!current.secureJsonFields.tlsClientCert"><textarea rows="7" class="gf-form-input gf-form-textarea" ng-model="current.secureJsonData.tlsClientCert" placeholder="Begins with -----BEGIN CERTIFICATE-----" required></textarea></div><div class="gf-form" ng-if="current.secureJsonFields.tlsClientCert"><input type="text" class="gf-form-input max-width-12" disabled="disabled" value="configured"> <a class="btn btn-secondary gf-form-btn" href="#" ng-click="current.secureJsonFields.tlsClientCert = false">reset</a></div></div><div class="gf-form-inline"><div class="gf-form gf-form--v-stretch"><label class="gf-form-label width-7">Client Key</label></div><div class="gf-form gf-form--grow" ng-if="!current.secureJsonFields.tlsClientKey"><textarea rows="7" class="gf-form-input gf-form-textarea" ng-model="current.secureJsonData.tlsClientKey" placeholder="Begins with -----BEGIN RSA PRIVATE KEY-----" required></textarea></div><div class="gf-form" ng-if="current.secureJsonFields.tlsClientKey"><input type="text" class="gf-form-input max-width-12" disabled="disabled" value="configured"> <a class="btn btn-secondary gf-form-btn" href="#" ng-click="current.secureJsonFields.tlsClientKey = false">reset</a></div></div></div>'),a.put("public/app/features/plugins/partials/ds_list.html",'<navbar model="ctrl.navModel"></navbar><div class="page-container"><div class="page-header"><h1>Data Sources</h1><a class="btn btn-success" href="datasources/new"><i class="fa fa-plus"></i> Add data source</a></div><section class="card-section" layout-mode><layout-selector></layout-selector><ol class="card-list"><li class="card-item-wrapper" ng-repeat="ds in ctrl.datasources"><a class="card-item" href="datasources/edit/{{ds.id}}/"><div class="card-item-header"><div class="card-item-type">{{ds.type}}</div></div><div class="card-item-body"><figure class="card-item-figure"><img ng-src="{{ds.typeLogoUrl}}"></figure><div class="card-item-details"><div class="card-item-name">{{ds.name}} <span ng-if="ds.isDefault"><span class="btn btn-secondary btn-mini">default</span></span></div><div class="card-item-sub-name">{{ds.url}}</div></div></div></a></li></ol></section><div ng-if="ctrl.datasources.length === 0"><em>No data sources defined</em></div></div>'),a.put("public/app/features/plugins/partials/plugin_edit.html",'<navbar model="ctrl.navModel"></navbar><div class="page-container" ng-init="ctrl.init()"><div class="page-header"><div class="plugin-header"><span class="plugin-header-logo"><img ng-src="{{ctrl.model.info.logos.large}}"></span><div class="plugin-header-info-block"><h1 class="plugin-header-name">{{ctrl.model.name}}</h1><div class="plugin-header-author">By {{ctrl.model.info.author.name}}</div><div class="plugin-header-stamps"><span class="plugin-header-stamps-type"><i class="{{ctrl.pluginIcon}}"></i> {{ctrl.model.type}}</span></div></div></div><ul class="gf-tabs"><li class="gf-tabs-item" ng-repeat="tab in ctrl.tabs"><a class="gf-tabs-link" ng-click="ctrl.tabIndex = $index" ng-class="{active: ctrl.tabIndex === $index}">{{::tab}}</a></li></ul></div><div class="page-body"><div class="tab-content page-content-with-sidebar" ng-if="ctrl.tabs[ctrl.tabIndex] === \'Readme\'"><div ng-bind-html="ctrl.readmeHtml" class="markdown-html"></div></div><div class="tab-content page-content-with-sidebar" ng-if="ctrl.tabs[ctrl.tabIndex] === \'Config\'"><div ng-if="ctrl.model.id"><plugin-component type="app-config-ctrl"></plugin-component><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="ctrl.enable()" ng-show="!ctrl.model.enabled">Enable</button> <button type="submit" class="btn btn-success" ng-click="ctrl.update()" ng-show="ctrl.model.enabled">Update</button> <button type="submit" class="btn btn-danger" ng-click="ctrl.disable()" ng-show="ctrl.model.enabled">Disable</button></div></div></div><div class="tab-content page-content-with-sidebar" ng-if="ctrl.tabs[ctrl.tabIndex] === \'Dashboards\'"><dashboard-import-list plugin="ctrl.model"></dashboard-import-list></div><aside class="page-sidebar"><section class="page-sidebar-section"><h4>Version</h4><span>{{ctrl.model.info.version}}</span><div ng-show="ctrl.model.hasUpdate"><a ng-click="ctrl.updateAvailable()" bs-tooltip="ctrl.model.latestVersion">Update Available!</a></div></section><section class="page-sidebar-section" ng-show="ctrl.model.type === \'app\'"><h5>Includes<ul class="ui-list plugin-info-list"><li ng-repeat="plug in ctrl.includes" class="plugin-info-list-item"><i class="{{plug.icon}}"></i> {{plug.name}}</li></ul></h5></section><section class="page-sidebar-section"><h5>Dependencies<ul class="ui-list plugin-info-list"><li class="plugin-info-list-item"><img src="public/img/grafana_icon.svg">Grafana {{ctrl.model.dependencies.grafanaVersion}}</li><li ng-repeat="plugDep in ctrl.model.dependencies.plugins" class="plugin-info-list-item"><i class="{{plugDep.icon}}"></i> {{plugDep.name}} {{plugDep.version}}</li></ul></h5></section><section class="page-sidebar-section"><h5>Links<ul class="ui-list"><li ng-repeat="link in ctrl.model.info.links"><a href="{{link.url}}" class="external-link" target="_blank">{{link.name}}</a></li></ul></h5></section></aside></div></div>'),a.put("public/app/features/plugins/partials/plugin_list.html",'<navbar model="ctrl.navModel"></navbar><div class="page-container"><div class="page-header"><h1>Plugins <span class="muted small">(currently installed)</span></h1><div class="page-header-tabs"><ul class="gf-tabs"><li class="gf-tabs-item"><a class="gf-tabs-link" href="plugins?type=panel" ng-class="{active: ctrl.tabIndex === 0}">Panels</a></li><li class="gf-tabs-item"><a class="gf-tabs-link" href="plugins?type=datasource" ng-class="{active: ctrl.tabIndex === 1}">Data sources</a></li><li class="gf-tabs-item"><a class="gf-tabs-link" href="plugins?type=app" ng-class="{active: ctrl.tabIndex === 2}">Apps</a></li></ul><a class="get-more-plugins-link" href="https://grafana.com/plugins?utm_source=grafana_plugin_list" target="_blank">Find more <img src="public/img/icn-plugins-tiny.svg">plugins on Grafana.com</a></div></div><section class="card-section" layout-mode><layout-selector></layout-selector><ol class="card-list"><li class="card-item-wrapper" ng-repeat="plugin in ctrl.plugins"><a class="card-item" href="plugins/{{plugin.id}}/edit"><div class="card-item-header"><div class="card-item-type"><i class="icon-gf icon-gf-{{plugin.type}}"></i> {{plugin.type}}</div><div class="card-item-notice" ng-show="plugin.hasUpdate"><span bs-tooltip="plugin.latestVersion">Update available!</span></div></div><div class="card-item-body"><figure class="card-item-figure"><img ng-src="{{plugin.info.logos.small}}"></figure><div class="card-item-details"><div class="card-item-name">{{plugin.name}}</div><div class="card-item-sub-name">By {{plugin.info.author.name}}</div></div></div></a></li></ol></section></div>'),a.put("public/app/features/plugins/partials/plugin_page.html",'<navbar model="ctrl.navModel" ng-if="ctrl.navModel"></navbar><div class="page-container"><div ng-if="ctrl.page"><plugin-component type="app-page"></plugin-component></div></div>'),a.put("public/app/features/plugins/partials/update_instructions.html",'<div class="modal-body"><div class="modal-header"><h2 class="modal-header-title"><i class="fa fa-cloud-download"></i> <span class="p-l-1">Update Plugin</span></h2><a class="modal-header-close" ng-click="dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content"><div class="gf-form-group"><p>Type the following on the command line to update {{plugin.name}}.</p><pre><code>grafana-cli plugins update {{plugin.id}}</code></pre><span class="small">Check out {{plugin.name}} on <a href="https://grafana.com/plugins/{{plugin.id}}">Grafana.com</a> for README and changelog. If you do not have access to the command line, ask your Grafana administator.</span></div><p class="pluginlist-none-installed"><img class="pluginlist-inline-logo" src="public/img/grafana_icon.svg"><strong>Pro tip</strong>: To update all plugins at once, type <code class="code--small">grafana-cli plugins update-all</code> on the command line.</p></div></div>'),a.put("public/app/features/snapshot/partials/snapshots.html",'<navbar model="ctrl.navModel"></navbar><div class="page-container"><div class="page-header"><h1>Available snapshots</h1></div><table class="filter-table" style="margin-top: 20px"><thead><th><strong>Name</strong></th><th><strong>Snapshot url</strong></th><th style="width: 70px"></th><th style="width: 25px"></th></thead><tr ng-repeat="snapshot in ctrl.snapshots"><td><a href="dashboard/snapshot/{{snapshot.key}}">{{snapshot.name}}</a></td><td><a href="dashboard/snapshot/{{snapshot.key}}">dashboard/snapshot/{{snapshot.key}}</a></td><td class="text-center"><a href="dashboard/snapshot/{{snapshot.key}}" class="btn btn-inverse btn-mini"><i class="fa fa-eye"></i> View</a></td><td class="text-right"><a ng-click="ctrl.removeSnapshot(snapshot)" class="btn btn-danger btn-mini"><i class="fa fa-remove"></i></a></td></tr></table></div>'),a.put("public/app/features/styleguide/styleguide.html",'<navbar model="ctrl.navModel"></navbar><div class="page-container"><div class="page-header"><h1>Style Guide</h1><a class="btn btn-success" ng-click="ctrl.switchTheme()"><i class="fa fa-random"></i> Switch theme</a><div class="page-header-tabs"><ul class="gf-tabs"><li class="gf-tabs-item" ng-repeat="page in ctrl.pages"><a class="gf-tabs-link" href="styleguide/{{page}}" ng-class="{active: ctrl.page[page]}">{{page}}</a></li></ul></div></div><div class="tab-pane" ng-if="ctrl.page.colors"><ul><li class="style-guide-color-card" ng-repeat="color in ctrl.colors" style="background-color: {{color.value}}"><strong>${{color.name}}</strong> <em>{{color.value}}</em></li></ul></div><div class="tab-pane" ng-if="ctrl.page.buttons"><div ng-repeat="variant in ctrl.buttonVariants" class="row"><div ng-repeat="btnSize in ctrl.buttonSizes" class="style-guide-button-list p-a-2 col-md-4"><button ng-repeat="buttonName in ctrl.buttonNames" class="btn btn{{variant}}{{buttonName}} {{btnSize}}">btn{{variant}}{{buttonName}}</button></div></div></div><div class="tab-pane style-guide-icon-list" ng-if="ctrl.page.icons"><div class="row"><div ng-repeat="icon in ctrl.icons" class="col-md-2 col-sm-3 col-xs-4"><i class="icon-gf icon-gf-{{icon}}" bs-tooltip="\'icon-gf icon-gf-{{icon}}\'"></i></div></div></div><div class="tab-pane style-guide-plugin-authoring" ng-if="ctrl.page.plugins"><p>From grafana 3.0 it\'s very easy to develop your own plugins and share them with other grafana users.</p><p>More information about plugin development can be found at <a href="http://docs.grafana.org/plugins/developing/development/" target="_blank">docs.grafana.org</a></p></div><div class="tab-pane" ng-if="ctrl.page.forms">forms</div></div>'),a.put("public/app/features/templating/partials/editor.html",'<div ng-controller="VariableEditorCtrl" ng-init="init()"><div class="tabbed-view-header"><h2 class="tabbed-view-title">Templating</h2><ul class="gf-tabs"><li class="gf-tabs-item"><a class="gf-tabs-link" ng-click="mode = \'list\';" ng-class="{active: mode === \'list\'}">Variables</a></li><li class="gf-tabs-item" ng-show="mode === \'edit\'"><a class="gf-tabs-link" ng-class="{active: mode === \'edit\'}">Edit</a></li><li class="gf-tabs-item" ng-show="mode === \'new\'"><span class="active gf-tabs-link">New</span></li><li class="gf-tabs-item"><a class="gf-tabs-link" ng-click="mode = \'help\';" ng-class="{active: mode === \'help\'}">Help</a></li></ul><button class="tabbed-view-close-btn" ng-click="dismiss();"><i class="fa fa-remove"></i></button></div><div class="tabbed-view-body"><div ng-if="mode === \'list\'"><div ng-if="variables.length === 0"><em>No template variables defined</em><br><br></div><table class="grafana-options-table"><tr ng-repeat="variable in variables"><td style="width: 1%"><span class="template-variable">${{variable.name}}</span></td><td class="max-width" style="max-width: 200px">{{variable.query}}</td><td style="width: 1%"><i ng-click="_.move(variables,$index,$index-1)" ng-hide="$first" class="pointer fa fa-arrow-up"></i></td><td style="width: 1%"><i ng-click="_.move(variables,$index,$index+1)" ng-hide="$last" class="pointer fa fa-arrow-down"></i></td><td style="width: 1%"><a ng-click="duplicate(variable)" class="btn btn-inverse btn-mini">Duplicate</a></td><td style="width: 1%"><a ng-click="edit(variable)" class="btn btn-inverse btn-mini"><i class="fa fa-edit"></i> Edit</a></td><td style="width: 1%"><a ng-click="removeVariable(variable)" class="btn btn-danger btn-mini"><i class="fa fa-remove"></i></a></td></tr></table></div><div ng-show="mode === \'help\'"><div class="grafana-info-box col-lg-8"><h5>What does templating do?</h5><p>Templating allows for more interactive and dynamic dashboards. Instead of hard-coding things like server, application and sensor name in you metric queries you can use variables in their place. Variables are shown as dropdown select boxes at the top of the dashboard. These dropdowns make it easy to change the data being displayed in your dashboard.<br><br>Checkout the <a class="external-link" target="_blank" href="http://docs.grafana.org/reference/templating/">Templating documentation</a> for more information.</p></div></div><div class="gf-form" ng-show="mode === \'list\'"><div class="gf-form-button-row"><a type="button" class="btn gf-form-button btn-success" ng-click="mode = \'new\';"><i class="fa fa-plus"></i>&nbsp;&nbsp;New</a></div></div><form ng-if="mode === \'edit\' || mode === \'new\'" name="ctrl.form"><h5 class="section-heading">Variable</h5><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form max-width-19"><span class="gf-form-label width-6">Name</span> <input type="text" class="gf-form-input" name="name" placeholder="name" ng-model="current.name" required ng-pattern="namePattern"></div><div class="gf-form max-width-19"><span class="gf-form-label width-6">Type<info-popover mode="right-normal">{{variableTypes[current.type].description}}</info-popover></span><div class="gf-form-select-wrapper max-width-17"><select class="gf-form-input" ng-model="current.type" ng-options="k as v.name for (k, v) in variableTypes" ng-change="typeChanged()"></select></div></div></div><div class="gf-form" ng-show="ctrl.form.name.$error.pattern"><span class="gf-form-label gf-form-label--error">Template names cannot begin with \'__\' that\'s reserved for Grafanas global variables</span></div><div class="gf-form-inline"><div class="gf-form max-width-19"><span class="gf-form-label width-6">Label</span> <input type="text" class="gf-form-input" ng-model="current.label" placeholder="optional display name"></div><div class="gf-form max-width-19"><span class="gf-form-label width-6">Hide</span><div class="gf-form-select-wrapper max-width-15"><select class="gf-form-input" ng-model="current.hide" ng-options="f.value as f.text for f in hideOptions"></select></div></div></div></div><div ng-if="current.type === \'interval\'" class="gf-form-group"><h5 class="section-heading">Interval Options</h5><div class="gf-form"><span class="gf-form-label width-9">Values</span> <input type="text" class="gf-form-input" placeholder="name" ng-model="current.query" placeholder="1m,10m,1h,6h,1d,7d" ng-model-onblur ng-change="runQuery()" required></div><div class="gf-form-inline"><gf-form-switch class="gf-form" label="Auto Option" label-class="width-9" checked="current.auto" on-change="runQuery()"></gf-form-switch><div class="gf-form"><span class="gf-form-label width-9" ng-show="current.auto">Step count<tip>How many times should the current time range be divided to calculate the value</tip></span><div class="gf-form-select-wrapper max-width-10" ng-show="current.auto"><select class="gf-form-input" ng-model="current.auto_count" ng-options="f for f in [1,2,3,4,5,10,20,30,40,50,100,200,300,400,500]" ng-change="runQuery()"></select></div></div><div class="gf-form"><span class="gf-form-label" ng-show="current.auto">Min interval<tip>The calculated value will not go below this threshold</tip></span><input type="text" class="gf-form-input max-width-10" ng-show="current.auto" ng-model="current.auto_min" ng-change="runQuery()" placeholder="10s"></div></div></div><div ng-if="current.type === \'custom\'" class="gf-form-group"><h5 class="section-heading">Custom Options</h5><div class="gf-form"><span class="gf-form-label width-14">Values separated by comma</span> <input type="text" class="gf-form-input" ng-model="current.query" ng-blur="runQuery()" placeholder="1, 10, 20, myvalue" required></div></div><div ng-if="current.type === \'constant\'" class="gf-form-group"><h5 class="section-heading">Constant options</h5><div class="gf-form"><span class="gf-form-label">Value</span> <input type="text" class="gf-form-input" ng-model="current.query" ng-blur="runQuery()" placeholder="your metric prefix"></div></div><div ng-if="current.type === \'query\'" class="gf-form-group"><h5 class="section-heading">Query Options</h5><div class="gf-form-inline"><div class="gf-form max-width-21"><span class="gf-form-label width-7">Data source</span><div class="gf-form-select-wrapper max-width-14"><select class="gf-form-input" ng-model="current.datasource" ng-options="f.value as f.name for f in datasources" required><option value="" ng-if="false"></option></select></div></div><div class="gf-form max-width-21"><span class="gf-form-label width-7">Refresh<info-popover mode="right-normal">When to update the values of this variable.</info-popover></span><div class="gf-form-select-wrapper max-width-14"><select class="gf-form-input" ng-model="current.refresh" ng-options="f.value as f.text for f in refreshOptions"></select></div></div></div><div class="gf-form"><span class="gf-form-label width-7">Query</span> <input type="text" class="gf-form-input" ng-model="current.query" placeholder="metric name or tags query" ng-model-onblur ng-change="runQuery()" required></div><div class="gf-form"><span class="gf-form-label width-7">Regex<info-popover mode="right-normal">Optional, if you want to extract part of a series name or metric node segment.</info-popover></span><input type="text" class="gf-form-input" ng-model="current.regex" placeholder="/.*-(.*)-.*/" ng-model-onblur ng-change="runQuery()"></div><div class="gf-form max-width-21"><span class="gf-form-label width-7">Sort<info-popover mode="right-normal">How to sort the values of this variable.</info-popover></span><div class="gf-form-select-wrapper max-width-14"><select class="gf-form-input" ng-model="current.sort" ng-options="f.value as f.text for f in sortOptions" ng-change="runQuery()"></select></div></div></div><div ng-show="current.type === \'datasource\'" class="gf-form-group"><h5 class="section-heading">Data source options</h5><div class="gf-form"><label class="gf-form-label width-12">Type</label><div class="gf-form-select-wrapper max-width-18"><select class="gf-form-input" ng-model="current.query" ng-options="f.value as f.text for f in datasourceTypes" ng-change="runQuery()"></select></div></div><div class="gf-form"><label class="gf-form-label width-12">Instance name filter<info-popover mode="right-normal">Regex filter for which data source instances to choose from in the variable value dropdown. Leave empty for all.<br><br>Example: <code>/^prod/</code></info-popover></label><input type="text" class="gf-form-input max-width-18" ng-model="current.regex" placeholder="/.*-(.*)-.*/" ng-model-onblur ng-change="runQuery()"></div></div><div ng-if="current.type === \'adhoc\'" class="gf-form-group"><h5 class="section-heading">Options</h5><div class="gf-form max-width-21"><span class="gf-form-label width-8">Data source</span><div class="gf-form-select-wrapper max-width-14"><select class="gf-form-input" ng-model="current.datasource" ng-options="f.value as f.name for f in datasources" required ng-change="validate()"><option value="" ng-if="false"></option></select></div></div></div><div class="section gf-form-group" ng-show="variableTypes[current.type].supportsMulti"><h5 class="section-heading">Selection Options</h5><div class="section"><gf-form-switch class="gf-form" label="Multi-value" label-class="width-10" tooltip="Enables multiple values to be selected at the same time" checked="current.multi" on-change="runQuery()"></gf-form-switch><gf-form-switch class="gf-form" label="Include All option" label-class="width-10" checked="current.includeAll" on-change="runQuery()"></gf-form-switch></div><div class="gf-form" ng-if="current.includeAll"><span class="gf-form-label width-10">Custom all value</span> <input type="text" class="gf-form-input max-width-15" ng-model="current.allValue" placeholder="blank = auto"></div></div><div class="gf-form-group" ng-if="current.type === \'query\'"><h5>Value groups/tags (Experimental feature)</h5><gf-form-switch class="gf-form" label="Enabled" label-class="width-10" checked="current.useTags" on-change="runQuery()"></gf-form-switch><div class="gf-form last" ng-if="current.useTags"><span class="gf-form-label width-10">Tags query</span> <input type="text" class="gf-form-input" ng-model="current.tagsQuery" placeholder="metric name or tags query" ng-model-onblur></div><div class="gf-form" ng-if="current.useTags"><li class="gf-form-label width-10">Tag values query</li><input type="text" class="gf-form-input" ng-model="current.tagValuesQuery" placeholder="apps.$tag.*" ng-model-onblur></div></div><div class="gf-form-group" ng-show="current.options.length"><h5>Preview of values (shows max 20)</h5><div class="gf-form-inline"><div class="gf-form" ng-repeat="option in current.options | limitTo: 20"><span class="gf-form-label">{{option.text}}</span></div></div></div><div class="alert alert-info gf-form-group" ng-if="infoText">{{infoText}}</div><div class="gf-form-button-row p-y-0"><button type="submit" class="btn btn-success" ng-show="mode === \'edit\'" ng-click="update();">Update</button> <button type="submit" class="btn btn-success" ng-show="mode === \'new\'" ng-click="add();">Add</button></div></form></div></div>'),
a.put("public/app/partials/confirm_modal.html",'<div class="modal-body" ng-cloak><div class="modal-header"><h2 class="modal-header-title"><i class="fa {{icon}}"></i> <span class="p-l-1">{{title}}</span></h2><a class="modal-header-close" ng-click="dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content text-center"><div class="confirm-modal-text">{{text}}<div class="confirm-modal-text2" ng-show="text2">{{text2}}</div></div><div class="modal-content-confirm-text" ng-if="confirmText"><input type="text" class="gf-form-input width-16" style="display: inline-block" placeholder="Type {{confirmText}} to confirm" ng-model="confirmInput" ng-change="updateConfirmText(confirmInput)"></div><div class="confirm-modal-buttons"><button type="button" class="btn btn-inverse" ng-click="dismiss()">{{noText}}</button> <button type="button" class="btn btn-danger" ng-click="onConfirm();dismiss();" ng-disabled="!confirmTextValid" give-focus="true">{{yesText}}</button> <button ng-show="onAltAction" type="button" class="btn btn-success" ng-click="dismiss();onAltAction();">{{altActionText}}</button></div></div></div>'),a.put("public/app/partials/dashboard.html",'<div dash-class ng-if="dashboard"><dashnav dashboard="dashboard"></dashnav><div class="dashboard-container"><div dash-editor-view class="dash-edit-view"></div><div class="clearfix"></div><dashboard-submenu ng-if="dashboard.meta.submenuEnabled" dashboard="dashboard"></dashboard-submenu><div class="clearfix"></div><dash-row class="dash-row" ng-repeat="row in dashboard.rows" row="row" dashboard="dashboard"></dash-row><div ng-show="dashboard.meta.canEdit && !dashboard.meta.fullscreen" class="add-row-panel-hint"><div class="span12" style="text-align:left"><span style="margin-left: 12px" ng-click="addRowDefault()" class="pointer btn btn-inverse btn-small"><span><i class="fa fa-plus"></i> ADD ROW</span></span></div></div></div></div>'),a.put("public/app/partials/edit_json.html",'<div ng-controller="JsonEditorCtrl"><div class="tabbed-view-header"><h2 class="tabbed-view-title">JSON</h2><button class="tabbed-view-close-btn" ng-click="dismiss()"><i class="fa fa-remove"></i></button></div><div class="tabbed-view-body"><div class="gf-form"><textarea class="gf-form-input" ng-model="json" rows="20" spellcheck="false"></textarea></div><div class="gf-form-button-row"><button type="button" class="btn btn-success" ng-show="canUpdate" ng-click="update(); dismiss();">Update</button></div></div></div>'),a.put("public/app/partials/error.html",'<navbar model="navModel"></navbar><div class="page-container"><div class="page-header"><h1>Page not found (404)</h1></div></div>'),a.put("public/app/partials/login.html",'<div class="login-container container"><div class="login-box"><div class="login-box-logo"><img class="logo-icon" src="public/img/grafana_icon.svg"><br><i class="icon-gf icon-gf-grafana_wordmark"></i></div><div class="login-inner-box"><div class="login-tab-header"><button class="btn-login-tab" ng-click="loginMode = true;" ng-class="{active: loginMode}">Log in</button> <button class="btn-login-tab" ng-click="loginMode = false;" ng-class="{active: !loginMode}" ng-show="!disableUserSignUp">Sign up</button></div><form name="loginForm" class="login-form gf-form-group" ng-hide="disableLoginForm"><div class="gf-form" ng-if="loginMode"><span class="gf-form-label width-7">User</span> <input type="text" name="username" class="gf-form-input max-width-14" required ng-model="formModel.user" placeholder="{{loginHint}}"></div><div class="gf-form" ng-if="loginMode"><span class="gf-form-label width-7">Password</span> <input type="password" name="password" class="gf-form-input max-width-14" required ng-model="formModel.password" id="inputPassword" placeholder="password"></div><div class="gf-form" ng-if="!loginMode"><span class="gf-form-label width-7">Email</span> <input type="email" class="gf-form-input max-width-14" required ng-model="formModel.email" placeholder="email"></div><div class="gf-form-button-row"><button type="submit" class="btn btn-large p-x-3" ng-click="submit();" ng-class="{\'btn-inverse\': !loginForm.$valid, \'btn-primary\': loginForm.$valid}">{{submitBtnText}}</button></div></form><div ng-if="loginMode"><div class="text-center login-divider" ng-show="oauthEnabled"><div class="login-divider-line"><span class="login-divider-text"><span ng-hide="disableLoginForm">Or</span> Login With</span></div></div><div class="clearfix"></div><div class="login-oauth text-center" ng-show="oauthEnabled"><a class="btn btn-large btn-google" href="login/google" target="_self" ng-if="oauth.google"><i class="fa fa-google"></i> Google </a><a class="btn btn-large btn-github" href="login/github" target="_self" ng-if="oauth.github"><i class="fa fa-github"></i> GitHub </a><a class="btn btn-large btn-grafana-com" href="login/grafana_com" target="_self" ng-if="oauth.grafana_com"><img src="public/img/grafana_com_auth_icon.svg"><span>Grafana.com</span> </a><a class="btn btn-large btn-generic-oauth" href="login/generic_oauth" target="_self" ng-if="oauth.generic_oauth"><i class="fa fa-gear"></i> {{oauth.generic_oauth.name}}</a></div></div></div><div class="clearfix"></div><div class="text-center password-recovery" ng-hide="disableLoginForm"><div class="text-center"><a href="user/password/send-reset-email">Forgot your password?</a></div></div></div></div>'),a.put("public/app/partials/modal.html",'<div class="modal-header"><button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button><h3>{{modal.title}}</h3></div><div class="modal-body"><div ng-bind-html="modal.body"></div></div><div class="modal-footer"><button type="button" class="btn btn-danger" ng-click="dismiss()">Close</button></div>'),a.put("public/app/partials/panelgeneral.html",'<div class="editor-row"><div class="section gf-form-group"><h5 class="section-heading">Info</h5><div class="gf-form"><span class="gf-form-label width-7">Title</span> <input type="text" class="gf-form-input width-25" ng-model="ctrl.panel.title"></div><div class="gf-form gf-form--v-stretch"><span class="gf-form-label width-7">Description</span><textarea class="gf-form-input width-25" rows="3" ng-model="ctrl.panel.description" placeholder="Panel description, supports markdown & links"></textarea></div></div><div class="section gf-form-group"><h5 class="section-heading">Dimensions</h5><div class="gf-form"><span class="gf-form-label width-7">Span</span><select class="gf-form-input width-6" ng-model="ctrl.panel.span" ng-options="f for f in [0,1,2,3,4,5,6,7,8,9,10,11,12]"></select></div><div class="gf-form"><span class="gf-form-label width-7">Height</span> <input type="text" class="gf-form-input width-6" ng-model="ctrl.panel.height" placeholder="100px"></div><gf-form-switch class="gf-form" label-class="width-7" switch-class="max-width-6" label="Transparent" checked="ctrl.panel.transparent" on-change="ctrl.render()"></gf-form-switch></div><div class="section gf-form-group"><h5 class="section-heading">Templating</h5><div class="gf-form"><span class="gf-form-label width-8">Repeat Panel</span><dash-repeat-option model="ctrl.panel"></dash-repeat-option></div><div class="gf-form"><span class="gf-form-label width-8">Min span</span><select class="gf-form-input" ng-model="ctrl.panel.minSpan" ng-options="f for f in [1,2,3,4,5,6,7,8,9,10,11,12]"><option value=""></option></select></div></div></div><panel-links-editor panel="ctrl.panel"></panel-links-editor>'),a.put("public/app/partials/reset_password.html",'<div class="login-container container"><div class="login-box"><div class="login-box-logo"><img class="logo-icon" src="public/img/grafana_icon.svg"><br><i class="icon-gf icon-gf-grafana_wordmark"></i></div><div class="login-inner-box"><div class="login-tab-header"><button class="btn-login-tab" class="active">Reset password</button></div><form name="sendResetForm" class="login-form gf-form-group" ng-show="mode === \'send\'"><div class="gf-form"><span class="gf-form-label width-7">User</span> <input type="text" name="username" class="gf-form-input max-width-14" required ng-model="formModel.userOrEmail" placeholder="email or username"></div><div class="gf-form-button-row"><br><br><button type="submit" class="btn btn-large" ng-click="sendResetEmail();" ng-class="{\'btn-inverse\': !sendResetForm.$valid, \'btn-primary\': sendResetForm.$valid}">Reset Password</button></div></form><div style="text-align: center; padding: 20px" ng-if="mode === \'email-sent\'">An email with a reset link as been sent to the email address.<br>You should receive it shortly.</div><br><br><form name="resetForm" class="login-form gf-form-group" ng-show="mode === \'reset\'"><div class="gf-form"><span class="gf-form-label width-10">New Password</span> <input type="password" name="NewPassword" class="gf-form-input max-width-14" required ng-minlength="4" ng-model="formModel.newPassword" placeholder="password" watch-change="formModel.newPassword = inputValue;"></div><div class="gf-form"><span class="gf-form-label width-10">Confirm Password</span> <input type="password" name="ConfirmPassword" class="gf-form-input max-width-14" required ng-minlength="4" ng-model="formModel.confirmPassword" placeholder="confirm password"></div><div style="margin-left: 141px; width: 207px"><password-strength password="formModel.newPassword"></password-strength></div><div class="gf-form-button-row"><button type="submit" class="btn" ng-click="submitReset();" ng-class="{\'btn-inverse\': !resetForm.$valid, \'btn-primary\': resetForm.$valid}">Reset Password</button></div></form></div><div class="row" style="margin-top: 20px"><div class="text-center"><a href="login">Back to login</a></div></div></div></div>'),a.put("public/app/partials/roweditor.html",'<div class="tabbed-view-header"><h2 class="tabbed-view-title">Row settings</h2><button class="tabbed-view-close-btn" ng-click="dismiss();"><i class="fa fa-remove"></i></button></div><div class="tabbed-view-body"><div class="row"><div class="col-md-8"><div class="page-heading"><h5>Row details</h5></div><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-6">Title</span> <input type="text" class="gf-form-input max-width-14" ng-model="row.title"></div><div class="gf-form"><span class="gf-form-label width-6">Height</span> <input type="text" class="gf-form-input max-width-8" ng-model="row.height"><editor-checkbox text="Show Title" model="row.showTitle"></editor-checkbox></div></div></div></div><div class="col-md-4"><div class="page-heading"><h5>Templating options</h5></div><div class="gf-form-group"><div class="gf-form"><span class="gf-form-label">Repeat Row</span><div class="gf-form-select-wrapper max-width-10"><select class="gf-form-input" ng-model="row.repeat" ng-options="f.name as f.name for f in dashboard.templating.list"><option value=""></option></select></div></div></div></div></div></div>'),a.put("public/app/partials/signup_invited.html",'<div class="container"><div class="signup-page-background"></div><div class="login-box"><div class="login-box-logo"><img class="logo-icon" src="public/img/grafana_icon.svg"><br><i class="icon-gf icon-gf-grafana_wordmark"></i></div><div class="invite-box"><h3>Hello {{greeting}}.</h3><div class="modal-tagline p-b-2"><em>{{invitedBy}}</em> has invited you to join Grafana and the organization <span class="highlight-word">{{contextSrv.user.orgName}}</span><br>Please complete the following to accept your invitation and continue:</div><form name="inviteForm" class="login-form gf-form-group"><div class="gf-form"><span class="gf-form-label width-7">Email</span> <input type="email" name="email" class="gf-form-input max-width-21" required ng-model="formModel.email" placeholder="Email"></div><div class="gf-form"><span class="gf-form-label width-7">Name</span> <input type="text" name="name" class="gf-form-input max-width-21" ng-model="formModel.name" placeholder="Name (optional)"></div><div class="gf-form"><span class="gf-form-label width-7">Username</span> <input type="text" name="username" class="gf-form-input max-width-21" required ng-model="formModel.username" placeholder="Username"></div><div class="gf-form"><span class="gf-form-label width-7">Password</span> <input type="password" name="password" class="gf-form-input max-width-21" required ng-model="formModel.password" id="inputPassword" placeholder="password"></div><div style="margin-left: 7.5rem; width: 254px"><password-strength password="formModel.password"></password-strength></div><div class="gf-form-button-row"><button type="submit" class="btn btn-inverse" ng-click="submit();" ng-class="{\'btn-inverse\': !inviteForm.$valid, \'btn-primary\': inviteForm.$valid}">Continue</button></div></form></div></div></div>'),a.put("public/app/partials/signup_step2.html",'<div class="container"><div class="signup-page-background"></div><div class="login-box"><div class="login-box-logo"><img class="logo-icon" src="public/img/grafana_icon.svg"><br><i class="icon-gf icon-gf-grafana_wordmark"></i></div><div class="invite-box"><h3>You\'re almost there.</h3><div class="modal-tagline">We just need a couple of more bits of<br>information to finish creating your account.</div><div style="display: inline-block; margin-top: 25px; width: 300px"><div class="editor-option"><label class="small">Your email:</label><span class="large">{{formModel.email}}</span></div></div><br><br><form name="signUpForm" class="login-form gf-form-group"><div class="gf-form" ng-if="verifyEmailEnabled"><span class="gf-form-label width-9">Email code<tip>Email verification code (sent to your email)</tip></span><input type="text" class="gf-form-input max-width-14" ng-model="formModel.code" required></div><div class="gf-form" ng-if="!autoAssignOrg"><span class="gf-form-label width-9">Org. name</span> <input type="text" name="orgName" class="gf-form-input max-width-14" ng-model="formModel.orgName" placeholder="Name your organization"></div><div class="gf-form"><span class="gf-form-label width-9">Your name</span> <input type="text" name="name" class="gf-form-input max-width-14" ng-model="formModel.name" placeholder="(optional)"></div><div class="gf-form"><span class="gf-form-label width-9">Username</span> <input type="text" class="gf-form-input max-width-14" required ng-model="formModel.username" placeholder="Username" autocomplete="off"></div><div class="gf-form"><span class="gf-form-label width-9">Password</span> <input type="password" class="gf-form-input max-width-14" required ng-model="formModel.password" id="inputPassword" placeholder="password" autocomplete="off"></div><div style="margin-left: 7.5rem; width: 254px"><password-strength password="formModel.password"></password-strength></div><div class="gf-form-button-row"><button type="submit" class="btn" ng-click="ctrl.submit();" ng-class="{\'btn-inverse\': !signUpForm.$valid, \'btn-primary\': signUpForm.$valid}">Continue</button></div></form></div></div></div>'),a.put("public/app/partials/valueSelectDropdown.html",'<div class="variable-link-wrapper"><a ng-click="vm.show()" class="gf-form-label variable-value-link">{{vm.linkText}} <span ng-repeat="tag in vm.selectedTags" bs-tooltip="tag.valuesText" data-placement="bottom"><span class="label-tag" tag-color-from-name="tag.text">&nbsp;&nbsp;<i class="fa fa-tag"></i>&nbsp; {{tag.text}} </span></span><i class="fa fa-caret-down"></i> </a><input type="text" class="gf-form-input" style="display: none" ng-keydown="vm.keyDown($event)" ng-model="vm.search.query" ng-change="vm.queryChanged()"><div class="variable-value-dropdown" ng-if="vm.dropdownVisible" ng-class="{\'multi\': vm.variable.multi, \'single\': !vm.variable.multi}"><div class="variable-options-wrapper"><div class="variable-options-column"><a class="variable-options-column-header" ng-if="vm.variable.multi" ng-class="{\'many-selected\': vm.selectedValues.length > 1}" bs-tooltip="\'Clear selections\'" data-placement="top" ng-click="vm.clearSelections()"><span class="variable-option-icon"></span> Selected ({{vm.selectedValues.length}}) </a><a class="variable-option pointer" ng-repeat="option in vm.search.options" ng-class="{\'selected\': option.selected, \'highlighted\': $index === vm.highlightIndex}" ng-click="vm.selectValue(option, $event)"><span class="variable-option-icon"></span> <span>{{option.text}}</span></a></div><div class="variable-options-column" ng-if="vm.tags.length"><div class="variable-options-column-header text-center">Tags</div><a class="variable-option-tag pointer" ng-repeat="tag in vm.tags" ng-click="vm.selectTag(tag, $event)" ng-class="{\'selected\': tag.selected}"><span class="fa fa-fw variable-option-icon"></span> <span class="label-tag" tag-color-from-name="tag.text">{{tag.text}}&nbsp;&nbsp;<i class="fa fa-tag"></i>&nbsp;</span></a></div></div></div></div>'),a.put("public/app/plugins/app/testdata/partials/query.editor.html",'<query-editor-row query-ctrl="ctrl" has-text-edit-mode="false"><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label query-keyword">Scenario</label><div class="gf-form-select-wrapper"><select class="gf-form-input" ng-model="ctrl.target.scenarioId" ng-options="v.id as v.name for v in ctrl.scenarioList" ng-change="ctrl.scenarioChanged()"></select></div></div><div class="gf-form gf-form gf-form--grow" ng-if="ctrl.scenario.stringInput"><label class="gf-form-label query-keyword">String Input</label><input type="text" class="gf-form-input" placeholder="{{ctrl.scenario.stringInput}}" ng-model="ctrl.target.stringInput" ng-change="ctrl.refresh()" ng-model-onblur></div><div class="gf-form"><label class="gf-form-label query-keyword">Alias</label><input type="text" class="gf-form-input max-width-7" placeholder="optional" ng-model="ctrl.target.alias" ng-change="ctrl.refresh()" ng-model-onblur></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div></query-editor-row>'),a.put("public/app/plugins/datasource/cloudwatch/partials/annotations.editor.html",'<cloudwatch-query-parameter target="ctrl.annotation" datasource="ctrl.datasource"></cloudwatch-query-parameter><div class="editor-row" style="padding: 2rem 0"><div class="section"><h5>Prefix matching</h5><div class="editor-option"><editor-checkbox text="Enable" model="ctrl.annotation.prefixMatching"></editor-checkbox></div><div class="editor-option" ng-if="ctrl.annotation.prefixMatching"><label class="small">Action</label><input type="text" class="input-small" ng-model="ctrl.annotation.actionPrefix"></div><div class="editor-option" ng-if="ctrl.annotation.prefixMatching"><label class="small">Alarm Name</label><input type="text" class="input-small" ng-model="ctrl.annotation.alarmNamePrefix"></div></div></div>'),a.put("public/app/plugins/datasource/cloudwatch/partials/config.html",'<h3 class="page-heading">CloudWatch details</h3><div class="gf-form-group max-width-30"><div class="gf-form"><label class="gf-form-label width-13">Auth Provider</label><select class="gf-form-input gf-max-width-13" ng-model="ctrl.current.jsonData.authType" ng-options="f.value as f.name for f in ctrl.authTypes"></select></div><div class="gf-form" ng-show=\'ctrl.current.jsonData.authType == "credentials"\'><label class="gf-form-label width-13">Credentials profile name</label><input type="text" class="gf-form-input max-width-18" ng-model="ctrl.current.database" placeholder="default"><info-popover mode="right-absolute">Credentials profile name, as specified in ~/.aws/credentials, leave blank for default</info-popover></div><div class="gf-form" ng-show=\'ctrl.current.jsonData.authType == "keys"\'><label class="gf-form-label width-13">Access key ID</label><label class="gf-form-label width-13" ng-show="ctrl.accessKeyExist">Configured</label><a class="btn btn-secondary gf-form-btn" type="submit" ng-click="ctrl.resetAccessKey()" ng-show="ctrl.accessKeyExist">Reset</a> <input type="text" class="gf-form-input max-width-18" ng-hide="ctrl.accessKeyExist" ng-model="ctrl.current.secureJsonData.accessKey"></div><div class="gf-form" ng-show=\'ctrl.current.jsonData.authType == "keys"\'><label class="gf-form-label width-13">Secret access key</label><label class="gf-form-label width-13" ng-show="ctrl.secretKeyExist">Configured</label><a class="btn btn-secondary gf-form-btn" type="submit" ng-click="ctrl.resetSecretKey()" ng-show="ctrl.secretKeyExist">Reset</a> <input type="text" class="gf-form-input max-width-18" ng-hide="ctrl.secretKeyExist" ng-model="ctrl.current.secureJsonData.secretKey"></div><div class="gf-form" ng-show=\'ctrl.current.jsonData.authType == "arn"\'><label class="gf-form-label width-13">Assume Role ARN</label><input type="text" class="gf-form-input max-width-18" ng-model="ctrl.current.jsonData.assumeRoleArn" placeholder="arn:aws:iam:*"><info-popover mode="right-absolute">ARN of Assume Role</info-popover></div><div class="gf-form"><label class="gf-form-label width-13">Default Region</label><div class="gf-form-select-wrapper max-width-18 gf-form-select-wrapper--has-help-icon"><select class="gf-form-input" ng-model="ctrl.current.jsonData.defaultRegion" ng-options="region for region in [\'ap-northeast-1\', \'ap-northeast-2\', \'ap-southeast-1\', \'ap-southeast-2\', \'ap-south-1\', \'ca-central-1\', \'cn-north-1\', \'eu-central-1\', \'eu-west-1\', \'eu-west-2\', \'sa-east-1\', \'us-east-1\', \'us-east-2\', \'us-gov-west-1\', \'us-west-1\', \'us-west-2\']"></select><info-popover mode="right-absolute">Specify the region, such as for US West (Oregon) use ` us-west-2 ` as the region.</info-popover></div></div><div class="gf-form"><label class="gf-form-label width-13">Custom Metrics</label><input type="text" class="gf-form-input max-width-18" ng-model="ctrl.current.jsonData.customMetricsNamespaces" placeholder="Namespace1,Namespace2"><info-popover mode="right-absolute">Namespaces of Custom Metrics</info-popover></div></div>'),a.put("public/app/plugins/datasource/cloudwatch/partials/query.editor.html",'<query-editor-row query-ctrl="ctrl" can-collapse="false"><cloudwatch-query-parameter target="ctrl.target" datasource="ctrl.datasource" on-change="ctrl.refresh()"></cloudwatch-query-parameter></query-editor-row>'),a.put("public/app/plugins/datasource/cloudwatch/partials/query.parameter.html",'<div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label query-keyword width-7">Metric</label><metric-segment segment="regionSegment" get-options="getRegions()" on-change="regionChanged()"></metric-segment><metric-segment segment="namespaceSegment" get-options="getNamespaces()" on-change="namespaceChanged()"></metric-segment><metric-segment segment="metricSegment" get-options="getMetrics()" on-change="metricChanged()"></metric-segment></div><div class="gf-form"><label class="gf-form-label query-keyword">Stats</label></div><div class="gf-form" ng-repeat="segment in statSegments"><metric-segment segment="segment" get-options="getStatSegments(segment, $index)" on-change="statSegmentChanged(segment, $index)"></metric-segment></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label query-keyword width-7">Dimensions</label><metric-segment ng-repeat="segment in dimSegments" segment="segment" get-options="getDimSegments(segment, $index)" on-change="dimSegmentChanged(segment, $index)"></metric-segment></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label query-keyword width-7">Period<info-popover mode="right-normal">Interval between points in seconds</info-popover></label><input type="text" class="gf-form-input" ng-model="target.period" spellcheck="false" placeholder="auto" ng-model-onblur ng-change="onChange()"></div><div class="gf-form max-width-30"><label class="gf-form-label query-keyword width-7">Alias</label><input type="text" class="gf-form-input" ng-model="target.alias" spellcheck="false" ng-model-onblur ng-change="onChange()"><info-popover mode="right-absolute">Alias replacement variables:<ul ng-non-bindable><li>{{metric}}</li><li>{{stat}}</li><li>{{namespace}}</li><li>{{region}}</li><li>{{YOUR_DIMENSION_NAME}}</li></ul></info-popover></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div>'),a.put("public/app/plugins/datasource/elasticsearch/partials/annotations.editor.html",'<div class="gf-form-group"><div class="gf-form" ng-if="ctrl.annotation.index"><span class="gf-form-label width-14">Index name</span> <input type="text" class="gf-form-input max-width-20" ng-model="ctrl.annotation.index" placeholder="events-*"></div><div class="gf-form-group"><div class="gf-form"><input type="text" class="gf-form-input" ng-model="ctrl.annotation.query" placeholder="Elasticsearch lucene query"></div></div></div><div class="gf-form-group"><h6>Field mappings</h6><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-10">Time</span> <input type="text" class="gf-form-input max-width-16" ng-model="ctrl.annotation.timeField" placeholder="@timestamp"></div><div class="gf-form"><span class="gf-form-label width-10">Title</span> <input type="text" class="gf-form-input max-width-16" ng-model="ctrl.annotation.titleField" placeholder="desc"></div></div><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-10">Tags</span> <input type="text" class="gf-form-input max-width-16" ng-model="ctrl.annotation.tagsField" placeholder="tags"></div><div class="gf-form"><span class="gf-form-label width-10">Text</span> <input type="text" class="gf-form-input max-width-16" ng-model="ctrl.annotation.textField" placeholder=""></div></div></div>'),a.put("public/app/plugins/datasource/elasticsearch/partials/bucket_agg.html",'<div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label query-keyword width-7"><span ng-show="isFirst">Group by</span> <span ng-hide="isFirst">Then by</span></label><gf-form-dropdown model="agg.type" lookup-text="true" get-options="getBucketAggTypes()" on-change="onTypeChanged()" allow-custom="false" label-mode="true" css-class="width-10"></gf-form-dropdown><gf-form-dropdown ng-if="agg.field" model="agg.field" get-options="getFieldsInternal()" on-change="onChange()" allow-custom="false" label-mode="true" css-class="width-12"></gf-form-dropdown></div><div class="gf-form gf-form--grow"><label class="gf-form-label gf-form-label--grow"><a ng-click="toggleOptions()"><i class="fa fa-caret-down" ng-show="showOptions"></i> <i class="fa fa-caret-right" ng-hide="showOptions"></i> {{settingsLinkText}}</a></label></div><div class="gf-form"><label class="gf-form-label" ng-if="isFirst"><a class="pointer" ng-click="addBucketAgg()"><i class="fa fa-plus"></i></a></label><label class="gf-form-label" ng-if="bucketAggCount > 1"><a class="pointer" ng-click="removeBucketAgg()"><i class="fa fa-minus"></i></a></label></div></div><div class="gf-form-group" ng-if="showOptions"><div ng-if="agg.type === \'date_histogram\'"><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Interval</label><gf-form-dropdown model="agg.settings.interval" get-options="getIntervalOptions()" on-change="onChangeInternal()" allow-custom="true" label-mode="true" css-class="width-12"></gf-form-dropdown></div><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Min Doc Count</label><input type="number" class="gf-form-input max-width-12" ng-model="agg.settings.min_doc_count" ng-blur="onChangeInternal()"></div><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Trim edges<info-popover mode="right-normal">Trim the edges on the timeseries datapoints</info-popover></label><input class="gf-form-input max-width-12" type="number" ng-model="agg.settings.trimEdges" ng-change="onChangeInternal()"></div></div><div ng-if="agg.type === \'histogram\'"><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Interval</label><input type="number" class="gf-form-input max-width-12" ng-model="agg.settings.interval" ng-blur="onChangeInternal()"></div><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Min Doc Count</label><input type="number" class="gf-form-input max-width-12" ng-model="agg.settings.min_doc_count" ng-blur="onChangeInternal()"></div></div><div ng-if="agg.type === \'terms\'"><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Order</label><gf-form-dropdown model="agg.settings.order" lookup-text="true" get-options="getOrderOptions()" on-change="onChangeInternal()" label-mode="true" css-class="width-12"></gf-form-dropdown></div><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Size</label><gf-form-dropdown model="agg.settings.size" lookup-text="true" get-options="getSizeOptions()" on-change="onChangeInternal()" label-mode="true" css-class="width-12"></gf-form-dropdown></div><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Min Doc Count</label><input type="number" class="gf-form-input max-width-12" ng-model="agg.settings.min_doc_count" ng-blur="onChangeInternal()"></div><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Order By</label><gf-form-dropdown model="agg.settings.orderBy" lookup-text="true" get-options="getOrderByOptions()" on-change="onChangeInternal()" label-mode="true" css-class="width-12"></gf-form-dropdown></div><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Missing<info-popover mode="right-normal">The missing parameter defines how documents that are missing a value should be treated. By default they will be ignored but it is also possible to treat them as if they had a value</info-popover></label><input type="text" class="gf-form-input max-width-12" empty-to-null ng-model="agg.settings.missing" ng-blur="onChangeInternal()" spellcheck="false"></div></div><div ng-if="agg.type === \'filters\'"><div class="gf-form-inline offset-width-7" ng-repeat="filter in agg.settings.filters"><div class="gf-form"><label class="gf-form-label width-10">Query {{$index + 1}}</label><input type="text" class="gf-form-input max-width-12" ng-model="filter.query" spellcheck="false" placeholder="Lucene query" ng-blur="onChangeInternal()"><label class="gf-form-label width-10">Label {{$index + 1}}</label><input type="text" class="gf-form-input max-width-12" ng-model="filter.label" spellcheck="false" placeholder="Label" ng-blur="onChangeInternal()"></div><div class="gf-form"><label class="gf-form-label" ng-if="$first"><a class="pointer" ng-click="addFiltersQuery()"><i class="fa fa-plus"></i></a></label><label class="gf-form-label" ng-if="!$first"><a class="pointer" ng-click="removeFiltersQuery(filter)"><i class="fa fa-minus"></i></a></label></div></div></div><div ng-if="agg.type === \'geohash_grid\'"><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Precision</label><input type="number" class="gf-form-input max-width-12" ng-model="agg.settings.precision" spellcheck="false" placeholder="3" ng-blur="onChangeInternal()"></div></div></div>'),a.put("public/app/plugins/datasource/elasticsearch/partials/config.html",'<datasource-http-settings current="ctrl.current" suggest-url="http://localhost:9200"></datasource-http-settings><h3 class="page-heading">Elasticsearch details</h3><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form max-width-25"><span class="gf-form-label width-9">Index name</span> <input class="gf-form-input" type="text" ng-model="ctrl.current.database" placeholder="" required></div><div class="gf-form width-14"><span class="gf-form-label width-9">Pattern</span><select class="gf-form-input gf-size-auto" ng-model="ctrl.current.jsonData.interval" ng-options="f.value as f.name for f in ctrl.indexPatternTypes" ng-change="ctrl.indexPatternTypeChanged()"></select></div></div><div class="gf-form max-width-25"><span class="gf-form-label width-9">Time field name</span> <input class="gf-form-input" type="text" ng-model="ctrl.current.jsonData.timeField" placeholder="" required ng-init=""></div><div class="gf-form"><span class="gf-form-label width-9">Version</span><select class="gf-form-input gf-size-auto" ng-model="ctrl.current.jsonData.esVersion" ng-options="f.value as f.name for f in ctrl.esVersions"></select></div><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-9">Min interval</span> <input type="text" class="gf-form-input width-6" ng-model="ctrl.current.jsonData.timeInterval" spellcheck="false" placeholder="10s"><info-popover mode="right-absolute">A lower limit for the auto group by time interval. Recommended to be set to write frequency, for example <code>1m</code> if your data is written every minute.</info-popover></div></div></div>'),
a.put("public/app/plugins/datasource/elasticsearch/partials/metric_agg.html",'<div class="gf-form-inline" ng-class="{\'gf-form-disabled\': agg.hide}"><div class="gf-form"><label class="gf-form-label query-keyword width-7">Metric &nbsp; <a ng-click="toggleShowMetric()" bs-tooltip="\'Click to toggle show / hide metric\'"><i class="fa fa-eye" ng-hide="agg.hide"></i> <i class="fa fa-eye-slash" ng-show="agg.hide"></i></a></label></div><div class="gf-form"><metric-segment-model property="agg.type" options="metricAggTypes" on-change="onTypeChange()" custom="false" css-class="width-10"></metric-segment-model><metric-segment-model ng-if="aggDef.requiresField" property="agg.field" get-options="getFieldsInternal()" on-change="onChange()" css-class="width-12"></metric-segment-model><metric-segment-model ng-if="aggDef.isPipelineAgg" property="agg.pipelineAgg" options="pipelineAggOptions" on-change="onChangeInternal()" custom="false" css-class="width-12"></metric-segment-model></div><div class="gf-form gf-form--grow"><label class="gf-form-label gf-form-label--grow"><a ng-click="toggleOptions()" ng-if="settingsLinkText"><i class="fa fa-caret-down" ng-show="showOptions"></i> <i class="fa fa-caret-right" ng-hide="showOptions"></i> {{settingsLinkText}}</a></label></div><div class="gf-form"><label class="gf-form-label" ng-if="isFirst"><a class="pointer" ng-click="addMetricAgg()"><i class="fa fa-plus"></i></a></label><label class="gf-form-label" ng-if="!isSingle"><a class="pointer" ng-click="removeMetricAgg()"><i class="fa fa-minus"></i></a></label></div></div><div class="gf-form-group" ng-if="showOptions"><div class="gf-form offset-width-7" ng-if="agg.type === \'derivative\'"><label class="gf-form-label width-10">Unit</label><input type="text" class="gf-form-input max-width-12" ng-model="agg.settings.unit" ng-blur="onChangeInternal()" spellcheck="false"></div><div ng-if="agg.type === \'moving_avg\'"><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Model</label><metric-segment-model property="agg.settings.model" options="movingAvgModelTypes" on-change="onChangeClearInternal()" custom="false" css-class="width-12"></metric-segment-model></div><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Window</label><input type="number" class="gf-form-input max-width-12" ng-model="agg.settings.window" ng-blur="onChangeInternal()" spellcheck="false"></div><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Predict</label><input type="number" class="gf-form-input max-width-12" ng-model="agg.settings.predict" ng-blur="onChangeInternal()" spellcheck="false"></div><div class="gf-form offset-width-7" ng-repeat="setting in modelSettings"><label class="gf-form-label width-10">{{setting.text}}</label><input type="number" class="gf-form-input max-width-12" ng-model="agg.settings.settings[setting.value]" ng-blur="onChangeInternal()" spellcheck="false"></div><gf-form-switch ng-if="agg.settings.model == \'holt_winters\'" class="gf-form offset-width-7" label="Pad" label-class="width-10" checked="agg.settings.settings.pad" on-change="onChangeInternal()"></gf-form-switch><gf-form-switch ng-if="agg.settings.model.match(\'ewma|holt_winters|holt\') !== null" class="gf-form offset-width-7" label="Minimize" label-class="width-10" checked="agg.settings.minimize" on-change="onChangeInternal()"></gf-form-switch></div><div class="gf-form offset-width-7" ng-if="agg.type === \'percentiles\'"><label class="gf-form-label width-10">Percentiles</label><input type="text" class="gf-form-input max-width-12" ng-model="agg.settings.percents" array-join ng-blur="onChange()"></div><div class="gf-form offset-width-7" ng-if="agg.type === \'raw_document\'"><label class="gf-form-label width-10">Size</label><input type="number" class="gf-form-input max-width-12" ng-model="agg.settings.size" ng-blur="onChange()"></div><div class="gf-form offset-width-7" ng-if="agg.type === \'cardinality\'"><label class="gf-form-label width-10">Precision threshold</label><input type="number" class="gf-form-input max-width-12" ng-model="agg.settings.precision_threshold" ng-blur="onChange()"></div><div ng-if="agg.type === \'extended_stats\'"><gf-form-switch ng-repeat="stat in extendedStats" class="gf-form offset-width-7" label="{{stat.text}}" label-class="width-10" checked="agg.meta[stat.value]" on-change="onChangeInternal()"></gf-form-switch><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Sigma</label><input type="number" class="gf-form-input max-width-12" placeholder="3" ng-model="agg.settings.sigma" ng-blur="onChange()"></div></div><div class="gf-form offset-width-7" ng-if="aggDef.supportsInlineScript"><label class="gf-form-label width-10">Script</label><input type="text" class="gf-form-input max-width-12" empty-to-null ng-model="agg.inlineScript" ng-blur="onChangeInternal()" spellcheck="false" placeholder="_value * 1"></div><div class="gf-form offset-width-7" ng-if="aggDef.supportsMissing"><label class="gf-form-label width-10">Missing<tip>The missing parameter defines how documents that are missing a value should be treated. By default they will be ignored but it is also possible to treat them as if they had a value</tip></label><input type="number" class="gf-form-input max-width-12" empty-to-null ng-model="agg.settings.missing" ng-blur="onChangeInternal()" spellcheck="false"></div></div>'),a.put("public/app/plugins/datasource/elasticsearch/partials/query.editor.html",'<query-editor-row query-ctrl="ctrl" can-collapse="true"><div class="gf-form-inline"><div class="gf-form gf-form--grow"><label class="gf-form-label query-keyword width-7">Query</label><input type="text" class="gf-form-input" ng-model="ctrl.target.query" spellcheck="false" placeholder="Lucene query" ng-blur="ctrl.refresh()"></div><div class="gf-form max-width-15"><label class="gf-form-label query-keyword">Alias</label><input type="text" class="gf-form-input" ng-model="ctrl.target.alias" spellcheck="false" placeholder="alias patterns" ng-blur="ctrl.refresh()"></div></div><div ng-repeat="agg in ctrl.target.metrics"><elastic-metric-agg target="ctrl.target" index="$index" get-fields="ctrl.getFields($fieldType)" on-change="ctrl.queryUpdated()" es-version="ctrl.esVersion"></elastic-metric-agg></div><div ng-repeat="agg in ctrl.target.bucketAggs"><elastic-bucket-agg target="ctrl.target" index="$index" get-fields="ctrl.getFields($fieldType)" on-change="ctrl.queryUpdated()"></elastic-bucket-agg></div></query-editor-row>'),a.put("public/app/plugins/datasource/grafana-live/partials/query.editor.html",'<query-editor-row query-ctrl="ctrl" can-collapse="false"><div class="gf-form-inline"><div class="gf-form gf-form--grow"><label class="gf-form-label width-8">Stream</label><input type="text" class="gf-form-input" ng-model="ctrl.target.stream" spellcheck="false" placeholder="metric"></div></div></query-editor-row>'),a.put("public/app/plugins/datasource/grafana/partials/annotations.editor.html",'<div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-7">Type</span><div class="gf-form-select-wrapper"><select class="gf-form-input" ng-model="ctrl.annotation.type" ng-options="f.value as f.text for f in [{text: \'Event\', value: \'event\'}, {text: \'Alert\', value: \'alert\'}]"></select></div></div><div class="gf-form"><span class="gf-form-label width-7">Max limit</span><div class="gf-form-select-wrapper"><select class="gf-form-input" ng-model="ctrl.annotation.limit" ng-options="f for f in [10,50,100,200,300,500,1000,2000]"></select></div></div></div></div>'),a.put("public/app/plugins/datasource/grafana/partials/query.editor.html",'<query-editor-row query-ctrl="ctrl" can-collapse="false"><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label">Test data: random walk</label></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div></query-editor-row>'),a.put("public/app/plugins/datasource/graphite/partials/annotations.editor.html",'<div class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-12">Graphite query</span> <input type="text" class="gf-form-input" ng-model="ctrl.annotation.target" placeholder="Example: statsd.application.counters.*.count"></div><h5 class="section-heading">Or</h5><div class="gf-form"><span class="gf-form-label width-12">Graphite events tags</span> <input type="text" class="gf-form-input" ng-model="ctrl.annotation.tags" placeholder="Example: event_tag_name"></div></div>'),a.put("public/app/plugins/datasource/graphite/partials/config.html",'<datasource-http-settings current="ctrl.current" suggest-url="http://localhost:8080"></datasource-http-settings><h3 class="page-heading">Graphite details</h3><div class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-8">Version<info-popover mode="right-normal" position="top center">This option controls what functions are available in the Graphite query editor.</info-popover></span><select class="gf-form-input gf-size-auto" ng-model="ctrl.current.jsonData.graphiteVersion" ng-options="f.value as f.name for f in ctrl.graphiteVersions"></select></div></div>'),a.put("public/app/plugins/datasource/graphite/partials/query.editor.html",'<query-editor-row query-ctrl="ctrl" has-text-edit-mode="true"><div class="gf-form" ng-show="ctrl.target.textEditor"><input type="text" class="gf-form-input" ng-model="ctrl.target.target" spellcheck="false" ng-blur="ctrl.targetTextChanged()"></div><div ng-hide="ctrl.target.textEditor"><div class="gf-form-inline"><div ng-repeat="segment in ctrl.segments" role="menuitem" class="gf-form"><metric-segment segment="segment" get-options="ctrl.getAltSegments($index)" on-change="ctrl.segmentValueChanged(segment, $index)"></metric-segment></div><div ng-repeat="func in ctrl.functions" class="gf-form"><span graphite-func-editor class="gf-form-label query-part"></span></div><div class="gf-form dropdown"><span graphite-add-func></span></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div></div></query-editor-row>'),a.put("public/app/plugins/datasource/influxdb/partials/annotations.editor.html",'<div class="gf-form-group"><div class="gf-form"><input type="text" class="gf-form-input" ng-model="ctrl.annotation.query" placeholder="select text from events where $timeFilter"></div></div><h5 class="section-heading">Field mappings<tip>If your influxdb query returns more than one field you need to specify the column names below. An annotation event is composed of a title, tags, and an additional text field.</tip></h5><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-4">Title</span> <input type="text" class="gf-form-input max-width-10" ng-model="ctrl.annotation.titleColumn" placeholder=""></div><div class="gf-form"><span class="gf-form-label width-4">Tags</span> <input type="text" class="gf-form-input max-width-10" ng-model="ctrl.annotation.tagsColumn" placeholder=""></div><div class="gf-form"><span class="gf-form-label width-4">Text</span> <input type="text" class="gf-form-input max-width-10" ng-model="ctrl.annotation.textColumn" placeholder=""></div></div></div>'),a.put("public/app/plugins/datasource/influxdb/partials/config.html",'<datasource-http-settings current="ctrl.current" suggest-url="http://localhost:8086"></datasource-http-settings><h3 class="page-heading">InfluxDB Details</h3><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form max-width-30"><span class="gf-form-label width-7">Database</span> <input type="text" class="gf-form-input" ng-model="ctrl.current.database" placeholder="" required></div></div><div class="gf-form-inline"><div class="gf-form max-width-15"><span class="gf-form-label width-7">User</span> <input type="text" class="gf-form-input" ng-model="ctrl.current.user" placeholder=""></div><div class="gf-form max-width-15"><span class="gf-form-label width-7">Password</span> <input type="password" class="gf-form-input" ng-model="ctrl.current.password" placeholder=""></div></div></div><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label">Min time interval</span> <input type="text" class="gf-form-input width-6" ng-model="ctrl.current.jsonData.timeInterval" spellcheck="false" placeholder="10s"><info-popover mode="right-absolute">A lower limit for the auto group by time interval. Recommended to be set to write frequency, for example <code>1m</code> if your data is written every minute.</info-popover></div></div></div>'),a.put("public/app/plugins/datasource/influxdb/partials/query.editor.html",'<query-editor-row query-ctrl="ctrl" can-collapse="true" has-text-edit-mode="true"><div ng-if="ctrl.target.rawQuery"><div class="gf-form"><textarea rows="3" class="gf-form-input" ng-model="ctrl.target.query" spellcheck="false" placeholder="InfuxDB Query" ng-model-onblur ng-change="ctrl.refresh()"></textarea></div><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label query-keyword">FORMAT AS</label><div class="gf-form-select-wrapper"><select class="gf-form-input gf-size-auto" ng-model="ctrl.target.resultFormat" ng-options="f.value as f.text for f in ctrl.resultFormats" ng-change="ctrl.refresh()"></select></div></div><div class="gf-form max-width-25" ng-hide="ctrl.target.resultFormat === \'table\'"><label class="gf-form-label query-keyword">ALIAS BY</label><input type="text" class="gf-form-input" ng-model="ctrl.target.alias" spellcheck="false" placeholder="Naming pattern" ng-blur="ctrl.refresh()"></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div></div><div ng-if="!ctrl.target.rawQuery"><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label query-keyword width-7">FROM</label><metric-segment segment="ctrl.policySegment" get-options="ctrl.getPolicySegments()" on-change="ctrl.policyChanged()"></metric-segment><metric-segment segment="ctrl.measurementSegment" get-options="ctrl.getMeasurements($query)" on-change="ctrl.measurementChanged()"></metric-segment></div><div class="gf-form"><label class="gf-form-label query-keyword">WHERE</label></div><div class="gf-form" ng-repeat="segment in ctrl.tagSegments"><metric-segment segment="segment" get-options="ctrl.getTagsOrValues(segment, $index)" on-change="ctrl.tagSegmentUpdated(segment, $index)"></metric-segment></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline" ng-repeat="selectParts in ctrl.queryModel.selectModels"><div class="gf-form"><label class="gf-form-label query-keyword width-7"><span ng-show="$index === 0">SELECT</span>&nbsp;</label></div><div class="gf-form" ng-repeat="part in selectParts"><query-part-editor class="gf-form-label query-part" part="part" handle-event="ctrl.handleSelectPartEvent(selectParts, part, $event)"></query-part-editor></div><div class="gf-form"><label class="dropdown" dropdown-typeahead="ctrl.selectMenu" dropdown-typeahead-on-select="ctrl.addSelectPart(selectParts, $item, $subItem)"></label></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label query-keyword width-7"><span>GROUP BY</span></label><query-part-editor ng-repeat="part in ctrl.queryModel.groupByParts" part="part" class="gf-form-label query-part" handle-event="ctrl.handleGroupByPartEvent(part, $index, $event)"></query-part-editor></div><div class="gf-form"><metric-segment segment="ctrl.groupBySegment" get-options="ctrl.getGroupByOptions()" on-change="ctrl.groupByAction(part, $index)"></metric-segment></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline" ng-if="ctrl.target.orderByTime === \'DESC\'"><div class="gf-form"><label class="gf-form-label query-keyword width-7">ORDER BY</label><label class="gf-form-label pointer" ng-click="ctrl.removeOrderByTime()">time <span class="query-keyword">DESC</span> <i class="fa fa-remove"></i></label></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline" ng-if="ctrl.target.limit"><div class="gf-form"><label class="gf-form-label query-keyword width-7">LIMIT</label><input type="text" class="gf-form-input width-9" ng-model="ctrl.target.limit" spellcheck="false" placeholder="No Limit" ng-blur="ctrl.refresh()"></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline" ng-if="ctrl.target.slimit"><div class="gf-form"><label class="gf-form-label query-keyword width-7">SLIMIT</label><input type="text" class="gf-form-input width-9" ng-model="ctrl.target.slimit" spellcheck="false" placeholder="No Limit" ng-blur="ctrl.refresh()"></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label query-keyword width-7">FORMAT AS</label><div class="gf-form-select-wrapper"><select class="gf-form-input gf-size-auto" ng-model="ctrl.target.resultFormat" ng-options="f.value as f.text for f in ctrl.resultFormats" ng-change="ctrl.refresh()"></select></div></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline" ng-hide="ctrl.target.resultFormat === \'table\'"><div class="gf-form max-width-30"><label class="gf-form-label query-keyword width-7">ALIAS BY</label><input type="text" class="gf-form-input" ng-model="ctrl.target.alias" spellcheck="false" placeholder="Naming pattern" ng-blur="ctrl.refresh()"></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div></div></query-editor-row>'),a.put("public/app/plugins/datasource/mysql/partials/annotations.editor.html",'<div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form gf-form--grow"><textarea rows="10" class="gf-form-input" ng-model="ctrl.annotation.rawQuery" spellcheck="false" placeholder="query expression" data-min-length="0" data-items="100" ng-model-onblur ng-change="ctrl.panelCtrl.refresh()"></textarea></div></div><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label query-keyword" ng-click="ctrl.showHelp = !ctrl.showHelp">Show Help <i class="fa fa-caret-down" ng-show="ctrl.showHelp"></i> <i class="fa fa-caret-right" ng-hide="ctrl.showHelp"></i></label></div></div><div class="gf-form" ng-show="ctrl.showHelp"><pre class="gf-form-pre alert alert-info"><h6>Annotation Query Format</h6>\nAn annotation is an event that is overlayed on top of graphs. The query can have up to four columns per row, the time_sec column is mandatory. Annotation rendering is expensive so it is important to limit the number of rows returned.\n\n- column with alias: <b>time_sec</b> for the annotation event. Format is UTC in seconds, use UNIX_TIMESTAMP(column)\n- column with alias <b>title</b> for the annotation title\n- column with alias: <b>text</b> for the annotation text\n- column with alias: <b>tags</b> for annotation tags. This is a comma separated string of tags e.g. \'tag1,tag2\'\n\n\nMacros:\n- $__time(column) -&gt; UNIX_TIMESTAMP(column) as time_sec\n- $__timeFilter(column) -&gt;  UNIX_TIMESTAMP(time_date_time) &gt; 1492750877 AND UNIX_TIMESTAMP(time_date_time) &lt; 1492750877\n- $__unixEpochFilter(column) -&gt;  time_unix_epoch &gt; 1492750877 AND time_unix_epoch &lt; 1492750877\n\nOr build your own conditionals using these macros which just return the values:\n- $__timeFrom() -&gt;  FROM_UNIXTIME(1492750877)\n- $__timeTo() -&gt;  FROM_UNIXTIME(1492750877)\n- $__unixEpochFrom() -&gt;  1492750877\n- $__unixEpochTo() -&gt;  1492750877\n\t\t</pre></div></div>'),a.put("public/app/plugins/datasource/mysql/partials/config.html",'<h3 class="page-heading">MySQL Connection</h3><div class="gf-form-group"><div class="gf-form max-width-30"><span class="gf-form-label width-7">Host</span> <input type="text" class="gf-form-input" ng-model="ctrl.current.url" placeholder="localhost:3306" bs-typeahead="{{[\'localhost:3306\', \'localhost:3307\']}}" required></div><div class="gf-form max-width-30"><span class="gf-form-label width-7">Database</span> <input type="text" class="gf-form-input" ng-model="ctrl.current.database" placeholder="" required></div><div class="gf-form-inline"><div class="gf-form max-width-15"><span class="gf-form-label width-7">User</span> <input type="text" class="gf-form-input" ng-model="ctrl.current.user" placeholder=""></div><div class="gf-form max-width-15"><span class="gf-form-label width-7">Password</span> <input type="password" class="gf-form-input" ng-model="ctrl.current.password" placeholder=""></div></div></div><div class="gf-form-group"><div class="grafana-info-box"><h5>User Permission</h5><p>The database user should only be granted SELECT permissions on the specified database &amp; tables you want to query. Grafana does not validate that queries are safe so queries can contain any SQL statement. For example, statements like <code>USE otherdb;</code> and <code>DROP TABLE user;</code> would be executed. To protect against this we <strong>Highly</strong> recommmend you create a specific MySQL user with restricted permissions. Checkout the <a class="external-link" target="_blank" href="http://docs.grafana.org/features/datasources/mysql/">MySQL Data Source Docs</a> for more information.</p></div></div>'),a.put("public/app/plugins/datasource/mysql/partials/query.editor.html",'<query-editor-row query-ctrl="ctrl" can-collapse="false"><div class="gf-form-inline"><div class="gf-form gf-form--grow"><code-editor content="ctrl.target.rawSql" on-change="ctrl.panelCtrl.refresh()" data-mode="sql"></code-editor></div></div><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label query-keyword">Format as</label><div class="gf-form-select-wrapper"><select class="gf-form-input gf-size-auto" ng-model="ctrl.target.format" ng-options="f.value as f.text for f in ctrl.formats" ng-change="ctrl.refresh()"></select></div></div><div class="gf-form"><label class="gf-form-label query-keyword" ng-click="ctrl.showHelp = !ctrl.showHelp">Show Help <i class="fa fa-caret-down" ng-show="ctrl.showHelp"></i> <i class="fa fa-caret-right" ng-hide="ctrl.showHelp"></i></label></div><div class="gf-form" ng-show="ctrl.lastQueryMeta"><label class="gf-form-label query-keyword" ng-click="ctrl.showLastQuerySQL = !ctrl.showLastQuerySQL">Generated SQL <i class="fa fa-caret-down" ng-show="ctrl.showLastQuerySQL"></i> <i class="fa fa-caret-right" ng-hide="ctrl.showLastQuerySQL"></i></label></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form" ng-show="ctrl.showLastQuerySQL"><pre class="gf-form-pre">{{ctrl.lastQueryMeta.sql}}</pre></div><div class="gf-form" ng-show="ctrl.showHelp"><pre class="gf-form-pre alert alert-info">Time series:\n- return column named time_sec (UTC in seconds), use UNIX_TIMESTAMP(column)\n- return column named value for the time point value\n- return column named metric to represent the series name\n\nTable:\n- return any set of columns\n\nMacros:\n- $__time(column) -&gt; UNIX_TIMESTAMP(column) as time_sec\n- $__timeFilter(column) -&gt;  UNIX_TIMESTAMP(time_date_time) &ge; 1492750877 AND UNIX_TIMESTAMP(time_date_time) &le; 1492750877\n- $__unixEpochFilter(column) -&gt;  time_unix_epoch &gt; 1492750877 AND time_unix_epoch &lt; 1492750877\n\nOr build your own conditionals using these macros which just return the values:\n- $__timeFrom() -&gt;  FROM_UNIXTIME(1492750877)\n- $__timeTo() -&gt;  FROM_UNIXTIME(1492750877)\n- $__unixEpochFrom() -&gt;  1492750877\n- $__unixEpochTo() -&gt;  1492750877\n\t\t</pre></div><div class="gf-form" ng-show="ctrl.lastQueryError"><pre class="gf-form-pre alert alert-error">{{ctrl.lastQueryError}}</pre></div></query-editor-row>'),a.put("public/app/plugins/datasource/opentsdb/partials/annotations.editor.html",'<div class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-13">OpenTSDB metrics query</span> <input type="text" class="gf-form-input" ng-model="ctrl.annotation.target" placeholder="events.eventname"></div><div class="gf-form"><span class="gf-form-label width-13">Show Global Annotations?</span><editor-checkbox text="" model="ctrl.annotation.isGlobal"></editor-checkbox></div></div>'),a.put("public/app/plugins/datasource/opentsdb/partials/config.html",'<datasource-http-settings current="ctrl.current" suggest-url="http://localhost:4242"></datasource-http-settings><h5>OpenTSDB settings</h5><div class="gf-form"><span class="gf-form-label width-7">Version </span><span class="gf-form-select-wrapper"><select class="gf-form-input gf-size-auto" ng-model="ctrl.current.jsonData.tsdbVersion" ng-options="v.value as v.name for v in ctrl.tsdbVersions"></select></span></div><div class="gf-form"><span class="gf-form-label width-7">Resolution </span><span class="gf-form-select-wrapper"><select class="gf-form-input gf-size-auto" ng-model="ctrl.current.jsonData.tsdbResolution" ng-options="v.value as v.name for v in ctrl.tsdbResolutions"></select></span></div>'),a.put("public/app/plugins/datasource/opentsdb/partials/query.editor.html",'<query-editor-row query-ctrl="ctrl" can-collapse="false"><div class="gf-form-inline"><div class="gf-form max-width-25"><label class="gf-form-label query-keyword width-8">Metric<label class="gf-form-label" bs-tooltip="ctrl.errors.metric" style="color: rgb(229, 189, 28)" ng-show="ctrl.errors.metric"><i class="fa fa-warning"></i></label></label><input type="text" class="gf-form-input" ng-model="ctrl.target.metric" spellcheck="false" bs-typeahead="ctrl.suggestMetrics" placeholder="metric name" data-min-length="0" data-items="100" ng-blur="ctrl.targetBlur()"></div><div class="gf-form"><label class="gf-form-label query-keyword">Aggregator <a bs-tooltip="ctrl.errors.aggregator" style="color: rgb(229, 189, 28)" ng-show="ctrl.errors.aggregator"><i class="fa fa-warning"></i></a></label><div class="gf-form-select-wrapper max-width-15"><select ng-model="ctrl.target.aggregator" class="gf-form-input" ng-options="agg for agg in ctrl.aggregators" ng-change="ctrl.targetBlur()"></select></div></div><div class="gf-form max-width-20"><label class="gf-form-label query-keyword width-6">Alias:<info-popover mode="right-normal">Use patterns like $tag_tagname to replace part of the alias for a tag value</info-popover></label><input type="text" class="gf-form-input" ng-model="ctrl.target.alias" spellcheck="false" placeholder="series alias" data-min-length="0" data-items="100" ng-blur="ctrl.targetBlur()"></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline"><div class="gf-form max-width-25"><label class="gf-form-label query-keyword width-8">Down sample</label><input type="text" class="gf-form-input" ng-model="ctrl.target.downsampleInterval" ng-model-onblur ng-change="ctrl.targetBlur()" placeholder="interval"><info-popover mode="right-absolute">blank for auto, or for example <code>1m</code></info-popover></div><div class="gf-form"><label class="gf-form-label query-keyword">Aggregator</label><div class="gf-form-select-wrapper"><select ng-model="ctrl.target.downsampleAggregator" class="gf-form-input" ng-options="agg for agg in ctrl.aggregators" ng-change="ctrl.targetBlur()"></select></div></div><div class="gf-form" ng-if="ctrl.tsdbVersion >= 2"><label class="gf-form-label query-keyword width-6">Fill</label><div class="gf-form-select-wrapper"><select ng-model="ctrl.target.downsampleFillPolicy" class="gf-form-input" ng-options="agg for agg in ctrl.fillPolicies" ng-change="ctrl.targetBlur()"></select></div></div><gf-form-switch class="gf-form" label="Disable downsampling" label-class="query-keyword" checked="ctrl.target.disableDownsampling" on-change="ctrl.targetBlur()"></gf-form-switch><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline" ng-if="ctrl.tsdbVersion >= 2"><div class="gf-form"><label class="gf-form-label query-keyword width-8">Filters<info-popover mode="right-normal">Filters does not work with tags, either of the two will work but not both.</info-popover></label><div ng-repeat="fil in ctrl.target.filters track by $index" class="gf-form-label">{{fil.tagk}}&nbsp;=&nbsp;{{fil.type}}&#40;{{fil.filter}}&#41;&nbsp;&#44&nbsp;groupBy&nbsp;=&nbsp;{{fil.groupBy}} <a ng-click="ctrl.editFilter(fil, $index)"><i class="fa fa-pencil"></i> </a><a ng-click="ctrl.removeFilter($index)"><i class="fa fa-remove"></i></a></div><label class="gf-form-label query-keyword" ng-hide="ctrl.addFilterMode"><a ng-click="ctrl.addFilter()"><i class="fa fa-plus"></i></a></label></div><div class="gf-form-inline" ng-show="ctrl.addFilterMode"><div class="gf-form"><input type="text" class="gf-form-input" spellcheck="false" bs-typeahead="ctrl.suggestTagKeys" data-min-length="0" data-items="100" ng-model="ctrl.target.currentFilterKey" placeholder="key"></div><div class="gf-form"><label class="gf-form-label query-keyword">Type</label><div class="gf-form-select-wrapper"><select ng-model="ctrl.target.currentFilterType" class="gf-form-input" ng-options="filType for filType in ctrl.filterTypes"></select></div></div><div class="gf-form"><input type="text" class="gf-form-input" spellcheck="false" bs-typeahead="ctrl.suggestTagValues" data-min-length="0" data-items="100" ng-model="ctrl.target.currentFilterValue" placeholder="filter"></div><gf-form-switch class="gf-form" label="Group by" label-class="query-keyword" checked="ctrl.target.currentFilterGroupBy" on-change="ctrl.targetBlur()"></gf-form-switch><div class="gf-form" ng-show="ctrl.addFilterMode"><label class="gf-form-label" ng-show="ctrl.errors.filters"><a bs-tooltip="ctrl.errors.filters" style="color: rgb(229, 189, 28)"><i class="fa fa-warning"></i></a></label><label class="gf-form-label"><a ng-click="ctrl.addFilter()" ng-hide="ctrl.errors.filters">add filter</a> <a ng-click="ctrl.closeAddFilterMode()"><i class="fa fa-remove"></i></a></label></div></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label query-keyword width-8">Tags<info-popover mode="right-normal" ng-if="ctrl.tsdbVersion >= 2">Please use filters, tags are deprecated in opentsdb 2.2</info-popover></label></div><div class="gf-form" ng-repeat="(key, value) in ctrl.target.tags track by $index" class="gf-form"><label class="gf-form-label">{{key}}&nbsp;=&nbsp;{{value}} <a ng-click="ctrl.editTag(key, value)"><i class="fa fa-pencil"></i> </a><a ng-click="ctrl.removeTag(key)"><i class="fa fa-remove"></i></a></label></div><div class="gf-form" ng-hide="ctrl.addTagMode"><label class="gf-form-label query-keyword"><a ng-click="ctrl.addTag()"><i class="fa fa-plus"></i></a></label></div><div class="gf-form" ng-show="ctrl.addTagMode"><input type="text" class="gf-form-input" spellcheck="false" bs-typeahead="ctrl.suggestTagKeys" data-min-length="0" data-items="100" ng-model="ctrl.target.currentTagKey" placeholder="key"><input type="text" class="gf-form-input" spellcheck="false" bs-typeahead="ctrl.suggestTagValues" data-min-length="0" data-items="100" ng-model="ctrl.target.currentTagValue" placeholder="value"><label class="gf-form-label" ng-show="ctrl.errors.tags"><a bs-tooltip="ctrl.errors.tags" style="color: rgb(229, 189, 28)"><i class="fa fa-warning"></i></a></label><label class="gf-form-label"><a ng-click="ctrl.addTag()" ng-hide="ctrl.errors.tags">add tag</a> <a ng-click="ctrl.closeAddTagMode()"><i class="fa fa-remove"></i></a></label></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline"><gf-form-switch class="gf-form" label="Rate" label-class="width-8 query-keyword" checked="ctrl.target.shouldComputeRate" on-change="ctrl.targetBlur()"></gf-form-switch><gf-form-switch ng-hide="!ctrl.target.shouldComputeRate" class="gf-form" label="Counter" label-class="query-keyword" checked="ctrl.target.isCounter" on-change="ctrl.targetBlur()"></gf-form-switch><div class="gf-form" ng-hide="!ctrl.target.isCounter || !ctrl.target.shouldComputeRate"><label class="gf-form-label query-keyword">Counter Max</label><input type="text" class="gf-form-input" ng-disabled="!ctrl.target.shouldComputeRate" ng-model="ctrl.target.counterMax" spellcheck="false" placeholder="max value" ng-model-onblur ng-blur="ctrl.targetBlur()"><label class="gf-form-label query-keyword">Reset Value</label><input type="text" class="tight-form-input input-small" ng-disabled="!ctrl.target.shouldComputeRate" ng-model="ctrl.target.counterResetValue" spellcheck="false" placeholder="reset value" ng-model-onblur ng-blur="ctrl.targetBlur()"></div><div class="gf-form" ng-if="ctrl.tsdbVersion > 2"><gf-form-switch class="gf-form" label="Explicit tags" label-class="width-8 query-keyword" checked="ctrl.target.explicitTags" on-change="ctrl.targetBlur()"></gf-form-switch></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div></query-editor-row>'),
a.put("public/app/plugins/datasource/prometheus/partials/annotations.editor.html",'<div class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-10">Search expression</span> <input type="text" class="gf-form-input" ng-model="ctrl.annotation.expr" placeholder="ALERTS"></div><div class="gf-form"><span class="gf-form-label width-10">step</span> <input type="text" class="gf-form-input max-width-6" ng-model="ctrl.annotation.step" placeholder="60s"></div></div><div class="gf-form-group"><h5 class="section-heading">Field formats<div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-5">Title</span> <input type="text" class="gf-form-input max-width-9" ng-model="ctrl.annotation.titleFormat" placeholder="alertname"></div><div class="gf-form"><span class="gf-form-label width-5">Tags</span> <input type="text" class="gf-form-input max-width-9" ng-model="ctrl.annotation.tagKeys" placeholder="label1,label2"></div><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-5">Text</span> <input type="text" class="gf-form-input max-width-9" ng-model="ctrl.annotation.textFormat" placeholder="instance"></div></div></div></h5></div>'),a.put("public/app/plugins/datasource/prometheus/partials/config.html",'<datasource-http-settings current="ctrl.current" suggest-url="http://localhost:9090"></datasource-http-settings>'),a.put("public/app/plugins/datasource/prometheus/partials/query.editor.html",'<query-editor-row query-ctrl="ctrl" can-collapse="true" has-text-edit-mode="false"><div class="gf-form-inline"><div class="gf-form gf-form--grow"><code-editor content="ctrl.target.expr" datasource="ctrl.datasource" on-change="ctrl.refreshMetricData()" get-completer="ctrl.getCompleter()" data-mode="prometheus" code-editor-focus="ctrl.isLastQuery"></code-editor></div></div><div class="gf-form-inline"><div class="gf-form max-width-26"><label class="gf-form-label width-8">Legend format</label><input type="text" class="gf-form-input" ng-model="ctrl.target.legendFormat" spellcheck="false" placeholder="legend format" data-min-length="0" data-items="1000" ng-model-onblur ng-change="ctrl.refreshMetricData()"></div><div class="gf-form"><label class="gf-form-label width-6">Min step</label><input type="text" class="gf-form-input width-8" ng-model="ctrl.target.interval" data-placement="right" spellcheck="false" placeholder="{{ctrl.panelCtrl.interval}}" data-min-length="0" data-items="100" ng-model-onblur ng-change="ctrl.refreshMetricData()"><info-popover mode="right-absolute">Leave blank for auto handling based on time range and panel width</info-popover></div><div class="gf-form"><label class="gf-form-label">Resolution</label><div class="gf-form-select-wrapper max-width-15"><select ng-model="ctrl.target.intervalFactor" class="gf-form-input" ng-options="r.factor as r.label for r in ctrl.resolutions" ng-change="ctrl.refreshMetricData()"></select></div></div><div class="gf-form"><label class="gf-form-label width-6">Format as</label><div class="gf-form-select-wrapper width-8"><select class="gf-form-input gf-size-auto" ng-model="ctrl.target.format" ng-options="f.value as f.text for f in ctrl.formats" ng-change="ctrl.refresh()"></select></div><label class="gf-form-label"><a href="{{ctrl.linkToPrometheus}}" target="_blank" bs-tooltip="\'Link to Graph in Prometheus\'"><i class="fa fa-share-square-o"></i></a></label></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div></query-editor-row>'),a.put("public/app/plugins/panel/alertlist/editor.html",'<div><div class="section gf-form-group"><h5 class="section-heading">Options</h5><div class="gf-form"><span class="gf-form-label width-8">Show</span><div class="gf-form-select-wrapper max-width-15"><select class="gf-form-input" ng-model="ctrl.panel.show" ng-options="f.value as f.text for f in ctrl.showOptions" ng-change="ctrl.onRender()"></select></div></div><div class="gf-form"><span class="gf-form-label width-8">Max items</span> <input type="text" class="gf-form-input max-width-15" ng-model="ctrl.panel.limit" ng-change="ctrl.onRender()"></div><div class="gf-form" ng-show="ctrl.panel.show === \'current\'"><span class="gf-form-label width-8">Sort order</span><div class="gf-form-select-wrapper max-width-15"><select class="gf-form-input" ng-model="ctrl.panel.sortOrder" ng-options="f.value as f.text for f in ctrl.sortOrderOptions" ng-change="ctrl.onRender()"></select></div></div><gf-form-switch class="gf-form" label="Alerts from this dashboard" label-class="width-18" checked="ctrl.panel.onlyAlertsOnDashboard" on-change="ctrl.updateStateFilter()"></gf-form-switch></div><div class="section gf-form-group"><h5 class="section-heading">State filter</h5><gf-form-switch class="gf-form" label="Ok" label-class="width-10" checked="ctrl.stateFilter[\'ok\']" on-change="ctrl.updateStateFilter()"></gf-form-switch><gf-form-switch class="gf-form" label="Paused" label-class="width-10" checked="ctrl.stateFilter[\'paused\']" on-change="ctrl.updateStateFilter()"></gf-form-switch><gf-form-switch class="gf-form" label="No data" label-class="width-10" checked="ctrl.stateFilter[\'no_data\']" on-change="ctrl.updateStateFilter()"></gf-form-switch><gf-form-switch class="gf-form" label="Execution error" label-class="width-10" checked="ctrl.stateFilter[\'execution_error\']" on-change="ctrl.updateStateFilter()"></gf-form-switch><gf-form-switch class="gf-form" label="Alerting" label-class="width-10" checked="ctrl.stateFilter[\'alerting\']" on-change="ctrl.updateStateFilter()"></gf-form-switch></div></div>'),a.put("public/app/plugins/panel/alertlist/module.html",'<div class="panel-alert-list" style="{{ctrl.contentHeight}}"><section class="card-section card-list-layout-list" ng-if="ctrl.panel.show === \'current\'"><ol class="card-list"><li class="card-item-wrapper" ng-repeat="alert in ctrl.currentAlerts"><div class="card-item card-item--alert"><div class="card-item-body"><div class="card-item-details"><div class="card-item-notice"><a href="dashboard/{{alert.dashboardUri}}?panelId={{alert.panelId}}&fullscreen&edit&tab=alert">{{alert.name}}</a></div><div class="card-item-sub-name"><span class="alert-list-item-state {{alert.stateModel.stateClass}}"><i class="{{alert.stateModel.iconClass}}"></i> {{alert.stateModel.text}} </span>for {{alert.newStateDateAgo}}</div><div class="small muted" ng-show="alert.executionError">{{alert.executionError}}</div></div></div></div></li></ol></section><section class="card-section card-list-layout-list" ng-if="ctrl.panel.show === \'changes\'"><ol class="card-list"><li class="card-item-wrapper" ng-repeat="al in ctrl.alertHistory"><div class="card-item card-item--alert"><div class="card-item-header"><div class="card-item-sub-name">{{al.time}}</div></div><div class="card-item-body"><div class="card-item-details"><div class="card-item-notice">{{al.title}}</div><div class="card-item-sub-name"><span class="alert-list-item-state {{al.stateModel.stateClass}}"><i class="{{al.stateModel.iconClass}}"></i> {{al.stateModel.text}} </span>{{al.info}}</div></div></div></div></li></ol></section></div>'),a.put("public/app/plugins/panel/dashlist/editor.html",'<div><div class="section gf-form-group"><h5 class="section-heading">Options</h5><gf-form-switch class="gf-form" label="Starred" label-class="width-9" checked="ctrl.panel.starred" on-change="ctrl.refresh()"></gf-form-switch><gf-form-switch class="gf-form" label="Recently viewed" label-class="width-9" checked="ctrl.panel.recent" on-change="ctrl.refresh()"></gf-form-switch><gf-form-switch class="gf-form" label="Search" label-class="width-9" checked="ctrl.panel.search" on-change="ctrl.refresh()"></gf-form-switch><gf-form-switch class="gf-form" label="Show headings" label-class="width-9" checked="ctrl.panel.headings" on-change="ctrl.refresh()"></gf-form-switch><div class="gf-form"><span class="gf-form-label width-9">Max items</span> <input class="gf-form-input max-width-5" type="number" ng-model="ctrl.panel.limit" ng-model-onblur ng-change="ctrl.refresh()"></div></div><div class="section gf-form-group"><h5 class="section-heading">Search</h5><div class="gf-form"><span class="gf-form-label width-6">Query</span> <input type="text" class="gf-form-input" placeholder="title query" ng-model="ctrl.panel.query" ng-change="ctrl.refresh()" ng-model-onblur></div><div class="gf-form"><span class="gf-form-label width-6">Tags</span><bootstrap-tagsinput ng-model="ctrl.panel.tags" tagclass="label label-tag" placeholder="add tags" on-tags-updated="ctrl.refresh()"></bootstrap-tagsinput></div></div></div>'),a.put("public/app/plugins/panel/dashlist/module.html",'<div class="dashlist" ng-repeat="group in ctrl.groups"><div class="dashlist-section" ng-if="group.show"><h6 class="dashlist-section-header" ng-show="ctrl.panel.headings">{{group.header}}</h6><div class="dashlist-item" ng-repeat="dash in group.list"><a class="dashlist-link dashlist-link-{{dash.type}}" href="dashboard/{{dash.uri}}"><span class="dashlist-title">{{dash.title}} </span><span class="dashlist-star"><i class="fa" ng-class="{\'fa-star\': dash.isStarred, \'fa-star-o\': dash.isStarred === false}"></i></span></a></div></div></div>'),a.put("public/app/plugins/panel/gettingstarted/editor.html",'<div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-10">Mode</span><div class="gf-form-select-wrapper max-width-10"><select class="gf-form-input" ng-model="ctrl.panel.mode" ng-options="f for f in ctrl.modes" ng-change="ctrl.refresh()"></select></div></div><div class="gf-form" ng-show="ctrl.panel.mode === \'recently viewed\'"><span class="gf-form-label"><i class="grafana-tip fa fa-question-circle ng-scope" bs-tooltip="\'WARNING: This list will be cleared when clearing browser cache\'" data-original-title="" title=""></i></span></div></div><div class="gf-form-inline" ng-if="ctrl.panel.mode === \'search\'"><div class="gf-form"><span class="gf-form-label width-10">Search options</span> <span class="gf-form-label">Query</span> <input type="text" class="gf-form-input" placeholder="title query" ng-model="ctrl.panel.query" ng-change="ctrl.refresh()" ng-model-onblur></div><div class="gf-form"><span class="gf-form-label">Tags</span><bootstrap-tagsinput ng-model="ctrl.panel.tags" tagclass="label label-tag" placeholder="add tags" on-tags-updated="ctrl.refresh()"></bootstrap-tagsinput></div></div><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-10">Limit number to</span> <input class="gf-form-input" type="number" ng-model="ctrl.panel.limit" ng-model-onblur ng-change="ctrl.refresh()"></div></div></div>'),a.put("public/app/plugins/panel/gettingstarted/module.html",'<div class="dashlist" ng-if="ctrl.checksDone"><div class="dashlist-section"><h6 class="dashlist-section-header">Getting Started with Grafana <button class="dashlist-cta-close-btn" ng-click="ctrl.dismiss()"><i class="fa fa-remove"></i></button></h6><ul class="progress-tracker"><li class="progress-step" ng-repeat="step in ctrl.steps" ng-class="step.cssClass"><a class="progress-link" ng-href="{{step.href}}" target="{{step.target}}" title="{{step.note}}"><span class="progress-marker" ng-class="step.cssClass"><i class="{{step.icon}}"></i></span> <span class="progress-text" ng-href="{{step.href}}" target="{{step.target}}">{{step.title}}</span> </a><a class="btn progress-step-cta" ng-href="{{step.href}}" target="{{step.target}}">{{step.cta}}</a></li></ul></div></div>'),a.put("public/app/plugins/panel/graph/axes_editor.html",'<div class="editor-row"><div class="section gf-form-group" ng-repeat="yaxis in ctrl.panel.yaxes"><h5 class="section-heading" ng-show="$index === 0">Left Y</h5><h5 class="section-heading" ng-show="$index === 1">Right Y</h5><gf-form-switch class="gf-form" label="Show" label-class="width-6" checked="yaxis.show" on-change="ctrl.render()"></gf-form-switch><div ng-if="yaxis.show"><div class="gf-form"><label class="gf-form-label width-6">Unit</label><div class="gf-form-dropdown-typeahead max-width-20" ng-model="yaxis.format" dropdown-typeahead2="ctrl.unitFormats" dropdown-typeahead-on-select="ctrl.setUnitFormat(yaxis, $subItem)"></div></div><div class="gf-form"><label class="gf-form-label width-6">Scale</label><div class="gf-form-select-wrapper max-width-20"><select class="gf-form-input" ng-model="yaxis.logBase" ng-options="v as k for (k, v) in ctrl.logScales" ng-change="ctrl.render()"></select></div></div><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label width-6">Y-Min</label><input type="text" class="gf-form-input width-5" placeholder="auto" empty-to-null ng-model="yaxis.min" ng-change="ctrl.render()" ng-model-onblur></div><div class="gf-form"><label class="gf-form-label width-6">Y-Max</label><input type="text" class="gf-form-input width-5" placeholder="auto" empty-to-null ng-model="yaxis.max" ng-change="ctrl.render()" ng-model-onblur></div></div><div class="gf-form"><label class="gf-form-label width-6">Decimals</label><input type="number" class="gf-form-input max-width-20" placeholder="auto" bs-tooltip="\'Override automatic decimal precision for y-axis\'" data-placement="right" ng-model="yaxis.decimals" ng-change="ctrl.render()" ng-model-onblur></div><div class="gf-form"><label class="gf-form-label width-6">Label</label><input type="text" class="gf-form-input max-width-20" ng-model="yaxis.label" ng-change="ctrl.render()" ng-model-onblur></div></div></div><div class="section gf-form-group"><h5 class="section-heading">X-Axis</h5><gf-form-switch class="gf-form" label="Show" label-class="width-6" checked="ctrl.panel.xaxis.show" on-change="ctrl.render()"></gf-form-switch><div class="gf-form"><label class="gf-form-label width-6">Mode</label><div class="gf-form-select-wrapper max-width-15"><select class="gf-form-input" ng-model="ctrl.panel.xaxis.mode" ng-options="v as k for (k, v) in ctrl.xAxisModes" ng-change="ctrl.xAxisModeChanged()"></select></div></div><div class="gf-form" ng-if="ctrl.panel.xaxis.mode === \'series\'"><label class="gf-form-label width-6">Value</label><metric-segment-model property="ctrl.panel.xaxis.values[0]" options="ctrl.xAxisStatOptions" on-change="ctrl.xAxisValueChanged()" custom="false" css-class="width-10" select-mode="true"></metric-segment-model></div><div class="gf-form" ng-if="ctrl.panel.xaxis.mode === \'histogram\'"><label class="gf-form-label width-6">Buckets</label><input type="number" class="gf-form-input max-width-8" ng-model="ctrl.panel.xaxis.buckets" placeholder="auto" ng-change="ctrl.render()" ng-model-onblur bs-tooltip="\'Number of buckets\'" data-placement="right"></div></div></div>'),a.put("public/app/plugins/panel/graph/tab_display.html",'<div class="edit-tab-with-sidemenu"><aside class="edit-sidemenu-aside"><ul class="edit-sidemenu"><li ng-class="{active: ctrl.subTabIndex === 0}"><a ng-click="ctrl.subTabIndex = 0">Draw options</a></li><li ng-class="{active: ctrl.subTabIndex === 1}"><a ng-click="ctrl.subTabIndex = 1">Series overrides <span class="muted">({{ctrl.panel.seriesOverrides.length}})</span></a></li><li ng-class="{active: ctrl.subTabIndex === 2}"><a ng-click="ctrl.subTabIndex = 2">Thresholds <span class="muted">({{ctrl.panel.thresholds.length}})</span></a></li></ul></aside><div class="edit-tab-content" ng-if="ctrl.subTabIndex === 0"><div class="section gf-form-group"><h5 class="section-heading">Draw Modes</h5><gf-form-switch class="gf-form" label="Bars" label-class="width-5" checked="ctrl.panel.bars" on-change="ctrl.render()"></gf-form-switch><gf-form-switch class="gf-form" label="Lines" label-class="width-5" checked="ctrl.panel.lines" on-change="ctrl.render()"></gf-form-switch><gf-form-switch class="gf-form" label="Points" label-class="width-5" checked="ctrl.panel.points" on-change="ctrl.render()"></gf-form-switch></div><div class="section gf-form-group"><h5 class="section-heading">Mode Options</h5><div class="gf-form" ng-show="ctrl.panel.lines"><label class="gf-form-label width-8">Fill</label><div class="gf-form-select-wrapper max-width-5"><select class="gf-form-input" ng-model="ctrl.panel.fill" ng-options="f for f in [0,1,2,3,4,5,6,7,8,9,10]" ng-change="ctrl.render()"></select></div></div><div class="gf-form" ng-show="(ctrl.panel.lines)"><label class="gf-form-label width-8">Line Width</label><div class="gf-form-select-wrapper max-width-5"><select class="gf-form-input" ng-model="ctrl.panel.linewidth" ng-options="f for f in [0,1,2,3,4,5,6,7,8,9,10]" ng-change="ctrl.render()"></select></div></div><gf-form-switch ng-show="ctrl.panel.lines" class="gf-form" label="Staircase" label-class="width-8" checked="ctrl.panel.steppedLine" on-change="ctrl.render()"></gf-form-switch><div class="gf-form" ng-show="ctrl.panel.points"><label class="gf-form-label width-8">Point Radius</label><div class="gf-form-select-wrapper max-width-5"><select class="gf-form-input" ng-model="ctrl.panel.pointradius" ng-options="f for f in [1,2,3,4,5,6,7,8,9,10]" ng-change="ctrl.render()"></select></div></div></div><div class="section gf-form-group"><h5 class="section-heading">Hover tooltip</h5><div class="gf-form"><label class="gf-form-label width-9">Mode</label><div class="gf-form-select-wrapper max-width-8"><select class="gf-form-input" ng-model="ctrl.panel.tooltip.shared" ng-options="f.value as f.text for f in [{text: \'All series\', value: true}, {text: \'Single\', value: false}]" ng-change="ctrl.render()"></select></div></div><div class="gf-form"><label class="gf-form-label width-9">Sort order</label><div class="gf-form-select-wrapper max-width-8"><select class="gf-form-input" ng-model="ctrl.panel.tooltip.sort" ng-options="f.value as f.text for f in [{text: \'None\', value: 0}, {text: \'Increasing\', value: 1}, {text: \'Decreasing\', value: 2}]" ng-change="ctrl.render()"></select></div></div><div class="gf-form" ng-show="ctrl.panel.stack"><label class="gf-form-label width-9">Stacked value</label><div class="gf-form-select-wrapper max-width-8"><select class="gf-form-input" ng-model="ctrl.panel.tooltip.value_type" ng-options="f for f in [\'cumulative\',\'individual\']" ng-change="ctrl.render()"></select></div></div></div><div class="section gf-form-group"><h5 class="section-heading">Stacking & Null value</h5><gf-form-switch class="gf-form" label="Stack" label-class="width-7" checked="ctrl.panel.stack" on-change="ctrl.render()"></gf-form-switch><gf-form-switch class="gf-form" ng-show="ctrl.panel.stack" label="Percent" label-class="width-7" checked="ctrl.panel.percentage" on-change="ctrl.render()"></gf-form-switch><div class="gf-form"><label class="gf-form-label width-7">Null value</label><div class="gf-form-select-wrapper"><select class="gf-form-input max-width-8" ng-model="ctrl.panel.nullPointMode" ng-options="f for f in [\'connected\', \'null\', \'null as zero\']" ng-change="ctrl.render()"></select></div></div></div></div><div class="edit-tab-content" ng-if="ctrl.subTabIndex === 1"><div class="gf-form-group"><h5>Series specific overrides<tip>Regex match example: /server[0-3]/i</tip></h5><div class="gf-form-inline" ng-repeat="override in ctrl.panel.seriesOverrides" ng-controller="SeriesOverridesCtrl"><div class="gf-form"><label class="gf-form-label">alias or regex</label></div><div class="gf-form width-15"><input type="text" ng-model="override.alias" bs-typeahead="getSeriesNames" ng-blur="ctrl.render()" data-min-length="0" data-items="100" class="gf-form-input width-15"></div><div class="gf-form" ng-repeat="option in currentOverrides"><label class="gf-form-label"><i class="pointer fa fa-remove" ng-click="removeOverride(option)"></i> <span ng-show="option.propertyName === \'color\'">Color: <i class="fa fa-circle" ng-style="{color:option.value}"></i> </span><span ng-show="option.propertyName !== \'color\'">{{option.name}}: {{option.value}}</span></label></div><div class="gf-form"><span class="dropdown" dropdown-typeahead="overrideMenu" dropdown-typeahead-on-select="setOverride($item, $subItem)"></span></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div><div class="gf-form"><label class="gf-form-label"><i class="fa fa-trash pointer" ng-click="ctrl.removeSeriesOverride(override)"></i></label></div></div></div><button class="btn btn-inverse" ng-click="ctrl.addSeriesOverride()"><i class="fa fa-plus"></i>&nbsp;Add override</button></div><div class="edit-tab-content" ng-if="ctrl.subTabIndex === 2"><graph-threshold-form panel-ctrl="ctrl"></graph-threshold-form></div></div>'),a.put("public/app/plugins/panel/graph/tab_legend.html",'<div class="editor-row"><div class="section gf-form-group"><h5 class="section-heading">Options</h5><gf-form-switch class="gf-form" label="Show" label-class="width-7" checked="ctrl.panel.legend.show" on-change="ctrl.refresh()"></gf-form-switch><gf-form-switch class="gf-form" label="As Table" label-class="width-7" checked="ctrl.panel.legend.alignAsTable" on-change="ctrl.render()"></gf-form-switch><gf-form-switch class="gf-form" label="To the right" label-class="width-7" checked="ctrl.panel.legend.rightSide" on-change="ctrl.render()"></gf-form-switch><div ng-if="ctrl.panel.legend.rightSide" class="gf-form"><label class="gf-form-label width-7">Width</label><input type="number" class="gf-form-input max-width-5" placeholder="250" bs-tooltip="\'Set a min-width for the legend side table/block\'" data-placement="right" ng-model="ctrl.panel.legend.sideWidth" ng-change="ctrl.render()" ng-model-onblur></div></div><div class="section gf-form-group"><h5 class="section-heading">Values</h5><div class="gf-form-inline"><gf-form-switch class="gf-form" label="Min" label-class="width-4" checked="ctrl.panel.legend.min" on-change="ctrl.legendValuesOptionChanged()"></gf-form-switch><gf-form-switch class="gf-form max-width-12" label="Max" label-class="width-6" switch-class="max-width-5" checked="ctrl.panel.legend.max" on-change="ctrl.legendValuesOptionChanged()"></gf-form-switch></div><div class="gf-form-inline"><gf-form-switch class="gf-form" label="Avg" label-class="width-4" checked="ctrl.panel.legend.avg" on-change="ctrl.legendValuesOptionChanged()"></gf-form-switch><gf-form-switch class="gf-form max-width-12" label="Current" label-class="width-6" switch-class="max-width-5" checked="ctrl.panel.legend.current" on-change="ctrl.legendValuesOptionChanged()"></gf-form-switch></div><div class="gf-form-inline"><gf-form-switch class="gf-form" label="Total" label-class="width-4" checked="ctrl.panel.legend.total" on-change="ctrl.legendValuesOptionChanged()"></gf-form-switch><div class="gf-form"><label class="gf-form-label width-6">Decimals</label><input type="number" class="gf-form-input width-5" placeholder="auto" bs-tooltip="\'Override automatic decimal precision for legend and tooltips\'" data-placement="right" ng-model="ctrl.panel.decimals" ng-change="ctrl.render()" ng-model-onblur></div></div></div><div class="section gf-form-group"><h5 class="section-heading">Hide series</h5><gf-form-switch class="gf-form" label="With only nulls" label-class="width-10" checked="ctrl.panel.legend.hideEmpty" on-change="ctrl.render()"></gf-form-switch><gf-form-switch class="gf-form" label="With only zeros" label-class="width-10" checked="ctrl.panel.legend.hideZero" on-change="ctrl.render()"></gf-form-switch></div></div>'),a.put("public/app/plugins/panel/heatmap/module.html",'<div class="heatmap-wrapper"><div class="heatmap-canvas-wrapper"><div class="datapoints-warning" ng-if="ctrl.dataWarning"><span class="small" bs-tooltip="ctrl.dataWarning.tip">{{ctrl.dataWarning.title}}</span></div><div class="heatmap-panel" ng-dblclick="ctrl.zoomOut()"></div></div><div class="heatmap-legend-wrapper" ng-if="ctrl.panel.legend.show"><heatmap-legend></heatmap-legend></div></div><div class="clearfix"></div>'),a.put("public/app/plugins/panel/heatmap/partials/axes_editor.html",'<div class="editor-row"><div class="section gf-form-group"><h5 class="section-heading">Y Axis</h5><div class="gf-form"><label class="gf-form-label width-8">Unit</label><div class="gf-form-dropdown-typeahead width-12" ng-model="ctrl.panel.yAxis.format" dropdown-typeahead2="editor.unitFormats" dropdown-typeahead-on-select="editor.setUnitFormat($subItem)"></div></div><div class="gf-form"><label class="gf-form-label width-8">Scale</label><div class="gf-form-select-wrapper width-12"><select class="gf-form-input" ng-model="ctrl.panel.yAxis.logBase" ng-options="v as k for (k, v) in editor.logScales" ng-change="ctrl.refresh()"></select></div></div><div class="gf-form"><label class="gf-form-label width-8">Y-Min</label><input type="text" class="gf-form-input width-12" placeholder="auto" empty-to-null ng-model="ctrl.panel.yAxis.min" ng-change="ctrl.render()" ng-model-onblur></div><div class="gf-form"><label class="gf-form-label width-8">Y-Max</label><input type="text" class="gf-form-input width-12" placeholder="auto" empty-to-null ng-model="ctrl.panel.yAxis.max" ng-change="ctrl.render()" ng-model-onblur></div><div class="gf-form"><label class="gf-form-label width-8">Decimals</label><input type="number" class="gf-form-input width-12" placeholder="auto" data-placement="right" bs-tooltip="\'Override automatic decimal precision for axis.\'" ng-model="ctrl.panel.yAxis.decimals" ng-change="ctrl.render()" ng-model-onblur></div></div><div class="section gf-form-group" ng-if="ctrl.panel.dataFormat == \'timeseries\'"><h5 class="section-heading">Buckets</h5><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label width-5">Y Axis</label></div><div class="gf-form" ng-show="ctrl.panel.yAxis.logBase === 1"><label class="gf-form-label width-5">Buckets</label><input type="number" class="gf-form-input width-5" placeholder="auto" data-placement="right" bs-tooltip="\'Number of buckets for Y axis.\'" ng-model="ctrl.panel.yBucketNumber" ng-change="ctrl.refresh()" ng-model-onblur></div><div class="gf-form" ng-show="ctrl.panel.yAxis.logBase === 1"><label class="gf-form-label width-4">Size</label><input type="number" class="gf-form-input width-5" placeholder="auto" data-placement="right" bs-tooltip="\'Size of bucket. Has priority over Buckets option.\'" ng-model="ctrl.panel.yBucketSize" ng-change="ctrl.refresh()" ng-model-onblur></div><div class="gf-form" ng-show="ctrl.panel.yAxis.logBase !== 1"><label class="gf-form-label width-10">Split Factor</label><input type="number" class="gf-form-input width-9" placeholder="1" data-placement="right" bs-tooltip="\'For log scales only. By default Y values is splitted by integer powers of log base (1, 2, 4, 8, 16, ... for log2). This option allows to split each default bucket into specified number of buckets.\'" ng-model="ctrl.panel.yAxis.splitFactor" ng-change="ctrl.refresh()" ng-model-onblur></div></div><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label width-5">X Axis</label><label class="gf-form-label width-5">Buckets</label><input type="number" class="gf-form-input width-5" placeholder="auto" data-placement="right" bs-tooltip="\'Number of buckets for X axis.\'" ng-model="ctrl.panel.xBucketNumber" ng-change="ctrl.refresh()" ng-model-onblur></div><div class="gf-form"><label class="gf-form-label width-4">Size</label><input type="text" class="gf-form-input width-5" placeholder="auto" data-placement="right" bs-tooltip="\'Size of bucket. Number or interval (10s, 5m, 1h, etc). Supported intervals: ms, s, m, h, d, w, M, y. Has priority over Buckets option.\'" ng-model="ctrl.panel.xBucketSize" ng-change="ctrl.refresh()" ng-model-onblur></div></div></div><div class="section gf-form-group"><h5 class="section-heading">Data format</h5><div class="gf-form"><label class="gf-form-label width-5">Format</label><div class="gf-form-select-wrapper max-width-15"><select class="gf-form-input" ng-model="ctrl.panel.dataFormat" ng-options="v as k for (k, v) in editor.dataFormats" ng-change="ctrl.render()"></select></div></div></div></div>'),a.put("public/app/plugins/panel/heatmap/partials/display_editor.html",'<div class="editor-row"><div class="section gf-form-group"><h5 class="section-heading">Colors</h5><div class="gf-form"><label class="gf-form-label width-9">Mode</label><div class="gf-form-select-wrapper width-8"><select class="input-small gf-form-input" ng-model="ctrl.panel.color.mode" ng-options="s for s in ctrl.colorModes" ng-change="ctrl.render()"></select></div></div><div ng-show="ctrl.panel.color.mode === \'opacity\'"><div class="gf-form"><label class="gf-form-label width-9">Color</label><span class="gf-form-label"><spectrum-picker ng-model="ctrl.panel.color.cardColor" ng-change="ctrl.render()"></spectrum-picker></span></div><div class="gf-form"><label class="gf-form-label width-9">Scale</label><div class="gf-form-select-wrapper width-8"><select class="input-small gf-form-input" ng-model="ctrl.panel.color.colorScale" ng-options="s for s in ctrl.opacityScales" ng-change="ctrl.render()"></select></div></div><div class="gf-form" ng-if="ctrl.panel.color.colorScale === \'sqrt\'"><label class="gf-form-label width-9">Exponent</label><input type="number" class="gf-form-input width-8" placeholder="auto" data-placement="right" bs-tooltip="\'\'" ng-model="ctrl.panel.color.exponent" ng-change="ctrl.refresh()" ng-model-onblur></div></div><div ng-show="ctrl.panel.color.mode === \'spectrum\'"><div class="gf-form"><label class="gf-form-label width-9">Scheme</label><div class="gf-form-select-wrapper width-8"><select class="input-small gf-form-input" ng-model="ctrl.panel.color.colorScheme" ng-options="s.value as s.name for s in ctrl.colorSchemes" ng-change="ctrl.render()"></select></div></div></div><div class="gf-form"><color-legend></color-legend></div></div><div class="section gf-form-group"><h5 class="section-heading">Color scale</h5><div class="gf-form"><label class="gf-form-label width-8">Min</label><input type="number" ng-model="ctrl.panel.color.min" class="gf-form-input width-5" placeholder="auto" data-placement="right" bs-tooltip="\'\'" ng-change="ctrl.refresh()" ng-model-onblur></div><div class="gf-form"><label class="gf-form-label width-8">Max</label><input type="number" ng-model="ctrl.panel.color.max" class="gf-form-input width-5" placeholder="auto" data-placement="right" bs-tooltip="\'\'" ng-change="ctrl.refresh()" ng-model-onblur></div></div><div class="section gf-form-group"><h5 class="section-heading">Legend</h5><gf-form-switch class="gf-form" label-class="width-8" label="Show legend" checked="ctrl.panel.legend.show" on-change="ctrl.render()"></gf-form-switch></div><div class="section gf-form-group"><h5 class="section-heading">Buckets</h5><div class="gf-form"><label class="gf-form-label width-8">Space</label><input type="number" class="gf-form-input width-5" placeholder="auto" data-placement="right" bs-tooltip="\'\'" ng-model="ctrl.panel.cards.cardPadding" ng-change="ctrl.refresh()" ng-model-onblur></div><div class="gf-form"><label class="gf-form-label width-8">Round</label><input type="number" class="gf-form-input width-5" placeholder="auto" data-placement="right" bs-tooltip="\'\'" ng-model="ctrl.panel.cards.cardRound" ng-change="ctrl.refresh()" ng-model-onblur></div></div><div class="section gf-form-group"><h5 class="section-heading">Tooltip</h5><gf-form-switch class="gf-form" label-class="width-8" label="Show tooltip" checked="ctrl.panel.tooltip.show" on-change="ctrl.render()"></gf-form-switch><div ng-if="ctrl.panel.tooltip.show"><gf-form-switch class="gf-form" label-class="width-8" label="Histogram" checked="ctrl.panel.tooltip.showHistogram" on-change="ctrl.render()"></gf-form-switch><div class="gf-form"><label class="gf-form-label width-8">Decimals</label><input type="number" class="gf-form-input width-5" placeholder="auto" data-placement="right" bs-tooltip="\'Max decimal precision for tooltip.\'" ng-model="ctrl.panel.tooltipDecimals" ng-change="ctrl.render()" ng-model-onblur></div></div></div></div>'),a.put("public/app/plugins/panel/pluginlist/editor.html",'<div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-10">Mode</span><div class="gf-form-select-wrapper max-width-10"><select class="gf-form-input" ng-model="ctrl.panel.mode" ng-options="f for f in ctrl.modes" ng-change="ctrl.refresh()"></select></div></div><div class="gf-form" ng-show="ctrl.panel.mode === \'recently viewed\'"><span class="gf-form-label"><i class="grafana-tip fa fa-question-circle ng-scope" bs-tooltip="\'WARNING: This list will be cleared when clearing browser cache\'" data-original-title="" title=""></i></span></div></div><div class="gf-form-inline" ng-if="ctrl.panel.mode === \'search\'"><div class="gf-form"><span class="gf-form-label width-10">Search options</span> <span class="gf-form-label">Query</span> <input type="text" class="gf-form-input" placeholder="title query" ng-model="ctrl.panel.query" ng-change="ctrl.refresh()" ng-model-onblur></div><div class="gf-form"><span class="gf-form-label">Tags</span><bootstrap-tagsinput ng-model="ctrl.panel.tags" tagclass="label label-tag" placeholder="add tags" on-tags-updated="ctrl.refresh()"></bootstrap-tagsinput></div></div><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-10">Limit number to</span> <input class="gf-form-input" type="number" ng-model="ctrl.panel.limit" ng-model-onblur ng-change="ctrl.refresh()"></div></div></div>'),
a.put("public/app/plugins/panel/pluginlist/module.html",'<div class="pluginlist"><div class="pluginlist-section" ng-repeat="category in ctrl.viewModel"><h6 class="pluginlist-section-header">{{category.header}}</h6><div class="pluginlist-item" ng-repeat="plugin in category.list"><a class="pluginlist-link pluginlist-link-{{plugin.state}} pointer" href="{{plugin.defaultNavUrl}}"><span><img ng-src="{{plugin.info.logos.small}}" class="pluginlist-image"> <span class="pluginlist-title">{{plugin.name}}</span> <span class="pluginlist-version">v{{plugin.info.version}}</span> </span><span class="pluginlist-message pluginlist-message--update" ng-show="plugin.hasUpdate" ng-click="ctrl.updateAvailable(plugin, $event)" bs-tooltip="\'New version: \' + plugin.latestVersion">Update available! </span><span class="pluginlist-message pluginlist-message--enable" ng-show="!plugin.enabled && !plugin.hasUpdate">Enable now </span><span class="pluginlist-message pluginlist-message--no-update" ng-show="plugin.enabled && !plugin.hasUpdate">Up to date</span></a></div><div class="pluginlist-item" ng-show="category.list.length === 0"><a class="pluginlist-link pluginlist-link-{{plugin.state}}" href="https://grafana.com/plugins"><span class="pluginlist-none-installed">None installed. <span class="pluginlist-emphasis">Browse Grafana.com</span></span></a></div></div></div>'),a.put("public/app/plugins/panel/singlestat/editor.html",'<div class="editor-row"><div class="section gf-form-group"><h5 class="section-heading">Value</h5><div class="gf-form-inline"><div class="gf-form" ng-show="ctrl.dataType === \'timeseries\'"><label class="gf-form-label width-6">Stat</label><div class="gf-form-select-wrapper width-7"><select class="gf-form-input" ng-model="ctrl.panel.valueName" ng-options="f for f in ctrl.valueNameOptions" ng-change="ctrl.render()"></select></div></div><div class="gf-form" ng-show="ctrl.dataType === \'table\'"><label class="gf-form-label width-6">Column</label><div class="gf-form-select-wrapper width-7"><select class="gf-form-input" ng-model="ctrl.panel.tableColumn" ng-options="f for f in ctrl.tableColumnOptions" ng-change="ctrl.refresh()"></select></div></div><div class="gf-form"><label class="gf-form-label width-6">Font size</label><div class="gf-form-select-wrapper"><select class="gf-form-input" ng-model="ctrl.panel.valueFontSize" ng-options="f for f in ctrl.fontSizes" ng-change="ctrl.render()"></select></div></div></div><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label width-6">Prefix</label><input type="text" class="gf-form-input width-7" ng-model="ctrl.panel.prefix" ng-change="ctrl.render()" ng-model-onblur><label class="gf-form-label width-6">Font size</label><div class="gf-form-select-wrapper"><select class="gf-form-input" ng-model="ctrl.panel.prefixFontSize" ng-options="f for f in ctrl.fontSizes" ng-change="ctrl.render()"></select></div></div></div><div class="gf-form"><label class="gf-form-label width-6">Postfix</label><input type="text" class="gf-form-input width-7" ng-model="ctrl.panel.postfix" ng-change="ctrl.render()" ng-model-onblur><label class="gf-form-label width-6">Font size</label><div class="gf-form-select-wrapper"><select class="input-small gf-form-input" ng-model="ctrl.panel.postfixFontSize" ng-options="f for f in ctrl.fontSizes" ng-change="ctrl.render()"></select></div></div><div class="gf-form"><label class="gf-form-label width-6">Unit</label><div class="gf-form-dropdown-typeahead width-18" ng-model="ctrl.panel.format" dropdown-typeahead2="ctrl.unitFormats" dropdown-typeahead-on-select="ctrl.setUnitFormat($subItem)"></div></div><div class="gf-form"><label class="gf-form-label width-6">Decimals</label><input type="number" class="gf-form-input width-18" placeholder="auto" data-placement="right" bs-tooltip="\'Override automatic decimal precision for legend and tooltips\'" ng-model="ctrl.panel.decimals" ng-change="ctrl.refresh()" ng-model-onblur></div></div><div class="section gf-form-group"><h5 class="section-heading">Coloring</h5><div class="gf-form-inline"><gf-form-switch class="gf-form" label-class="width-8" label="Background" checked="ctrl.panel.colorBackground" on-change="ctrl.render()"></gf-form-switch><gf-form-switch class="gf-form" label-class="width-4" label="Value" checked="ctrl.panel.colorValue" on-change="ctrl.render()"></gf-form-switch></div><div class="gf-form-inline"><div class="gf-form max-width-21"><label class="gf-form-label width-8">Thresholds<tip>Define two threshold values&lt;br /&gt; 50,80 will produce: &lt;50 = Green, 50:80 = Yellow, &gt;80 = Red</tip></label><input type="text" class="gf-form-input" ng-model="ctrl.panel.thresholds" ng-blur="ctrl.render()" placeholder="50,80"></div></div><div class="gf-form"><label class="gf-form-label width-8">Colors</label><span class="gf-form-label"><spectrum-picker ng-model="ctrl.panel.colors[0]" ng-change="ctrl.render()"></spectrum-picker></span><span class="gf-form-label"><spectrum-picker ng-model="ctrl.panel.colors[1]" ng-change="ctrl.render()"></spectrum-picker></span><span class="gf-form-label"><spectrum-picker ng-model="ctrl.panel.colors[2]" ng-change="ctrl.render()"></spectrum-picker></span><span class="gf-form-label"><a ng-click="ctrl.invertColorOrder()">Invert</a></span></div></div><div class="section gf-form-group"><h5 class="section-heading">Spark lines</h5><gf-form-switch class="gf-form" label-class="width-9" label="Show" checked="ctrl.panel.sparkline.show" on-change="ctrl.render()"></gf-form-switch><div ng-if="ctrl.panel.sparkline.show"><gf-form-switch class="gf-form" label-class="width-9" label="Full height" checked="ctrl.panel.sparkline.full" on-change="ctrl.render()"></gf-form-switch><div class="gf-form"><label class="gf-form-label width-9">Line Color</label><span class="gf-form-label"><spectrum-picker ng-model="ctrl.panel.sparkline.lineColor" ng-change="ctrl.render()"></spectrum-picker></span></div><div class="gf-form"><label class="gf-form-label width-9">Fill Color</label><span class="gf-form-label"><spectrum-picker ng-model="ctrl.panel.sparkline.fillColor" ng-change="ctrl.render()"></spectrum-picker></span></div></div></div><div class="section gf-form-group"><h5 class="section-heading">Gauge</h5><gf-form-switch class="gf-form" label-class="width-10" switch-class="max-width-6" label="Show" checked="ctrl.panel.gauge.show" on-change="ctrl.render()"></gf-form-switch><div ng-if="ctrl.panel.gauge.show"><div class="gf-form"><label class="gf-form-label width-10">Min</label><input type="number" class="gf-form-input width-6" placeholder="0" data-placement="right" ng-model="ctrl.panel.gauge.minValue" ng-change="ctrl.refresh()" ng-model-onblur><label class="gf-form-label alert-state-critical" ng-show="ctrl.invalidGaugeRange">&nbsp; <i class="fa fa-warning"></i> Min value is bigger than max.</label></div><div class="gf-form"><label class="gf-form-label width-10">Max</label><input type="number" class="gf-form-input width-6" placeholder="0" data-placement="right" ng-model="ctrl.panel.gauge.maxValue" ng-change="ctrl.refresh()" ng-model-onblur></div><gf-form-switch class="gf-form" label-class="width-10" switch-class="max-width-6" label="Threshold labels" checked="ctrl.panel.gauge.thresholdLabels" on-change="ctrl.render()"></gf-form-switch><gf-form-switch class="gf-form" label-class="width-10" switch-class="max-width-6" label="Threshold markers" checked="ctrl.panel.gauge.thresholdMarkers" on-change="ctrl.render()"></gf-form-switch></div></div></div>'),a.put("public/app/plugins/panel/singlestat/mappings.html",'<div class="editor-row"><div class="gf-form-group"><div class="gf-form"><span class="gf-form-label">Type</span><div class="gf-form-select-wrapper"><select class="gf-form-input" ng-model="ctrl.panel.mappingType" ng-options="f.value as f.name for f in ctrl.panel.mappingTypes" ng-change="ctrl.render()"></select></div></div></div></div><div class="editor-row" ng-if="ctrl.panel.mappingType==1"><h5 class="page-heading">Set value mappings</h5><div class="gf-form-group"><div class="gf-form" ng-repeat="map in ctrl.panel.valueMaps"><span class="gf-form-label"><i class="fa fa-remove pointer" ng-click="ctrl.removeValueMap(map)"></i> </span><input type="text" ng-model="map.value" placeholder="value" class="gf-form-input max-width-6" ng-blur="ctrl.render()"> <span class="gf-form-label"><i class="fa fa-arrow-right"></i> </span><input type="text" placeholder="text" ng-model="map.text" class="gf-form-input max-width-8" ng-blur="ctrl.render()"></div><div class="gf-form-button-row"><button class="btn btn-inverse" ng-click="ctrl.addValueMap();"><i class="fa fa-plus"></i> Add a value mapping</button></div></div></div><div class="editor-row" ng-if="ctrl.panel.mappingType==2"><h5 class="page-heading">Set range mappings</h5><div class="gf-form-group"><div class="gf-form" ng-repeat="rangeMap in ctrl.panel.rangeMaps"><span class="gf-form-label"><i class="fa fa-remove pointer" ng-click="ctrl.removeRangeMap(rangeMap)"></i> </span><span class="gf-form-label">From</span> <input type="text" ng-model="rangeMap.from" class="gf-form-input max-width-6" ng-blur="ctrl.render()"> <span class="gf-form-label">To</span> <input type="text" ng-model="rangeMap.to" class="gf-form-input max-width-6" ng-blur="ctrl.render()"> <span class="gf-form-label">Text</span> <input type="text" ng-model="rangeMap.text" class="gf-form-input max-width-8" ng-blur="ctrl.render()"></div><div class="gf-form-button-row"><button class="btn btn-inverse" ng-click="ctrl.addRangeMap()"><i class="fa fa-plus"></i> Add a range mapping</button></div></div></div>'),a.put("public/app/plugins/panel/singlestat/module.html",'<div class="singlestat-panel"></div>'),a.put("public/app/plugins/panel/table/column_options.html",'<div class="edit-tab-with-sidemenu"><aside class="edit-sidemenu-aside"><ul class="edit-sidemenu"><li ng-repeat="style in editor.panel.styles" ng-class="{active: editor.activeStyleIndex === $index}"><a ng-click="editor.activeStyleIndex = $index">{{style.pattern || \'New rule\'}}</a></li><li><a class="pointer" ng-click="editor.addColumnStyle()"><i class="fa fa-plus"></i>&nbsp;Add</a></li></ul></aside><div class="edit-tab-content" ng-repeat="style in editor.panel.styles" ng-if="editor.activeStyleIndex === $index"><div class="section gf-form-group"><h5 class="section-heading">Options</h5><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label width-13">Apply to columns named</label><input type="text" placeholder="Name or regex" class="gf-form-input width-13" ng-model="style.pattern" bs-tooltip="\'Specify regex using /my.*regex/ syntax\'" bs-typeahead="editor.getColumnNames" ng-blur="editor.render()" data-min-length="0" data-items="100" ng-model-onblur data-placement="right"></div></div><div class="gf-form" ng-if="style.type !== \'hidden\'"><label class="gf-form-label width-13">Column Header</label><input type="text" class="gf-form-input width-13" ng-model="style.alias" ng-change="editor.render()" ng-model-onblur placeholder="Override header label"></div><gf-form-switch class="gf-form" label-class="width-13" label="Render value as link" checked="style.link" change="editor.render()"></gf-form-switch></div><div class="section gf-form-group"><h5 class="section-heading">Type</h5><div class="gf-form"><label class="gf-form-label width-11">Type</label><div class="gf-form-select-wrapper width-10"><select class="gf-form-input" ng-model="style.type" ng-options="c.value as c.text for c in editor.columnTypes" ng-change="editor.render()"></select></div></div><div class="gf-form" ng-if="style.type === \'date\'"><label class="gf-form-label width-11">Date Format</label><metric-segment-model property="style.dateFormat" options="editor.dateFormats" on-change="editor.render()" custom="true"></metric-segment-model></div><div ng-if="style.type === \'string\'"><gf-form-switch class="gf-form" label-class="width-11" ng-if="style.type === \'string\'" label="Sanitize HTML" checked="style.sanitize" change="editor.render()"></gf-form-switch></div><div ng-if="style.type === \'string\'"><gf-form-switch class="gf-form" label-class="width-11" ng-if="style.type === \'string\'" label="Preserve Formatting" checked="style.preserveFormat" change="editor.render()"></gf-form-switch></div><div ng-if="style.type === \'number\'"><div class="gf-form"><label class="gf-form-label width-11">Unit</label><div class="gf-form-dropdown-typeahead width-10" ng-model="style.unit" dropdown-typeahead2="editor.unitFormats" dropdown-typeahead-on-select="editor.setUnitFormat(style, $subItem)"></div></div><div class="gf-form"><label class="gf-form-label width-11">Decimals</label><input type="number" class="gf-form-input width-4" data-placement="right" ng-model="style.decimals" ng-change="editor.render()" ng-model-onblur></div></div></div><div class="section gf-form-group" ng-if="style.type === \'number\'"><h5 class="section-heading">Thresholds</h5><div class="gf-form"><label class="gf-form-label width-8">Thresholds<tip>Comma separated values</tip></label><input type="text" class="gf-form-input width-10" ng-model="style.thresholds" placeholder="50,80" ng-blur="editor.render()" array-join ng-model-onblur></div><div class="gf-form"><label class="gf-form-label width-8">Color Mode</label><div class="gf-form-select-wrapper width-10"><select class="gf-form-input" ng-model="style.colorMode" ng-options="c.value as c.text for c in editor.colorModes" ng-change="editor.render()"></select></div></div><div class="gf-form"><label class="gf-form-label width-8">Colors</label><span class="gf-form-label"><spectrum-picker ng-model="style.colors[0]" ng-change="editor.render()"></spectrum-picker></span><span class="gf-form-label"><spectrum-picker ng-model="style.colors[1]" ng-change="editor.render()"></spectrum-picker></span><span class="gf-form-label"><spectrum-picker ng-model="style.colors[2]" ng-change="editor.render()"></spectrum-picker></span><div class="gf-form-label"><a class="pointer" ng-click="editor.invertColorOrder($index)">Invert</a></div></div></div><div class="section gf-form-group" ng-if="style.link"><h5 class="section-heading">Link</h5><div class="gf-form"><label class="gf-form-label width-9">Url</label><input type="text" class="gf-form-input width-29" ng-model="style.linkUrl" ng-blur="editor.render()" ng-model-onblur data-placement="right"><info-popover mode="right-absolute"><p>Specify an URL (relative or absolute)</p><span>Use special variables to specify cell values:<br><em>$__cell</em> refers to current cell value<br><em>$__cell_n</em> refers to Nth column value in current row. Column indexes are started from 0. For instance, <em>$__cell_1</em> refers to second column\'s value.</span></info-popover></div><div class="gf-form"><label class="gf-form-label width-9">Tooltip</label><input type="text" class="gf-form-input width-29" ng-model="style.linkTooltip" ng-blur="editor.render()" ng-model-onblur data-placement="right"><info-popover mode="right-absolute"><p>Specify text for link tooltip.</p><span>This title appears when user hovers pointer over the cell with link. Use the same variables as for URL.</span></info-popover></div><gf-form-switch class="gf-form" label-class="width-9" label="Open in new tab" checked="style.linkTargetBlank"></gf-form-switch></div><div class="clearfix"></div><button class="btn btn-danger btn-small" ng-click="editor.removeColumnStyle(style)"><i class="fa fa-trash"></i> Remove Rule</button><br><br></div></div>'),a.put("public/app/plugins/panel/table/editor.html",'<div class="editor-row"><div class="section gf-form-group"><h5 class="section-heading">Data</h5><div class="gf-form"><label class="gf-form-label width-10">Table Transform</label><div class="gf-form-select-wrapper max-width-15"><select class="gf-form-input" ng-model="editor.panel.transform" ng-options="k as v.description for (k, v) in editor.transformers" ng-change="editor.transformChanged()"></select></div></div><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label width-10">Columns</label></div><div class="gf-form" ng-repeat="column in editor.panel.columns"><label class="gf-form-label"><i class="pointer fa fa-remove" ng-click="editor.removeColumn(column)"></i> <span>{{column.text}}</span></label></div><div class="gf-form" ng-show="editor.canSetColumns"><metric-segment segment="editor.addColumnSegment" get-options="editor.getColumnOptions()" on-change="editor.addColumn()"></metric-segment></div><div class="gf-form" ng-hide="editor.canSetColumns"><label class="gf-form-label">Auto<info-popover mode="right-normal" ng-if="editor.columnsHelpMessage">{{editor.columnsHelpMessage}}</info-popover></label></div></div></div><div class="section gf-form-group"><h5 class="section-heading">Paging</h5><div class="gf-form"><label class="gf-form-label width-8">Rows per page</label><input type="number" class="gf-form-input width-6" placeholder="100" data-placement="right" ng-model="editor.panel.pageSize" ng-change="editor.render()" ng-model-onblur></div><gf-form-switch class="gf-form" label-class="width-8" switch-class="max-width-6" label="Scroll" checked="editor.panel.scroll" on-change="editor.render()"></gf-form-switch><div class="gf-form max-width-17"><label class="gf-form-label width-8">Font size</label><div class="gf-form-select-wrapper width-6"><select class="gf-form-input" ng-model="editor.panel.fontSize" ng-options="f for f in editor.fontSizes" ng-change="editor.render()"></select></div></div></div></div>'),a.put("public/app/plugins/panel/table/module.html",'<div class="table-panel-container"><div class="table-panel-header-bg" ng-show="ctrl.table.rows.length"></div><div class="table-panel-scroll" ng-show="ctrl.table.rows.length"><table class="table-panel-table"><thead><tr><th ng-repeat="col in ctrl.table.columns" ng-hide="col.hidden"><div class="table-panel-table-header-inner pointer" ng-click="ctrl.toggleColumnSort(col, $index)">{{col.title}} <span class="table-panel-table-header-controls" ng-if="col.sort"><i class="fa fa-caret-down" ng-show="col.desc"></i> <i class="fa fa-caret-up" ng-hide="col.desc"></i></span></div></th></tr></thead><tbody></tbody></table></div></div><div class="datapoints-warning" ng-show="ctrl.table.rows.length===0"><span class="small">No data to show<tip>Nothing returned by data query</tip></span></div><div class="table-panel-footer"></div>'),a.put("public/app/plugins/panel/text/editor.html",'<div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label">Mode</span> <span class="gf-form-select-wrapper"><select class="gf-form-input" ng-model="ctrl.panel.mode" ng-options="f for f in [\'html\',\'markdown\']"></select></span></div></div></div><h3 class="page-heading">Content</h3><span ng-show="ctrl.panel.mode == \'markdown\'">(This area uses <a target="_blank" href="http://en.wikipedia.org/wiki/Markdown">Markdown</a>. HTML is not supported)</span><textarea class="gf-form-input" ng-model="ctrl.panel.content" rows="20" style="width:95%" give-focus="true" ng-change="ctrl.render()" ng-model-onblur>\n</textarea>'),a.put("public/app/plugins/panel/text/module.html",'<p class="markdown-html panel-text-content" ng-bind-html="ctrl.content" ng-show="ctrl.content"></p>'),a.put("public/app/plugins/panel/unknown/module.html",'<div class="text-center" style="padding-top: 2rem">Unknown panel type: <strong>{{ctrl.panel.type}}</strong></div>')}])});