/*! grafana - v4.5.0 - 2017-09-14
 * Copyright (c) 2017 Torkel Ödegaard; Licensed Apache-2.0 */

System.register(["test/lib/common","lodash","../model"],function(a,b){"use strict";var c,d,e;b&&b.id;return{setters:[function(a){c=a},function(a){d=a},function(a){e=a}],execute:function(){c.describe("DashboardModel",function(){c.describe("when creating new dashboard model defaults only",function(){var a;c.beforeEach(function(){a=new e.DashboardModel({},{})}),c.it("should have title",function(){c.expect(a.title).to.be("No Title")}),c.it("should have meta",function(){c.expect(a.meta.canSave).to.be(!0),c.expect(a.meta.canShare).to.be(!0)}),c.it("should have default properties",function(){c.expect(a.rows.length).to.be(0)})}),c.describe("when getting next panel id",function(){var a;c.beforeEach(function(){a=new e.DashboardModel({rows:[{panels:[{id:5}]}]})}),c.it("should return max id + 1",function(){c.expect(a.getNextPanelId()).to.be(6)})}),c.describe("getSaveModelClone",function(){c.it("should sort keys",function(){var a=new e.DashboardModel({}),b=a.getSaveModelClone(),f=d.default.keys(b);c.expect(f[0]).to.be("addEmptyRow"),c.expect(f[1]).to.be("addPanel")})}),c.describe("row and panel manipulation",function(){var a;c.beforeEach(function(){a=new e.DashboardModel({})}),c.it("adding default should split span in half",function(){a.addEmptyRow(),a.rows[0].addPanel({span:12}),a.rows[0].addPanel({span:12}),c.expect(a.rows[0].panels[0].span).to.be(6),c.expect(a.rows[0].panels[1].span).to.be(6)}),c.it("duplicate panel should try to add it to same row",function(){var b={span:4,attr:"123",id:10};a.addEmptyRow(),a.rows[0].addPanel(b),a.duplicatePanel(b,a.rows[0]),c.expect(a.rows[0].panels[0].span).to.be(4),c.expect(a.rows[0].panels[1].span).to.be(4),c.expect(a.rows[0].panels[1].attr).to.be("123"),c.expect(a.rows[0].panels[1].id).to.be(11)}),c.it("duplicate panel should remove repeat data",function(){var b={span:4,attr:"123",id:10,repeat:"asd",scopedVars:{test:"asd"}};a.addEmptyRow(),a.rows[0].addPanel(b),a.duplicatePanel(b,a.rows[0]),c.expect(a.rows[0].panels[1].repeat).to.be(void 0),c.expect(a.rows[0].panels[1].scopedVars).to.be(void 0)})}),c.describe("when creating dashboard with old schema",function(){var a,b,d,f;c.beforeEach(function(){a=new e.DashboardModel({services:{filter:{time:{from:"now-1d",to:"now"},list:[{}]}},pulldowns:[{type:"filtering",enable:!0},{type:"annotations",enable:!0,annotations:[{name:"old"}]}],rows:[{panels:[{type:"graph",legend:!0,aliasYAxis:{test:2},y_formats:["kbyte","ms"],grid:{min:1,max:10,rightMin:5,rightMax:15,leftLogBase:1,rightLogBase:2,threshold1:200,threshold2:400,threshold1Color:"yellow",threshold2Color:"red"},leftYAxisLabel:"left label",targets:[{refId:"A"},{}]},{type:"singlestat",legend:!0,thresholds:"10,20,30",aliasYAxis:{test:2},grid:{min:1,max:10},targets:[{refId:"A"},{}]},{type:"table",legend:!0,styles:[{thresholds:["10","20","30"]},{thresholds:["100","200","300"]}],targets:[{refId:"A"},{}]}]}]}),b=a.rows[0].panels[0],d=a.rows[0].panels[1],f=a.rows[0].panels[2]}),c.it("should have title",function(){c.expect(a.title).to.be("No Title")}),c.it("should have panel id",function(){c.expect(b.id).to.be(1)}),c.it("should move time and filtering list",function(){c.expect(a.time.from).to.be("now-1d"),c.expect(a.templating.list[0].allFormat).to.be("glob")}),c.it("graphite panel should change name too graph",function(){c.expect(b.type).to.be("graph")}),c.it("single stat panel should have two thresholds",function(){c.expect(d.thresholds).to.be("20,30")}),c.it("queries without refId should get it",function(){c.expect(b.targets[1].refId).to.be("B")}),c.it("update legend setting",function(){c.expect(b.legend.show).to.be(!0)}),c.it("move aliasYAxis to series override",function(){c.expect(b.seriesOverrides[0].alias).to.be("test"),c.expect(b.seriesOverrides[0].yaxis).to.be(2)}),c.it("should move pulldowns to new schema",function(){c.expect(a.annotations.list[0].name).to.be("old")}),c.it("table panel should only have two thresholds values",function(){c.expect(f.styles[0].thresholds[0]).to.be("20"),c.expect(f.styles[0].thresholds[1]).to.be("30"),c.expect(f.styles[1].thresholds[0]).to.be("200"),c.expect(f.styles[1].thresholds[1]).to.be("300")}),c.it("graph grid to yaxes options",function(){c.expect(b.yaxes[0].min).to.be(1),c.expect(b.yaxes[0].max).to.be(10),c.expect(b.yaxes[0].format).to.be("kbyte"),c.expect(b.yaxes[0].label).to.be("left label"),c.expect(b.yaxes[0].logBase).to.be(1),c.expect(b.yaxes[1].min).to.be(5),c.expect(b.yaxes[1].max).to.be(15),c.expect(b.yaxes[1].format).to.be("ms"),c.expect(b.yaxes[1].logBase).to.be(2),c.expect(b.grid.rightMax).to.be(void 0),c.expect(b.grid.rightLogBase).to.be(void 0),c.expect(b.y_formats).to.be(void 0)}),c.it("dashboard schema version should be set to latest",function(){c.expect(a.schemaVersion).to.be(14)}),c.it("graph thresholds should be migrated",function(){c.expect(b.thresholds.length).to.be(2),c.expect(b.thresholds[0].op).to.be("gt"),c.expect(b.thresholds[0].value).to.be(200),c.expect(b.thresholds[0].fillColor).to.be("yellow"),c.expect(b.thresholds[1].value).to.be(400),c.expect(b.thresholds[1].fillColor).to.be("red")})}),c.describe("when creating dashboard model with missing list for annoations or templating",function(){var a;c.beforeEach(function(){a=new e.DashboardModel({annotations:{enable:!0},templating:{enable:!0}})}),c.it("should add empty list",function(){c.expect(a.annotations.list.length).to.be(0),c.expect(a.templating.list.length).to.be(0)})}),c.describe("Given editable false dashboard",function(){var a;c.beforeEach(function(){a=new e.DashboardModel({editable:!1})}),c.it("Should set meta canEdit and canSave to false",function(){c.expect(a.meta.canSave).to.be(!1),c.expect(a.meta.canEdit).to.be(!1)}),c.it("getSaveModelClone should remove meta",function(){var b=a.getSaveModelClone();c.expect(b.meta).to.be(void 0)})}),c.describe("when loading dashboard with old influxdb query schema",function(){var a,b;c.beforeEach(function(){a=new e.DashboardModel({rows:[{panels:[{type:"graph",grid:{},yaxes:[{},{}],targets:[{alias:"$tag_datacenter $tag_source $col",column:"value",measurement:"logins.count",fields:[{func:"mean",name:"value",mathExpr:"*2",asExpr:"value"},{name:"one-minute",func:"mean",mathExpr:"*3",asExpr:"one-minute"}],tags:[],fill:"previous",function:"mean",groupBy:[{interval:"auto",type:"time"},{key:"source",type:"tag"},{type:"tag",key:"datacenter"}]}]}]}]}),b=a.rows[0].panels[0].targets[0]}),c.it("should update query schema",function(){c.expect(b.fields).to.be(void 0),c.expect(b.select.length).to.be(2),c.expect(b.select[0].length).to.be(4),c.expect(b.select[0][0].type).to.be("field"),c.expect(b.select[0][1].type).to.be("mean"),c.expect(b.select[0][2].type).to.be("math"),c.expect(b.select[0][3].type).to.be("alias")})}),c.describe("when creating dashboard model with missing list for annoations or templating",function(){var a;c.beforeEach(function(){a=new e.DashboardModel({annotations:{enable:!0},templating:{enable:!0}})}),c.it("should add empty list",function(){c.expect(a.annotations.list.length).to.be(0),c.expect(a.templating.list.length).to.be(0)})}),c.describe("Formatting epoch timestamp when timezone is set as utc",function(){var a;c.beforeEach(function(){a=new e.DashboardModel({timezone:"utc"})}),c.it("Should format timestamp with second resolution by default",function(){c.expect(a.formatDate(123456789e4)).to.be("2009-02-13 23:31:30")}),c.it("Should format timestamp with second resolution even if second format is passed as parameter",function(){c.expect(a.formatDate(1234567890007,"YYYY-MM-DD HH:mm:ss")).to.be("2009-02-13 23:31:30")}),c.it("Should format timestamp with millisecond resolution if format is passed as parameter",function(){c.expect(a.formatDate(1234567890007,"YYYY-MM-DD HH:mm:ss.SSS")).to.be("2009-02-13 23:31:30.007")})}),c.describe("updateSubmenuVisibility with empty lists",function(){var a;c.beforeEach(function(){a=new e.DashboardModel({}),a.updateSubmenuVisibility()}),c.it("should not enable submmenu",function(){c.expect(a.meta.submenuEnabled).to.be(!1)})}),c.describe("updateSubmenuVisibility with annotation",function(){var a;c.beforeEach(function(){a=new e.DashboardModel({annotations:{list:[{}]}}),a.updateSubmenuVisibility()}),c.it("should enable submmenu",function(){c.expect(a.meta.submenuEnabled).to.be(!0)})}),c.describe("updateSubmenuVisibility with template var",function(){var a;c.beforeEach(function(){a=new e.DashboardModel({templating:{list:[{}]}}),a.updateSubmenuVisibility()}),c.it("should enable submmenu",function(){c.expect(a.meta.submenuEnabled).to.be(!0)})}),c.describe("updateSubmenuVisibility with hidden template var",function(){var a;c.beforeEach(function(){a=new e.DashboardModel({templating:{list:[{hide:2}]}}),a.updateSubmenuVisibility()}),c.it("should not enable submmenu",function(){c.expect(a.meta.submenuEnabled).to.be(!1)})}),c.describe("updateSubmenuVisibility with hidden annotation toggle",function(){var a;c.beforeEach(function(){a=new e.DashboardModel({annotations:{list:[{hide:!0}]}}),a.updateSubmenuVisibility()}),c.it("should not enable submmenu",function(){c.expect(a.meta.submenuEnabled).to.be(!1)})})})}}});