/*! grafana - v4.5.0 - 2017-09-14
 * Copyright (c) 2017 Torkel Ödegaard; Licensed Apache-2.0 */

System.register(["test/lib/common","lodash","app/core/config","../export/exporter","../model"],function(a,b){"use strict";var c,d,e,f,g;b&&b.id;return{setters:[function(a){c=a},function(a){d=a},function(a){e=a},function(a){f=a},function(a){g=a}],execute:function(){c.describe("given dashboard with repeated panels",function(){var a,b;c.beforeEach(function(d){a={rows:[],templating:{list:[]},annotations:{list:[]}},e.default.buildInfo={version:"3.0.2"},a.templating.list.push({name:"apps",type:"query",datasource:"gfdb",current:{value:"Asd",text:"Asd"},options:[{value:"Asd",text:"Asd"}]}),a.templating.list.push({name:"prefix",type:"constant",current:{value:"collectd",text:"collectd"},options:[]}),a.templating.list.push({name:"ds",type:"datasource",query:"testdb",current:{value:"prod",text:"prod"},options:[]}),a.annotations.list.push({name:"logs",datasource:"gfdb"}),a.rows.push({repeat:"test",panels:[{id:2,repeat:"apps",datasource:"gfdb",type:"graph"},{id:3,repeat:null,repeatPanelId:2},{id:4,datasource:"-- Mixed --",targets:[{datasource:"other"}]},{id:5,datasource:"$ds"}]}),a.rows.push({repeat:null,repeatRowId:1,panels:[]});var h={get:c.sinon.stub()};h.get.withArgs("gfdb").returns(Promise.resolve({name:"gfdb",meta:{id:"testdb",info:{version:"1.2.1"},name:"TestDB"}})),h.get.withArgs("other").returns(Promise.resolve({name:"other",meta:{id:"other",info:{version:"1.2.1"},name:"OtherDB"}})),h.get.withArgs("-- Mixed --").returns(Promise.resolve({name:"mixed",meta:{id:"mixed",info:{version:"1.2.1"},name:"Mixed",builtIn:!0}})),e.default.panels.graph={id:"graph",name:"Graph",info:{version:"1.1.0"}},a=new g.DashboardModel(a,{});var i=new f.DashboardExporter(h);i.makeExportable(a).then(function(a){b=a,d()})}),c.it("exported dashboard should not contain repeated panels",function(){c.expect(b.rows[0].panels.length).to.be(3)}),c.it("exported dashboard should not contain repeated rows",function(){c.expect(b.rows.length).to.be(1)}),c.it("should replace datasource refs",function(){var a=b.rows[0].panels[0];c.expect(a.datasource).to.be("${DS_GFDB}")}),c.it("should replace datasource in variable query",function(){c.expect(b.templating.list[0].datasource).to.be("${DS_GFDB}"),c.expect(b.templating.list[0].options.length).to.be(0),c.expect(b.templating.list[0].current.value).to.be(void 0),c.expect(b.templating.list[0].current.text).to.be(void 0)}),c.it("should replace datasource in annotation query",function(){c.expect(b.annotations.list[0].datasource).to.be("${DS_GFDB}")}),c.it("should add datasource as input",function(){c.expect(b.__inputs[0].name).to.be("DS_GFDB"),c.expect(b.__inputs[0].pluginId).to.be("testdb"),c.expect(b.__inputs[0].type).to.be("datasource")}),c.it("should add datasource to required",function(){var a=d.default.find(b.__requires,{name:"TestDB"});c.expect(a.name).to.be("TestDB"),c.expect(a.id).to.be("testdb"),c.expect(a.type).to.be("datasource"),c.expect(a.version).to.be("1.2.1")}),c.it("should not add built in datasources to required",function(){var a=d.default.find(b.__requires,{name:"Mixed"});c.expect(a).to.be(void 0)}),c.it("should add datasources used in mixed mode",function(){var a=d.default.find(b.__requires,{name:"OtherDB"});c.expect(a).to.not.be(void 0)}),c.it("should add panel to required",function(){var a=d.default.find(b.__requires,{name:"Graph"});c.expect(a.name).to.be("Graph"),c.expect(a.id).to.be("graph"),c.expect(a.version).to.be("1.1.0")}),c.it("should add grafana version",function(){var a=d.default.find(b.__requires,{name:"Grafana"});c.expect(a.type).to.be("grafana"),c.expect(a.id).to.be("grafana"),c.expect(a.version).to.be("3.0.2")}),c.it("should add constant template variables as inputs",function(){var a=d.default.find(b.__inputs,{name:"VAR_PREFIX"});c.expect(a.type).to.be("constant"),c.expect(a.label).to.be("prefix"),c.expect(a.value).to.be("collectd")}),c.it("should templatize constant variables",function(){var a=d.default.find(b.templating.list,{name:"prefix"});c.expect(a.query).to.be("${VAR_PREFIX}"),c.expect(a.current.text).to.be("${VAR_PREFIX}"),c.expect(a.current.value).to.be("${VAR_PREFIX}"),c.expect(a.options[0].text).to.be("${VAR_PREFIX}"),c.expect(a.options[0].value).to.be("${VAR_PREFIX}")})})}}});