/*! grafana - v4.5.0 - 2017-09-14
 * Copyright (c) 2017 Torkel Ödegaard; Licensed Apache-2.0 */

System.register(["test/lib/common","lodash","app/features/dashboard/history/history","test/mocks/history-mocks"],function(a,b){"use strict";var c,d,e,f;b&&b.id;return{setters:[function(a){c=a},function(a){d=a},function(a){e=a},function(a){f=a}],execute:function(){c.describe("HistoryListCtrl",function(){var a=4,b={},g=f.versions();f.restore(7,a);c.beforeEach(c.angularMocks.module("grafana.core")),c.beforeEach(c.angularMocks.module("grafana.services")),c.beforeEach(c.angularMocks.inject(function(a){b.scope=a.$new()}));var h,i;c.beforeEach(function(){h={getHistoryList:c.sinon.stub(),calculateDiff:c.sinon.stub(),restoreDashboard:c.sinon.stub()},i={appEvent:c.sinon.spy(),onAppEvent:c.sinon.spy()}}),c.describe("when the history list component is loaded",function(){var a;c.beforeEach(c.angularMocks.inject(function(d,f){a=f.defer(),h.getHistoryList.returns(a.promise),b.ctrl=d(e.HistoryListCtrl,{historySrv:h,$rootScope:i,$scope:b.scope},{dashboard:{id:2,version:3,formatDate:c.sinon.stub().returns("date")}})})),c.it("should immediately attempt to fetch the history list",function(){c.expect(h.getHistoryList.calledOnce).to.be(!0)}),c.describe("and the history list is successfully fetched",function(){c.beforeEach(function(){a.resolve(g),b.ctrl.$scope.$apply()}),c.it("should reset the controller's state",function(){c.expect(b.ctrl.mode).to.be("list"),c.expect(b.ctrl.delta).to.eql({basic:"",json:""}),c.expect(b.ctrl.canCompare).to.be(!1),c.expect(d.default.find(b.ctrl.revisions,function(a){return a.checked})).to.be.undefined}),c.it("should indicate loading has finished",function(){c.expect(b.ctrl.loading).to.be(!1)}),c.it("should store the revisions sorted desc by version id",function(){c.expect(b.ctrl.revisions[0].version).to.be(4),c.expect(b.ctrl.revisions[1].version).to.be(3),c.expect(b.ctrl.revisions[2].version).to.be(2),c.expect(b.ctrl.revisions[3].version).to.be(1)}),c.it("should add a checked property to each revision",function(){var a=d.default.filter(b.ctrl.revisions,function(a){return a.hasOwnProperty("checked")});c.expect(a.length).to.be(4)}),c.it("should set all checked properties to false on reset",function(){b.ctrl.revisions[0].checked=!0,b.ctrl.revisions[2].checked=!0,b.ctrl.reset();var a=d.default.filter(b.ctrl.revisions,function(a){return!a.checked});c.expect(a.length).to.be(4)})}),c.describe("and fetching the history list fails",function(){c.beforeEach(function(){a.reject(new Error("HistoryListError")),b.ctrl.$scope.$apply()}),c.it("should reset the controller's state",function(){c.expect(b.ctrl.mode).to.be("list"),c.expect(b.ctrl.delta).to.eql({basic:"",json:""}),c.expect(d.default.find(b.ctrl.revisions,function(a){return a.checked})).to.be.undefined}),c.it("should indicate loading has finished",function(){c.expect(b.ctrl.loading).to.be(!1)}),c.it("should have an empty revisions list",function(){c.expect(b.ctrl.revisions).to.eql([])})}),c.describe("should update the history list when the dashboard is saved",function(){c.beforeEach(function(){b.ctrl.dashboard={version:3},b.ctrl.resetFromSource=c.sinon.spy()}),c.it("should listen for the `dashboard-saved` appEvent",function(){c.expect(i.onAppEvent.calledOnce).to.be(!0),c.expect(i.onAppEvent.getCall(0).args[0]).to.be("dashboard-saved")}),c.it("should call `onDashboardSaved` when the appEvent is received",function(){c.expect(i.onAppEvent.getCall(0).args[1]).to.not.be(b.ctrl.onDashboardSaved),c.expect(i.onAppEvent.getCall(0).args[1].toString).to.be(b.ctrl.onDashboardSaved.toString)})})}),c.describe("when the user wants to compare two revisions",function(){var a;c.beforeEach(c.angularMocks.inject(function(d,f){a=f.defer(),h.getHistoryList.returns(f.when(g)),h.calculateDiff.returns(a.promise),b.ctrl=d(e.HistoryListCtrl,{historySrv:h,$rootScope:i,$scope:b.scope},{dashboard:{id:2,version:3,formatDate:c.sinon.stub().returns("date")}}),b.ctrl.$scope.onDashboardSaved=c.sinon.spy(),b.ctrl.$scope.$apply()})),c.it("should have already fetched the history list",function(){c.expect(h.getHistoryList.calledOnce).to.be(!0),c.expect(b.ctrl.revisions.length).to.be.above(0)}),c.it("should check that two valid versions are selected",function(){c.expect(b.ctrl.canCompare).to.be(!1),b.ctrl.revisions=[{checked:!0}],b.ctrl.revisionSelectionChanged(),c.expect(b.ctrl.canCompare).to.be(!1),b.ctrl.revisions=[{checked:!0},{checked:!0}],b.ctrl.revisionSelectionChanged(),c.expect(b.ctrl.canCompare).to.be(!0)}),c.describe("and the basic diff is successfully fetched",function(){c.beforeEach(function(){a.resolve(f.compare("basic")),b.ctrl.revisions[1].checked=!0,b.ctrl.revisions[3].checked=!0,b.ctrl.getDiff("basic"),b.ctrl.$scope.$apply()}),c.it("should fetch the basic diff if two valid versions are selected",function(){c.expect(h.calculateDiff.calledOnce).to.be(!0),c.expect(b.ctrl.delta.basic).to.be("<div></div>"),c.expect(b.ctrl.delta.json).to.be("")}),c.it("should set the basic diff view as active",function(){c.expect(b.ctrl.mode).to.be("compare"),c.expect(b.ctrl.diff).to.be("basic")}),c.it("should indicate loading has finished",function(){c.expect(b.ctrl.loading).to.be(!1)})}),c.describe("and the json diff is successfully fetched",function(){c.beforeEach(function(){a.resolve(f.compare("json")),b.ctrl.revisions[1].checked=!0,b.ctrl.revisions[3].checked=!0,b.ctrl.getDiff("json"),b.ctrl.$scope.$apply()}),c.it("should fetch the json diff if two valid versions are selected",function(){c.expect(h.calculateDiff.calledOnce).to.be(!0),c.expect(b.ctrl.delta.basic).to.be(""),c.expect(b.ctrl.delta.json).to.be("<pre><code></code></pre>")}),c.it("should set the json diff view as active",function(){c.expect(b.ctrl.mode).to.be("compare"),c.expect(b.ctrl.diff).to.be("json")}),c.it("should indicate loading has finished",function(){c.expect(b.ctrl.loading).to.be(!1)})}),c.describe("and diffs have already been fetched",function(){c.beforeEach(function(){a.resolve(f.compare("basic")),b.ctrl.revisions[3].checked=!0,b.ctrl.revisions[1].checked=!0,b.ctrl.delta.basic="cached basic",b.ctrl.getDiff("basic"),b.ctrl.$scope.$apply()}),c.it("should use the cached diffs instead of fetching",function(){c.expect(h.calculateDiff.calledOnce).to.be(!1),c.expect(b.ctrl.delta.basic).to.be("cached basic")}),c.it("should indicate loading has finished",function(){c.expect(b.ctrl.loading).to.be(!1)})}),c.describe("and fetching the diff fails",function(){c.beforeEach(function(){a.reject(new Error("DiffError")),b.ctrl.revisions[3].checked=!0,b.ctrl.revisions[1].checked=!0,b.ctrl.getDiff("basic"),b.ctrl.$scope.$apply()}),c.it("should fetch the diff if two valid versions are selected",function(){c.expect(h.calculateDiff.calledOnce).to.be(!0)}),c.it("should return to the history list view",function(){c.expect(b.ctrl.mode).to.be("list")}),c.it("should indicate loading has finished",function(){c.expect(b.ctrl.loading).to.be(!1)}),c.it("should have an empty delta/changeset",function(){c.expect(b.ctrl.delta).to.eql({basic:"",json:""})})})}),c.describe("when the user wants to restore a revision",function(){var d;c.beforeEach(c.angularMocks.inject(function(a,c){d=c.defer(),h.getHistoryList.returns(c.when(g)),h.restoreDashboard.returns(d.promise),b.ctrl=a(e.HistoryListCtrl,{historySrv:h,contextSrv:{user:{name:"Carlos"}},$rootScope:i,$scope:b.scope}),b.ctrl.dashboard={id:1},b.ctrl.restore(),b.ctrl.$scope.$apply()})),c.it("should display a modal allowing the user to restore or cancel",function(){c.expect(i.appEvent.calledOnce).to.be(!0),c.expect(i.appEvent.calledWith("confirm-modal")).to.be(!0)}),c.describe("and restore fails to fetch",function(){c.beforeEach(function(){d.reject(new Error("RestoreError")),b.ctrl.restoreConfirm(a);try{b.ctrl.$scope.$apply()}catch(a){}}),c.it("should indicate loading has finished",function(){c.expect(b.ctrl.loading).to.be(!1)})})})})}}});