/*! grafana - v4.5.0 - 2017-09-14
 * Copyright (c) 2017 Torkel Ödegaard; Licensed Apache-2.0 */

System.register(["test/lib/common","../elastic_response"],function(a,b){"use strict";var c,d;b&&b.id;return{setters:[function(a){c=a},function(a){d=a}],execute:function(){c.describe("ElasticResponse",function(){var a,b,e;c.describe("simple query and count",function(){c.beforeEach(function(){a=[{refId:"A",metrics:[{type:"count",id:"1"}],bucketAggs:[{type:"date_histogram",field:"@timestamp",id:"2"}]}],b={responses:[{aggregations:{2:{buckets:[{doc_count:10,key:1e3},{doc_count:15,key:2e3}]}}}]},e=new d.ElasticResponse(a,b).getTimeSeries()}),c.it("should return 1 series",function(){c.expect(e.data.length).to.be(1),c.expect(e.data[0].target).to.be("Count"),c.expect(e.data[0].datapoints.length).to.be(2),c.expect(e.data[0].datapoints[0][0]).to.be(10),c.expect(e.data[0].datapoints[0][1]).to.be(1e3)})}),c.describe("simple query count & avg aggregation",function(){var e;c.beforeEach(function(){a=[{refId:"A",metrics:[{type:"count",id:"1"},{type:"avg",field:"value",id:"2"}],bucketAggs:[{type:"date_histogram",field:"@timestamp",id:"3"}]}],b={responses:[{aggregations:{3:{buckets:[{2:{value:88},doc_count:10,key:1e3},{2:{value:99},doc_count:15,key:2e3}]}}}]},e=new d.ElasticResponse(a,b).getTimeSeries()}),c.it("should return 2 series",function(){c.expect(e.data.length).to.be(2),c.expect(e.data[0].datapoints.length).to.be(2),c.expect(e.data[0].datapoints[0][0]).to.be(10),c.expect(e.data[0].datapoints[0][1]).to.be(1e3),c.expect(e.data[1].target).to.be("Average value"),c.expect(e.data[1].datapoints[0][0]).to.be(88),c.expect(e.data[1].datapoints[1][0]).to.be(99)})}),c.describe("single group by query one metric",function(){var e;c.beforeEach(function(){a=[{refId:"A",metrics:[{type:"count",id:"1"}],bucketAggs:[{type:"terms",field:"host",id:"2"},{type:"date_histogram",field:"@timestamp",id:"3"}]}],b={responses:[{aggregations:{2:{buckets:[{3:{buckets:[{doc_count:1,key:1e3},{doc_count:3,key:2e3}]},doc_count:4,key:"server1"},{3:{buckets:[{doc_count:2,key:1e3},{doc_count:8,key:2e3}]},doc_count:10,key:"server2"}]}}}]},e=new d.ElasticResponse(a,b).getTimeSeries()}),c.it("should return 2 series",function(){c.expect(e.data.length).to.be(2),c.expect(e.data[0].datapoints.length).to.be(2),c.expect(e.data[0].target).to.be("server1"),c.expect(e.data[1].target).to.be("server2")})}),c.describe("single group by query two metrics",function(){var e;c.beforeEach(function(){a=[{refId:"A",metrics:[{type:"count",id:"1"},{type:"avg",field:"@value",id:"4"}],bucketAggs:[{type:"terms",field:"host",id:"2"},{type:"date_histogram",field:"@timestamp",id:"3"}]}],b={responses:[{aggregations:{2:{buckets:[{3:{buckets:[{4:{value:10},doc_count:1,key:1e3},{4:{value:12},doc_count:3,key:2e3}]},doc_count:4,key:"server1"},{3:{buckets:[{4:{value:20},doc_count:1,key:1e3},{4:{value:32},doc_count:3,key:2e3}]},doc_count:10,key:"server2"}]}}}]},e=new d.ElasticResponse(a,b).getTimeSeries()}),c.it("should return 2 series",function(){c.expect(e.data.length).to.be(4),c.expect(e.data[0].datapoints.length).to.be(2),c.expect(e.data[0].target).to.be("server1 Count"),c.expect(e.data[1].target).to.be("server1 Average @value"),c.expect(e.data[2].target).to.be("server2 Count"),c.expect(e.data[3].target).to.be("server2 Average @value")})}),c.describe("with percentiles ",function(){var e;c.beforeEach(function(){a=[{refId:"A",metrics:[{type:"percentiles",settings:{percents:[75,90]},id:"1"}],bucketAggs:[{type:"date_histogram",field:"@timestamp",id:"3"}]}],b={responses:[{aggregations:{3:{buckets:[{1:{values:{75:3.3,90:5.5}},doc_count:10,key:1e3},{1:{values:{75:2.3,90:4.5}},doc_count:15,key:2e3}]}}}]},e=new d.ElasticResponse(a,b).getTimeSeries()}),c.it("should return 2 series",function(){c.expect(e.data.length).to.be(2),c.expect(e.data[0].datapoints.length).to.be(2),c.expect(e.data[0].target).to.be("p75"),c.expect(e.data[1].target).to.be("p90"),c.expect(e.data[0].datapoints[0][0]).to.be(3.3),c.expect(e.data[0].datapoints[0][1]).to.be(1e3),c.expect(e.data[1].datapoints[1][0]).to.be(4.5)})}),c.describe("with extended_stats",function(){var e;c.beforeEach(function(){a=[{refId:"A",metrics:[{type:"extended_stats",meta:{max:!0,std_deviation_bounds_upper:!0},id:"1"}],bucketAggs:[{type:"terms",field:"host",id:"3"},{type:"date_histogram",id:"4"}]}],b={responses:[{aggregations:{3:{buckets:[{key:"server1",4:{buckets:[{1:{max:10.2,min:5.5,std_deviation_bounds:{upper:3,lower:-2}},doc_count:10,key:1e3}]}},{key:"server2",4:{buckets:[{1:{max:10.2,min:5.5,std_deviation_bounds:{upper:3,lower:-2}},doc_count:10,key:1e3}]}}]}}}]},e=new d.ElasticResponse(a,b).getTimeSeries()}),c.it("should return 4 series",function(){c.expect(e.data.length).to.be(4),c.expect(e.data[0].datapoints.length).to.be(1),c.expect(e.data[0].target).to.be("server1 Max"),c.expect(e.data[1].target).to.be("server1 Std Dev Upper"),c.expect(e.data[0].datapoints[0][0]).to.be(10.2),c.expect(e.data[1].datapoints[0][0]).to.be(3)})}),c.describe("single group by with alias pattern",function(){var e;c.beforeEach(function(){a=[{refId:"A",metrics:[{type:"count",id:"1"}],alias:"{{term @host}} {{metric}} and {{not_exist}} {{@host}}",bucketAggs:[{type:"terms",field:"@host",id:"2"},{type:"date_histogram",field:"@timestamp",id:"3"}]}],b={responses:[{aggregations:{2:{buckets:[{3:{buckets:[{doc_count:1,key:1e3},{doc_count:3,key:2e3}]},doc_count:4,key:"server1"},{3:{buckets:[{doc_count:2,key:1e3},{doc_count:8,key:2e3}]},doc_count:10,key:"server2"},{3:{buckets:[{doc_count:2,key:1e3},{doc_count:8,key:2e3}]},doc_count:10,key:0}]}}}]},e=new d.ElasticResponse(a,b).getTimeSeries()}),c.it("should return 2 series",function(){c.expect(e.data.length).to.be(3),c.expect(e.data[0].datapoints.length).to.be(2),c.expect(e.data[0].target).to.be("server1 Count and {{not_exist}} server1"),c.expect(e.data[1].target).to.be("server2 Count and {{not_exist}} server2"),c.expect(e.data[2].target).to.be("0 Count and {{not_exist}} 0")})}),c.describe("histogram response",function(){var e;c.beforeEach(function(){a=[{refId:"A",metrics:[{type:"count",id:"1"}],bucketAggs:[{type:"histogram",field:"bytes",id:"3"}]}],b={responses:[{aggregations:{3:{buckets:[{doc_count:1,key:1e3},{doc_count:3,key:2e3},{doc_count:2,key:1e3}]}}}]},e=new d.ElasticResponse(a,b).getTimeSeries()}),c.it("should return table with byte and count",function(){c.expect(e.data[0].rows.length).to.be(3),c.expect(e.data[0].columns).to.eql([{text:"bytes",filterable:!0},{text:"Count"}])})}),c.describe("with two filters agg",function(){var e;c.beforeEach(function(){a=[{refId:"A",metrics:[{type:"count",id:"1"}],bucketAggs:[{id:"2",type:"filters",settings:{filters:[{query:"@metric:cpu"},{query:"@metric:logins.count"}]}},{type:"date_histogram",field:"@timestamp",id:"3"}]}],b={responses:[{aggregations:{2:{buckets:{"@metric:cpu":{3:{buckets:[{doc_count:1,key:1e3},{doc_count:3,key:2e3}]}},"@metric:logins.count":{3:{buckets:[{doc_count:2,key:1e3},{doc_count:8,key:2e3}]}}}}}}]},e=new d.ElasticResponse(a,b).getTimeSeries()}),c.it("should return 2 series",function(){c.expect(e.data.length).to.be(2),c.expect(e.data[0].datapoints.length).to.be(2),c.expect(e.data[0].target).to.be("@metric:cpu"),c.expect(e.data[1].target).to.be("@metric:logins.count")})}),c.describe("with dropfirst and last aggregation",function(){c.beforeEach(function(){a=[{refId:"A",metrics:[{type:"avg",id:"1"},{type:"count"}],bucketAggs:[{id:"2",type:"date_histogram",field:"host",settings:{trimEdges:1}}]}],b={responses:[{aggregations:{2:{buckets:[{1:{value:1e3},key:1,doc_count:369},{1:{value:2e3},key:2,doc_count:200},{1:{value:2e3},key:3,doc_count:200}]}}}]},e=new d.ElasticResponse(a,b).getTimeSeries()}),c.it("should remove first and last value",function(){c.expect(e.data.length).to.be(2),c.expect(e.data[0].datapoints.length).to.be(1)})}),c.describe("No group by time",function(){c.beforeEach(function(){a=[{refId:"A",metrics:[{type:"avg",id:"1"},{type:"count"}],bucketAggs:[{id:"2",type:"terms",field:"host"}]}],b={responses:[{aggregations:{2:{buckets:[{1:{value:1e3},key:"server-1",doc_count:369},{1:{value:2e3},key:"server-2",doc_count:200}]}}}]},e=new d.ElasticResponse(a,b).getTimeSeries()}),c.it("should return table",function(){c.expect(e.data.length).to.be(1),c.expect(e.data[0].type).to.be("table"),c.expect(e.data[0].rows.length).to.be(2),c.expect(e.data[0].rows[0][0]).to.be("server-1"),c.expect(e.data[0].rows[0][1]).to.be(1e3),c.expect(e.data[0].rows[0][2]).to.be(369),c.expect(e.data[0].rows[1][0]).to.be("server-2"),c.expect(e.data[0].rows[1][1]).to.be(2e3)})}),c.describe("Multiple metrics of same type",function(){c.beforeEach(function(){a=[{refId:"A",metrics:[{type:"avg",id:"1",field:"test"},{type:"avg",id:"2",field:"test2"}],bucketAggs:[{id:"2",type:"terms",field:"host"}]}],b={responses:[{aggregations:{2:{buckets:[{1:{value:1e3},2:{value:3e3},key:"server-1",doc_count:369}]}}}]},e=new d.ElasticResponse(a,b).getTimeSeries()}),c.it("should include field in metric name",function(){c.expect(e.data[0].type).to.be("table"),c.expect(e.data[0].rows[0][1]).to.be(1e3),c.expect(e.data[0].rows[0][2]).to.be(3e3)})}),c.describe("Raw documents query",function(){c.beforeEach(function(){a=[{refId:"A",metrics:[{type:"raw_document",id:"1"}],bucketAggs:[]}],b={responses:[{hits:{total:100,hits:[{_id:"1",_type:"type",_index:"index",_source:{sourceProp:"asd"},fields:{fieldProp:"field"}},{_source:{sourceProp:"asd2"},fields:{fieldProp:"field2"}}]}}]},e=new d.ElasticResponse(a,b).getTimeSeries()}),c.it("should return docs",function(){c.expect(e.data.length).to.be(1),c.expect(e.data[0].type).to.be("docs"),c.expect(e.data[0].total).to.be(100),c.expect(e.data[0].datapoints.length).to.be(2),c.expect(e.data[0].datapoints[0].sourceProp).to.be("asd"),c.expect(e.data[0].datapoints[0].fieldProp).to.be("field")})})})}}});