/*! grafana - v4.5.0 - 2017-09-14
 * Copyright (c) 2017 Torkel Ödegaard; Licensed Apache-2.0 */

System.register(["test/lib/common","../query_builder"],function(a,b){"use strict";var c,d;b&&b.id;return{setters:[function(a){c=a},function(a){d=a}],execute:function(){c.describe("ElasticQueryBuilder",function(){var a;c.beforeEach(function(){a=new d.default({timeField:"@timestamp"})}),c.it("with defaults",function(){var b=a.build({metrics:[{type:"Count",id:"0"}],timeField:"@timestamp",bucketAggs:[{type:"date_histogram",field:"@timestamp",id:"1"}]});c.expect(b.query.bool.filter[0].range["@timestamp"].gte).to.be("$timeFrom"),c.expect(b.aggs[1].date_histogram.extended_bounds.min).to.be("$timeFrom")}),c.it("with defaults on es5.x",function(){var a=new d.default({timeField:"@timestamp",esVersion:5}),b=a.build({metrics:[{type:"Count",id:"0"}],timeField:"@timestamp",bucketAggs:[{type:"date_histogram",field:"@timestamp",id:"1"}]});c.expect(b.query.bool.filter[0].range["@timestamp"].gte).to.be("$timeFrom"),c.expect(b.aggs[1].date_histogram.extended_bounds.min).to.be("$timeFrom")}),c.it("with multiple bucket aggs",function(){var b=a.build({metrics:[{type:"count",id:"1"}],timeField:"@timestamp",bucketAggs:[{type:"terms",field:"@host",id:"2"},{type:"date_histogram",field:"@timestamp",id:"3"}]});c.expect(b.aggs[2].terms.field).to.be("@host"),c.expect(b.aggs[2].aggs[3].date_histogram.field).to.be("@timestamp")}),c.it("with select field",function(){var b=a.build({metrics:[{type:"avg",field:"@value",id:"1"}],bucketAggs:[{type:"date_histogram",field:"@timestamp",id:"2"}]},100,1e3),d=b.aggs[2].aggs;c.expect(d[1].avg.field).to.be("@value")}),c.it("with term agg and order by metric agg",function(){var b=a.build({metrics:[{type:"count",id:"1"},{type:"avg",field:"@value",id:"5"}],bucketAggs:[{type:"terms",field:"@host",settings:{size:5,order:"asc",orderBy:"5"},id:"2"},{type:"date_histogram",field:"@timestamp",id:"3"}]},100,1e3),d=b.aggs[2],e=d.aggs[3];c.expect(d.aggs[5].avg.field).to.be("@value"),c.expect(e.aggs[5].avg.field).to.be("@value")}),c.it("with metric percentiles",function(){var b=a.build({metrics:[{id:"1",type:"percentiles",field:"@load_time",settings:{percents:[1,2,3,4]}}],bucketAggs:[{type:"date_histogram",field:"@timestamp",id:"3"}]},100,1e3),d=b.aggs[3];c.expect(d.aggs[1].percentiles.field).to.be("@load_time"),c.expect(d.aggs[1].percentiles.percents).to.eql([1,2,3,4])}),c.it("with filters aggs",function(){var b=a.build({metrics:[{type:"count",id:"1"}],timeField:"@timestamp",bucketAggs:[{id:"2",type:"filters",settings:{filters:[{query:"@metric:cpu"},{query:"@metric:logins.count"}]}},{type:"date_histogram",field:"@timestamp",id:"4"}]});c.expect(b.aggs[2].filters.filters["@metric:cpu"].query_string.query).to.be("@metric:cpu"),c.expect(b.aggs[2].filters.filters["@metric:logins.count"].query_string.query).to.be("@metric:logins.count"),c.expect(b.aggs[2].aggs[4].date_histogram.field).to.be("@timestamp")}),c.it("with filters aggs on es5.x",function(){var a=new d.default({timeField:"@timestamp",esVersion:5}),b=a.build({metrics:[{type:"count",id:"1"}],timeField:"@timestamp",bucketAggs:[{id:"2",type:"filters",settings:{filters:[{query:"@metric:cpu"},{query:"@metric:logins.count"}]}},{type:"date_histogram",field:"@timestamp",id:"4"}]});c.expect(b.aggs[2].filters.filters["@metric:cpu"].query_string.query).to.be("@metric:cpu"),c.expect(b.aggs[2].filters.filters["@metric:logins.count"].query_string.query).to.be("@metric:logins.count"),c.expect(b.aggs[2].aggs[4].date_histogram.field).to.be("@timestamp")}),c.it("with raw_document metric",function(){var b=a.build({metrics:[{type:"raw_document",id:"1",settings:{}}],timeField:"@timestamp",bucketAggs:[]});c.expect(b.size).to.be(500)}),c.it("with raw_document metric size set",function(){var b=a.build({metrics:[{type:"raw_document",id:"1",settings:{size:1337}}],timeField:"@timestamp",bucketAggs:[]});c.expect(b.size).to.be(1337)}),c.it("with moving average",function(){var b=a.build({metrics:[{id:"3",type:"sum",field:"@value"},{id:"2",type:"moving_avg",field:"3",pipelineAgg:"3"}],bucketAggs:[{type:"date_histogram",field:"@timestamp",id:"3"}]}),d=b.aggs[3];c.expect(d.aggs[2]).not.to.be(void 0),c.expect(d.aggs[2].moving_avg).not.to.be(void 0),c.expect(d.aggs[2].moving_avg.buckets_path).to.be("3")}),c.it("with broken moving average",function(){var b=a.build({metrics:[{id:"3",type:"sum",field:"@value"},{id:"2",type:"moving_avg",pipelineAgg:"3"},{id:"4",type:"moving_avg",pipelineAgg:"Metric to apply moving average"}],bucketAggs:[{type:"date_histogram",field:"@timestamp",id:"3"}]}),d=b.aggs[3];c.expect(d.aggs[2]).not.to.be(void 0),c.expect(d.aggs[2].moving_avg).not.to.be(void 0),c.expect(d.aggs[2].moving_avg.buckets_path).to.be("3"),c.expect(d.aggs[4]).to.be(void 0)}),c.it("with derivative",function(){var b=a.build({metrics:[{id:"3",type:"sum",field:"@value"},{id:"2",type:"derivative",pipelineAgg:"3"}],bucketAggs:[{type:"date_histogram",field:"@timestamp",id:"3"}]}),d=b.aggs[3];c.expect(d.aggs[2]).not.to.be(void 0),c.expect(d.aggs[2].derivative).not.to.be(void 0),c.expect(d.aggs[2].derivative.buckets_path).to.be("3")}),c.it("with histogram",function(){var b=a.build({metrics:[{id:"1",type:"count"}],bucketAggs:[{type:"histogram",field:"bytes",id:"3",settings:{interval:10,min_doc_count:2,missing:5}}]}),d=b.aggs[3];c.expect(d.histogram.field).to.be("bytes"),c.expect(d.histogram.interval).to.be(10),c.expect(d.histogram.min_doc_count).to.be(2),c.expect(d.histogram.missing).to.be(5)}),c.it("with adhoc filters",function(){var b=a.build({metrics:[{type:"Count",id:"0"}],timeField:"@timestamp",bucketAggs:[{type:"date_histogram",field:"@timestamp",id:"3"}]},[{key:"key1",operator:"=",value:"value1"},{key:"key2",operator:"=",value:"value2"},{key:"key2",operator:"!=",value:"value2"},{key:"key3",operator:"<",value:"value3"},{key:"key4",operator:">",value:"value4"},{key:"key5",operator:"=~",value:"value5"},{key:"key6",operator:"!~",value:"value6"}]);c.expect(b.query.bool.must[0].match_phrase.key1.query).to.be("value1"),c.expect(b.query.bool.must[1].match_phrase.key2.query).to.be("value2"),c.expect(b.query.bool.must_not[0].match_phrase.key2.query).to.be("value2"),c.expect(b.query.bool.filter[2].range.key3.lt).to.be("value3"),c.expect(b.query.bool.filter[3].range.key4.gt).to.be("value4"),c.expect(b.query.bool.filter[4].regexp.key5).to.be("value5"),c.expect(b.query.bool.filter[5].bool.must_not.regexp.key6).to.be("value6")})})}}});