/*! grafana - v4.5.0 - 2017-09-14
 * Copyright (c) 2017 Torkel Ödegaard; Licensed Apache-2.0 */

System.register(["test/lib/common","../influx_query"],function(a,b){"use strict";var c,d;b&&b.id;return{setters:[function(a){c=a},function(a){d=a}],execute:function(){c.describe("InfluxQuery",function(){var a={replace:function(a){return a}};c.describe("render series with mesurement only",function(){c.it("should generate correct query",function(){var b=new d.default({measurement:"cpu"},a,{}),e=b.render();c.expect(e).to.be('SELECT mean("value") FROM "cpu" WHERE $timeFilter GROUP BY time($__interval) fill(null)')})}),c.describe("render series with policy only",function(){c.it("should generate correct query",function(){var b=new d.default({measurement:"cpu",policy:"5m_avg"},a,{}),e=b.render();c.expect(e).to.be('SELECT mean("value") FROM "5m_avg"."cpu" WHERE $timeFilter GROUP BY time($__interval) fill(null)')})}),c.describe("render series with math and alias",function(){c.it("should generate correct query",function(){var b=new d.default({measurement:"cpu",select:[[{type:"field",params:["value"]},{type:"mean",params:[]},{type:"math",params:["/100"]},{type:"alias",params:["text"]}]]},a,{}),e=b.render();c.expect(e).to.be('SELECT mean("value") /100 AS "text" FROM "cpu" WHERE $timeFilter GROUP BY time($__interval) fill(null)')})}),c.describe("series with single tag only",function(){c.it("should generate correct query",function(){var b=new d.default({measurement:"cpu",groupBy:[{type:"time",params:["auto"]}],tags:[{key:"hostname",value:"server\\1"}]},a,{}),e=b.render();c.expect(e).to.be('SELECT mean("value") FROM "cpu" WHERE ("hostname" = \'server\\\\1\') AND $timeFilter GROUP BY time($__interval)')}),c.it("should switch regex operator with tag value is regex",function(){var b=new d.default({measurement:"cpu",groupBy:[{type:"time",params:["auto"]}],tags:[{key:"app",value:"/e.*/"}]},a,{}),e=b.render();c.expect(e).to.be('SELECT mean("value") FROM "cpu" WHERE ("app" =~ /e.*/) AND $timeFilter GROUP BY time($__interval)')})}),c.describe("series with multiple tags only",function(){c.it("should generate correct query",function(){var b=new d.default({measurement:"cpu",groupBy:[{type:"time",params:["auto"]}],tags:[{key:"hostname",value:"server1"},{key:"app",value:"email",condition:"AND"}]},a,{}),e=b.render();c.expect(e).to.be('SELECT mean("value") FROM "cpu" WHERE ("hostname" = \'server1\' AND "app" = \'email\') AND $timeFilter GROUP BY time($__interval)')})}),c.describe("series with tags OR condition",function(){c.it("should generate correct query",function(){var b=new d.default({measurement:"cpu",groupBy:[{type:"time",params:["auto"]}],tags:[{key:"hostname",value:"server1"},{key:"hostname",value:"server2",condition:"OR"}]},a,{}),e=b.render();c.expect(e).to.be('SELECT mean("value") FROM "cpu" WHERE ("hostname" = \'server1\' OR "hostname" = \'server2\') AND $timeFilter GROUP BY time($__interval)')})}),c.describe("query with value condition",function(){c.it("should not quote value",function(){var b=new d.default({measurement:"cpu",groupBy:[],tags:[{key:"value",value:"5",operator:">"}]},a,{}),e=b.render();c.expect(e).to.be('SELECT mean("value") FROM "cpu" WHERE ("value" > 5) AND $timeFilter')})}),c.describe("series with groupByTag",function(){c.it("should generate correct query",function(){var b=new d.default({measurement:"cpu",tags:[],groupBy:[{type:"time",interval:"auto"},{type:"tag",params:["host"]}]},a,{}),e=b.render();c.expect(e).to.be('SELECT mean("value") FROM "cpu" WHERE $timeFilter GROUP BY time($__interval), "host"')})}),c.describe("render series without group by",function(){c.it("should generate correct query",function(){var b=new d.default({measurement:"cpu",select:[[{type:"field",params:["value"]}]],groupBy:[]},a,{}),e=b.render();c.expect(e).to.be('SELECT "value" FROM "cpu" WHERE $timeFilter')})}),c.describe("render series without group by and fill",function(){c.it("should generate correct query",function(){var b=new d.default({measurement:"cpu",select:[[{type:"field",params:["value"]}]],groupBy:[{type:"time"},{type:"fill",params:["0"]}]},a,{}),e=b.render();c.expect(e).to.be('SELECT "value" FROM "cpu" WHERE $timeFilter GROUP BY time($__interval) fill(0)')})}),c.describe("when adding group by part",function(){c.it("should add tag before fill",function(){var b=new d.default({measurement:"cpu",groupBy:[{type:"time"},{type:"fill"}]},a,{});b.addGroupBy("tag(host)"),c.expect(b.target.groupBy.length).to.be(3),c.expect(b.target.groupBy[1].type).to.be("tag"),c.expect(b.target.groupBy[1].params[0]).to.be("host"),c.expect(b.target.groupBy[2].type).to.be("fill")}),c.it("should add tag last if no fill",function(){var b=new d.default({measurement:"cpu",groupBy:[]},a,{});b.addGroupBy("tag(host)"),c.expect(b.target.groupBy.length).to.be(1),c.expect(b.target.groupBy[0].type).to.be("tag")})}),c.describe("when adding select part",function(){c.it("should add mean after after field",function(){var b=new d.default({measurement:"cpu",select:[[{type:"field",params:["value"]}]]},a,{});b.addSelectPart(b.selectModels[0],"mean"),c.expect(b.target.select[0].length).to.be(2),c.expect(b.target.select[0][1].type).to.be("mean")}),c.it("should replace sum by mean",function(){var b=new d.default({measurement:"cpu",select:[[{type:"field",params:["value"]},{type:"mean"}]]},a,{});b.addSelectPart(b.selectModels[0],"sum"),c.expect(b.target.select[0].length).to.be(2),c.expect(b.target.select[0][1].type).to.be("sum")}),c.it("should add math before alias",function(){var b=new d.default({measurement:"cpu",select:[[{type:"field",params:["value"]},{type:"mean"},{type:"alias"}]]},a,{});b.addSelectPart(b.selectModels[0],"math"),c.expect(b.target.select[0].length).to.be(4),c.expect(b.target.select[0][2].type).to.be("math")}),c.it("should add math last",function(){var b=new d.default({measurement:"cpu",select:[[{type:"field",params:["value"]},{type:"mean"}]]},a,{});b.addSelectPart(b.selectModels[0],"math"),c.expect(b.target.select[0].length).to.be(3),c.expect(b.target.select[0][2].type).to.be("math")}),c.it("should replace math",function(){var b=new d.default({measurement:"cpu",select:[[{type:"field",params:["value"]},{type:"mean"},{type:"math"}]]},a,{});b.addSelectPart(b.selectModels[0],"math"),c.expect(b.target.select[0].length).to.be(3),c.expect(b.target.select[0][2].type).to.be("math")}),c.it("should add math when one only query part",function(){var b=new d.default({measurement:"cpu",select:[[{type:"field",params:["value"]}]]},a,{});b.addSelectPart(b.selectModels[0],"math"),c.expect(b.target.select[0].length).to.be(2),c.expect(b.target.select[0][1].type).to.be("math")}),c.describe("when render adhoc filters",function(){c.it("should generate correct query segment",function(){var b=new d.default({measurement:"cpu"},a,{}),e=b.renderAdhocFilters([{key:"key1",operator:"=",value:"value1"},{key:"key2",operator:"!=",value:"value2"}]);c.expect(e).to.be("\"key1\" = 'value1' AND \"key2\" != 'value2'")})})})})}}});