/*! grafana - v4.5.0 - 2017-09-14
 * Copyright (c) 2017 Torkel Ödegaard; Licensed Apache-2.0 */

System.register(["../../../../../test/lib/common","../module","angular","jquery","test/specs/helpers","app/core/time_series2","moment","app/core/core"],function(a,b){"use strict";var c,d,e,f,g,h,i;b&&b.id;return{setters:[function(a){c=a},function(a){},function(a){d=a},function(a){e=a},function(a){f=a},function(a){g=a},function(a){h=a},function(a){i=a}],execute:function(){c.describe("grafanaGraph",function(){function a(a,b,j){void 0===j&&(j=500),c.describe(a,function(){var a={};a.setup=function(b){c.beforeEach(c.angularMocks.module(function(a){a.value("timeSrv",new f.default.TimeSrvStub)})),c.beforeEach(c.angularMocks.inject(function(f,k){var l={events:new i.Emitter,height:200,panel:{legend:{},grid:{},yaxes:[{min:null,max:null,format:"short",logBase:1},{min:null,max:null,format:"short",logBase:1}],thresholds:[],xaxis:{},seriesOverrides:[],tooltip:{shared:!0}},renderingCompleted:c.sinon.spy(),hiddenSeries:{},dashboard:{getTimezone:c.sinon.stub().returns("browser")},range:{from:h.default([2015,1,1,10]),to:h.default([2015,1,1,22])}},m=f.$new();m.ctrl=l,f.onAppEvent=c.sinon.spy(),a.data=[],a.data.push(new g.default({datapoints:[[1,1],[2,2]],alias:"series1"})),a.data.push(new g.default({datapoints:[[1,1],[2,2]],alias:"series2"})),b(l,a.data);var n=d.default.element("<div style='width:"+j+"px' grafana-graph><div>");k(n)(m),m.$digest(),e.default.plot=a.plotSpy=c.sinon.spy(),l.events.emit("render",a.data),a.plotData=a.plotSpy.getCall(0).args[1],a.plotOptions=a.plotSpy.getCall(0).args[2]}))},b(a)})}c.beforeEach(c.angularMocks.module("grafana.core")),a("simple lines options",function(a){a.setup(function(a){a.panel.lines=!0,a.panel.fill=5,a.panel.linewidth=3,a.panel.steppedLine=!0}),c.it("should configure plot with correct options",function(){c.expect(a.plotOptions.series.lines.show).to.be(!0),c.expect(a.plotOptions.series.lines.fill).to.be(.5),c.expect(a.plotOptions.series.lines.lineWidth).to.be(3),c.expect(a.plotOptions.series.lines.steps).to.be(!0)})}),a("when logBase is log 10",function(a){a.setup(function(a,b){a.panel.yaxes[0].logBase=10,b[0]=new g.default({datapoints:[[2e3,1],[.002,2],[0,3],[-1,4]],alias:"seriesAutoscale"}),b[0].yaxis=1,a.panel.yaxes[1].logBase=10,a.panel.yaxes[1].min="0.05",a.panel.yaxes[1].max="1500",b[1]=new g.default({datapoints:[[2e3,1],[.002,2],[0,3],[-1,4]],alias:"seriesFixedscale"}),b[1].yaxis=2}),c.it("should apply axis transform, autoscaling (if necessary) and ticks",function(){var b=a.plotOptions.yaxes[0];c.expect(b.transform(100)).to.be(2),c.expect(b.inverseTransform(-3)).to.be(.001),c.expect(b.min).to.be(.001),c.expect(b.max).to.be(1e4),c.expect(b.ticks.length).to.be(8),c.expect(b.ticks[0]).to.be(.001),c.expect(b.ticks[7]).to.be(1e4);var d=a.plotOptions.yaxes[1];c.expect(d.min).to.be(.05),c.expect(d.max).to.be(1500),c.expect(d.ticks.length).to.be(5),c.expect(d.ticks[0]).to.be(.1),c.expect(d.ticks[4]).to.be(1e3)})}),a("when logBase is log 10 and data points contain only zeroes",function(a){a.setup(function(a,b){a.panel.yaxes[0].logBase=10,b[0]=new g.default({datapoints:[[0,1],[0,2],[0,3],[0,4]],alias:"seriesAutoscale"}),b[0].yaxis=1}),c.it("should not set min and max and should create some fake ticks",function(){var b=a.plotOptions.yaxes[0];c.expect(b.transform(100)).to.be(2),c.expect(b.inverseTransform(-3)).to.be(.001),c.expect(b.min).to.be(void 0),c.expect(b.max).to.be(void 0),c.expect(b.ticks.length).to.be(2),c.expect(b.ticks[0]).to.be(1),c.expect(b.ticks[1]).to.be(2)})}),a("when logBase is log 10 and y-min is set to 0 and auto min is > 0.1",function(a){a.setup(function(a,b){a.panel.yaxes[0].logBase=10,a.panel.yaxes[0].min="0",b[0]=new g.default({datapoints:[[2e3,1],[4,2],[500,3],[3e3,4]],alias:"seriesAutoscale"}),b[0].yaxis=1}),c.it("should set min to 0.1 and add a tick for 0.1",function(){var b=a.plotOptions.yaxes[0];c.expect(b.transform(100)).to.be(2),c.expect(b.inverseTransform(-3)).to.be(.001),c.expect(b.min).to.be(.1),c.expect(b.max).to.be(1e4),c.expect(b.ticks.length).to.be(6),c.expect(b.ticks[0]).to.be(.1),c.expect(b.ticks[5]).to.be(1e4)})}),a("when logBase is log 2 and y-min is set to 0 and num of ticks exceeds max",function(a){a.setup(function(a,b){var c=125;a.height=c,a.panel.yaxes[0].logBase=2,a.panel.yaxes[0].min="0",b[0]=new g.default({datapoints:[[2e3,1],[4,2],[500,3],[3e3,4],[1e4,5],[1e5,6]],alias:"seriesAutoscale"}),b[0].yaxis=1}),c.it("should regenerate ticks so that if fits on the y-axis",function(){var b=a.plotOptions.yaxes[0];c.expect(b.min).to.be(.1),c.expect(b.ticks.length).to.be(8),c.expect(b.ticks[0]).to.be(.1),c.expect(b.ticks[7]).to.be(262144),c.expect(b.max).to.be(262144)}),c.it("should set axis max to be max tick value",function(){c.expect(a.plotOptions.yaxes[0].max).to.be(262144)})}),a("dashed lines options",function(a){a.setup(function(a){a.panel.lines=!0,a.panel.linewidth=2,a.panel.dashes=!0}),c.it("should configure dashed plot with correct options",function(){c.expect(a.plotOptions.series.lines.show).to.be(!0),c.expect(a.plotOptions.series.dashes.lineWidth).to.be(2),c.expect(a.plotOptions.series.dashes.show).to.be(!0)})}),a("should use timeStep for barWidth",function(a){a.setup(function(a,b){a.panel.bars=!0,b[0]=new g.default({datapoints:[[1,10],[2,20]],alias:"series1"})}),c.it("should set barWidth",function(){c.expect(a.plotOptions.series.bars.barWidth).to.be(1/1.5)})}),a("series option overrides, fill & points",function(a){a.setup(function(a,b){a.panel.lines=!0,a.panel.fill=5,b[0].zindex=10,b[1].alias="test",b[1].lines={fill:.001},b[1].points={show:!0}}),c.it("should match second series and fill zero, and enable points",function(){c.expect(a.plotOptions.series.lines.fill).to.be(.5),c.expect(a.plotData[1].lines.fill).to.be(.001),c.expect(a.plotData[1].points.show).to.be(!0)})}),a("should order series order according to zindex",function(a){a.setup(function(a,b){b[1].zindex=1,b[0].zindex=10}),c.it("should move zindex 2 last",function(){c.expect(a.plotData[0].alias).to.be("series2"),c.expect(a.plotData[1].alias).to.be("series1")})}),a("when series is hidden",function(a){a.setup(function(a){a.hiddenSeries={series2:!0}}),c.it("should remove datapoints and disable stack",function(){c.expect(a.plotData[0].alias).to.be("series1"),c.expect(a.plotData[1].data.length).to.be(0),c.expect(a.plotData[1].stack).to.be(!1)})}),a("when stack and percent",function(a){a.setup(function(a){a.panel.percentage=!0,a.panel.stack=!0}),c.it("should show percentage",function(){var b=a.plotOptions.yaxes[0];c.expect(b.tickFormatter(100,b)).to.be("100%")})}),a("when panel too narrow to show x-axis dates in same granularity as wide panels",function(a){c.describe("and the range is less than 24 hours",function(){a.setup(function(a){a.range.from=h.default([2015,1,1,10]),a.range.to=h.default([2015,1,1,22])}),c.it("should format dates as hours minutes",function(){var b=a.plotOptions.xaxis;c.expect(b.timeformat).to.be("%H:%M")})}),c.describe("and the range is less than one year",function(){a.setup(function(a){a.range.from=h.default([2015,1,1]),a.range.to=h.default([2015,11,20])}),c.it("should format dates as month days",function(){var b=a.plotOptions.xaxis;c.expect(b.timeformat).to.be("%m/%d")})})},10)})}}});