/*! grafana - v4.5.0 - 2017-09-14
 * Copyright (c) 2017 Torkel Ödegaard; Licensed Apache-2.0 */

System.register(["lodash","../../../../../test/lib/common","app/core/time_series2","../heatmap_data_converter"],function(a,b){"use strict";function c(a,b,c){return void 0===c&&(c=1e-6),a===b||Math.abs(1-a/b)<=c}var d,e,f,g;b&&b.id;return{setters:[function(a){d=a},function(a){e=a},function(a){f=a},function(a){g=a}],execute:function(){e.describe("isHeatmapDataEqual",function(){var a={};e.beforeEach(function(){a.heatmapA={1422774000000:{x:1422774e6,buckets:{1:{y:1,values:[1,1.5]},2:{y:2,values:[1]}}}},a.heatmapB={1422774000000:{x:1422774e6,buckets:{1:{y:1,values:[1.5,1]},2:{y:2,values:[1]}}}}}),e.it("should proper compare objects",function(){var b=d.default.cloneDeep(a.heatmapA);b[1422774e6].buckets[1].values=[1,1.5];var c=d.default.cloneDeep(a.heatmapA);c[1422774e6].buckets[1].values=[1.5,1,1.6];var f=d.default.cloneDeep(a.heatmapA);f[1422774e6].buckets[1].values=[1,1.6];var h={},i=d.default.cloneDeep(a.heatmapA);i[1422774e6].buckets[1].values=[],e.expect(g.isHeatmapDataEqual(a.heatmapA,a.heatmapB)).to.be(!0),e.expect(g.isHeatmapDataEqual(a.heatmapB,a.heatmapA)).to.be(!0),e.expect(g.isHeatmapDataEqual(a.heatmapA,b)).to.be(!0),e.expect(g.isHeatmapDataEqual(b,a.heatmapA)).to.be(!0),e.expect(g.isHeatmapDataEqual(a.heatmapA,c)).to.be(!1),e.expect(g.isHeatmapDataEqual(c,a.heatmapA)).to.be(!1),e.expect(g.isHeatmapDataEqual(a.heatmapA,f)).to.be(!1),e.expect(g.isHeatmapDataEqual(f,a.heatmapA)).to.be(!1),e.expect(g.isHeatmapDataEqual(h,a.heatmapA)).to.be(!1),e.expect(g.isHeatmapDataEqual(a.heatmapA,h)).to.be(!1),e.expect(g.isHeatmapDataEqual(i,a.heatmapA)).to.be(!1),e.expect(g.isHeatmapDataEqual(a.heatmapA,i)).to.be(!1)})}),e.describe("calculateBucketSize",function(){var a={};e.describe("when logBase is 1 (linear scale)",function(){e.beforeEach(function(){a.logBase=1,a.bounds_set=[{bounds:[],size:0},{bounds:[0],size:0},{bounds:[4],size:4},{bounds:[0,1,2,3,4],size:1},{bounds:[0,1,3,5,7],size:1},{bounds:[0,3,7,9,15],size:2},{bounds:[0,7,3,15,9],size:2},{bounds:[0,5,10,15,50],size:5}]}),e.it("should properly calculate bucket size",function(){d.default.each(a.bounds_set,function(b){var c=g.calculateBucketSize(b.bounds,a.logBase);e.expect(c).to.be(b.size)})})}),e.describe("when logBase is 2",function(){e.beforeEach(function(){a.logBase=2,a.bounds_set=[{bounds:[],size:0},{bounds:[0],size:0},{bounds:[4],size:4},{bounds:[1,2,4,8],size:1},{bounds:[1,Math.SQRT2,2,8,16],size:.5}]}),e.it("should properly calculate bucket size",function(){d.default.each(a.bounds_set,function(b){var d=g.calculateBucketSize(b.bounds,a.logBase);e.expect(c(d,b.size)).to.be(!0)})})})}),e.describe("HeatmapDataConverter",function(){var a={};e.beforeEach(function(){a.series=[],a.series.push(new f.default({datapoints:[[1,1422774e6],[1,1422774000010],[2,142277406e4]],alias:"series1"})),a.series.push(new f.default({datapoints:[[2,1422774e6],[2,1422774000010],[3,142277406e4]],alias:"series2"})),a.series.push(new f.default({datapoints:[[5,1422774e6],[3,1422774000010],[4,142277406e4]],alias:"series3"})),a.xBucketSize=6e4,a.yBucketSize=2,a.logBase=1}),e.describe("when logBase is 1 (linear scale)",function(){e.beforeEach(function(){a.logBase=1}),e.it("should build proper heatmap data",function(){var b={1422774000000:{x:1422774e6,buckets:{0:{y:0,values:[1,1],count:2,bounds:{bottom:0,top:2}},2:{y:2,values:[2,2,3],count:3,bounds:{bottom:2,top:4}},4:{y:4,values:[5],count:1,bounds:{bottom:4,top:6}}}},1422774060000:{x:142277406e4,buckets:{2:{y:2,values:[2,3],count:3,bounds:{bottom:2,top:4}},4:{y:4,values:[4],count:1,bounds:{bottom:4,top:6}}}}},c=g.convertToHeatMap(a.series,a.yBucketSize,a.xBucketSize,a.logBase);e.expect(g.isHeatmapDataEqual(c,b)).to.be(!0)})}),e.describe.skip("when logBase is 2",function(){e.beforeEach(function(){a.logBase=2}),e.it("should build proper heatmap data",function(){var b={1422774000000:{x:1422774e6,buckets:{1:{y:1,values:[1]},2:{y:2,values:[2]}}},1422774060000:{x:142277406e4,buckets:{2:{y:2,values:[2,3]}}}},c=g.convertToHeatMap(a.series,a.yBucketSize,a.xBucketSize,a.logBase);e.expect(g.isHeatmapDataEqual(c,b)).to.be(!0)})})}),e.describe("ES Histogram converter",function(){var a={};e.beforeEach(function(){a.series=[],a.series.push(new f.default({datapoints:[[1,1422774e6],[0,142277406e4]],alias:"1",label:"1"})),a.series.push(new f.default({datapoints:[[5,1422774e6],[3,142277406e4]],alias:"2",label:"2"})),a.series.push(new f.default({datapoints:[[0,1422774e6],[1,142277406e4]],alias:"3",label:"3"}))}),e.describe("when converting ES histogram",function(){e.beforeEach(function(){}),e.it("should build proper heatmap data",function(){var b={1422774000000:{x:1422774e6,buckets:{1:{y:1,count:1,values:[],points:[]},2:{y:2,count:5,values:[],points:[]},3:{y:3,count:0,values:[],points:[]}}},1422774060000:{x:142277406e4,buckets:{1:{y:1,count:0,values:[],points:[]},2:{y:2,count:3,values:[],points:[]},3:{y:3,count:1,values:[],points:[]}}}},c=g.elasticHistogramToHeatmap(a.series);e.expect(c).to.eql(b)})})}),e.describe("convertToCards",function(){var a={};e.beforeEach(function(){a={1422774000000:{x:1422774e6,buckets:{1:{y:1,values:[1],count:1,bounds:{}},2:{y:2,values:[2],count:1,bounds:{}}}},1422774060000:{x:142277406e4,buckets:{2:{y:2,values:[2,3],count:2,bounds:{}}}}}}),e.it("should build proper cards data",function(){var b=[{x:1422774e6,y:1,count:1,values:[1],yBounds:{}},{x:1422774e6,y:2,count:1,values:[2],yBounds:{}},{x:142277406e4,y:2,count:2,values:[2,3],yBounds:{}}],c=g.convertToCards(a),d=c.cards;c.cardStats;e.expect(d).to.eql(b)}),e.it("should build proper cards stats",function(){var b={min:1,max:2},c=g.convertToCards(a),d=(c.cards,c.cardStats);e.expect(d).to.eql(b)})})}}});