/*! grafana - v4.5.0 - 2017-09-14
 * Copyright (c) 2017 Torkel Ödegaard; Licensed Apache-2.0 */

System.register(["test/lib/common","lodash","app/core/table_model","../renderer"],function(a,b){"use strict";function c(a){return a.replace(/\s+/gm," ").trim()}var d,e,f,g;b&&b.id;return{setters:[function(a){d=a},function(a){e=a},function(a){f=a},function(a){g=a}],execute:function(){d.describe("when rendering table",function(){d.describe("given 2 columns",function(){var a=new f.default;a.columns=[{text:"Time"},{text:"Value"},{text:"Colored"},{text:"Undefined"},{text:"String"},{text:"United",unit:"bps"},{text:"Sanitized"},{text:"Link"}],a.rows=[[1388556366666,1230,40,void 0,"","","my.host.com","host1"]];var b={pageSize:10,styles:[{pattern:"Time",type:"date",format:"LLL",alias:"Timestamp"},{pattern:"/(Val)ue/",type:"number",unit:"ms",decimals:3,alias:"$1"},{pattern:"Colored",type:"number",unit:"none",decimals:1,colorMode:"value",thresholds:[50,80],colors:["green","orange","red"]},{pattern:"String",type:"string"},{pattern:"United",type:"number",unit:"ms",decimals:2},{pattern:"Sanitized",type:"string",sanitize:!0},{pattern:"Link",type:"string",link:!0,linkUrl:"/dashboard?param=$__cell&param_1=$__cell_1&param_2=$__cell_2",linkTooltip:"$__cell $__cell_1 $__cell_6",linkTargetBlank:!0}]},h=function(a){return"sanitized"},i={replace:function(a,b){return b&&e.default.each(b,function(b,c){a=a.replace("$"+c,b.value)}),a}},j=new g.TableRenderer(b,a,"utc",h,i);d.it("time column should be formated",function(){var a=j.renderCell(0,0,1388556366666);d.expect(a).to.be("<td>2014-01-01T06:06:06Z</td>")}),d.it("undefined time column should be rendered as -",function(){var a=j.renderCell(0,0,void 0);d.expect(a).to.be("<td>-</td>")}),d.it("null time column should be rendered as -",function(){var a=j.renderCell(0,0,null);d.expect(a).to.be("<td>-</td>")}),d.it("number column with unit specified should ignore style unit",function(){var a=j.renderCell(5,0,1230);d.expect(a).to.be("<td>1.23 kbps</td>")}),d.it("number column should be formated",function(){var a=j.renderCell(1,0,1230);d.expect(a).to.be("<td>1.230 s</td>")}),d.it("number style should ignore string values",function(){var a=j.renderCell(1,0,"asd");d.expect(a).to.be("<td>asd</td>")}),d.it("colored cell should have style",function(){var a=j.renderCell(2,0,40);d.expect(a).to.be('<td style="color:green">40.0</td>')}),d.it("colored cell should have style",function(){var a=j.renderCell(2,0,55);d.expect(a).to.be('<td style="color:orange">55.0</td>')}),d.it("colored cell should have style",function(){var a=j.renderCell(2,0,85);d.expect(a).to.be('<td style="color:red">85.0</td>')}),d.it("unformated undefined should be rendered as string",function(){var a=j.renderCell(3,0,"value");d.expect(a).to.be("<td>value</td>")}),d.it("string style with escape html should return escaped html",function(){var a=j.renderCell(4,0,"&breaking <br /> the <br /> row");d.expect(a).to.be("<td>&amp;breaking &lt;br /&gt; the &lt;br /&gt; row</td>")}),d.it("undefined formater should return escaped html",function(){var a=j.renderCell(3,0,"&breaking <br /> the <br /> row");d.expect(a).to.be("<td>&amp;breaking &lt;br /&gt; the &lt;br /&gt; row</td>")}),d.it("undefined value should render as -",function(){var a=j.renderCell(3,0,void 0);d.expect(a).to.be("<td></td>")}),d.it("sanitized value should render as",function(){var a=j.renderCell(6,0,'text <a href="http://google.com">link</a>');d.expect(a).to.be("<td>sanitized</td>")}),d.it("Time column title should be Timestamp",function(){d.expect(a.columns[0].title).to.be("Timestamp")}),d.it("Value column title should be Val",function(){d.expect(a.columns[1].title).to.be("Val")}),d.it("Colored column title should be Colored",function(){d.expect(a.columns[2].title).to.be("Colored")}),d.it("link should render as",function(){var a=j.renderCell(7,0,"host1"),b='\n        <td class="table-panel-cell-link">\n          <a href="/dashboard?param=host1&param_1=1230&param_2=40"\n            target="_blank" data-link-tooltip data-original-title="host1 1230 my.host.com" data-placement="right">\n            host1\n          </a>\n        </td>\n      ';d.expect(c(a)).to.be(c(b))})})})}}});