/*! grafana - v4.5.0 - 2017-09-14
 * Copyright (c) 2017 Torkel Ödegaard; Licensed Apache-2.0 */

System.register(["test/lib/common","../transformers"],function(a,b){"use strict";var c,d;b&&b.id;return{setters:[function(a){c=a},function(a){d=a}],execute:function(){c.describe("when transforming time series table",function(){var a;c.describe("given 2 time series",function(){var b=(new Date).getTime(),e=[{target:"series1",datapoints:[[12.12,b],[14.44,b+1]]},{target:"series2",datapoints:[[16.12,b]]}];c.describe("timeseries_to_rows",function(){var b={transform:"timeseries_to_rows",sort:{col:0,desc:!0}};c.beforeEach(function(){a=d.transformDataToTable(e,b)}),c.it("should return 3 rows",function(){c.expect(a.rows.length).to.be(3),c.expect(a.rows[0][1]).to.be("series1"),c.expect(a.rows[1][1]).to.be("series1"),c.expect(a.rows[2][1]).to.be("series2"),c.expect(a.rows[0][2]).to.be(12.12)}),c.it("should return 3 rows",function(){c.expect(a.columns.length).to.be(3),c.expect(a.columns[0].text).to.be("Time"),c.expect(a.columns[1].text).to.be("Metric"),c.expect(a.columns[2].text).to.be("Value")})}),c.describe("timeseries_to_columns",function(){var b={transform:"timeseries_to_columns"};c.beforeEach(function(){a=d.transformDataToTable(e,b)}),c.it("should return 3 columns",function(){c.expect(a.columns.length).to.be(3),c.expect(a.columns[0].text).to.be("Time"),c.expect(a.columns[1].text).to.be("series1"),c.expect(a.columns[2].text).to.be("series2")}),c.it("should return 2 rows",function(){c.expect(a.rows.length).to.be(2),c.expect(a.rows[0][1]).to.be(12.12),c.expect(a.rows[0][2]).to.be(16.12)}),c.it("should be undefined when no value for timestamp",function(){c.expect(a.rows[1][2]).to.be(void 0)})}),c.describe("timeseries_aggregations",function(){var b={transform:"timeseries_aggregations",sort:{col:0,desc:!0},columns:[{text:"Max",value:"max"},{text:"Min",value:"min"}]};c.beforeEach(function(){a=d.transformDataToTable(e,b)}),c.it("should return 2 rows",function(){c.expect(a.rows.length).to.be(2),c.expect(a.rows[0][0]).to.be("series1"),c.expect(a.rows[0][1]).to.be(14.44),c.expect(a.rows[0][2]).to.be(12.12)}),c.it("should return 2 columns",function(){c.expect(a.columns.length).to.be(3),c.expect(a.columns[0].text).to.be("Metric"),c.expect(a.columns[1].text).to.be("Max"),c.expect(a.columns[2].text).to.be("Min")})}),c.describe("JSON Data",function(){var b={transform:"json",columns:[{text:"Timestamp",value:"timestamp"},{text:"Message",value:"message"},{text:"nested.level2",value:"nested.level2"}]},e=[{type:"docs",datapoints:[{timestamp:"time",message:"message",nested:{level2:"level2-value"}}]}];c.describe("getColumns",function(){c.it("should return nested properties",function(){var a=d.transformers.json.getColumns(e);c.expect(a[0].text).to.be("timestamp"),c.expect(a[1].text).to.be("message"),c.expect(a[2].text).to.be("nested.level2")})}),c.describe("transform",function(){c.beforeEach(function(){a=d.transformDataToTable(e,b)}),c.it("should return 2 columns",function(){c.expect(a.columns.length).to.be(3),c.expect(a.columns[0].text).to.be("Timestamp"),c.expect(a.columns[1].text).to.be("Message"),c.expect(a.columns[2].text).to.be("nested.level2")}),c.it("should return 2 rows",function(){c.expect(a.rows.length).to.be(1),c.expect(a.rows[0][0]).to.be("time"),c.expect(a.rows[0][1]).to.be("message"),c.expect(a.rows[0][2]).to.be("level2-value")})})}),c.describe("Annnotations",function(){var b={transform:"annotations"},e={annotations:[{min:1e3,text:"hej",tags:["tags","asd"],title:"title"}]};c.beforeEach(function(){a=d.transformDataToTable(e,b)}),c.it("should return 4 columns",function(){c.expect(a.columns.length).to.be(4),c.expect(a.columns[0].text).to.be("Time"),c.expect(a.columns[1].text).to.be("Title"),c.expect(a.columns[2].text).to.be("Text"),c.expect(a.columns[3].text).to.be("Tags")}),c.it("should return 1 rows",function(){c.expect(a.rows.length).to.be(1),c.expect(a.rows[0][0]).to.be(1e3)})})})})}}});