/*! grafana - v4.5.0 - 2017-09-14
 * Copyright (c) 2017 Torkel Ödegaard; Licensed Apache-2.0 */

define(["app/core/utils/kbn","app/core/utils/datemath"],function(a,b){"use strict";function c(b,c,d,e,f){describe("value format: "+b,function(){it("should translate "+c+" as "+f,function(){var g=e-Math.floor(Math.log(d)/Math.LN10),h=a.valueFormats[b](c,e,g);expect(h).to.be(f)})})}describe("unit format menu",function(){var b=a.getUnitFormats();b.map(function(b){describe("submenu "+b.text,function(){it("should have a title",function(){expect(b.text).to.be.a("string")}),it("should have a submenu",function(){expect(b.submenu).to.be.an("array")}),b.submenu.map(function(b){describe("entry "+b.text,function(){it("should have a title",function(){expect(b.text).to.be.a("string")}),it("should have a format",function(){expect(b.value).to.be.a("string")}),it("should have a valid format",function(){expect(a.valueFormats[b.value]).to.be.a("function")})})})})})}),c("ms",.0024,5e-4,4,"0.0024 ms"),c("ms",100,1,0,"100 ms"),c("ms",1250,10,0,"1.25 s"),c("ms",1250,300,0,"1.3 s"),c("ms",65150,1e4,0,"1.1 min"),c("ms",6515e3,15e5,0,"1.8 hour"),c("ms",6515e5,15e7,0,"8 day"),c("none",2.75e-10,0,10,"3e-10"),c("none",0,0,2,"0"),c("dB",10,1e3,2,"10.00 dB"),c("percent",0,0,0,"0%"),c("percent",53,0,1,"53.0%"),c("percentunit",0,0,0,"0%"),c("percentunit",.278,0,1,"27.8%"),c("percentunit",1,0,0,"100%"),c("currencyUSD",7.42,1e4,2,"$7.42"),c("currencyUSD",1532.82,1e3,1,"$1.53K"),c("currencyUSD",18520408.7,1e7,0,"$19M"),c("bytes",-1.57e308,-1.57e308,2,"NA"),c("ns",25,1,0,"25 ns"),c("ns",2558,50,0,"2.56 µs"),c("ops",123,1,0,"123 ops"),c("rps",456e3,1e3,-1,"456K rps"),c("rps",123456789,1e6,2,"123.457M rps"),c("wps",789e6,1e6,-1,"789M wps"),c("iops",11e9,1e9,-1,"11B iops"),c("s",1.23456789e-7,1e-10,8,"123.5 ns"),c("s",.000123456789,1e-7,5,"123.5 µs"),c("s",.00123456789,1e-6,4,"1.235 ms"),c("s",.0123456789,1e-5,3,"12.35 ms"),c("s",.123456789,1e-4,2,"123.5 ms"),c("s",24,1,0,"24 s"),c("s",246,1,0,"4.1 min"),c("s",24567,100,0,"6.82 hour"),c("s",24567890,1e4,0,"40.62 week"),c("s",2456789e4,1e6,0,"778.53 year"),c("m",24,1,0,"24 min"),c("m",246,10,0,"4.1 hour"),c("m",6545,10,0,"4.55 day"),c("m",24567,100,0,"2.44 week"),c("m",24567892,1e4,0,"46.7 year"),c("h",21,1,0,"21 hour"),c("h",145,1,0,"6.04 day"),c("h",1234,100,0,"7.3 week"),c("h",9458,1e3,0,"1.08 year"),c("d",3,1,0,"3 day"),c("d",245,100,0,"35 week"),c("d",2456,10,0,"6.73 year"),describe("kbn.toFixed and negative decimals",function(){it("should treat as zero decimals",function(){var b=a.toFixed(186.123,-2);expect(b).to.be("186")})}),describe("kbn ms format when scaled decimals is null do not use it",function(){it("should use specified decimals",function(){var b=a.valueFormats.ms(10000086.123,1,null);expect(b).to.be("2.8 hour")})}),describe("kbn kbytes format when scaled decimals is null do not use it",function(){it("should use specified decimals",function(){var b=a.valueFormats.kbytes(1e7,3,null);expect(b).to.be("9.537 GiB")})}),describe("kbn deckbytes format when scaled decimals is null do not use it",function(){it("should use specified decimals",function(){var b=a.valueFormats.deckbytes(1e7,3,null);expect(b).to.be("10.000 GB")})}),describe("kbn roundValue",function(){it("should should handle null value",function(){var b=a.roundValue(null,2);expect(b).to.be(null)})}),describe("calculateInterval",function(){it("1h 100 resultion",function(){var c={from:b.parse("now-1h"),to:b.parse("now")},d=a.calculateInterval(c,100,null);expect(d.interval).to.be("30s")}),it("10m 1600 resolution",function(){var c={from:b.parse("now-10m"),to:b.parse("now")},d=a.calculateInterval(c,1600,null);expect(d.interval).to.be("500ms"),expect(d.intervalMs).to.be(500)}),it("fixed user min interval",function(){var c={from:b.parse("now-10m"),to:b.parse("now")},d=a.calculateInterval(c,1600,"10s");expect(d.interval).to.be("10s"),expect(d.intervalMs).to.be(1e4)}),it("short time range and user low limit",function(){var c={from:b.parse("now-10m"),to:b.parse("now")},d=a.calculateInterval(c,1600,">10s");expect(d.interval).to.be("10s")}),it("large time range and user low limit",function(){var c={from:b.parse("now-14d"),to:b.parse("now")},d=a.calculateInterval(c,1e3,">10s");expect(d.interval).to.be("20m")}),it("10s 900 resolution and user low limit in ms",function(){var c={from:b.parse("now-10s"),to:b.parse("now")},d=a.calculateInterval(c,900,">15ms");expect(d.interval).to.be("15ms")}),it("1d 1 resolution",function(){var c={from:b.parse("now-1d"),to:b.parse("now")},d=a.calculateInterval(c,1,null);expect(d.interval).to.be("1d"),expect(d.intervalMs).to.be(864e5)}),it("86399s 1 resolution",function(){var c={from:b.parse("now-86390s"),to:b.parse("now")},d=a.calculateInterval(c,1,null);expect(d.interval).to.be("12h"),expect(d.intervalMs).to.be(432e5)})}),describe("hex",function(){it("positive integer",function(){var b=a.valueFormats.hex(100,0);expect(b).to.be("64")}),it("negative integer",function(){var b=a.valueFormats.hex(-100,0);expect(b).to.be("-64")}),it("null",function(){var b=a.valueFormats.hex(null,0);expect(b).to.be("")}),it("positive float",function(){var b=a.valueFormats.hex(50.52,1);expect(b).to.be("32.8")}),it("negative float",function(){var b=a.valueFormats.hex(-50.333,2);expect(b).to.be("-32.547AE147AE14")})}),describe("hex 0x",function(){it("positive integeter",function(){var b=a.valueFormats.hex0x(7999,0);expect(b).to.be("0x1F3F")}),it("negative integer",function(){var b=a.valueFormats.hex0x(-584,0);expect(b).to.be("-0x248")}),it("null",function(){var b=a.valueFormats.hex0x(null,0);expect(b).to.be("")}),it("positive float",function(){var b=a.valueFormats.hex0x(74.443,3);expect(b).to.be("0x4A.716872B020C4")}),it("negative float",function(){var b=a.valueFormats.hex0x(-65.458,1);expect(b).to.be("-0x41.8")})}),describe("duration",function(){it("null",function(){var b=a.toDuration(null,0,"millisecond");expect(b).to.be("")}),it("0 milliseconds",function(){var b=a.toDuration(0,0,"millisecond");expect(b).to.be("0 milliseconds")}),it("1 millisecond",function(){var b=a.toDuration(1,0,"millisecond");expect(b).to.be("1 millisecond")}),it("-1 millisecond",function(){var b=a.toDuration(-1,0,"millisecond");expect(b).to.be("1 millisecond ago")}),it("seconds",function(){var b=a.toDuration(1,0,"second");expect(b).to.be("1 second")}),it("minutes",function(){var b=a.toDuration(1,0,"minute");expect(b).to.be("1 minute")}),it("hours",function(){var b=a.toDuration(1,0,"hour");expect(b).to.be("1 hour")}),it("days",function(){var b=a.toDuration(1,0,"day");expect(b).to.be("1 day")}),it("weeks",function(){var b=a.toDuration(1,0,"week");expect(b).to.be("1 week")}),it("months",function(){var b=a.toDuration(1,0,"month");expect(b).to.be("1 month")}),it("years",function(){var b=a.toDuration(1,0,"year");expect(b).to.be("1 year")}),it("decimal days",function(){var b=a.toDuration(1.5,2,"day");expect(b).to.be("1 day, 12 hours, 0 minutes")}),it("decimal months",function(){var b=a.toDuration(1.5,3,"month");expect(b).to.be("1 month, 2 weeks, 1 day, 0 hours")}),it("no decimals",function(){var b=a.toDuration(38898367008,0,"millisecond");expect(b).to.be("1 year")}),it("1 decimal",function(){var b=a.toDuration(38898367008,1,"millisecond");expect(b).to.be("1 year, 2 months")}),it("too many decimals",function(){var b=a.toDuration(38898367008,20,"millisecond");expect(b).to.be("1 year, 2 months, 3 weeks, 4 days, 5 hours, 6 minutes, 7 seconds, 8 milliseconds")}),it("floating point error",function(){var b=a.toDuration(36993906007,8,"millisecond");expect(b).to.be("1 year, 2 months, 0 weeks, 3 days, 4 hours, 5 minutes, 6 seconds, 7 milliseconds")})})});