/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.time.Duration;
import org.apache.kafka.streams.AutoOffsetReset;
import org.apache.kafka.streams.internals.AutoOffsetResetInternal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AutoOffsetResetTest {
    AutoOffsetResetTest() {
    }

    @Test
    void shouldThrowExceptionOnDurationForNoneReset() {
        AutoOffsetResetInternal none = new AutoOffsetResetInternal(AutoOffsetReset.none());
        Assertions.assertThrows(IllegalStateException.class, () -> ((AutoOffsetResetInternal)none).duration(), (String)"None should not have a duration.");
    }

    @Test
    void shouldThrowExceptionOnDurationForEarliestReset() {
        AutoOffsetResetInternal earliest = new AutoOffsetResetInternal(AutoOffsetReset.earliest());
        Assertions.assertThrows(IllegalStateException.class, () -> ((AutoOffsetResetInternal)earliest).duration(), (String)"Earliest should not have a duration.");
    }

    @Test
    void shouldThrowExceptionOnDurationForLastetReset() {
        AutoOffsetResetInternal latest = new AutoOffsetResetInternal(AutoOffsetReset.latest());
        Assertions.assertThrows(IllegalStateException.class, () -> ((AutoOffsetResetInternal)latest).duration(), (String)"Latest should not have a duration.");
    }

    @Test
    void customDurationShouldMatchExpectedValue() {
        Duration duration = Duration.ofSeconds(10L);
        AutoOffsetResetInternal custom = new AutoOffsetResetInternal(AutoOffsetReset.byDuration((Duration)duration));
        Assertions.assertEquals((long)10L, (long)custom.duration().toSeconds(), (String)"Duration should match the specified value in milliseconds.");
    }

    @Test
    void shouldThrowExceptionIfDurationIsNegative() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AutoOffsetReset.byDuration((Duration)Duration.ofSeconds(-1L)), (String)"Creating an AutoOffsetReset with a negative duration should throw an IllegalArgumentException.");
        Assertions.assertEquals((Object)"Duration cannot be negative", (Object)exception.getMessage(), (String)"Exception message should indicate the duration cannot be negative.");
    }

    @Test
    void twoInstancesCreatedAtTheSameTimeWithSameOptionsShouldBeEqual() {
        AutoOffsetReset latest1 = AutoOffsetReset.latest();
        AutoOffsetReset latest2 = AutoOffsetReset.latest();
        AutoOffsetReset earliest1 = AutoOffsetReset.earliest();
        AutoOffsetReset earliest2 = AutoOffsetReset.earliest();
        AutoOffsetReset custom1 = AutoOffsetReset.byDuration((Duration)Duration.ofSeconds(5L));
        AutoOffsetReset custom2 = AutoOffsetReset.byDuration((Duration)Duration.ofSeconds(5L));
        AutoOffsetReset customDifferent = AutoOffsetReset.byDuration((Duration)Duration.ofSeconds(10L));
        Assertions.assertEquals((Object)latest1, (Object)latest2, (String)"Two latest instances should be equal.");
        Assertions.assertEquals((Object)earliest1, (Object)earliest2, (String)"Two earliest instances should be equal.");
        Assertions.assertEquals((Object)custom1, (Object)custom2, (String)"Two custom instances with the same duration should be equal.");
        Assertions.assertNotEquals((Object)latest1, (Object)earliest1, (String)"Latest and earliest should not be equal.");
        Assertions.assertNotEquals((Object)custom1, (Object)customDifferent, (String)"Custom instances with different durations should not be equal.");
        Assertions.assertEquals((int)latest1.hashCode(), (int)latest2.hashCode(), (String)"HashCode for equal instances should be the same.");
        Assertions.assertEquals((int)custom1.hashCode(), (int)custom2.hashCode(), (String)"HashCode for equal custom instances should be the same.");
        Assertions.assertNotEquals((int)custom1.hashCode(), (int)customDifferent.hashCode(), (String)"HashCode for different custom instances should not match.");
    }
}

