/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.LogCaptureAppender;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.ClientInstanceIds;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyQueryMetadata;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.errors.StreamsNotStartedException;
import org.apache.kafka.streams.errors.StreamsUncaughtExceptionHandler;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.errors.UnknownStateStoreException;
import org.apache.kafka.streams.internals.StreamsConfigUtils;
import org.apache.kafka.streams.internals.metrics.ClientMetrics;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.processor.StandbyUpdateListener;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.GlobalStreamThread;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StreamThread;
import org.apache.kafka.streams.processor.internals.StreamsMetadataState;
import org.apache.kafka.streams.processor.internals.ThreadStateTransitionValidator;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecordingTrigger;
import org.apache.kafka.streams.utils.TestUtils;
import org.apache.kafka.test.MockClientSupplier;
import org.apache.kafka.test.MockMetricsReporter;
import org.apache.kafka.test.MockProcessorSupplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.MockedConstruction;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@Timeout(value=600L)
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class KafkaStreamsTest {
    private static final int NUM_THREADS = 2;
    private static final String APPLICATION_ID = "appId-";
    private static final String CLIENT_ID = "test-client";
    private static final Duration DEFAULT_DURATION = Duration.ofSeconds(30L);
    private MockClientSupplier supplier;
    private MockTime time;
    private Properties props;
    private MockAdminClient adminClient;
    private StateListenerStub streamsStateListener;
    @Mock
    private StreamThread streamThreadOne;
    @Mock
    private StreamThread streamThreadTwo;
    @Captor
    private ArgumentCaptor<StreamThread.StateListener> threadStateListenerCapture;
    private MockedStatic<ClientMetrics> clientMetricsMockedStatic;
    private MockedStatic<StreamThread> streamThreadMockedStatic;
    private MockedStatic<StreamsConfigUtils> streamsConfigUtils;
    private MockedConstruction<GlobalStreamThread> globalStreamThreadMockedConstruction;
    private MockedConstruction<Metrics> metricsMockedConstruction;

    @BeforeEach
    public void before(TestInfo testInfo) throws Exception {
        this.time = new MockTime();
        this.supplier = new MockClientSupplier();
        this.supplier.setCluster(Cluster.bootstrap(Collections.singletonList(new InetSocketAddress("localhost", 9999))));
        this.adminClient = (MockAdminClient)this.supplier.getAdmin(null);
        this.streamsStateListener = new StateListenerStub();
        this.props = new Properties();
        this.props.put("application.id", APPLICATION_ID + TestUtils.safeUniqueTestName(testInfo));
        this.props.put("client.id", CLIENT_ID);
        this.props.put("bootstrap.servers", "localhost:2018");
        this.props.put("metric.reporters", MockMetricsReporter.class.getName());
        this.props.put("state.dir", org.apache.kafka.test.TestUtils.tempDirectory().getPath());
        this.props.put("num.stream.threads", (Object)2);
    }

    @AfterEach
    public void tearDown() {
        if (this.clientMetricsMockedStatic != null) {
            this.clientMetricsMockedStatic.close();
        }
        if (this.streamThreadMockedStatic != null) {
            this.streamThreadMockedStatic.close();
        }
        if (this.globalStreamThreadMockedConstruction != null) {
            this.globalStreamThreadMockedConstruction.close();
        }
        if (this.metricsMockedConstruction != null) {
            this.metricsMockedConstruction.close();
        }
        if (this.streamsConfigUtils != null) {
            this.streamsConfigUtils.close();
        }
        if (this.adminClient != null) {
            this.adminClient.close();
        }
        Mockito.reset((Object[])new StreamThread[]{this.streamThreadOne, this.streamThreadTwo});
    }

    private void prepareStreams() {
        this.metricsMockedConstruction = Mockito.mockConstruction(Metrics.class, (mock, context) -> {
            Assertions.assertEquals((int)4, (int)context.arguments().size());
            List reporters = (List)context.arguments().get(1);
            for (MetricsReporter reporter : reporters) {
                reporter.init(Collections.emptyList());
            }
            ((Metrics)Mockito.doAnswer(invocation -> {
                for (MetricsReporter reporter : reporters) {
                    reporter.close();
                }
                return null;
            }).when(mock)).close();
        });
        this.clientMetricsMockedStatic = Mockito.mockStatic(ClientMetrics.class);
        this.clientMetricsMockedStatic.when(ClientMetrics::version).thenReturn((Object)"1.56");
        this.clientMetricsMockedStatic.when(ClientMetrics::commitId).thenReturn((Object)"1a2b3c4d5e");
        ClientMetrics.addVersionMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any(StreamsMetricsImpl.class)));
        ClientMetrics.addCommitIdMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any(StreamsMetricsImpl.class)));
        ClientMetrics.addApplicationIdMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any(StreamsMetricsImpl.class)), (String)((String)Mockito.eq((Object)APPLICATION_ID)));
        ClientMetrics.addTopologyDescriptionMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any(StreamsMetricsImpl.class)), (Gauge)((Gauge)ArgumentMatchers.any()));
        ClientMetrics.addStateMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any(StreamsMetricsImpl.class)), (Gauge)((Gauge)ArgumentMatchers.any()));
        ClientMetrics.addNumAliveStreamThreadMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any(StreamsMetricsImpl.class)), (Gauge)((Gauge)ArgumentMatchers.any()));
        this.streamThreadMockedStatic = Mockito.mockStatic(StreamThread.class);
        this.streamThreadMockedStatic.when(() -> StreamThread.create((TopologyMetadata)((TopologyMetadata)ArgumentMatchers.any(TopologyMetadata.class)), (StreamsConfig)((StreamsConfig)ArgumentMatchers.any(StreamsConfig.class)), (KafkaClientSupplier)((KafkaClientSupplier)ArgumentMatchers.any(KafkaClientSupplier.class)), (Admin)((Admin)ArgumentMatchers.any(Admin.class)), (UUID)((UUID)ArgumentMatchers.any(UUID.class)), (String)((String)ArgumentMatchers.any(String.class)), (StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any(StreamsMetricsImpl.class)), (Time)((Time)ArgumentMatchers.any(Time.class)), (StreamsMetadataState)((StreamsMetadataState)ArgumentMatchers.any(StreamsMetadataState.class)), (long)Mockito.anyLong(), (StateDirectory)((StateDirectory)ArgumentMatchers.any(StateDirectory.class)), (StateRestoreListener)((StateRestoreListener)ArgumentMatchers.any(StateRestoreListener.class)), (StandbyUpdateListener)((StandbyUpdateListener)ArgumentMatchers.any(StandbyUpdateListener.class)), (int)Mockito.anyInt(), (Runnable)((Runnable)ArgumentMatchers.any(Runnable.class)), (BiConsumer)((BiConsumer)ArgumentMatchers.any()))).thenReturn((Object)this.streamThreadOne).thenReturn((Object)this.streamThreadTwo);
        this.streamsConfigUtils = Mockito.mockStatic(StreamsConfigUtils.class);
        this.streamsConfigUtils.when(() -> StreamsConfigUtils.processingMode((StreamsConfig)((StreamsConfig)ArgumentMatchers.any(StreamsConfig.class)))).thenReturn((Object)StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE);
        this.streamsConfigUtils.when(() -> StreamsConfigUtils.eosEnabled((StreamsConfig)((StreamsConfig)ArgumentMatchers.any(StreamsConfig.class)))).thenReturn((Object)false);
        this.streamsConfigUtils.when(() -> StreamsConfigUtils.totalCacheSize((StreamsConfig)((StreamsConfig)ArgumentMatchers.any(StreamsConfig.class)))).thenReturn((Object)0xA00000L);
        AtomicReference<GlobalStreamThread.State> globalThreadState = new AtomicReference<GlobalStreamThread.State>(GlobalStreamThread.State.CREATED);
        this.globalStreamThreadMockedConstruction = Mockito.mockConstruction(GlobalStreamThread.class, (mock, context) -> {
            Mockito.when((Object)mock.state()).thenAnswer(invocation -> globalThreadState.get());
            ((GlobalStreamThread)Mockito.doNothing().when(mock)).setStateListener((StreamThread.StateListener)this.threadStateListenerCapture.capture());
            ((GlobalStreamThread)Mockito.doAnswer(invocation -> {
                globalThreadState.set(GlobalStreamThread.State.RUNNING);
                ((StreamThread.StateListener)this.threadStateListenerCapture.getValue()).onChange((Thread)mock, (ThreadStateTransitionValidator)GlobalStreamThread.State.RUNNING, (ThreadStateTransitionValidator)GlobalStreamThread.State.CREATED);
                return null;
            }).when(mock)).start();
            ((GlobalStreamThread)Mockito.doAnswer(invocation -> {
                this.supplier.restoreConsumer.close();
                for (MockProducer<byte[], byte[]> producer : this.supplier.producers) {
                    producer.close();
                }
                globalThreadState.set(GlobalStreamThread.State.DEAD);
                ((StreamThread.StateListener)this.threadStateListenerCapture.getValue()).onChange((Thread)mock, (ThreadStateTransitionValidator)GlobalStreamThread.State.PENDING_SHUTDOWN, (ThreadStateTransitionValidator)GlobalStreamThread.State.RUNNING);
                ((StreamThread.StateListener)this.threadStateListenerCapture.getValue()).onChange((Thread)mock, (ThreadStateTransitionValidator)GlobalStreamThread.State.DEAD, (ThreadStateTransitionValidator)GlobalStreamThread.State.PENDING_SHUTDOWN);
                return null;
            }).when(mock)).shutdown();
            Mockito.when((Object)mock.stillRunning()).thenReturn((Object)(globalThreadState.get() == GlobalStreamThread.State.RUNNING ? 1 : 0));
        });
    }

    private AtomicReference<StreamThread.State> prepareStreamThread(StreamThread thread, int threadId) {
        Mockito.when((Object)thread.getId()).thenReturn((Object)threadId);
        AtomicReference<StreamThread.State> state = new AtomicReference<StreamThread.State>(StreamThread.State.CREATED);
        Mockito.when((Object)thread.state()).thenAnswer(invocation -> state.get());
        ((StreamThread)Mockito.doNothing().when((Object)thread)).setStateListener((StreamThread.StateListener)this.threadStateListenerCapture.capture());
        Mockito.when((Object)thread.getName()).thenReturn((Object)("processId-StreamThread-" + threadId));
        return state;
    }

    private void prepareConsumer(StreamThread thread, AtomicReference<StreamThread.State> state) {
        ((StreamThread)Mockito.doAnswer(invocation -> {
            this.supplier.consumer.close();
            this.supplier.restoreConsumer.close();
            for (MockProducer<byte[], byte[]> producer : this.supplier.producers) {
                producer.close();
            }
            state.set(StreamThread.State.DEAD);
            ((StreamThread.StateListener)this.threadStateListenerCapture.getValue()).onChange((Thread)thread, (ThreadStateTransitionValidator)StreamThread.State.PENDING_SHUTDOWN, (ThreadStateTransitionValidator)StreamThread.State.RUNNING);
            ((StreamThread.StateListener)this.threadStateListenerCapture.getValue()).onChange((Thread)thread, (ThreadStateTransitionValidator)StreamThread.State.DEAD, (ThreadStateTransitionValidator)StreamThread.State.PENDING_SHUTDOWN);
            return null;
        }).when((Object)thread)).shutdown();
    }

    private void prepareThreadLock(StreamThread thread) {
        Mockito.when((Object)thread.getStateLock()).thenReturn(new Object());
    }

    private void prepareThreadState(StreamThread thread, AtomicReference<StreamThread.State> state) {
        ((StreamThread)Mockito.doAnswer(invocation -> {
            state.set(StreamThread.State.STARTING);
            ((StreamThread.StateListener)this.threadStateListenerCapture.getValue()).onChange((Thread)thread, (ThreadStateTransitionValidator)StreamThread.State.STARTING, (ThreadStateTransitionValidator)StreamThread.State.CREATED);
            ((StreamThread.StateListener)this.threadStateListenerCapture.getValue()).onChange((Thread)thread, (ThreadStateTransitionValidator)StreamThread.State.PARTITIONS_REVOKED, (ThreadStateTransitionValidator)StreamThread.State.STARTING);
            ((StreamThread.StateListener)this.threadStateListenerCapture.getValue()).onChange((Thread)thread, (ThreadStateTransitionValidator)StreamThread.State.PARTITIONS_ASSIGNED, (ThreadStateTransitionValidator)StreamThread.State.PARTITIONS_REVOKED);
            ((StreamThread.StateListener)this.threadStateListenerCapture.getValue()).onChange((Thread)thread, (ThreadStateTransitionValidator)StreamThread.State.RUNNING, (ThreadStateTransitionValidator)StreamThread.State.PARTITIONS_ASSIGNED);
            return null;
        }).when((Object)thread)).start();
    }

    private void prepareTerminableThread(StreamThread thread) throws InterruptedException {
        ((StreamThread)Mockito.doAnswer(invocation -> {
            Thread.sleep(2000L);
            return null;
        }).when((Object)thread)).join();
    }

    @Test
    public void testShouldTransitToNotRunningIfCloseRightAfterCreated() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.close();
            Assertions.assertEquals((Object)KafkaStreams.State.NOT_RUNNING, (Object)streams.state());
        }
    }

    @Test
    public void stateShouldTransitToRunningIfNonDeadThreadsBackToRunning() throws Exception {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.setStateListener((KafkaStreams.StateListener)this.streamsStateListener);
            Assertions.assertEquals((int)0, (int)this.streamsStateListener.numChanges);
            Assertions.assertEquals((Object)KafkaStreams.State.CREATED, (Object)streams.state());
            streams.start();
            org.apache.kafka.test.TestUtils.waitForCondition(() -> this.streamsStateListener.numChanges == 2, (String)"Streams never started.");
            Assertions.assertEquals((Object)KafkaStreams.State.RUNNING, (Object)streams.state());
            org.apache.kafka.test.TestUtils.waitForCondition(() -> this.streamsStateListener.numChanges == 2, (String)"Streams never started.");
            Assertions.assertEquals((Object)KafkaStreams.State.RUNNING, (Object)streams.state());
            for (StreamThread thread : streams.threads) {
                ((StreamThread.StateListener)this.threadStateListenerCapture.getValue()).onChange((Thread)thread, (ThreadStateTransitionValidator)StreamThread.State.PARTITIONS_REVOKED, (ThreadStateTransitionValidator)StreamThread.State.RUNNING);
            }
            Assertions.assertEquals((int)3, (int)this.streamsStateListener.numChanges);
            Assertions.assertEquals((Object)KafkaStreams.State.REBALANCING, (Object)streams.state());
            for (StreamThread thread : streams.threads) {
                ((StreamThread.StateListener)this.threadStateListenerCapture.getValue()).onChange((Thread)thread, (ThreadStateTransitionValidator)StreamThread.State.PARTITIONS_ASSIGNED, (ThreadStateTransitionValidator)StreamThread.State.PARTITIONS_REVOKED);
            }
            Assertions.assertEquals((int)3, (int)this.streamsStateListener.numChanges);
            Assertions.assertEquals((Object)KafkaStreams.State.REBALANCING, (Object)streams.state());
            ((StreamThread.StateListener)this.threadStateListenerCapture.getValue()).onChange((Thread)streams.threads.get(1), (ThreadStateTransitionValidator)StreamThread.State.PENDING_SHUTDOWN, (ThreadStateTransitionValidator)StreamThread.State.PARTITIONS_ASSIGNED);
            ((StreamThread.StateListener)this.threadStateListenerCapture.getValue()).onChange((Thread)streams.threads.get(1), (ThreadStateTransitionValidator)StreamThread.State.DEAD, (ThreadStateTransitionValidator)StreamThread.State.PENDING_SHUTDOWN);
            Assertions.assertEquals((int)3, (int)this.streamsStateListener.numChanges);
            Assertions.assertEquals((Object)KafkaStreams.State.REBALANCING, (Object)streams.state());
            for (StreamThread thread : streams.threads) {
                if (thread == streams.threads.get(1)) continue;
                ((StreamThread.StateListener)this.threadStateListenerCapture.getValue()).onChange((Thread)thread, (ThreadStateTransitionValidator)StreamThread.State.RUNNING, (ThreadStateTransitionValidator)StreamThread.State.PARTITIONS_ASSIGNED);
            }
            Assertions.assertEquals((int)4, (int)this.streamsStateListener.numChanges);
            Assertions.assertEquals((Object)KafkaStreams.State.RUNNING, (Object)streams.state());
            streams.close();
            org.apache.kafka.test.TestUtils.waitForCondition(() -> this.streamsStateListener.numChanges == 6, (String)"Streams never closed.");
            Assertions.assertEquals((Object)KafkaStreams.State.NOT_RUNNING, (Object)streams.state());
        }
    }

    @Test
    public void shouldCleanupResourcesOnCloseWithoutPreviousStart() throws Exception {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareConsumer(this.streamThreadOne, state1);
        this.prepareConsumer(this.streamThreadTwo, state2);
        StreamsBuilder builder = this.getBuilderWithSource();
        builder.globalTable("anyTopic");
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(KafkaStreams.class);
             KafkaStreams streams = new KafkaStreams(builder.build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.close();
            org.apache.kafka.test.TestUtils.waitForCondition(() -> streams.state() == KafkaStreams.State.NOT_RUNNING, (String)"Streams never stopped.");
            MatcherAssert.assertThat((Object)appender.getMessages(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Matcher)Matchers.containsString((String)"ERROR"))));
        }
        Assertions.assertTrue((boolean)this.supplier.consumer.closed());
        Assertions.assertTrue((boolean)this.supplier.restoreConsumer.closed());
        for (MockProducer<byte[], byte[]> p : this.supplier.producers) {
            Assertions.assertTrue((boolean)p.closed());
        }
    }

    @Test
    public void testStateThreadClose() throws Exception {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        this.prepareConsumer(this.streamThreadOne, state1);
        this.prepareConsumer(this.streamThreadTwo, state2);
        this.prepareThreadLock(this.streamThreadOne);
        this.prepareThreadLock(this.streamThreadTwo);
        StreamsBuilder builder = this.getBuilderWithSource();
        builder.globalTable("anyTopic");
        try (KafkaStreams streams = new KafkaStreams(builder.build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            Assertions.assertEquals((int)2, (int)streams.threads.size());
            Assertions.assertEquals((Object)streams.state(), (Object)KafkaStreams.State.CREATED);
            streams.start();
            org.apache.kafka.test.TestUtils.waitForCondition(() -> streams.state() == KafkaStreams.State.RUNNING, (String)"Streams never started.");
            for (int i = 0; i < 2; ++i) {
                StreamThread tmpThread = (StreamThread)streams.threads.get(i);
                tmpThread.shutdown();
                org.apache.kafka.test.TestUtils.waitForCondition(() -> tmpThread.state() == StreamThread.State.DEAD, (String)"Thread never stopped.");
                ((StreamThread)streams.threads.get(i)).join();
            }
            org.apache.kafka.test.TestUtils.waitForCondition(() -> streams.metadataForLocalThreads().stream().allMatch(t -> t.threadState().equals("DEAD")), (String)"Streams never stopped");
            streams.close();
            org.apache.kafka.test.TestUtils.waitForCondition(() -> streams.state() == KafkaStreams.State.NOT_RUNNING, (String)"Streams never stopped.");
            Assertions.assertNull((Object)streams.globalStreamThread);
        }
    }

    @Test
    public void testStateGlobalThreadClose() throws Exception {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        StreamsBuilder builder = this.getBuilderWithSource();
        builder.globalTable("anyTopic");
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(KafkaStreams.class);
             KafkaStreams streams = new KafkaStreams(builder.build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            org.apache.kafka.test.TestUtils.waitForCondition(() -> streams.state() == KafkaStreams.State.RUNNING, (String)"Streams never started.");
            GlobalStreamThread globalStreamThread = streams.globalStreamThread;
            globalStreamThread.shutdown();
            org.apache.kafka.test.TestUtils.waitForCondition(() -> globalStreamThread.state() == GlobalStreamThread.State.DEAD, (String)"Thread never stopped.");
            org.apache.kafka.test.TestUtils.waitForCondition(() -> streams.state() == KafkaStreams.State.ERROR, (String)"Thread never stopped.");
            streams.close();
            Assertions.assertEquals((Object)streams.state(), (Object)KafkaStreams.State.ERROR, (String)"KafkaStreams should remain in ERROR state after close.");
            MatcherAssert.assertThat((Object)appender.getMessages(), (Matcher)CoreMatchers.hasItem((Matcher)Matchers.containsString((String)"State transition from RUNNING to PENDING_ERROR")));
            MatcherAssert.assertThat((Object)appender.getMessages(), (Matcher)CoreMatchers.hasItem((Matcher)Matchers.containsString((String)"State transition from PENDING_ERROR to ERROR")));
            MatcherAssert.assertThat((Object)appender.getMessages(), (Matcher)CoreMatchers.hasItem((Matcher)Matchers.containsString((String)"Streams client is already in the terminal ERROR state")));
        }
    }

    @Test
    public void testInitializesAndDestroysMetricsReporters() {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        int oldInitCount = MockMetricsReporter.INIT_COUNT.get();
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            int newInitCount = MockMetricsReporter.INIT_COUNT.get();
            int initDiff = newInitCount - oldInitCount;
            Assertions.assertEquals((int)1, (int)initDiff, (String)"some reporters including MockMetricsReporter should be initialized by calling on construction");
            streams.start();
            int oldCloseCount = MockMetricsReporter.CLOSE_COUNT.get();
            streams.close();
            Assertions.assertEquals((Object)streams.state(), (Object)KafkaStreams.State.NOT_RUNNING);
            Assertions.assertEquals((int)(oldCloseCount + initDiff), (int)MockMetricsReporter.CLOSE_COUNT.get());
        }
    }

    @Test
    public void testCloseIsIdempotent() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.close();
            int closeCount = MockMetricsReporter.CLOSE_COUNT.get();
            streams.close();
            Assertions.assertEquals((int)closeCount, (int)MockMetricsReporter.CLOSE_COUNT.get(), (String)"subsequent close() calls should do nothing");
        }
    }

    @Test
    public void testPauseResume() {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            streams.pause();
            Assertions.assertTrue((boolean)streams.isPaused());
            streams.resume();
            Assertions.assertFalse((boolean)streams.isPaused());
        }
    }

    @Test
    public void testStartingPaused() {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.pause();
            streams.start();
            Assertions.assertTrue((boolean)streams.isPaused());
            streams.resume();
            Assertions.assertFalse((boolean)streams.isPaused());
        }
    }

    @Test
    public void testShowPauseResumeAreIdempotent() {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            streams.pause();
            Assertions.assertTrue((boolean)streams.isPaused());
            streams.pause();
            Assertions.assertTrue((boolean)streams.isPaused());
            streams.resume();
            Assertions.assertFalse((boolean)streams.isPaused());
            streams.resume();
            Assertions.assertFalse((boolean)streams.isPaused());
        }
    }

    @Test
    public void shouldAddThreadWhenRunning() throws Exception {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        this.props.put("num.stream.threads", (Object)1);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            int oldSize = streams.threads.size();
            org.apache.kafka.test.TestUtils.waitForCondition(() -> streams.state() == KafkaStreams.State.RUNNING, (long)15L, (String)"wait until running");
            MatcherAssert.assertThat((Object)streams.addStreamThread(), (Matcher)Matchers.equalTo(Optional.of("processId-StreamThread-2")));
            MatcherAssert.assertThat((Object)streams.threads.size(), (Matcher)Matchers.equalTo((Object)(oldSize + 1)));
        }
    }

    @Test
    public void shouldNotAddThreadWhenCreated() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            int oldSize = streams.threads.size();
            MatcherAssert.assertThat((Object)streams.addStreamThread(), (Matcher)Matchers.equalTo(Optional.empty()));
            MatcherAssert.assertThat((Object)streams.threads.size(), (Matcher)Matchers.equalTo((Object)oldSize));
        }
    }

    @Test
    public void shouldNotAddThreadWhenClosed() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            int oldSize = streams.threads.size();
            streams.close();
            MatcherAssert.assertThat((Object)streams.addStreamThread(), (Matcher)Matchers.equalTo(Optional.empty()));
            MatcherAssert.assertThat((Object)streams.threads.size(), (Matcher)Matchers.equalTo((Object)oldSize));
        }
    }

    @Test
    public void shouldNotAddThreadWhenError() {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        StreamsBuilder builder = this.getBuilderWithSource();
        builder.globalTable("anyTopic");
        try (KafkaStreams streams = new KafkaStreams(builder.build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            int oldSize = streams.threads.size();
            streams.start();
            streams.globalStreamThread.shutdown();
            MatcherAssert.assertThat((Object)streams.addStreamThread(), (Matcher)Matchers.equalTo(Optional.empty()));
            MatcherAssert.assertThat((Object)streams.threads.size(), (Matcher)Matchers.equalTo((Object)oldSize));
        }
    }

    @Test
    public void shouldNotReturnDeadThreads() {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        this.prepareThreadLock(this.streamThreadOne);
        this.prepareThreadLock(this.streamThreadTwo);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            this.streamThreadOne.shutdown();
            Set threads = streams.metadataForLocalThreads();
            MatcherAssert.assertThat((Object)threads.size(), (Matcher)Matchers.equalTo((Object)1));
            MatcherAssert.assertThat((Object)threads, (Matcher)CoreMatchers.hasItem((Object)this.streamThreadTwo.threadMetadata()));
        }
    }

    @Test
    public void shouldRemoveThread() throws Exception {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        Mockito.when((Object)this.streamThreadOne.groupInstanceID()).thenReturn(Optional.empty());
        Mockito.when((Object)this.streamThreadOne.waitOnThreadState((StreamThread.State)Mockito.isA(StreamThread.State.class), Mockito.anyLong())).thenReturn((Object)true);
        Mockito.when((Object)this.streamThreadOne.isThreadAlive()).thenReturn((Object)true);
        this.props.put("num.stream.threads", (Object)2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            int oldSize = streams.threads.size();
            org.apache.kafka.test.TestUtils.waitForCondition(() -> streams.state() == KafkaStreams.State.RUNNING, (long)15L, (String)"Kafka Streams client did not reach state RUNNING");
            MatcherAssert.assertThat((Object)streams.removeStreamThread(), (Matcher)Matchers.equalTo(Optional.of("processId-StreamThread-1")));
            MatcherAssert.assertThat((Object)streams.threads.size(), (Matcher)Matchers.equalTo((Object)(oldSize - 1)));
        }
    }

    @Test
    public void shouldNotRemoveThreadWhenNotRunning() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.props.put("num.stream.threads", (Object)1);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            MatcherAssert.assertThat((Object)streams.removeStreamThread(), (Matcher)Matchers.equalTo(Optional.empty()));
            MatcherAssert.assertThat((Object)streams.threads.size(), (Matcher)Matchers.equalTo((Object)1));
        }
    }

    @Test
    public void testCannotStartOnceClosed() {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            streams.close();
            try {
                streams.start();
                Assertions.fail((String)"Should have throw IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Test
    public void shouldNotSetGlobalRestoreListenerAfterStarting() {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            try {
                streams.setGlobalStateRestoreListener(null);
                Assertions.fail((String)"Should throw an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Test
    public void shouldThrowExceptionSettingUncaughtExceptionHandlerNotInCreateState() {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            Assertions.assertThrows(IllegalStateException.class, () -> streams.setUncaughtExceptionHandler((StreamsUncaughtExceptionHandler)null));
        }
    }

    @Test
    public void shouldThrowExceptionSettingStreamsUncaughtExceptionHandlerNotInCreateState() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            Assertions.assertThrows(IllegalStateException.class, () -> streams.setUncaughtExceptionHandler((StreamsUncaughtExceptionHandler)null));
        }
    }

    @Test
    public void shouldThrowNullPointerExceptionSettingStreamsUncaughtExceptionHandlerIfNull() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            Assertions.assertThrows(NullPointerException.class, () -> streams.setUncaughtExceptionHandler((StreamsUncaughtExceptionHandler)null));
        }
    }

    @Test
    public void shouldThrowExceptionSettingStateListenerNotInCreateState() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            try {
                streams.setStateListener(null);
                Assertions.fail((String)"Should throw IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Test
    public void shouldAllowCleanupBeforeStartAndAfterClose() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            try {
                streams.cleanUp();
                streams.start();
            }
            finally {
                streams.close();
                streams.cleanUp();
            }
        }
    }

    @Test
    public void shouldThrowOnCleanupWhileRunning() throws Exception {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            org.apache.kafka.test.TestUtils.waitForCondition(() -> streams.state() == KafkaStreams.State.RUNNING, (String)"Streams never started.");
            try {
                streams.cleanUp();
                Assertions.fail((String)"Should have thrown IllegalStateException");
            }
            catch (IllegalStateException expected) {
                Assertions.assertEquals((Object)"Cannot clean up while running.", (Object)expected.getMessage());
            }
        }
    }

    @Test
    public void shouldThrowOnCleanupWhilePaused() throws Exception {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            org.apache.kafka.test.TestUtils.waitForCondition(() -> streams.state() == KafkaStreams.State.RUNNING, (String)"Streams never started.");
            streams.pause();
            org.apache.kafka.test.TestUtils.waitForCondition(() -> ((KafkaStreams)streams).isPaused(), (String)"Streams did not pause.");
            Assertions.assertThrows(IllegalStateException.class, () -> ((KafkaStreams)streams).cleanUp(), (String)"Cannot clean up while running.");
        }
    }

    @Test
    public void shouldThrowOnCleanupWhileShuttingDown() throws Exception {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        this.prepareTerminableThread(this.streamThreadOne);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            org.apache.kafka.test.TestUtils.waitForCondition(() -> streams.state() == KafkaStreams.State.RUNNING, (String)"Streams never started.");
            streams.close(Duration.ZERO);
            MatcherAssert.assertThat((Object)(streams.state() == KafkaStreams.State.PENDING_SHUTDOWN ? 1 : 0), (Matcher)Matchers.equalTo((Object)true));
            Assertions.assertThrows(IllegalStateException.class, () -> ((KafkaStreams)streams).cleanUp());
            MatcherAssert.assertThat((Object)(streams.state() == KafkaStreams.State.PENDING_SHUTDOWN ? 1 : 0), (Matcher)Matchers.equalTo((Object)true));
        }
    }

    @Test
    public void shouldThrowOnCleanupWhileShuttingDownStreamClosedWithCloseOptionLeaveGroupFalse() throws Exception {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        this.prepareTerminableThread(this.streamThreadOne);
        MockClientSupplier mockClientSupplier = (MockClientSupplier)Mockito.spy(MockClientSupplier.class);
        Mockito.when((Object)mockClientSupplier.getAdmin((Map)ArgumentMatchers.any())).thenReturn((Object)this.adminClient);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)mockClientSupplier, (Time)this.time);){
            streams.start();
            org.apache.kafka.test.TestUtils.waitForCondition(() -> streams.state() == KafkaStreams.State.RUNNING, (String)"Streams never started.");
            KafkaStreams.CloseOptions closeOptions = new KafkaStreams.CloseOptions();
            closeOptions.timeout(Duration.ZERO);
            closeOptions.leaveGroup(true);
            streams.close(closeOptions);
            MatcherAssert.assertThat((Object)(streams.state() == KafkaStreams.State.PENDING_SHUTDOWN ? 1 : 0), (Matcher)Matchers.equalTo((Object)true));
            Assertions.assertThrows(IllegalStateException.class, () -> ((KafkaStreams)streams).cleanUp());
            MatcherAssert.assertThat((Object)(streams.state() == KafkaStreams.State.PENDING_SHUTDOWN ? 1 : 0), (Matcher)Matchers.equalTo((Object)true));
        }
    }

    @Test
    public void shouldThrowOnCleanupWhileShuttingDownStreamClosedWithCloseOptionLeaveGroupTrue() throws Exception {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        this.prepareTerminableThread(this.streamThreadOne);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            org.apache.kafka.test.TestUtils.waitForCondition(() -> streams.state() == KafkaStreams.State.RUNNING, (String)"Streams never started.");
            KafkaStreams.CloseOptions closeOptions = new KafkaStreams.CloseOptions();
            closeOptions.timeout(Duration.ZERO);
            streams.close(closeOptions);
            MatcherAssert.assertThat((Object)(streams.state() == KafkaStreams.State.PENDING_SHUTDOWN ? 1 : 0), (Matcher)Matchers.equalTo((Object)true));
            Assertions.assertThrows(IllegalStateException.class, () -> ((KafkaStreams)streams).cleanUp());
            MatcherAssert.assertThat((Object)(streams.state() == KafkaStreams.State.PENDING_SHUTDOWN ? 1 : 0), (Matcher)Matchers.equalTo((Object)true));
        }
    }

    @Test
    public void shouldNotGetAllTasksWhenNotRunning() throws Exception {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            Assertions.assertThrows(StreamsNotStartedException.class, () -> ((KafkaStreams)streams).metadataForAllStreamsClients());
            streams.start();
            TestUtils.waitForApplicationState(Collections.singletonList(streams), KafkaStreams.State.RUNNING, DEFAULT_DURATION);
            streams.close();
            TestUtils.waitForApplicationState(Collections.singletonList(streams), KafkaStreams.State.NOT_RUNNING, DEFAULT_DURATION);
            Assertions.assertThrows(IllegalStateException.class, () -> ((KafkaStreams)streams).metadataForAllStreamsClients());
        }
    }

    @Test
    public void shouldNotGetAllTasksWithStoreWhenNotRunning() throws Exception {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            Assertions.assertThrows(StreamsNotStartedException.class, () -> streams.streamsMetadataForStore("store"));
            streams.start();
            TestUtils.waitForApplicationState(Collections.singletonList(streams), KafkaStreams.State.RUNNING, DEFAULT_DURATION);
            streams.close();
            TestUtils.waitForApplicationState(Collections.singletonList(streams), KafkaStreams.State.NOT_RUNNING, DEFAULT_DURATION);
            Assertions.assertThrows(IllegalStateException.class, () -> streams.streamsMetadataForStore("store"));
        }
    }

    @Test
    public void shouldNotGetQueryMetadataWithSerializerWhenNotRunningOrRebalancing() throws Exception {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            Assertions.assertThrows(StreamsNotStartedException.class, () -> streams.queryMetadataForKey("store", (Object)"key", (Serializer)new StringSerializer()));
            streams.start();
            TestUtils.waitForApplicationState(Collections.singletonList(streams), KafkaStreams.State.RUNNING, DEFAULT_DURATION);
            streams.close();
            TestUtils.waitForApplicationState(Collections.singletonList(streams), KafkaStreams.State.NOT_RUNNING, DEFAULT_DURATION);
            Assertions.assertThrows(IllegalStateException.class, () -> streams.queryMetadataForKey("store", (Object)"key", (Serializer)new StringSerializer()));
        }
    }

    @Test
    public void shouldGetQueryMetadataWithSerializerWhenRunningOrRebalancing() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            Assertions.assertEquals((Object)KeyQueryMetadata.NOT_AVAILABLE, (Object)streams.queryMetadataForKey("store", (Object)"key", (Serializer)new StringSerializer()));
        }
    }

    @Test
    public void shouldNotGetQueryMetadataWithPartitionerWhenNotRunningOrRebalancing() throws Exception {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            Assertions.assertThrows(StreamsNotStartedException.class, () -> streams.queryMetadataForKey("store", (Object)"key", (topic, key, value, numPartitions) -> Optional.of(Collections.singleton(0))));
            streams.start();
            TestUtils.waitForApplicationState(Collections.singletonList(streams), KafkaStreams.State.RUNNING, DEFAULT_DURATION);
            streams.close();
            TestUtils.waitForApplicationState(Collections.singletonList(streams), KafkaStreams.State.NOT_RUNNING, DEFAULT_DURATION);
            Assertions.assertThrows(IllegalStateException.class, () -> streams.queryMetadataForKey("store", (Object)"key", (topic, key, value, numPartitions) -> Optional.of(Collections.singleton(0))));
        }
    }

    @Test
    public void shouldThrowUnknownStateStoreExceptionWhenStoreNotExist() throws Exception {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            TestUtils.waitForApplicationState(Collections.singletonList(streams), KafkaStreams.State.RUNNING, DEFAULT_DURATION);
            Assertions.assertThrows(UnknownStateStoreException.class, () -> streams.store(StoreQueryParameters.fromNameAndType((String)"unknown-store", (QueryableStoreType)QueryableStoreTypes.keyValueStore())));
        }
    }

    @Test
    public void shouldNotGetStoreWhenWhenNotRunningOrRebalancing() throws Exception {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            Assertions.assertThrows(StreamsNotStartedException.class, () -> streams.store(StoreQueryParameters.fromNameAndType((String)"store", (QueryableStoreType)QueryableStoreTypes.keyValueStore())));
            streams.start();
            TestUtils.waitForApplicationState(Collections.singletonList(streams), KafkaStreams.State.RUNNING, DEFAULT_DURATION);
            streams.close();
            TestUtils.waitForApplicationState(Collections.singletonList(streams), KafkaStreams.State.NOT_RUNNING, DEFAULT_DURATION);
            Assertions.assertThrows(IllegalStateException.class, () -> streams.store(StoreQueryParameters.fromNameAndType((String)"store", (QueryableStoreType)QueryableStoreTypes.keyValueStore())));
        }
    }

    @Test
    public void shouldReturnEmptyLocalStorePartitionLags() {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        KafkaFutureImpl allFuture = new KafkaFutureImpl();
        allFuture.complete(Collections.emptyMap());
        MockAdminClient mockAdminClient = (MockAdminClient)Mockito.spy(MockAdminClient.class);
        MockClientSupplier mockClientSupplier = (MockClientSupplier)Mockito.spy(MockClientSupplier.class);
        Mockito.when((Object)mockClientSupplier.getAdmin((Map)ArgumentMatchers.any())).thenReturn((Object)mockAdminClient);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)mockClientSupplier, (Time)this.time);){
            streams.start();
            Assertions.assertEquals((int)0, (int)streams.allLocalStorePartitionLags().size());
        }
    }

    @Test
    public void shouldReturnFalseOnCloseWhenThreadsHaventTerminated() throws Exception {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareTerminableThread(this.streamThreadOne);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier);){
            Assertions.assertFalse((boolean)streams.close(Duration.ofMillis(10L)));
        }
    }

    @Test
    public void shouldThrowOnNegativeTimeoutForClose() throws Exception {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareTerminableThread(this.streamThreadOne);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> streams.close(Duration.ofMillis(-1L)));
        }
    }

    @Test
    public void shouldNotBlockInCloseForZeroDuration() throws Exception {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareTerminableThread(this.streamThreadOne);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            Assertions.assertFalse((boolean)streams.close(Duration.ZERO));
        }
    }

    @Test
    public void shouldReturnFalseOnCloseWithCloseOptionWithLeaveGroupFalseWhenThreadsHaventTerminated() throws Exception {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareTerminableThread(this.streamThreadOne);
        KafkaStreams.CloseOptions closeOptions = new KafkaStreams.CloseOptions();
        closeOptions.timeout(Duration.ofMillis(10L));
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier);){
            Assertions.assertFalse((boolean)streams.close(closeOptions));
        }
    }

    @Test
    public void shouldThrowOnNegativeTimeoutForCloseWithCloseOptionLeaveGroupFalse() throws Exception {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareTerminableThread(this.streamThreadOne);
        KafkaStreams.CloseOptions closeOptions = new KafkaStreams.CloseOptions();
        closeOptions.timeout(Duration.ofMillis(-1L));
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> streams.close(closeOptions));
        }
    }

    @Test
    public void shouldNotBlockInCloseWithCloseOptionLeaveGroupFalseForZeroDuration() throws Exception {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareTerminableThread(this.streamThreadOne);
        KafkaStreams.CloseOptions closeOptions = new KafkaStreams.CloseOptions();
        closeOptions.timeout(Duration.ZERO);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier);){
            Assertions.assertFalse((boolean)streams.close(closeOptions));
        }
    }

    @Test
    public void shouldReturnFalseOnCloseWithCloseOptionWithLeaveGroupTrueWhenThreadsHaventTerminated() throws Exception {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareTerminableThread(this.streamThreadOne);
        MockClientSupplier mockClientSupplier = (MockClientSupplier)Mockito.spy(MockClientSupplier.class);
        Mockito.when((Object)mockClientSupplier.getAdmin((Map)ArgumentMatchers.any())).thenReturn((Object)this.adminClient);
        KafkaStreams.CloseOptions closeOptions = new KafkaStreams.CloseOptions();
        closeOptions.timeout(Duration.ofMillis(10L));
        closeOptions.leaveGroup(true);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)mockClientSupplier);){
            Assertions.assertFalse((boolean)streams.close(closeOptions));
        }
    }

    @Test
    public void shouldThrowOnNegativeTimeoutForCloseWithCloseOptionLeaveGroupTrue() throws Exception {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareTerminableThread(this.streamThreadOne);
        MockClientSupplier mockClientSupplier = (MockClientSupplier)Mockito.spy(MockClientSupplier.class);
        Mockito.when((Object)mockClientSupplier.getAdmin((Map)ArgumentMatchers.any())).thenReturn((Object)this.adminClient);
        KafkaStreams.CloseOptions closeOptions = new KafkaStreams.CloseOptions();
        closeOptions.timeout(Duration.ofMillis(-1L));
        closeOptions.leaveGroup(true);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)mockClientSupplier, (Time)this.time);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> streams.close(closeOptions));
        }
    }

    @Test
    public void shouldNotBlockInCloseWithCloseOptionLeaveGroupTrueForZeroDuration() throws Exception {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareTerminableThread(this.streamThreadOne);
        MockClientSupplier mockClientSupplier = (MockClientSupplier)Mockito.spy(MockClientSupplier.class);
        Mockito.when((Object)mockClientSupplier.getAdmin((Map)ArgumentMatchers.any())).thenReturn((Object)this.adminClient);
        KafkaStreams.CloseOptions closeOptions = new KafkaStreams.CloseOptions();
        closeOptions.timeout(Duration.ZERO);
        closeOptions.leaveGroup(true);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)mockClientSupplier);){
            Assertions.assertFalse((boolean)streams.close(closeOptions));
        }
    }

    @Test
    public void shouldTriggerRecordingOfRocksDBMetricsIfRecordingLevelIsDebug() throws Exception {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareTerminableThread(this.streamThreadOne);
        try (MockedStatic executorsMockedStatic = Mockito.mockStatic(Executors.class);){
            ScheduledExecutorService cleanupSchedule = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
            ScheduledExecutorService rocksDBMetricsRecordingTriggerThread = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
            executorsMockedStatic.when(() -> Executors.newSingleThreadScheduledExecutor((ThreadFactory)ArgumentMatchers.any(ThreadFactory.class))).thenReturn((Object)cleanupSchedule, new Object[]{rocksDBMetricsRecordingTriggerThread});
            StreamsBuilder builder = new StreamsBuilder();
            builder.table("topic", Materialized.as((String)"store"));
            this.props.setProperty("metrics.recording.level", Sensor.RecordingLevel.DEBUG.name());
            try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
                streams.start();
            }
            executorsMockedStatic.verify(() -> Executors.newSingleThreadScheduledExecutor((ThreadFactory)ArgumentMatchers.any(ThreadFactory.class)), Mockito.times((int)2));
            ((ScheduledExecutorService)Mockito.verify((Object)rocksDBMetricsRecordingTriggerThread)).scheduleAtFixedRate((Runnable)ArgumentMatchers.any(RocksDBMetricsRecordingTrigger.class), Mockito.eq((long)0L), Mockito.eq((long)1L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MINUTES))));
            ((ScheduledExecutorService)Mockito.verify((Object)rocksDBMetricsRecordingTriggerThread)).shutdownNow();
        }
    }

    @Test
    public void shouldGetClientSupplierFromConfigForConstructor() throws Exception {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareTerminableThread(this.streamThreadOne);
        this.prepareTerminableThread(this.streamThreadTwo);
        StreamsConfig config = new StreamsConfig((Map)this.props);
        StreamsConfig mockConfig = (StreamsConfig)Mockito.spy((Object)config);
        Mockito.when((Object)mockConfig.getKafkaClientSupplier()).thenReturn((Object)this.supplier);
        KafkaStreams ignored = new KafkaStreams(this.getBuilderWithSource().build(), mockConfig);
        ignored.close();
        ((StreamsConfig)Mockito.verify((Object)mockConfig, (VerificationMode)Mockito.times((int)2))).getKafkaClientSupplier();
    }

    @Test
    public void shouldGetClientSupplierFromConfigForConstructorWithTime() throws Exception {
        this.prepareStreams();
        AtomicReference<StreamThread.State> state1 = this.prepareStreamThread(this.streamThreadOne, 1);
        AtomicReference<StreamThread.State> state2 = this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareThreadState(this.streamThreadOne, state1);
        this.prepareThreadState(this.streamThreadTwo, state2);
        StreamsConfig config = new StreamsConfig((Map)this.props);
        StreamsConfig mockConfig = (StreamsConfig)Mockito.spy((Object)config);
        Mockito.when((Object)mockConfig.getKafkaClientSupplier()).thenReturn((Object)this.supplier);
        KafkaStreams ignored = new KafkaStreams(this.getBuilderWithSource().build(), mockConfig, (Time)this.time);
        ignored.close();
        ((StreamsConfig)Mockito.verify((Object)mockConfig, (VerificationMode)Mockito.times((int)2))).getKafkaClientSupplier();
    }

    @Test
    public void shouldUseProvidedClientSupplier() throws Exception {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        this.prepareTerminableThread(this.streamThreadOne);
        this.prepareTerminableThread(this.streamThreadTwo);
        StreamsConfig config = new StreamsConfig((Map)this.props);
        StreamsConfig mockConfig = (StreamsConfig)Mockito.spy((Object)config);
        KafkaStreams ignored = new KafkaStreams(this.getBuilderWithSource().build(), mockConfig, (KafkaClientSupplier)this.supplier);
        ignored.close();
        ((StreamsConfig)Mockito.verify((Object)mockConfig, (VerificationMode)Mockito.times((int)0))).getKafkaClientSupplier();
    }

    @Test
    public void shouldNotTriggerRecordingOfRocksDBMetricsIfRecordingLevelIsInfo() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        try (MockedStatic executorsMockedStatic = Mockito.mockStatic(Executors.class);){
            ScheduledExecutorService cleanupSchedule = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
            executorsMockedStatic.when(() -> Executors.newSingleThreadScheduledExecutor((ThreadFactory)ArgumentMatchers.any(ThreadFactory.class))).thenReturn((Object)cleanupSchedule);
            StreamsBuilder builder = new StreamsBuilder();
            builder.table("topic", Materialized.as((String)"store"));
            this.props.setProperty("metrics.recording.level", Sensor.RecordingLevel.INFO.name());
            try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
                streams.start();
            }
            executorsMockedStatic.verify(() -> Executors.newSingleThreadScheduledExecutor((ThreadFactory)ArgumentMatchers.any(ThreadFactory.class)));
        }
    }

    @Test
    public void shouldCleanupOldStateDirs() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        try (MockedStatic executorsMockedStatic = Mockito.mockStatic(Executors.class);){
            ScheduledExecutorService cleanupSchedule = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
            executorsMockedStatic.when(() -> Executors.newSingleThreadScheduledExecutor((ThreadFactory)ArgumentMatchers.any(ThreadFactory.class))).thenReturn((Object)cleanupSchedule);
            try (MockedConstruction ignored = Mockito.mockConstruction(StateDirectory.class, (mock, context) -> Mockito.when((Object)mock.initializeProcessId()).thenReturn((Object)UUID.randomUUID()));){
                this.props.setProperty("state.cleanup.delay.ms", "1");
                StreamsBuilder builder = new StreamsBuilder();
                builder.table("topic", Materialized.as((String)"store"));
                try (KafkaStreams streams = new KafkaStreams(builder.build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
                    streams.start();
                }
            }
            ((ScheduledExecutorService)Mockito.verify((Object)cleanupSchedule)).scheduleAtFixedRate((Runnable)ArgumentMatchers.any(Runnable.class), Mockito.eq((long)1L), Mockito.eq((long)1L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
            ((ScheduledExecutorService)Mockito.verify((Object)cleanupSchedule)).shutdownNow();
        }
    }

    @Test
    public void statelessTopologyShouldNotCreateStateDirectory(TestInfo testInfo) {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        String safeTestName = TestUtils.safeUniqueTestName(testInfo);
        String inputTopic = safeTestName + "-input";
        String outputTopic = safeTestName + "-output";
        Topology topology = new Topology();
        topology.addSource("source", (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer(), new String[]{inputTopic}).addProcessor("process", () -> new Processor<String, String, String, String>(){
            private ProcessorContext<String, String> context;

            public void init(ProcessorContext<String, String> context) {
                this.context = context;
            }

            public void process(Record<String, String> record) {
                if (((String)record.value()).length() % 2 == 0) {
                    this.context.forward(record.withValue((Object)((String)record.key() + (String)record.value())));
                }
            }
        }, new String[]{"source"}).addSink("sink", outputTopic, (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), new String[]{"process"});
        this.startStreamsAndCheckDirExists(topology, false);
    }

    @Test
    public void inMemoryStatefulTopologyShouldNotCreateStateDirectory(TestInfo testInfo) {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        String safeTestName = TestUtils.safeUniqueTestName(testInfo);
        String inputTopic = safeTestName + "-input";
        String outputTopic = safeTestName + "-output";
        String globalTopicName = safeTestName + "-global";
        String storeName = safeTestName + "-counts";
        String globalStoreName = safeTestName + "-globalStore";
        Topology topology = this.getStatefulTopology(inputTopic, outputTopic, globalTopicName, storeName, globalStoreName, false);
        this.startStreamsAndCheckDirExists(topology, false);
    }

    @Test
    public void statefulTopologyShouldCreateStateDirectory(TestInfo testInfo) {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        String safeTestName = TestUtils.safeUniqueTestName(testInfo);
        String inputTopic = safeTestName + "-input";
        String outputTopic = safeTestName + "-output";
        String globalTopicName = safeTestName + "-global";
        String storeName = safeTestName + "-counts";
        String globalStoreName = safeTestName + "-globalStore";
        Topology topology = this.getStatefulTopology(inputTopic, outputTopic, globalTopicName, storeName, globalStoreName, true);
        this.startStreamsAndCheckDirExists(topology, true);
    }

    @Test
    public void shouldThrowTopologyExceptionOnEmptyTopology() {
        this.prepareStreams();
        try (KafkaStreams ignored = new KafkaStreams(new StreamsBuilder().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            Assertions.fail((String)"Should have thrown TopologyException");
        }
        catch (TopologyException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"Invalid topology: Topology has no stream threads and no global threads, must subscribe to at least one source topic or global table."));
        }
    }

    @Test
    public void shouldNotCreateStreamThreadsForGlobalOnlyTopology() {
        this.prepareStreams();
        StreamsBuilder builder = new StreamsBuilder();
        builder.globalTable("anyTopic");
        try (KafkaStreams streams = new KafkaStreams(builder.build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            MatcherAssert.assertThat((Object)streams.threads.size(), (Matcher)Matchers.equalTo((Object)0));
        }
    }

    @Test
    public void shouldTransitToRunningWithGlobalOnlyTopology() throws Exception {
        this.prepareStreams();
        StreamsBuilder builder = new StreamsBuilder();
        builder.globalTable("anyTopic");
        try (KafkaStreams streams = new KafkaStreams(builder.build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            MatcherAssert.assertThat((Object)streams.threads.size(), (Matcher)Matchers.equalTo((Object)0));
            Assertions.assertEquals((Object)streams.state(), (Object)KafkaStreams.State.CREATED);
            streams.start();
            org.apache.kafka.test.TestUtils.waitForCondition(() -> streams.state() == KafkaStreams.State.RUNNING, (String)("Streams never started, state is " + String.valueOf(streams.state())));
            streams.close();
            org.apache.kafka.test.TestUtils.waitForCondition(() -> streams.state() == KafkaStreams.State.NOT_RUNNING, (String)"Streams never stopped.");
        }
    }

    @Test
    public void shouldThrowOnClientInstanceIdsWithNegativeTimeout() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            IllegalArgumentException error = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> streams.clientInstanceIds(Duration.ofMillis(-1L)));
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.equalTo((Object)"The timeout cannot be negative."));
        }
    }

    @Test
    public void shouldThrowOnClientInstanceIdsWhenNotStarted() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            IllegalStateException error = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> streams.clientInstanceIds(Duration.ZERO));
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.equalTo((Object)"KafkaStreams has not been started, you can retry after calling start()."));
        }
    }

    @Test
    public void shouldThrowOnClientInstanceIdsWhenClosed() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.close();
            IllegalStateException error = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> streams.clientInstanceIds(Duration.ZERO));
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.equalTo((Object)"KafkaStreams has been stopped (NOT_RUNNING)."));
        }
    }

    @Test
    public void shouldThrowStreamsExceptionWhenAdminNotInitialized() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            StreamsException error = (StreamsException)Assertions.assertThrows(StreamsException.class, () -> streams.clientInstanceIds(Duration.ZERO));
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.equalTo((Object)"Could not retrieve admin client instance id."));
            Throwable cause = error.getCause();
            MatcherAssert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(UnsupportedOperationException.class));
            MatcherAssert.assertThat((Object)cause.getMessage(), (Matcher)Matchers.equalTo((Object)"clientInstanceId not set"));
        }
    }

    @Test
    public void shouldNotCrashButThrowLaterIfAdminTelemetryDisabled() {
        this.prepareStreams();
        this.adminClient.disableTelemetry();
        this.props.put("num.stream.threads", (Object)0);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            ClientInstanceIds clientInstanceIds = streams.clientInstanceIds(Duration.ZERO);
            IllegalStateException error = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((ClientInstanceIds)clientInstanceIds).adminInstanceId());
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.equalTo((Object)"Telemetry is not enabled on the admin client. Set config `enable.metrics.push` to `true`."));
        }
    }

    @Test
    public void shouldThrowTimeExceptionWhenAdminTimesOut() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        this.adminClient.setClientInstanceId(Uuid.randomUuid());
        this.adminClient.injectTimeoutException(1);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            Assertions.assertThrows(org.apache.kafka.common.errors.TimeoutException.class, () -> streams.clientInstanceIds(Duration.ZERO));
        }
    }

    @Test
    public void shouldReturnAdminInstanceID() {
        this.prepareStreams();
        Uuid instanceId = Uuid.randomUuid();
        this.adminClient.setClientInstanceId(instanceId);
        this.props.put("num.stream.threads", (Object)0);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            MatcherAssert.assertThat((Object)streams.clientInstanceIds(Duration.ZERO).adminInstanceId(), (Matcher)Matchers.equalTo((Object)instanceId));
        }
    }

    @Test
    public void shouldReturnProducerAndConsumerInstanceIds() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.props.put("num.stream.threads", (Object)1);
        Uuid mainConsumerInstanceId = Uuid.randomUuid();
        Uuid producerInstanceId = Uuid.randomUuid();
        KafkaFutureImpl consumerFuture = new KafkaFutureImpl();
        KafkaFutureImpl producerFuture = new KafkaFutureImpl();
        consumerFuture.complete((Object)mainConsumerInstanceId);
        producerFuture.complete((Object)producerInstanceId);
        Uuid adminInstanceId = Uuid.randomUuid();
        this.adminClient.setClientInstanceId(adminInstanceId);
        Map<String, KafkaFutureImpl> expectedClientIds = Map.of("main-consumer", consumerFuture, "some-thread-producer", producerFuture);
        Mockito.when((Object)this.streamThreadOne.clientInstanceIds((Duration)ArgumentMatchers.any())).thenReturn(expectedClientIds);
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            ClientInstanceIds clientInstanceIds = streams.clientInstanceIds(Duration.ZERO);
            MatcherAssert.assertThat((Object)clientInstanceIds.consumerInstanceIds().size(), (Matcher)Matchers.equalTo((Object)1));
            MatcherAssert.assertThat((Object)((Uuid)clientInstanceIds.consumerInstanceIds().get("main-consumer")), (Matcher)Matchers.equalTo((Object)mainConsumerInstanceId));
            MatcherAssert.assertThat((Object)clientInstanceIds.producerInstanceIds().size(), (Matcher)Matchers.equalTo((Object)1));
            MatcherAssert.assertThat((Object)((Uuid)clientInstanceIds.producerInstanceIds().get("some-thread-producer")), (Matcher)Matchers.equalTo((Object)producerInstanceId));
            MatcherAssert.assertThat((Object)clientInstanceIds.adminInstanceId(), (Matcher)Matchers.equalTo((Object)adminInstanceId));
        }
    }

    @Test
    public void shouldThrowTimeoutExceptionWhenAnyClientFutureDoesNotComplete() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        Mockito.when((Object)this.streamThreadOne.clientInstanceIds((Duration)ArgumentMatchers.any())).thenReturn(Collections.singletonMap("some-client", new KafkaFutureImpl()));
        this.adminClient.setClientInstanceId(Uuid.randomUuid());
        try (KafkaStreams streams = new KafkaStreams(this.getBuilderWithSource().build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            org.apache.kafka.common.errors.TimeoutException timeoutException = (org.apache.kafka.common.errors.TimeoutException)Assertions.assertThrows(org.apache.kafka.common.errors.TimeoutException.class, () -> streams.clientInstanceIds(Duration.ZERO));
            MatcherAssert.assertThat((Object)timeoutException.getMessage(), (Matcher)Matchers.equalTo((Object)"Could not retrieve consumer/producer instance id for some-client."));
            MatcherAssert.assertThat((Object)timeoutException.getCause(), (Matcher)Matchers.instanceOf(TimeoutException.class));
        }
    }

    @Test
    public void shouldThrowTimeoutExceptionWhenGlobalConsumerFutureDoesNotComplete() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        this.adminClient.setClientInstanceId(Uuid.randomUuid());
        StreamsBuilder builder = this.getBuilderWithSource();
        builder.globalTable("anyTopic");
        try (KafkaStreams streams = new KafkaStreams(builder.build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            Mockito.when((Object)((GlobalStreamThread)this.globalStreamThreadMockedConstruction.constructed().get(0)).globalConsumerInstanceId((Duration)ArgumentMatchers.any())).thenReturn((Object)new KafkaFutureImpl());
            org.apache.kafka.common.errors.TimeoutException timeoutException = (org.apache.kafka.common.errors.TimeoutException)Assertions.assertThrows(org.apache.kafka.common.errors.TimeoutException.class, () -> streams.clientInstanceIds(Duration.ZERO));
            MatcherAssert.assertThat((Object)timeoutException.getMessage(), (Matcher)Matchers.equalTo((Object)"Could not retrieve global consumer client instance id."));
            MatcherAssert.assertThat((Object)timeoutException.getCause(), (Matcher)Matchers.instanceOf(TimeoutException.class));
        }
    }

    @Test
    public void shouldCountDownTimeoutAcrossClient() {
        this.prepareStreams();
        this.prepareStreamThread(this.streamThreadOne, 1);
        this.prepareStreamThread(this.streamThreadTwo, 2);
        this.adminClient.setClientInstanceId(Uuid.randomUuid());
        this.adminClient.advanceTimeOnClientInstanceId((Time)this.time, Duration.ofMillis(10L).toMillis());
        MockTime mockTime = this.time;
        final AtomicLong expectedTimeout = new AtomicLong(50L);
        final AtomicBoolean didAssertThreadOne = new AtomicBoolean(false);
        final AtomicBoolean didAssertThreadTwo = new AtomicBoolean(false);
        final AtomicBoolean didAssertGlobalThread = new AtomicBoolean(false);
        Mockito.when((Object)this.streamThreadOne.clientInstanceIds((Duration)ArgumentMatchers.any())).thenReturn(Collections.singletonMap("any-client-1", new KafkaFutureImpl<Uuid>((Time)mockTime){
            final /* synthetic */ Time val$mockTime;
            {
                this.val$mockTime = time;
            }

            public Uuid get(long timeout, TimeUnit timeUnit) {
                didAssertThreadOne.set(true);
                MatcherAssert.assertThat((Object)timeout, (Matcher)Matchers.equalTo((Object)expectedTimeout.getAndAdd(-10L)));
                this.val$mockTime.sleep(10L);
                return null;
            }
        }));
        Mockito.when((Object)this.streamThreadTwo.clientInstanceIds((Duration)ArgumentMatchers.any())).thenReturn(Collections.singletonMap("any-client-2", new KafkaFutureImpl<Uuid>((Time)mockTime){
            final /* synthetic */ Time val$mockTime;
            {
                this.val$mockTime = time;
            }

            public Uuid get(long timeout, TimeUnit timeUnit) {
                didAssertThreadTwo.set(true);
                MatcherAssert.assertThat((Object)timeout, (Matcher)Matchers.equalTo((Object)expectedTimeout.getAndAdd(-5L)));
                this.val$mockTime.sleep(5L);
                return null;
            }
        }));
        StreamsBuilder builder = this.getBuilderWithSource();
        builder.globalTable("anyTopic");
        try (KafkaStreams streams = new KafkaStreams(builder.build(), this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            streams.start();
            Mockito.when((Object)((GlobalStreamThread)this.globalStreamThreadMockedConstruction.constructed().get(0)).globalConsumerInstanceId((Duration)ArgumentMatchers.any())).thenReturn((Object)new KafkaFutureImpl<Uuid>((Time)mockTime){
                final /* synthetic */ Time val$mockTime;
                {
                    this.val$mockTime = time;
                }

                public Uuid get(long timeout, TimeUnit timeUnit) {
                    didAssertGlobalThread.set(true);
                    MatcherAssert.assertThat((Object)timeout, (Matcher)Matchers.equalTo((Object)expectedTimeout.getAndAdd(-8L)));
                    this.val$mockTime.sleep(8L);
                    return null;
                }
            });
            streams.clientInstanceIds(Duration.ofMillis(60L));
        }
        MatcherAssert.assertThat((Object)didAssertThreadOne.get(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)didAssertThreadTwo.get(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)didAssertGlobalThread.get(), (Matcher)Matchers.equalTo((Object)true));
    }

    private Topology getStatefulTopology(String inputTopic, String outputTopic, String globalTopicName, final String storeName, String globalStoreName, boolean isPersistentStore) {
        StoreBuilder storeBuilder = Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)(isPersistentStore ? Stores.persistentKeyValueStore((String)storeName) : Stores.inMemoryKeyValueStore((String)storeName)), (Serde)Serdes.String(), (Serde)Serdes.Long());
        Topology topology = new Topology();
        topology.addSource("source", (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer(), new String[]{inputTopic}).addProcessor("process", () -> new Processor<String, String, String, String>(){
            private ProcessorContext<String, String> context;

            public void init(ProcessorContext<String, String> context) {
                this.context = context;
            }

            public void process(Record<String, String> record) {
                KeyValueStore kvStore = (KeyValueStore)this.context.getStateStore(storeName);
                kvStore.put((Object)((String)record.key()), (Object)5L);
                this.context.forward(record.withValue((Object)"5"));
                this.context.commit();
            }
        }, new String[]{"source"}).addStateStore(storeBuilder, new String[]{"process"}).addSink("sink", outputTopic, (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), new String[]{"process"});
        StoreBuilder globalStoreBuilder = Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)(isPersistentStore ? Stores.persistentKeyValueStore((String)globalStoreName) : Stores.inMemoryKeyValueStore((String)globalStoreName)), (Serde)Serdes.String(), (Serde)Serdes.String()).withLoggingDisabled();
        topology.addGlobalStore(globalStoreBuilder, "global", (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer(), globalTopicName, globalTopicName + "-processor", new MockProcessorSupplier());
        return topology;
    }

    private StreamsBuilder getBuilderWithSource() {
        StreamsBuilder builder = new StreamsBuilder();
        builder.stream("source-topic");
        return builder;
    }

    private void startStreamsAndCheckDirExists(Topology topology, boolean shouldFilesExist) {
        try (MockedConstruction stateDirectoryMockedConstruction = Mockito.mockConstruction(StateDirectory.class, (mock, context) -> {
            Mockito.when((Object)mock.initializeProcessId()).thenReturn((Object)UUID.randomUUID());
            Assertions.assertEquals((int)4, (int)context.arguments().size());
            Assertions.assertEquals((Object)shouldFilesExist, context.arguments().get(2));
        });
             KafkaStreams ignored = new KafkaStreams(topology, this.props, (KafkaClientSupplier)this.supplier, (Time)this.time);){
            Assertions.assertFalse((boolean)stateDirectoryMockedConstruction.constructed().isEmpty());
        }
    }

    public static class StateListenerStub
    implements KafkaStreams.StateListener {
        int numChanges = 0;
        KafkaStreams.State oldState;
        KafkaStreams.State newState;
        public Map<KafkaStreams.State, Long> mapStates = new HashMap<KafkaStreams.State, Long>();

        public void onChange(KafkaStreams.State newState, KafkaStreams.State oldState) {
            long prevCount = this.mapStates.containsKey(newState) ? this.mapStates.get(newState) : 0L;
            ++this.numChanges;
            this.oldState = oldState;
            this.newState = newState;
            this.mapStates.put(newState, prevCount + 1L);
        }
    }
}

