/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.KeyValueTimestamp;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyConfig;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.TopologyWrapper;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.kstream.Branched;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.Joined;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.Printed;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.SlidingWindows;
import org.apache.kafka.streams.kstream.StreamJoined;
import org.apache.kafka.streams.kstream.Suppressed;
import org.apache.kafka.streams.kstream.TableJoined;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StoreFactory;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.state.BuiltInDslStoreSuppliers;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.apache.kafka.streams.state.internals.InMemorySessionStore;
import org.apache.kafka.streams.state.internals.InMemoryWindowStore;
import org.apache.kafka.streams.state.internals.RocksDBStore;
import org.apache.kafka.streams.state.internals.RocksDBWindowStore;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.apache.kafka.streams.utils.TestUtils;
import org.apache.kafka.test.MockApiFixedKeyProcessorSupplier;
import org.apache.kafka.test.MockApiProcessorSupplier;
import org.apache.kafka.test.MockMapper;
import org.apache.kafka.test.MockPredicate;
import org.apache.kafka.test.MockValueJoiner;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=600L)
public class StreamsBuilderTest {
    private static final String STREAM_TOPIC = "stream-topic";
    private static final String STREAM_OPERATION_NAME = "stream-operation";
    private static final String STREAM_TOPIC_TWO = "stream-topic-two";
    private static final String TABLE_TOPIC = "table-topic";
    private final StreamsBuilder builder = new StreamsBuilder();
    private Properties props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.String());

    @BeforeEach
    public void before() {
        this.props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.String());
    }

    @Test
    public void shouldAddGlobalStore() {
        StreamsBuilder builder = new StreamsBuilder();
        builder.addGlobalStore(Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"store"), (Serde)Serdes.String(), (Serde)Serdes.String()), "topic", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()), () -> new Processor<String, String, Void, Void>(){
            private KeyValueStore<String, String> store;

            public void init(ProcessorContext<Void, Void> context) {
                this.store = (KeyValueStore)context.getStateStore("store");
            }

            public void process(Record<String, String> record) {
                this.store.put((Object)((String)record.key()), (Object)((String)record.value()));
            }
        });
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build());){
            TestInputTopic inputTopic = driver.createInputTopic("topic", (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            inputTopic.pipeInput((Object)"hey", (Object)"there");
            KeyValueStore store = driver.getKeyValueStore("store");
            String hey = (String)store.get((Object)"hey");
            MatcherAssert.assertThat((Object)hey, (Matcher)Is.is((Object)"there"));
        }
    }

    @Test
    public void shouldNotThrowNullPointerIfOptimizationsNotSpecified() {
        Properties properties = new Properties();
        StreamsBuilder builder = new StreamsBuilder();
        builder.build(properties);
    }

    @Test
    public void shouldAllowJoinUnmaterializedFilteredKTable() {
        KTable filteredKTable = this.builder.table(TABLE_TOPIC).filter(MockPredicate.allGoodPredicate());
        this.builder.stream(STREAM_TOPIC).join(filteredKTable, MockValueJoiner.TOSTRING_JOINER);
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        MatcherAssert.assertThat((Object)topology.stateStores().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)topology.processorConnectedStateStores("KSTREAM-JOIN-0000000005"), (Matcher)CoreMatchers.equalTo(Collections.singleton(((StateStore)topology.stateStores().get(0)).name())));
        Assertions.assertTrue((boolean)topology.processorConnectedStateStores("KTABLE-FILTER-0000000003").isEmpty());
    }

    @Test
    public void shouldAllowJoinMaterializedFilteredKTable() {
        KTable filteredKTable = this.builder.table(TABLE_TOPIC).filter(MockPredicate.allGoodPredicate(), Materialized.as((String)"store"));
        this.builder.stream(STREAM_TOPIC).join(filteredKTable, MockValueJoiner.TOSTRING_JOINER);
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        MatcherAssert.assertThat((Object)topology.stateStores().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)topology.processorConnectedStateStores("KSTREAM-JOIN-0000000005"), (Matcher)CoreMatchers.equalTo(Collections.singleton("store")));
        MatcherAssert.assertThat((Object)topology.processorConnectedStateStores("KTABLE-FILTER-0000000003"), (Matcher)CoreMatchers.equalTo(Collections.singleton("store")));
    }

    @Test
    public void shouldAllowJoinUnmaterializedMapValuedKTable() {
        KTable mappedKTable = this.builder.table(TABLE_TOPIC).mapValues(MockMapper.noOpValueMapper());
        this.builder.stream(STREAM_TOPIC).join(mappedKTable, MockValueJoiner.TOSTRING_JOINER);
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        MatcherAssert.assertThat((Object)topology.stateStores().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)topology.processorConnectedStateStores("KSTREAM-JOIN-0000000005"), (Matcher)CoreMatchers.equalTo(Collections.singleton(((StateStore)topology.stateStores().get(0)).name())));
        Assertions.assertTrue((boolean)topology.processorConnectedStateStores("KTABLE-MAPVALUES-0000000003").isEmpty());
    }

    @Test
    public void shouldAllowJoinMaterializedMapValuedKTable() {
        KTable mappedKTable = this.builder.table(TABLE_TOPIC).mapValues(MockMapper.noOpValueMapper(), Materialized.as((String)"store"));
        this.builder.stream(STREAM_TOPIC).join(mappedKTable, MockValueJoiner.TOSTRING_JOINER);
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        MatcherAssert.assertThat((Object)topology.stateStores().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)topology.processorConnectedStateStores("KSTREAM-JOIN-0000000005"), (Matcher)CoreMatchers.equalTo(Collections.singleton("store")));
        MatcherAssert.assertThat((Object)topology.processorConnectedStateStores("KTABLE-MAPVALUES-0000000003"), (Matcher)CoreMatchers.equalTo(Collections.singleton("store")));
    }

    @Test
    public void shouldAllowJoinUnmaterializedJoinedKTable() {
        KTable table1 = this.builder.table("table-topic1");
        KTable table2 = this.builder.table("table-topic2");
        this.builder.stream(STREAM_TOPIC).join(table1.join(table2, MockValueJoiner.TOSTRING_JOINER), MockValueJoiner.TOSTRING_JOINER);
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        MatcherAssert.assertThat((Object)topology.stateStores().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)topology.processorConnectedStateStores("KSTREAM-JOIN-0000000010"), (Matcher)CoreMatchers.equalTo(Set.of(((StateStore)topology.stateStores().get(0)).name(), ((StateStore)topology.stateStores().get(1)).name())));
        Assertions.assertTrue((boolean)topology.processorConnectedStateStores("KTABLE-MERGE-0000000007").isEmpty());
    }

    @Test
    public void shouldAllowJoinMaterializedJoinedKTable() {
        KTable table1 = this.builder.table("table-topic1");
        KTable table2 = this.builder.table("table-topic2");
        this.builder.stream(STREAM_TOPIC).join(table1.join(table2, MockValueJoiner.TOSTRING_JOINER, Materialized.as((String)"store")), MockValueJoiner.TOSTRING_JOINER);
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        MatcherAssert.assertThat((Object)topology.stateStores().size(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)topology.processorConnectedStateStores("KSTREAM-JOIN-0000000010"), (Matcher)CoreMatchers.equalTo(Collections.singleton("store")));
        MatcherAssert.assertThat((Object)topology.processorConnectedStateStores("KTABLE-MERGE-0000000007"), (Matcher)CoreMatchers.equalTo(Collections.singleton("store")));
    }

    @Test
    public void shouldAllowJoinMaterializedSourceKTable() {
        KTable table = this.builder.table(TABLE_TOPIC);
        this.builder.stream(STREAM_TOPIC).join(table, MockValueJoiner.TOSTRING_JOINER);
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        MatcherAssert.assertThat((Object)topology.stateStores().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)topology.processorConnectedStateStores("KTABLE-SOURCE-0000000002"), (Matcher)CoreMatchers.equalTo(Collections.singleton(((StateStore)topology.stateStores().get(0)).name())));
        MatcherAssert.assertThat((Object)topology.processorConnectedStateStores("KSTREAM-JOIN-0000000004"), (Matcher)CoreMatchers.equalTo(Collections.singleton(((StateStore)topology.stateStores().get(0)).name())));
    }

    @Test
    public void shouldProcessingFromSinkTopic() {
        KStream source = this.builder.stream("topic-source");
        source.to("topic-sink");
        MockApiProcessorSupplier processorSupplier = new MockApiProcessorSupplier();
        source.process(processorSupplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("topic-source", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            inputTopic.pipeInput((Object)"A", (Object)"aa");
        }
        Assertions.assertEquals(Collections.singletonList(new KeyValueTimestamp<String, String>("A", "aa", 0L)), processorSupplier.theCapturedProcessor().processed());
    }

    @Test
    public void shouldProcessViaRepartitionTopic() {
        KStream source = this.builder.stream("topic-source");
        KStream through = source.repartition();
        MockApiProcessorSupplier sourceProcessorSupplier = new MockApiProcessorSupplier();
        source.process(sourceProcessorSupplier, new String[0]);
        MockApiProcessorSupplier throughProcessorSupplier = new MockApiProcessorSupplier();
        through.process(throughProcessorSupplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("topic-source", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            inputTopic.pipeInput((Object)"A", (Object)"aa");
        }
        Assertions.assertEquals(Collections.singletonList(new KeyValueTimestamp<String, String>("A", "aa", 0L)), sourceProcessorSupplier.theCapturedProcessor().processed());
        Assertions.assertEquals(Collections.singletonList(new KeyValueTimestamp<String, String>("A", "aa", 0L)), throughProcessorSupplier.theCapturedProcessor().processed());
    }

    @Test
    public void shouldMergeStreams() {
        String topic1 = "topic-1";
        String topic2 = "topic-2";
        KStream source1 = this.builder.stream("topic-1");
        KStream source2 = this.builder.stream("topic-2");
        KStream merged = source1.merge(source2);
        MockApiProcessorSupplier processorSupplier = new MockApiProcessorSupplier();
        merged.process(processorSupplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            TestInputTopic inputTopic1 = driver.createInputTopic("topic-1", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic2 = driver.createInputTopic("topic-2", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            inputTopic1.pipeInput((Object)"A", (Object)"aa");
            inputTopic2.pipeInput((Object)"B", (Object)"bb");
            inputTopic2.pipeInput((Object)"C", (Object)"cc");
            inputTopic1.pipeInput((Object)"D", (Object)"dd");
        }
        Assertions.assertEquals(Arrays.asList(new KeyValueTimestamp<String, String>("A", "aa", 0L), new KeyValueTimestamp<String, String>("B", "bb", 0L), new KeyValueTimestamp<String, String>("C", "cc", 0L), new KeyValueTimestamp<String, String>("D", "dd", 0L)), processorSupplier.theCapturedProcessor().processed());
    }

    @Test
    public void shouldUseDslStoreSupplierDefinedInMaterialized() {
        String topic = "topic";
        this.builder.stream("topic").groupByKey().count(Materialized.as((String)"store").withStoreType(BuiltInDslStoreSuppliers.IN_MEMORY)).toStream();
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertTypesForStateStore(topology.stateStores(), InMemoryKeyValueStore.class);
    }

    @Test
    public void shouldUseDslStoreSupplierDefinedInMaterializedOverTopologyOverrides() {
        String topic = "topic";
        Properties topoOverrides = new Properties();
        topoOverrides.putAll((Map<?, ?>)this.props);
        topoOverrides.put("dsl.store.suppliers.class", BuiltInDslStoreSuppliers.RocksDBDslStoreSuppliers.class);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig((Map)topoOverrides)));
        builder.stream("topic").groupByKey().count(Materialized.as((String)"store").withStoreType(BuiltInDslStoreSuppliers.IN_MEMORY)).toStream();
        builder.build();
        ProcessorTopology topology = builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertTypesForStateStore(topology.stateStores(), InMemoryKeyValueStore.class);
    }

    @Test
    public void shouldUseDslStoreSupplierOverStoreType() {
        String topic = "topic";
        Properties topoOverrides = new Properties();
        topoOverrides.putAll((Map<?, ?>)this.props);
        topoOverrides.put("default.dsl.store", "rocksDB");
        topoOverrides.put("dsl.store.suppliers.class", BuiltInDslStoreSuppliers.InMemoryDslStoreSuppliers.class);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig((Map)topoOverrides)));
        builder.stream("topic").groupByKey().count(Materialized.as((String)"store")).toStream();
        builder.build();
        ProcessorTopology topology = builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertTypesForStateStore(topology.stateStores(), InMemoryKeyValueStore.class);
    }

    @Test
    public void shouldUseTopologyOverrideStoreTypeOverConfiguredDslStoreSupplier() {
        String topic = "topic";
        Properties topoOverrides = new Properties();
        topoOverrides.putAll((Map<?, ?>)this.props);
        topoOverrides.put("default.dsl.store", "in_memory");
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig((Map)topoOverrides)));
        builder.stream("topic").groupByKey().count(Materialized.as((String)"store")).toStream();
        builder.build();
        this.props.put("dsl.store.suppliers.class", BuiltInDslStoreSuppliers.RocksDBDslStoreSuppliers.class);
        ProcessorTopology topology = builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertTypesForStateStore(topology.stateStores(), InMemoryKeyValueStore.class);
    }

    @Test
    public void shouldUseDslStoreSupplierDefinedConfiguredInStreamsConfig() {
        String topic = "topic";
        this.builder.stream("topic").groupByKey().count().toStream();
        this.builder.build();
        this.props.put("dsl.store.suppliers.class", BuiltInDslStoreSuppliers.InMemoryDslStoreSuppliers.class);
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertTypesForStateStore(topology.stateStores(), InMemoryKeyValueStore.class);
    }

    @Test
    public void shouldUseDslStoreSupplierDefinedConfiguredInTopologyConfigOverStreamsConfig() {
        String topic = "topic";
        Properties topoOverrides = new Properties();
        topoOverrides.putAll((Map<?, ?>)this.props);
        topoOverrides.put("dsl.store.suppliers.class", BuiltInDslStoreSuppliers.InMemoryDslStoreSuppliers.class);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig((Map)topoOverrides)));
        builder.stream("topic").groupByKey().count().toStream();
        builder.build();
        this.props.put("dsl.store.suppliers.class", BuiltInDslStoreSuppliers.RocksDBDslStoreSuppliers.class);
        ProcessorTopology topology = builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertTypesForStateStore(topology.stateStores(), InMemoryKeyValueStore.class);
    }

    @Test
    public void shouldUseDslStoreSupplierDefinedInMaterializedForWindowedOperation() {
        String topic = "topic";
        this.builder.stream("topic").groupByKey().windowedBy((Windows)JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofHours(1L), (Duration)Duration.ZERO)).count(Materialized.as((String)"store").withStoreType(BuiltInDslStoreSuppliers.IN_MEMORY)).toStream();
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertTypesForStateStore(topology.stateStores(), InMemoryWindowStore.class);
    }

    @Test
    public void shouldUseDslStoreSupplierDefinedConfiguredInStreamsConfigForWindowedOperation() {
        String topic = "topic";
        this.builder.stream("topic").groupByKey().windowedBy((Windows)JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofHours(1L), (Duration)Duration.ZERO)).count().toStream();
        this.builder.build();
        this.props.put("dsl.store.suppliers.class", BuiltInDslStoreSuppliers.InMemoryDslStoreSuppliers.class);
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertTypesForStateStore(topology.stateStores(), InMemoryWindowStore.class);
    }

    @Test
    public void shouldUseDslStoreSupplierDefinedConfiguredInTopologyConfigOverStreamsConfigForWindowedOperation() {
        String topic = "topic";
        Properties topoOverrides = new Properties();
        topoOverrides.putAll((Map<?, ?>)this.props);
        topoOverrides.put("dsl.store.suppliers.class", BuiltInDslStoreSuppliers.InMemoryDslStoreSuppliers.class);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig((Map)topoOverrides)));
        builder.stream("topic").groupByKey().windowedBy((Windows)JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofHours(1L), (Duration)Duration.ZERO)).count().toStream();
        builder.build();
        this.props.put("dsl.store.suppliers.class", BuiltInDslStoreSuppliers.RocksDBDslStoreSuppliers.class);
        ProcessorTopology topology = builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertTypesForStateStore(topology.stateStores(), InMemoryWindowStore.class);
    }

    @Test
    public void shouldUseDslStoreSupplierDefinedInMaterializedForSessionWindowedOperation() {
        String topic = "topic";
        this.builder.stream("topic").groupByKey().windowedBy(SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofHours(1L), (Duration)Duration.ZERO)).count(Materialized.as((String)"store").withStoreType(BuiltInDslStoreSuppliers.IN_MEMORY)).toStream();
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertTypesForStateStore(topology.stateStores(), InMemorySessionStore.class);
    }

    @Test
    public void shouldUseDslStoreSupplierDefinedConfiguredInStreamsConfigForSessionWindowedOperation() {
        String topic = "topic";
        this.builder.stream("topic").groupByKey().windowedBy(SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofHours(1L), (Duration)Duration.ZERO)).count().toStream();
        this.builder.build();
        this.props.put("dsl.store.suppliers.class", BuiltInDslStoreSuppliers.InMemoryDslStoreSuppliers.class);
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertTypesForStateStore(topology.stateStores(), InMemorySessionStore.class);
    }

    @Test
    public void shouldUseDslStoreSupplierDefinedConfiguredInTopologyConfigOverStreamsConfigForSessionWindowedOperation() {
        String topic = "topic";
        Properties topoOverrides = new Properties();
        topoOverrides.putAll((Map<?, ?>)this.props);
        topoOverrides.put("dsl.store.suppliers.class", BuiltInDslStoreSuppliers.InMemoryDslStoreSuppliers.class);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig((Map)topoOverrides)));
        builder.stream("topic").groupByKey().windowedBy(SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofHours(1L), (Duration)Duration.ZERO)).count().toStream();
        builder.build();
        this.props.put("dsl.store.suppliers.class", BuiltInDslStoreSuppliers.RocksDBDslStoreSuppliers.class);
        ProcessorTopology topology = builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertTypesForStateStore(topology.stateStores(), InMemorySessionStore.class);
    }

    @Test
    public void shouldUseSerdesDefinedInMaterializedToConsumeTable() {
        HashMap results = new HashMap();
        String topic = "topic";
        ForeachAction action = results::put;
        this.builder.table("topic", Materialized.as((String)"store").withKeySerde(Serdes.Long()).withValueSerde(Serdes.String())).toStream().foreach(action);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("topic", (Serializer)new LongSerializer(), (Serializer)new StringSerializer());
            inputTopic.pipeInput((Object)1L, (Object)"value1");
            inputTopic.pipeInput((Object)2L, (Object)"value2");
            KeyValueStore store = driver.getKeyValueStore("store");
            MatcherAssert.assertThat((Object)((String)store.get((Object)1L)), (Matcher)CoreMatchers.equalTo((Object)"value1"));
            MatcherAssert.assertThat((Object)((String)store.get((Object)2L)), (Matcher)CoreMatchers.equalTo((Object)"value2"));
            MatcherAssert.assertThat((Object)((String)results.get(1L)), (Matcher)CoreMatchers.equalTo((Object)"value1"));
            MatcherAssert.assertThat((Object)((String)results.get(2L)), (Matcher)CoreMatchers.equalTo((Object)"value2"));
        }
    }

    @Test
    public void shouldUseSerdesDefinedInMaterializedToConsumeGlobalTable() {
        String topic = "topic";
        this.builder.globalTable("topic", Materialized.as((String)"store").withKeySerde(Serdes.Long()).withValueSerde(Serdes.String()));
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("topic", (Serializer)new LongSerializer(), (Serializer)new StringSerializer());
            inputTopic.pipeInput((Object)1L, (Object)"value1");
            inputTopic.pipeInput((Object)2L, (Object)"value2");
            KeyValueStore store = driver.getKeyValueStore("store");
            MatcherAssert.assertThat((Object)((String)store.get((Object)1L)), (Matcher)CoreMatchers.equalTo((Object)"value1"));
            MatcherAssert.assertThat((Object)((String)store.get((Object)2L)), (Matcher)CoreMatchers.equalTo((Object)"value2"));
        }
    }

    @Test
    public void shouldThrowOnVersionedStoreSupplierForGlobalTable() {
        String topic = "topic";
        Assertions.assertThrows(TopologyException.class, () -> this.builder.globalTable("topic", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"store", (Duration)Duration.ZERO)).withKeySerde(Serdes.Long()).withValueSerde(Serdes.String())));
    }

    @Test
    public void shouldNotMaterializeStoresIfNotRequired() {
        String topic = "topic";
        this.builder.table("topic", Materialized.with((Serde)Serdes.Long(), (Serde)Serdes.String()));
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        MatcherAssert.assertThat((Object)topology.stateStores().size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldReuseSourceTopicAsChangelogsWithOptimization20() {
        String topic = "topic";
        this.builder.table("topic", Materialized.as((String)"store"));
        Properties props = StreamsTestUtils.getStreamsConfig();
        props.put("topology.optimization", "all");
        Topology topology = this.builder.build(props);
        InternalTopologyBuilder internalTopologyBuilder = TopologyWrapper.getInternalTopologyBuilder(topology);
        internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)props));
        MatcherAssert.assertThat((Object)internalTopologyBuilder.buildTopology().storeToChangelogTopic(), (Matcher)CoreMatchers.equalTo(Collections.singletonMap("store", "topic")));
        MatcherAssert.assertThat(internalTopologyBuilder.stateStores().keySet(), (Matcher)CoreMatchers.equalTo(Collections.singleton("store")));
        MatcherAssert.assertThat((Object)((StoreFactory)internalTopologyBuilder.stateStores().get("store")).loggingEnabled(), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)((InternalTopologyBuilder.TopicsInfo)internalTopologyBuilder.subtopologyToTopicsInfo().get(AssignmentTestUtils.SUBTOPOLOGY_0)).nonSourceChangelogTopics().isEmpty(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void shouldNotReuseRepartitionTopicAsChangelogs() {
        String topic = "topic";
        this.builder.stream("topic").repartition().toTable(Materialized.as((String)"store"));
        Properties props = StreamsTestUtils.getStreamsConfig("appId");
        props.put("topology.optimization", "all");
        Topology topology = this.builder.build(props);
        InternalTopologyBuilder internalTopologyBuilder = TopologyWrapper.getInternalTopologyBuilder(topology);
        internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)props));
        MatcherAssert.assertThat((Object)internalTopologyBuilder.buildTopology().storeToChangelogTopic(), (Matcher)CoreMatchers.equalTo(Collections.singletonMap("store", "appId-store-changelog")));
        MatcherAssert.assertThat(internalTopologyBuilder.stateStores().keySet(), (Matcher)CoreMatchers.equalTo(Collections.singleton("store")));
        MatcherAssert.assertThat((Object)((StoreFactory)internalTopologyBuilder.stateStores().get("store")).loggingEnabled(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat(((InternalTopologyBuilder.TopicsInfo)internalTopologyBuilder.subtopologyToTopicsInfo().get((Object)AssignmentTestUtils.SUBTOPOLOGY_1)).stateChangelogTopics.keySet(), (Matcher)CoreMatchers.equalTo(Collections.singleton("appId-store-changelog")));
    }

    @Test
    public void shouldNotReuseSourceTopicAsChangelogsByDefault() {
        String topic = "topic";
        this.builder.table("topic", Materialized.as((String)"store"));
        InternalTopologyBuilder internalTopologyBuilder = TopologyWrapper.getInternalTopologyBuilder(this.builder.build());
        internalTopologyBuilder.setApplicationId("appId");
        MatcherAssert.assertThat((Object)internalTopologyBuilder.buildTopology().storeToChangelogTopic(), (Matcher)CoreMatchers.equalTo(Collections.singletonMap("store", "appId-store-changelog")));
        MatcherAssert.assertThat(internalTopologyBuilder.stateStores().keySet(), (Matcher)CoreMatchers.equalTo(Collections.singleton("store")));
        MatcherAssert.assertThat((Object)((StoreFactory)internalTopologyBuilder.stateStores().get("store")).loggingEnabled(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat(((InternalTopologyBuilder.TopicsInfo)internalTopologyBuilder.subtopologyToTopicsInfo().get((Object)AssignmentTestUtils.SUBTOPOLOGY_0)).stateChangelogTopics.keySet(), (Matcher)CoreMatchers.equalTo(Collections.singleton("appId-store-changelog")));
    }

    @Test
    public void shouldThrowExceptionWhenNoTopicPresent() {
        this.builder.stream(Collections.emptyList());
        Assertions.assertThrows(TopologyException.class, () -> ((StreamsBuilder)this.builder).build());
    }

    @Test
    public void shouldThrowExceptionWhenTopicNamesAreNull() {
        this.builder.stream(Arrays.asList(null, null));
        Assertions.assertThrows(NullPointerException.class, () -> ((StreamsBuilder)this.builder).build());
    }

    @Test
    public void shouldUseSpecifiedNameForStreamSourceProcessor() {
        String expected = "source-node";
        this.builder.stream(STREAM_TOPIC, Consumed.as((String)"source-node"));
        this.builder.stream(STREAM_TOPIC_TWO);
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForOperation(topology, "source-node", "KSTREAM-SOURCE-0000000001");
    }

    @Test
    public void shouldUseSpecifiedNameForTableSourceProcessor() {
        String expected = "source-node";
        this.builder.table(STREAM_TOPIC, Consumed.as((String)"source-node"));
        this.builder.table(STREAM_TOPIC_TWO);
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForOperation(topology, "source-node-source", "source-node", "KSTREAM-SOURCE-0000000004", "KTABLE-SOURCE-0000000005");
    }

    @Test
    public void shouldUseSpecifiedNameForGlobalTableSourceProcessor() {
        String expected = "source-processor";
        this.builder.globalTable(STREAM_TOPIC, Consumed.as((String)"source-processor"));
        this.builder.globalTable(STREAM_TOPIC_TWO);
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForStateStore(topology.globalStateStores(), "stream-topic-STATE-STORE-0000000000", "stream-topic-two-STATE-STORE-0000000003");
    }

    @Test
    public void shouldUseSpecifiedNameForSinkProcessor() {
        String expected = "sink-processor";
        KStream stream = this.builder.stream(STREAM_TOPIC);
        stream.to(STREAM_TOPIC_TWO, Produced.as((String)"sink-processor"));
        stream.to(STREAM_TOPIC_TWO);
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", "sink-processor", "KSTREAM-SINK-0000000002");
    }

    @Test
    public void shouldUseSpecifiedNameForMapOperation() {
        this.builder.stream(STREAM_TOPIC).map(KeyValue::pair, Named.as((String)STREAM_OPERATION_NAME));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", STREAM_OPERATION_NAME);
    }

    @Test
    public void shouldUseSpecifiedNameForMapValuesOperation() {
        this.builder.stream(STREAM_TOPIC).mapValues(v -> v, Named.as((String)STREAM_OPERATION_NAME));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", STREAM_OPERATION_NAME);
    }

    @Test
    public void shouldUseSpecifiedNameForMapValuesWithKeyOperation() {
        this.builder.stream(STREAM_TOPIC).mapValues((k, v) -> v, Named.as((String)STREAM_OPERATION_NAME));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", STREAM_OPERATION_NAME);
    }

    @Test
    public void shouldUseSpecifiedNameForFilterOperation() {
        this.builder.stream(STREAM_TOPIC).filter((k, v) -> true, Named.as((String)STREAM_OPERATION_NAME));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", STREAM_OPERATION_NAME);
    }

    @Test
    public void shouldUseSpecifiedNameForForEachOperation() {
        this.builder.stream(STREAM_TOPIC).foreach((k, v) -> {}, Named.as((String)STREAM_OPERATION_NAME));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", STREAM_OPERATION_NAME);
    }

    @Test
    public void shouldUseSpecifiedNameForSplitOperation() {
        this.builder.stream(STREAM_TOPIC).split(Named.as((String)"branch-processor")).branch((k, v) -> true, Branched.as((String)"-1")).branch((k, v) -> false, Branched.as((String)"-2"));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", "branch-processor", "branch-processor-1", "branch-processor-2");
    }

    @Test
    public void shouldUseSpecifiedNameForJoinOperationBetweenKStreamAndKTable() {
        KStream streamOne = this.builder.stream(STREAM_TOPIC);
        KTable streamTwo = this.builder.table(TABLE_TOPIC);
        streamOne.join(streamTwo, (value1, value2) -> value1, Joined.as((String)STREAM_OPERATION_NAME));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", "KSTREAM-SOURCE-0000000002", "KTABLE-SOURCE-0000000003", STREAM_OPERATION_NAME);
    }

    @Test
    public void shouldUseSpecifiedNameForLeftJoinOperationBetweenKStreamAndKTable() {
        KStream streamOne = this.builder.stream(STREAM_TOPIC);
        KTable streamTwo = this.builder.table(STREAM_TOPIC_TWO);
        streamOne.leftJoin(streamTwo, (value1, value2) -> value1, Joined.as((String)STREAM_OPERATION_NAME));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", "KSTREAM-SOURCE-0000000002", "KTABLE-SOURCE-0000000003", STREAM_OPERATION_NAME);
    }

    @Test
    public void shouldNotAddThirdStateStoreIfStreamStreamJoinFixIsDisabledViaOldApi() {
        KStream streamOne = this.builder.stream(STREAM_TOPIC);
        KStream streamTwo = this.builder.stream(STREAM_TOPIC_TWO);
        streamOne.leftJoin(streamTwo, (value1, value2) -> value1, JoinWindows.of((Duration)Duration.ofHours(1L)), StreamJoined.as((String)STREAM_OPERATION_NAME).withName(STREAM_OPERATION_NAME));
        Properties properties = new Properties();
        this.builder.build(properties);
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForStateStore(topology.stateStores(), "stream-operation-this-join-store", "stream-operation-outer-other-join-store");
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", "KSTREAM-SOURCE-0000000001", "stream-operation-this-windowed", "stream-operation-other-windowed", "stream-operation-this-join", "stream-operation-outer-other-join", "stream-operation-merge");
    }

    @Test
    public void shouldUseSpecifiedNameForLeftJoinOperationBetweenKStreamAndKStream() {
        KStream streamOne = this.builder.stream(STREAM_TOPIC);
        KStream streamTwo = this.builder.stream(STREAM_TOPIC_TWO);
        streamOne.leftJoin(streamTwo, (value1, value2) -> value1, JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofHours(1L)), StreamJoined.as((String)STREAM_OPERATION_NAME).withName(STREAM_OPERATION_NAME));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForStateStore(topology.stateStores(), "stream-operation-this-join-store", "stream-operation-outer-other-join-store", "stream-operation-left-shared-join-store");
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", "KSTREAM-SOURCE-0000000001", "stream-operation-this-windowed", "stream-operation-other-windowed", "stream-operation-this-join", "stream-operation-outer-other-join", "stream-operation-merge");
    }

    @Test
    public void shouldUseGeneratedStoreNamesForLeftJoinOperationBetweenKStreamAndKStream() {
        KStream streamOne = this.builder.stream(STREAM_TOPIC);
        KStream streamTwo = this.builder.stream(STREAM_TOPIC_TWO);
        streamOne.leftJoin(streamTwo, (value1, value2) -> value1, JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofHours(1L)), StreamJoined.with((Serde)Serdes.String(), (Serde)Serdes.String(), (Serde)Serdes.String()).withName(STREAM_OPERATION_NAME));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForStateStore(topology.stateStores(), "KSTREAM-JOINTHIS-0000000004-store", "KSTREAM-OUTEROTHER-0000000005-store", "KSTREAM-OUTERSHARED-0000000004-store");
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", "KSTREAM-SOURCE-0000000001", "stream-operation-this-windowed", "stream-operation-other-windowed", "stream-operation-this-join", "stream-operation-outer-other-join", "stream-operation-merge");
    }

    @Test
    public void shouldUseSpecifiedNameForJoinOperationBetweenKStreamAndKStream() {
        KStream streamOne = this.builder.stream(STREAM_TOPIC);
        KStream streamTwo = this.builder.stream(STREAM_TOPIC_TWO);
        streamOne.join(streamTwo, (value1, value2) -> value1, JoinWindows.of((Duration)Duration.ofHours(1L)), StreamJoined.as((String)STREAM_OPERATION_NAME).withName(STREAM_OPERATION_NAME));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForStateStore(topology.stateStores(), "stream-operation-this-join-store", "stream-operation-other-join-store");
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", "KSTREAM-SOURCE-0000000001", "stream-operation-this-windowed", "stream-operation-other-windowed", "stream-operation-this-join", "stream-operation-other-join", "stream-operation-merge");
    }

    @Test
    public void shouldUseGeneratedNameForJoinOperationBetweenKStreamAndKStream() {
        KStream streamOne = this.builder.stream(STREAM_TOPIC);
        KStream streamTwo = this.builder.stream(STREAM_TOPIC_TWO);
        streamOne.join(streamTwo, (value1, value2) -> value1, JoinWindows.of((Duration)Duration.ofHours(1L)), StreamJoined.with((Serde)Serdes.String(), (Serde)Serdes.String(), (Serde)Serdes.String()).withName(STREAM_OPERATION_NAME));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForStateStore(topology.stateStores(), "KSTREAM-JOINTHIS-0000000004-store", "KSTREAM-JOINOTHER-0000000005-store");
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", "KSTREAM-SOURCE-0000000001", "stream-operation-this-windowed", "stream-operation-other-windowed", "stream-operation-this-join", "stream-operation-other-join", "stream-operation-merge");
    }

    @Test
    public void shouldUseSpecifiedNameForOuterJoinOperationBetweenKStreamAndKStream() {
        KStream streamOne = this.builder.stream(STREAM_TOPIC);
        KStream streamTwo = this.builder.stream(STREAM_TOPIC_TWO);
        streamOne.outerJoin(streamTwo, (value1, value2) -> value1, JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofHours(1L)), StreamJoined.as((String)STREAM_OPERATION_NAME).withName(STREAM_OPERATION_NAME));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForStateStore(topology.stateStores(), "stream-operation-outer-this-join-store", "stream-operation-outer-other-join-store", "stream-operation-outer-shared-join-store");
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", "KSTREAM-SOURCE-0000000001", "stream-operation-this-windowed", "stream-operation-other-windowed", "stream-operation-outer-this-join", "stream-operation-outer-other-join", "stream-operation-merge");
    }

    @Test
    public void shouldUseGeneratedStoreNamesForOuterJoinOperationBetweenKStreamAndKStream() {
        KStream streamOne = this.builder.stream(STREAM_TOPIC);
        KStream streamTwo = this.builder.stream(STREAM_TOPIC_TWO);
        streamOne.outerJoin(streamTwo, (value1, value2) -> value1, JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofHours(1L)), StreamJoined.with((Serde)Serdes.String(), (Serde)Serdes.String(), (Serde)Serdes.String()).withName(STREAM_OPERATION_NAME));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForStateStore(topology.stateStores(), "KSTREAM-OUTERTHIS-0000000004-store", "KSTREAM-OUTEROTHER-0000000005-store", "KSTREAM-OUTERSHARED-0000000004-store");
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", "KSTREAM-SOURCE-0000000001", "stream-operation-this-windowed", "stream-operation-other-windowed", "stream-operation-outer-this-join", "stream-operation-outer-other-join", "stream-operation-merge");
    }

    @Test
    public void shouldUseSpecifiedDslStoreSuppliersForAllOuterJoinOperationBetweenKStreamAndKStream() {
        KStream streamOne = this.builder.stream(STREAM_TOPIC);
        KStream streamTwo = this.builder.stream(STREAM_TOPIC_TWO);
        streamOne.outerJoin(streamTwo, (value1, value2) -> value1, JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofHours(1L)), StreamJoined.as((String)STREAM_OPERATION_NAME).withName(STREAM_OPERATION_NAME).withDslStoreSuppliers(BuiltInDslStoreSuppliers.IN_MEMORY));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertTypesForStateStore(topology.stateStores(), InMemoryWindowStore.class, InMemoryWindowStore.class, InMemoryKeyValueStore.class);
    }

    @Test
    public void shouldUseConfiguredInStreamsConfigIfNoTopologyOverrideDslStoreSuppliersForAllOuterJoinOperationBetweenKStreamAndKStream() {
        KStream streamOne = this.builder.stream(STREAM_TOPIC);
        KStream streamTwo = this.builder.stream(STREAM_TOPIC_TWO);
        streamOne.outerJoin(streamTwo, (value1, value2) -> value1, JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofHours(1L)), StreamJoined.as((String)STREAM_OPERATION_NAME).withName(STREAM_OPERATION_NAME));
        this.builder.build();
        this.props.put("dsl.store.suppliers.class", BuiltInDslStoreSuppliers.InMemoryDslStoreSuppliers.class);
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertTypesForStateStore(topology.stateStores(), InMemoryWindowStore.class, InMemoryWindowStore.class, InMemoryKeyValueStore.class);
    }

    @Test
    public void shouldUseConfiguredTopologyOverrideDslStoreSuppliersForAllOuterJoinOperationBetweenKStreamAndKStream() {
        Properties topoOverrides = new Properties();
        topoOverrides.putAll((Map<?, ?>)this.props);
        topoOverrides.put("dsl.store.suppliers.class", BuiltInDslStoreSuppliers.InMemoryDslStoreSuppliers.class);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig((Map)topoOverrides)));
        KStream streamOne = builder.stream(STREAM_TOPIC);
        KStream streamTwo = builder.stream(STREAM_TOPIC_TWO);
        streamOne.outerJoin(streamTwo, (value1, value2) -> value1, JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofHours(1L)), StreamJoined.as((String)STREAM_OPERATION_NAME).withName(STREAM_OPERATION_NAME));
        builder.build();
        this.props.put("dsl.store.suppliers.class", BuiltInDslStoreSuppliers.RocksDBDslStoreSuppliers.class);
        ProcessorTopology topology = builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertTypesForStateStore(topology.stateStores(), InMemoryWindowStore.class, InMemoryWindowStore.class, InMemoryKeyValueStore.class);
    }

    @Test
    public void shouldUseSpecifiedStoreSupplierForEachOuterJoinOperationBetweenKStreamAndKStreamAndUseSameTypeAsThisSupplierForOuter() {
        KStream streamOne = this.builder.stream(STREAM_TOPIC);
        KStream streamTwo = this.builder.stream(STREAM_TOPIC_TWO);
        JoinWindows windows = JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofHours(1L));
        streamOne.outerJoin(streamTwo, (value1, value2) -> value1, windows, StreamJoined.as((String)STREAM_OPERATION_NAME).withName(STREAM_OPERATION_NAME).withThisStoreSupplier(Stores.inMemoryWindowStore((String)"thisSupplier", (Duration)Duration.ofMillis(windows.size() + windows.gracePeriodMs()), (Duration)Duration.ofMillis(windows.size()), (boolean)true)).withOtherStoreSupplier(Stores.persistentWindowStore((String)"otherSupplier", (Duration)Duration.ofMillis(windows.size() + windows.gracePeriodMs()), (Duration)Duration.ofMillis(windows.size()), (boolean)true)));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertTypesForStateStore(topology.stateStores(), InMemoryWindowStore.class, RocksDBWindowStore.class, InMemoryKeyValueStore.class);
    }

    @Test
    public void shouldUseSpecifiedStoreSuppliersOuterJoinStoreEvenIfThisSupplierIsSupplied() {
        KStream streamOne = this.builder.stream(STREAM_TOPIC);
        KStream streamTwo = this.builder.stream(STREAM_TOPIC_TWO);
        JoinWindows windows = JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofHours(1L));
        streamOne.outerJoin(streamTwo, (value1, value2) -> value1, windows, StreamJoined.as((String)STREAM_OPERATION_NAME).withName(STREAM_OPERATION_NAME).withDslStoreSuppliers(BuiltInDslStoreSuppliers.ROCKS_DB).withThisStoreSupplier(Stores.inMemoryWindowStore((String)"thisSupplier", (Duration)Duration.ofMillis(windows.size() + windows.gracePeriodMs()), (Duration)Duration.ofMillis(windows.size()), (boolean)true)).withOtherStoreSupplier(Stores.persistentWindowStore((String)"otherSupplier", (Duration)Duration.ofMillis(windows.size() + windows.gracePeriodMs()), (Duration)Duration.ofMillis(windows.size()), (boolean)true)));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertTypesForStateStore(topology.stateStores(), InMemoryWindowStore.class, RocksDBWindowStore.class, RocksDBStore.class);
    }

    @Test
    public void shouldUseThisStoreSupplierEvenIfDslStoreSuppliersConfiguredInTopologyConfig() {
        Properties topoOverrides = new Properties();
        topoOverrides.putAll((Map<?, ?>)this.props);
        topoOverrides.put("dsl.store.suppliers.class", BuiltInDslStoreSuppliers.RocksDBDslStoreSuppliers.class);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig((Map)topoOverrides)));
        KStream streamOne = builder.stream(STREAM_TOPIC);
        KStream streamTwo = builder.stream(STREAM_TOPIC_TWO);
        JoinWindows windows = JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofHours(1L));
        streamOne.outerJoin(streamTwo, (value1, value2) -> value1, windows, StreamJoined.as((String)STREAM_OPERATION_NAME).withName(STREAM_OPERATION_NAME).withThisStoreSupplier(Stores.inMemoryWindowStore((String)"thisSupplier", (Duration)Duration.ofMillis(windows.size() + windows.gracePeriodMs()), (Duration)Duration.ofMillis(windows.size()), (boolean)true)).withOtherStoreSupplier(Stores.persistentWindowStore((String)"otherSupplier", (Duration)Duration.ofMillis(windows.size() + windows.gracePeriodMs()), (Duration)Duration.ofMillis(windows.size()), (boolean)true)));
        builder.build();
        ProcessorTopology topology = builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertTypesForStateStore(topology.stateStores(), InMemoryWindowStore.class, RocksDBWindowStore.class, InMemoryKeyValueStore.class);
    }

    @Test
    public void shouldUseSpecifiedNameForMergeOperation() {
        String topic1 = "topic-1";
        String topic2 = "topic-2";
        KStream source1 = this.builder.stream("topic-1");
        KStream source2 = this.builder.stream("topic-2");
        source1.merge(source2, Named.as((String)"merge-processor"));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", "KSTREAM-SOURCE-0000000001", "merge-processor");
    }

    @Test
    public void shouldUseSpecifiedNameForProcessOperation() {
        this.builder.stream(STREAM_TOPIC).process(new MockApiProcessorSupplier(), Named.as((String)"test-processor"), new String[0]);
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", "test-processor");
    }

    @Test
    public void shouldUseSpecifiedNameForProcessValuesOperation() {
        this.builder.stream(STREAM_TOPIC).processValues(new MockApiFixedKeyProcessorSupplier(), Named.as((String)"test-fixed-key-processor"), new String[0]);
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", "test-fixed-key-processor");
    }

    @Test
    public void shouldUseSpecifiedNameForPrintOperation() {
        this.builder.stream(STREAM_TOPIC).print(Printed.toSysOut().withName("print-processor"));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", "print-processor");
    }

    @Test
    public void shouldUseSpecifiedNameForToStream() {
        this.builder.table(STREAM_TOPIC).toStream(Named.as((String)"to-stream"));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000001", "KTABLE-SOURCE-0000000002", "to-stream");
    }

    @Test
    public void shouldUseSpecifiedNameForToStreamWithMapper() {
        this.builder.table(STREAM_TOPIC).toStream(KeyValue::pair, Named.as((String)"to-stream"));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000001", "KTABLE-SOURCE-0000000002", "to-stream", "KSTREAM-KEY-SELECT-0000000004");
    }

    @Test
    public void shouldUseSpecifiedNameForAggregateOperationGivenTable() {
        this.builder.table(STREAM_TOPIC).groupBy(KeyValue::pair, Grouped.as((String)"group-operation")).count(Named.as((String)STREAM_OPERATION_NAME));
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildTopology();
        StreamsBuilderTest.assertNamesForStateStore(topology.stateStores(), "stream-topic-STATE-STORE-0000000000", "KTABLE-AGGREGATE-STATE-STORE-0000000004");
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000001", "KTABLE-SOURCE-0000000002", "group-operation", "stream-operation-sink", "stream-operation-source", STREAM_OPERATION_NAME);
    }

    @Test
    public void shouldUseSpecifiedNameForGlobalStoreProcessor() {
        this.builder.addGlobalStore(Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"store"), (Serde)Serdes.String(), (Serde)Serdes.String()), "topic", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()).withName("test"), new MockApiProcessorSupplier());
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildGlobalStateTopology();
        StreamsBuilderTest.assertNamesForOperation(topology, "test-source", "test");
    }

    @Test
    public void shouldUseDefaultNameForGlobalStoreProcessor() {
        this.builder.addGlobalStore(Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"store"), (Serde)Serdes.String(), (Serde)Serdes.String()), "topic", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()), new MockApiProcessorSupplier());
        this.builder.build();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)this.props)).buildGlobalStateTopology();
        StreamsBuilderTest.assertNamesForOperation(topology, "KSTREAM-SOURCE-0000000000", "KTABLE-SOURCE-0000000001");
    }

    @Test
    public void shouldWrapProcessorsForProcess() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        final Random random = new Random();
        final StoreBuilder store = Stores.timestampedKeyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"store"), (Serde)Serdes.String(), (Serde)Serdes.String());
        builder.stream("input", Consumed.as((String)"source")).process((ProcessorSupplier)new ProcessorSupplier<Object, Object, Object, Object>(){

            public Processor<Object, Object, Object, Object> get() {
                return record -> System.out.println("Processing: " + random.nextInt());
            }

            public Set<StoreBuilder<?>> stores() {
                return Collections.singleton(store);
            }
        }, Named.as((String)"stateful-process-1"), new String[0]).process((ProcessorSupplier)new ProcessorSupplier<Object, Object, Object, Object>(){

            public Processor<Object, Object, Object, Object> get() {
                return record -> System.out.println("Processing: " + random.nextInt());
            }

            public Set<StoreBuilder<?>> stores() {
                return Collections.singleton(store);
            }
        }, Named.as((String)"stateful-process-2"), new String[0]).processValues(() -> record -> System.out.println("Processing values: " + random.nextInt()), Named.as((String)"stateless-processValues"), new String[0]).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"stateful-process-1", "stateful-process-2", "stateless-processValues"}));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void shouldWrapProcessorsForStreamReduce() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        builder.stream("input", Consumed.as((String)"source")).groupBy(KeyValue::new, Grouped.as((String)"groupBy")).reduce((l, r) -> l, Named.as((String)"reduce"), Materialized.as((String)"store")).toStream(Named.as((String)"toStream")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"groupBy", "groupBy-repartition-filter", "reduce", "toStream"}));
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void shouldWrapProcessorsForStreamAggregate() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        builder.stream("input", Consumed.as((String)"source")).groupByKey().count(Named.as((String)"count")).toStream(Named.as((String)"toStream")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"count", "toStream"}));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void shouldWrapProcessorsForSuppress() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        builder.stream("input", Consumed.as((String)"source")).groupByKey().count(Named.as((String)"count")).suppress(Suppressed.untilTimeLimit((Duration)Duration.ofSeconds(10L), (Suppressed.BufferConfig)Suppressed.BufferConfig.unbounded()).withName("suppressed")).toStream(Named.as((String)"toStream")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"count", "toStream", "suppressed"}));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void shouldWrapProcessorsForTimeWindowStreamAggregate() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        builder.stream("input", Consumed.as((String)"source")).groupByKey().windowedBy((Windows)TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofDays(1L))).count(Named.as((String)"count")).toStream(Named.as((String)"toStream")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"count", "toStream"}));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void shouldWrapProcessorsForSlidingWindowStreamAggregate() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        builder.stream("input", Consumed.as((String)"source")).groupByKey().windowedBy(SlidingWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofDays(1L))).count(Named.as((String)"count")).toStream(Named.as((String)"toStream")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"count", "toStream"}));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void shouldWrapProcessorsForSessionWindowStreamAggregate() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        builder.stream("input", Consumed.as((String)"source")).groupByKey().windowedBy(SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofDays(1L))).count(Named.as((String)"count")).toStream(Named.as((String)"toStream")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"count", "toStream"}));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void shouldWrapProcessorsForCoGroupedStreamAggregate() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        KStream stream1 = builder.stream("one", Consumed.as((String)"source-1"));
        KStream stream2 = builder.stream("two", Consumed.as((String)"source-2"));
        KGroupedStream grouped1 = stream1.groupByKey(Grouped.as((String)"groupByKey-1"));
        KGroupedStream grouped2 = stream2.groupByKey(Grouped.as((String)"groupByKey-2"));
        grouped1.cogroup((k, v, a) -> String.valueOf(a) + v).cogroup(grouped2, (k, v, a) -> String.valueOf(a) + v).aggregate(() -> "", Named.as((String)"aggregate"), Materialized.as((String)"store")).toStream(Named.as((String)"toStream")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"aggregate-cogroup-agg-0", "aggregate-cogroup-agg-1", "aggregate-cogroup-merge", "toStream"}));
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void shouldWrapProcessorsForMapValuesWithMaterializedStore() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        builder.table("input", Consumed.as((String)"source-table")).mapValues(v -> null, Named.as((String)"map-values"), Materialized.as((String)"map-values-store")).toStream(Named.as((String)"to-stream")).to("output-topic", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"source-table", "map-values", "to-stream"}));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldWrapProcessorAndStoreForFilterTable() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        builder.table("input", Consumed.as((String)"source-table")).filter((k, v) -> true, Named.as((String)"filter"), Materialized.as((String)"filter")).toStream(Named.as((String)"to-stream")).to("output-topic", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"source-table", "filter", "to-stream"}));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldWrapProcessorsForTableAggregate() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        builder.table("input", Consumed.as((String)"source-table")).groupBy(KeyValue::new, Grouped.as((String)"groupBy")).count(Named.as((String)"count")).toStream(Named.as((String)"toStream")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"source-table", "groupBy", "count", "toStream"}));
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void shouldWrapProcessorsForTableReduce() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        builder.table("input", Consumed.as((String)"source-table")).groupBy(KeyValue::new, Grouped.as((String)"groupBy")).reduce((l, r) -> "", (l, r) -> "", Named.as((String)"reduce"), Materialized.as((String)"store")).toStream(Named.as((String)"toStream")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"source-table", "groupBy", "reduce", "toStream"}));
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void shouldWrapProcessorsForStatelessOperators() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        builder.stream("input", Consumed.as((String)"source")).filter((k, v) -> true, Named.as((String)"filter-stream")).map(KeyValue::new, Named.as((String)"map")).selectKey((k, v) -> k, Named.as((String)"selectKey")).peek((k, v) -> {}, Named.as((String)"peek")).flatMapValues(e -> new ArrayList(), Named.as((String)"flatMap")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"filter-stream", "map", "selectKey", "peek", "flatMap"}));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void shouldWrapProcessorsWhenMultipleTableOperators() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        builder.stream("input", Consumed.as((String)"source")).toTable(Named.as((String)"to-table")).mapValues(v -> v, Named.as((String)"map-values")).mapValues(v -> v, Named.as((String)"map-values-stateful"), Materialized.as((String)"map-values-stateful")).filter((k, v) -> true, Named.as((String)"filter-table")).filter((k, v) -> true, Named.as((String)"filter-table-stateful"), Materialized.as((String)"filter-table-stateful")).toStream(Named.as((String)"to-stream")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)6));
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"to-table", "map-values", "map-values-stateful", "filter-table", "filter-table-stateful", "to-stream"}));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void shouldWrapProcessorsForUnmaterializedSourceTable() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        builder.table("input", Consumed.as((String)"source")).toStream(Named.as((String)"toStream")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"source", "toStream"}));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void shouldWrapProcessorsForMaterializedSourceTable() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        builder.table("input", Consumed.as((String)"source"), Materialized.as((String)"store")).toStream(Named.as((String)"toStream")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"source", "toStream"}));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void shouldWrapProcessorsForStreamStreamInnerJoin() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        KStream stream1 = builder.stream("input-1", Consumed.as((String)"source-1"));
        KStream stream2 = builder.stream("input-2", Consumed.as((String)"source-2"));
        stream1.join(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofDays(1L), (Duration)Duration.ofDays(1L)), StreamJoined.as((String)"ss-join")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"KSTREAM-JOINTHIS-0000000004", "KSTREAM-JOINOTHER-0000000005", "KSTREAM-WINDOWED-0000000003", "KSTREAM-WINDOWED-0000000002", "KSTREAM-MERGE-0000000006"}));
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void shouldWrapProcessorsForStreamStreamLeftJoin() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        KStream stream1 = builder.stream("input-1", Consumed.as((String)"source-1"));
        KStream stream2 = builder.stream("input-2", Consumed.as((String)"source-2"));
        stream1.leftJoin(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofDays(1L), (Duration)Duration.ofDays(1L)), StreamJoined.as((String)"ss-join")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"KSTREAM-JOINTHIS-0000000004", "KSTREAM-OUTEROTHER-0000000005", "KSTREAM-WINDOWED-0000000003", "KSTREAM-WINDOWED-0000000002", "KSTREAM-MERGE-0000000006"}));
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)6));
    }

    @Test
    public void shouldWrapProcessorsForStreamStreamOuterJoin() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        KStream stream1 = builder.stream("input-1", Consumed.as((String)"source-1"));
        KStream stream2 = builder.stream("input-2", Consumed.as((String)"source-2"));
        stream1.outerJoin(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofDays(1L), (Duration)Duration.ofDays(1L)), StreamJoined.as((String)"ss-join")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"KSTREAM-OUTERTHIS-0000000004", "KSTREAM-OUTEROTHER-0000000005", "KSTREAM-WINDOWED-0000000003", "KSTREAM-WINDOWED-0000000002", "KSTREAM-MERGE-0000000006"}));
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)6));
    }

    @Test
    public void shouldWrapProcessorsForStreamStreamOuterJoinWithoutSpuriousResultsFix() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        KStream stream1 = builder.stream("input-1", Consumed.as((String)"source-1"));
        KStream stream2 = builder.stream("input-2", Consumed.as((String)"source-2"));
        stream1.outerJoin(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.of((Duration)Duration.ofDays(1L)), StreamJoined.as((String)"ss-join")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"KSTREAM-OUTERTHIS-0000000004", "KSTREAM-OUTEROTHER-0000000005", "KSTREAM-WINDOWED-0000000003", "KSTREAM-WINDOWED-0000000002", "KSTREAM-MERGE-0000000006"}));
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void shouldWrapProcessorsForStreamStreamSelfJoin() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        KStream stream1 = builder.stream("input", Consumed.as((String)"source"));
        stream1.join(stream1, MockValueJoiner.TOSTRING_JOINER, JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofDays(1L)), StreamJoined.as((String)"ss-join")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"KSTREAM-JOINTHIS-0000000003", "KSTREAM-JOINOTHER-0000000004", "KSTREAM-WINDOWED-0000000001", "KSTREAM-WINDOWED-0000000002", "KSTREAM-MERGE-0000000005"}));
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void shouldWrapProcessorsForStreamStreamSelfJoinWithSharedStoreOptimization() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        props.put("topology.optimization", "all");
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        KStream stream1 = builder.stream("input", Consumed.as((String)"source"));
        stream1.join(stream1, MockValueJoiner.TOSTRING_JOINER, JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofDays(1L)), StreamJoined.as((String)"ss-join")).to("output", Produced.as((String)"sink"));
        Properties properties = new Properties();
        properties.putAll(props);
        builder.build(properties);
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"KSTREAM-WINDOWED-0000000001", "KSTREAM-MERGE-0000000005"}));
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void shouldWrapProcessorsForStreamTableJoin() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        KStream stream = builder.stream("input", Consumed.as((String)"source-stream"));
        KTable table = builder.table("input-table", Consumed.as((String)"source-table"));
        stream.join(table, MockValueJoiner.TOSTRING_JOINER, Joined.as((String)"st-join")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"source-table", "st-join"}));
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void shouldWrapProcessorsForStreamTableJoinWithGracePeriod() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        KStream stream = builder.stream("input", Consumed.as((String)"source-stream"));
        KTable table = builder.table("input-table", Consumed.as((String)"versioned-source-table"), Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"table-store", (Duration)Duration.ofDays(1L))));
        stream.join(table, MockValueJoiner.TOSTRING_JOINER, Joined.as((String)"st-join").withGracePeriod(Duration.ofDays(1L))).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat(counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"versioned-source-table", "st-join"}));
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void shouldWrapProcessorsForTableTableInnerJoin() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        KTable t1 = builder.table("input1", Consumed.as((String)"input1"));
        KTable t2 = builder.table("input2", Consumed.as((String)"input2"));
        t1.join(t2, (v1, v2) -> v1 + v2, Named.as((String)"join-processor"), Materialized.as((String)"the_join")).toStream(Named.as((String)"toStream")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)6));
        MatcherAssert.assertThat((String)counter.wrappedProcessorNames().toString(), counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"input1", "input2", "join-processor-join-this", "join-processor-join-other", "join-processor", "toStream"}));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void shouldWrapProcessorsForTableTableLeftJoin() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        KTable t1 = builder.table("input1", Consumed.as((String)"input1"));
        KTable t2 = builder.table("input2", Consumed.as((String)"input2"));
        t1.leftJoin(t2, (v1, v2) -> v1 + v2, Named.as((String)"join-processor"), Materialized.as((String)"the_join")).toStream(Named.as((String)"toStream")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)6));
        MatcherAssert.assertThat((String)counter.wrappedProcessorNames().toString(), counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"input1", "input2", "join-processor-join-this", "join-processor-join-other", "join-processor", "toStream"}));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void shouldWrapProcessorsForTableTableOuterJoin() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        KTable t1 = builder.table("input1", Consumed.as((String)"input1"));
        KTable t2 = builder.table("input2", Consumed.as((String)"input2"));
        t1.outerJoin(t2, (v1, v2) -> v1 + v2, Named.as((String)"join-processor"), Materialized.as((String)"the_join")).toStream(Named.as((String)"toStream")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)6));
        MatcherAssert.assertThat((String)counter.wrappedProcessorNames().toString(), counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"input1", "input2", "join-processor-join-this", "join-processor-join-other", "join-processor", "toStream"}));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void shouldWrapProcessorsForForeignKeyInnerJoin() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        KTable left = builder.table("input1", Consumed.as((String)"input1"));
        KTable right = builder.table("input2", Consumed.as((String)"input2"));
        left.join(right, value -> value, (v1, v2) -> v1 + v2, TableJoined.as((String)"join"), Materialized.as((String)"materialized-store").withValueSerde(Serdes.String())).toStream(Named.as((String)"toStream")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)9));
        MatcherAssert.assertThat((String)counter.wrappedProcessorNames().toString(), counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"input1", "input2", "join-foreign-join-subscription", "join-subscription-join-foreign", "join-subscription-registration-processor", "join-subscription-receive", "join-result", "join-subscription-response-resolver", "toStream"}));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)5));
    }

    @Test
    public void shouldWrapProcessorsForForeignKeyLeftJoin() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", TestUtils.RecordingProcessorWrapper.class);
        TestUtils.RecordingProcessorWrapper.WrapperRecorder counter = new TestUtils.RecordingProcessorWrapper.WrapperRecorder();
        props.put("wrapped.counter", counter);
        StreamsBuilder builder = new StreamsBuilder(new TopologyConfig(new StreamsConfig(props)));
        KTable left = builder.table("input1", Consumed.as((String)"input1"));
        KTable right = builder.table("input2", Consumed.as((String)"input2"));
        left.leftJoin(right, value -> value, (v1, v2) -> v1 + v2, TableJoined.as((String)"l-join"), Materialized.as((String)"materialized-store").withValueSerde(Serdes.String())).toStream(Named.as((String)"toStream")).to("output", Produced.as((String)"sink"));
        builder.build();
        MatcherAssert.assertThat((Object)counter.numWrappedProcessors(), (Matcher)CoreMatchers.is((Object)9));
        MatcherAssert.assertThat((String)counter.wrappedProcessorNames().toString(), counter.wrappedProcessorNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"input1", "input2", "l-join-foreign-join-subscription", "l-join-subscription-join-foreign", "l-join-subscription-registration-processor", "l-join-subscription-receive", "l-join-result", "l-join-subscription-response-resolver", "toStream"}));
        MatcherAssert.assertThat((Object)counter.numUniqueStateStores(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)counter.numConnectedStateStores(), (Matcher)CoreMatchers.is((Object)5));
    }

    @Test
    public void shouldAllowStreamsFromSameTopic() {
        this.builder.stream("topic");
        this.builder.stream("topic");
        StreamsBuilderTest.assertBuildDoesNotThrow(this.builder);
    }

    @Test
    public void shouldAllowSubscribingToSamePattern() {
        this.builder.stream(Pattern.compile("some-regex"));
        this.builder.stream(Pattern.compile("some-regex"));
        StreamsBuilderTest.assertBuildDoesNotThrow(this.builder);
    }

    @Test
    public void shouldAllowReadingFromSameCollectionOfTopics() {
        this.builder.stream(Arrays.asList("topic1", "topic2"));
        this.builder.stream(Arrays.asList("topic2", "topic1"));
        StreamsBuilderTest.assertBuildDoesNotThrow(this.builder);
    }

    @Test
    public void shouldNotAllowReadingFromOverlappingAndUnequalCollectionOfTopics() {
        this.builder.stream(Collections.singletonList("topic"));
        this.builder.stream(Arrays.asList("topic", "anotherTopic"));
        Assertions.assertThrows(TopologyException.class, () -> ((StreamsBuilder)this.builder).build());
    }

    @Test
    public void shouldThrowWhenSubscribedToATopicWithDifferentResetPolicies() {
        this.builder.stream("topic", Consumed.with((Topology.AutoOffsetReset)Topology.AutoOffsetReset.EARLIEST));
        this.builder.stream("topic", Consumed.with((Topology.AutoOffsetReset)Topology.AutoOffsetReset.LATEST));
        Assertions.assertThrows(TopologyException.class, () -> ((StreamsBuilder)this.builder).build());
    }

    @Test
    public void shouldThrowWhenSubscribedToATopicWithSetAndUnsetResetPolicies() {
        this.builder.stream("topic", Consumed.with((Topology.AutoOffsetReset)Topology.AutoOffsetReset.EARLIEST));
        this.builder.stream("topic");
        Assertions.assertThrows(TopologyException.class, () -> ((StreamsBuilder)this.builder).build());
    }

    @Test
    public void shouldThrowWhenSubscribedToATopicWithUnsetAndSetResetPolicies() {
        this.builder.stream("another-topic");
        this.builder.stream("another-topic", Consumed.with((Topology.AutoOffsetReset)Topology.AutoOffsetReset.LATEST));
        Assertions.assertThrows(TopologyException.class, () -> ((StreamsBuilder)this.builder).build());
    }

    @Test
    public void shouldThrowWhenSubscribedToAPatternWithDifferentResetPolicies() {
        this.builder.stream(Pattern.compile("some-regex"), Consumed.with((Topology.AutoOffsetReset)Topology.AutoOffsetReset.EARLIEST));
        this.builder.stream(Pattern.compile("some-regex"), Consumed.with((Topology.AutoOffsetReset)Topology.AutoOffsetReset.LATEST));
        Assertions.assertThrows(TopologyException.class, () -> ((StreamsBuilder)this.builder).build());
    }

    @Test
    public void shouldThrowWhenSubscribedToAPatternWithSetAndUnsetResetPolicies() {
        this.builder.stream(Pattern.compile("some-regex"), Consumed.with((Topology.AutoOffsetReset)Topology.AutoOffsetReset.EARLIEST));
        this.builder.stream(Pattern.compile("some-regex"));
        Assertions.assertThrows(TopologyException.class, () -> ((StreamsBuilder)this.builder).build());
    }

    @Test
    public void shouldNotAllowTablesFromSameTopic() {
        this.builder.table("topic");
        this.builder.table("topic");
        Assertions.assertThrows(TopologyException.class, () -> ((StreamsBuilder)this.builder).build());
    }

    @Test
    public void shouldNowAllowStreamAndTableFromSameTopic() {
        this.builder.stream("topic");
        this.builder.table("topic");
        Assertions.assertThrows(TopologyException.class, () -> ((StreamsBuilder)this.builder).build());
    }

    private static void assertBuildDoesNotThrow(StreamsBuilder builder) {
        try {
            builder.build();
        }
        catch (TopologyException topologyException) {
            Assertions.fail((String)"TopologyException not expected");
        }
    }

    private static void assertNamesForOperation(ProcessorTopology topology, String ... expected) {
        List processors = topology.processors();
        Assertions.assertEquals((int)expected.length, (int)processors.size(), (String)"Invalid number of expected processors");
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)((ProcessorNode)processors.get(i)).name());
        }
    }

    private static void assertNamesForStateStore(List<StateStore> stores, String ... expected) {
        Assertions.assertEquals((int)expected.length, (int)stores.size(), (String)"Invalid number of expected state stores");
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)stores.get(i).name());
        }
    }

    private static void assertTypesForStateStore(List<StateStore> stores, Class<?> ... expected) {
        Assertions.assertEquals((int)expected.length, (int)stores.size(), (String)"Invalid number of expected state stores");
        for (int i = 0; i < expected.length; ++i) {
            StateStore store = stores.get(i);
            while (store instanceof WrappedStateStore && !expected[i].isInstance(store)) {
                store = ((WrappedStateStore)store).wrapped();
            }
            MatcherAssert.assertThat((Object)store, (Matcher)CoreMatchers.instanceOf(expected[i]));
        }
    }
}

