/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals.metrics;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.internals.metrics.StreamsClientMetricsDelegatingReporter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class StreamsClientMetricsDelegatingReporterTest {
    private MockAdminClient mockAdminClient;
    private StreamsClientMetricsDelegatingReporter streamsClientMetricsDelegatingReporter;
    private KafkaMetric streamClientMetricOne;
    private KafkaMetric streamClientMetricTwo;
    private KafkaMetric streamClientMetricThree;
    private KafkaMetric kafkaMetricWithThreadIdTag;
    private final Object lock = new Object();
    private final MetricConfig metricConfig = new MetricConfig();

    StreamsClientMetricsDelegatingReporterTest() {
    }

    @BeforeEach
    public void setup() {
        this.mockAdminClient = new MockAdminClient();
        this.streamsClientMetricsDelegatingReporter = new StreamsClientMetricsDelegatingReporter((Admin)this.mockAdminClient, "adminClientId");
        HashMap<String, String> threadIdTagMap = new HashMap<String, String>();
        String threadId = "abcxyz-StreamThread-1";
        threadIdTagMap.put("thread-id", "abcxyz-StreamThread-1");
        MetricName metricNameOne = new MetricName("metricOne", "stream-metrics", "description for metric one", new HashMap());
        MetricName metricNameTwo = new MetricName("metricTwo", "stream-metrics", "description for metric two", new HashMap());
        MetricName metricNameThree = new MetricName("metricThree", "stream-metrics", "description for metric three", new HashMap());
        MetricName metricNameFour = new MetricName("metricThree", "thread-metrics", "description for metric three", threadIdTagMap);
        this.streamClientMetricOne = new KafkaMetric(this.lock, metricNameOne, (MetricValueProvider)((Measurable)(m, now) -> 1.0), this.metricConfig, Time.SYSTEM);
        this.streamClientMetricTwo = new KafkaMetric(this.lock, metricNameTwo, (MetricValueProvider)((Measurable)(m, now) -> 2.0), this.metricConfig, Time.SYSTEM);
        this.streamClientMetricThree = new KafkaMetric(this.lock, metricNameThree, (MetricValueProvider)((Measurable)(m, now) -> 3.0), this.metricConfig, Time.SYSTEM);
        this.kafkaMetricWithThreadIdTag = new KafkaMetric(this.lock, metricNameFour, (MetricValueProvider)((Measurable)(m, now) -> 4.0), this.metricConfig, Time.SYSTEM);
    }

    @AfterEach
    public void tearDown() {
        this.mockAdminClient.close();
    }

    @Test
    public void shouldInitMetrics() {
        List<KafkaMetric> metrics = Arrays.asList(this.streamClientMetricOne, this.streamClientMetricTwo, this.streamClientMetricThree, this.kafkaMetricWithThreadIdTag);
        this.streamsClientMetricsDelegatingReporter.init(metrics);
        List<KafkaMetric> expectedMetrics = Arrays.asList(this.streamClientMetricOne, this.streamClientMetricTwo, this.streamClientMetricThree);
        Assertions.assertEquals(expectedMetrics, (Object)this.mockAdminClient.addedMetrics(), (String)"Should register metrics from init method");
    }

    @Test
    public void shouldRegisterCorrectMetrics() {
        this.streamsClientMetricsDelegatingReporter.metricChange(this.kafkaMetricWithThreadIdTag);
        Assertions.assertEquals((int)0, (int)this.mockAdminClient.addedMetrics().size());
        this.streamsClientMetricsDelegatingReporter.metricChange(this.streamClientMetricOne);
        Assertions.assertEquals((int)1, (int)this.mockAdminClient.addedMetrics().size(), (String)"Should register client instance metrics only");
    }

    @Test
    public void metricRemoval() {
        this.streamsClientMetricsDelegatingReporter.metricChange(this.streamClientMetricOne);
        this.streamsClientMetricsDelegatingReporter.metricChange(this.streamClientMetricTwo);
        this.streamsClientMetricsDelegatingReporter.metricChange(this.streamClientMetricThree);
        Assertions.assertEquals((int)3, (int)this.mockAdminClient.addedMetrics().size());
        this.streamsClientMetricsDelegatingReporter.metricRemoval(this.streamClientMetricOne);
        Assertions.assertEquals((int)2, (int)this.mockAdminClient.addedMetrics().size(), (String)"Should remove client instance metrics");
    }
}

