/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals.metrics;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.internals.AutoOffsetResetStrategy;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.internals.metrics.StreamsThreadMetricsDelegatingReporter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class StreamsThreadMetricsDelegatingReporterTest {
    private MockConsumer<byte[], byte[]> mockConsumer;
    private StreamsThreadMetricsDelegatingReporter streamsThreadMetricsDelegatingReporter;
    private KafkaMetric kafkaMetricOneHasThreadIdTag;
    private KafkaMetric kafkaMetricTwoHasThreadIdTag;
    private KafkaMetric kafkaMetricThreeHasThreadIdTag;
    private KafkaMetric kafkaMetricWithoutThreadIdTag;
    private final Object lock = new Object();
    private final MetricConfig metricConfig = new MetricConfig();

    StreamsThreadMetricsDelegatingReporterTest() {
    }

    @BeforeEach
    public void setUp() {
        HashMap<String, String> threadIdTagMap = new HashMap<String, String>();
        String threadId = "abcxyz-StreamThread-1";
        threadIdTagMap.put("thread-id", "abcxyz-StreamThread-1");
        HashMap<String, String> threadIdWithStateUpdaterTagMap = new HashMap<String, String>();
        String stateUpdaterId = "deftuv-StateUpdater-1";
        threadIdWithStateUpdaterTagMap.put("thread-id", "deftuv-StateUpdater-1");
        HashMap<String, String> noThreadIdTagMap = new HashMap<String, String>();
        noThreadIdTagMap.put("client-id", "foo");
        this.mockConsumer = new MockConsumer(AutoOffsetResetStrategy.NONE.name());
        this.streamsThreadMetricsDelegatingReporter = new StreamsThreadMetricsDelegatingReporter(this.mockConsumer, "abcxyz-StreamThread-1", "deftuv-StateUpdater-1");
        MetricName metricNameOne = new MetricName("metric-one", "test-group-one", "foo bar baz", threadIdTagMap);
        MetricName metricNameTwo = new MetricName("metric-two", "test-group-two", "description two", threadIdWithStateUpdaterTagMap);
        MetricName metricNameThree = new MetricName("metric-three", "test-group-three", "description three", threadIdTagMap);
        MetricName metricNameFour = new MetricName("metric-four", "test-group-three", "description three", noThreadIdTagMap);
        this.kafkaMetricOneHasThreadIdTag = new KafkaMetric(this.lock, metricNameOne, (MetricValueProvider)((Measurable)(m, now) -> 1.0), this.metricConfig, Time.SYSTEM);
        this.kafkaMetricTwoHasThreadIdTag = new KafkaMetric(this.lock, metricNameTwo, (MetricValueProvider)((Measurable)(m, now) -> 2.0), this.metricConfig, Time.SYSTEM);
        this.kafkaMetricThreeHasThreadIdTag = new KafkaMetric(this.lock, metricNameThree, (MetricValueProvider)((Measurable)(m, now) -> 3.0), this.metricConfig, Time.SYSTEM);
        this.kafkaMetricWithoutThreadIdTag = new KafkaMetric(this.lock, metricNameFour, (MetricValueProvider)((Measurable)(m, now) -> 4.0), this.metricConfig, Time.SYSTEM);
    }

    @AfterEach
    public void tearDown() {
        this.mockConsumer.close();
    }

    @Test
    public void shouldInitMetrics() {
        List<KafkaMetric> allMetrics = Arrays.asList(this.kafkaMetricOneHasThreadIdTag, this.kafkaMetricTwoHasThreadIdTag, this.kafkaMetricThreeHasThreadIdTag);
        List<KafkaMetric> expectedMetrics = Arrays.asList(this.kafkaMetricOneHasThreadIdTag, this.kafkaMetricTwoHasThreadIdTag, this.kafkaMetricThreeHasThreadIdTag);
        this.streamsThreadMetricsDelegatingReporter.init(allMetrics);
        Assertions.assertEquals(expectedMetrics, (Object)this.mockConsumer.addedMetrics(), (String)"Init method should register metrics it receives as parameters");
    }

    @Test
    public void shouldRegisterMetrics() {
        this.streamsThreadMetricsDelegatingReporter.metricChange(this.kafkaMetricOneHasThreadIdTag);
        Assertions.assertEquals((Object)this.kafkaMetricOneHasThreadIdTag, this.mockConsumer.addedMetrics().get(0), (String)"Should register metrics with thread-id in tag map");
    }

    @Test
    public void shouldRemoveMetrics() {
        this.streamsThreadMetricsDelegatingReporter.metricChange(this.kafkaMetricOneHasThreadIdTag);
        this.streamsThreadMetricsDelegatingReporter.metricChange(this.kafkaMetricTwoHasThreadIdTag);
        this.streamsThreadMetricsDelegatingReporter.metricChange(this.kafkaMetricThreeHasThreadIdTag);
        List<KafkaMetric> expected = Arrays.asList(this.kafkaMetricOneHasThreadIdTag, this.kafkaMetricTwoHasThreadIdTag, this.kafkaMetricThreeHasThreadIdTag);
        Assertions.assertEquals(expected, (Object)this.mockConsumer.addedMetrics());
        this.streamsThreadMetricsDelegatingReporter.metricRemoval(this.kafkaMetricOneHasThreadIdTag);
        expected = Arrays.asList(this.kafkaMetricTwoHasThreadIdTag, this.kafkaMetricThreeHasThreadIdTag);
        Assertions.assertEquals(expected, (Object)this.mockConsumer.addedMetrics(), (String)"Should remove metrics");
    }

    @Test
    public void shouldNotRegisterMetricsWithoutThreadIdTag() {
        this.streamsThreadMetricsDelegatingReporter.metricChange(this.kafkaMetricWithoutThreadIdTag);
        Assertions.assertEquals((int)0, (int)this.mockConsumer.addedMetrics().size(), (String)"Should not register metrics without thread-id tag");
    }
}

