/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.kstream.Printed;
import org.apache.kafka.streams.kstream.internals.PrintedInternal;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PrintedTest {
    private final PrintStream originalSysOut = System.out;
    private final ByteArrayOutputStream sysOut = new ByteArrayOutputStream();
    private Printed<String, Integer> sysOutPrinter;

    @BeforeEach
    public void before() {
        System.setOut(new PrintStream(this.sysOut));
        this.sysOutPrinter = Printed.toSysOut();
    }

    @AfterEach
    public void after() {
        System.setOut(this.originalSysOut);
    }

    @Test
    public void shouldCreateProcessorThatPrintsToFile() throws IOException {
        File file = TestUtils.tempFile();
        ProcessorSupplier processorSupplier = new PrintedInternal(Printed.toFile((String)file.getPath())).build("processor");
        Processor processor = processorSupplier.get();
        processor.process(new Record((Object)"hi", (Object)1, 0L));
        processor.close();
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            byte[] data = new byte[stream.available()];
            stream.read(data);
            MatcherAssert.assertThat((Object)new String(data, StandardCharsets.UTF_8), (Matcher)CoreMatchers.equalTo((Object)"[processor]: hi, 1\n"));
        }
    }

    @Test
    public void shouldCreateProcessorThatPrintsToStdOut() throws UnsupportedEncodingException {
        ProcessorSupplier supplier = new PrintedInternal(this.sysOutPrinter).build("processor");
        Processor processor = supplier.get();
        processor.process(new Record((Object)"good", (Object)2, 0L));
        processor.close();
        MatcherAssert.assertThat((Object)this.sysOut.toString(StandardCharsets.UTF_8.name()), (Matcher)CoreMatchers.equalTo((Object)"[processor]: good, 2\n"));
    }

    @Test
    public void shouldPrintWithLabel() throws UnsupportedEncodingException {
        Processor processor = new PrintedInternal(this.sysOutPrinter.withLabel("label")).build("processor").get();
        processor.process(new Record((Object)"hello", (Object)3, 0L));
        processor.close();
        MatcherAssert.assertThat((Object)this.sysOut.toString(StandardCharsets.UTF_8.name()), (Matcher)CoreMatchers.equalTo((Object)"[label]: hello, 3\n"));
    }

    @Test
    public void shouldPrintWithKeyValueMapper() throws UnsupportedEncodingException {
        Processor processor = new PrintedInternal(this.sysOutPrinter.withKeyValueMapper((key, value) -> String.format("%s -> %d", key, value))).build("processor").get();
        processor.process(new Record((Object)"hello", (Object)1, 0L));
        processor.close();
        MatcherAssert.assertThat((Object)this.sysOut.toString(StandardCharsets.UTF_8.name()), (Matcher)CoreMatchers.equalTo((Object)"[processor]: hello -> 1\n"));
    }

    @Test
    public void shouldThrowNullPointerExceptionIfFilePathIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> Printed.toFile(null));
    }

    @Test
    public void shouldThrowNullPointerExceptionIfMapperIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.sysOutPrinter.withKeyValueMapper(null));
    }

    @Test
    public void shouldThrowNullPointerExceptionIfLabelIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.sysOutPrinter.withLabel(null));
    }

    @Test
    public void shouldThrowTopologyExceptionIfFilePathIsEmpty() {
        Assertions.assertThrows(TopologyException.class, () -> Printed.toFile((String)""));
    }

    @Test
    public void shouldThrowTopologyExceptionIfFilePathDoesntExist() {
        Assertions.assertThrows(TopologyException.class, () -> Printed.toFile((String)"/this/should/not/exist"));
    }
}

